/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.recipe;

import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.crafttweaker.functions.IPredicateFunction;
import com.cleanroommc.multiblocked.api.recipe.Content;
import com.cleanroommc.multiblocked.api.recipe.EntityIngredient;
import com.cleanroommc.multiblocked.api.recipe.ItemsIngredient;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.api.recipe.RecipeCondition;
import com.cleanroommc.multiblocked.api.recipe.RecipeMap;
import com.cleanroommc.multiblocked.api.registry.MbdCapabilities;
import com.cleanroommc.multiblocked.common.capability.AspectThaumcraftCapability;
import com.cleanroommc.multiblocked.common.capability.AuraMultiblockCapability;
import com.cleanroommc.multiblocked.common.capability.EMCProjectECapability;
import com.cleanroommc.multiblocked.common.capability.EmberEmbersCapability;
import com.cleanroommc.multiblocked.common.capability.EnergyGTCECapability;
import com.cleanroommc.multiblocked.common.capability.EntityMultiblockCapability;
import com.cleanroommc.multiblocked.common.capability.GPExtraUtilities2Capability;
import com.cleanroommc.multiblocked.common.capability.GasMekanismCapability;
import com.cleanroommc.multiblocked.common.capability.HeatMekanismCapability;
import com.cleanroommc.multiblocked.common.capability.HotAirProdigyCapability;
import com.cleanroommc.multiblocked.common.capability.ImpetusThaumicAugmentationCapability;
import com.cleanroommc.multiblocked.common.capability.LEMultiblockCapability;
import com.cleanroommc.multiblocked.common.capability.LPBloodMagicCapability;
import com.cleanroommc.multiblocked.common.capability.LaserMekanismCapability;
import com.cleanroommc.multiblocked.common.capability.ManaBotaniaCapability;
import com.cleanroommc.multiblocked.common.capability.MystMechPowerCapability;
import com.cleanroommc.multiblocked.common.capability.ParticleQMDCapability;
import com.cleanroommc.multiblocked.common.capability.PneumaticPressureCapability;
import com.cleanroommc.multiblocked.common.capability.StarlightAstralCapability;
import com.cleanroommc.multiblocked.common.recipe.conditions.BiomeCondition;
import com.cleanroommc.multiblocked.common.recipe.conditions.DimensionCondition;
import com.cleanroommc.multiblocked.common.recipe.conditions.PositionYCondition;
import com.cleanroommc.multiblocked.common.recipe.conditions.PredicateCondition;
import com.cleanroommc.multiblocked.common.recipe.conditions.RainingCondition;
import com.cleanroommc.multiblocked.common.recipe.conditions.ThunderCondition;
import com.cleanroommc.multiblocked.common.recipe.content.AspectStack;
import com.cleanroommc.multiblocked.common.recipe.content.Starlight;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.data.IData;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.text.ITextComponent;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lach_01298.qmd.particle.ParticleStack;
import mekanism.api.gas.GasStack;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenConstructor;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenProperty;

@ZenClass(value="mods.multiblocked.recipe.RecipeBuilder")
@ZenRegister
public class RecipeBuilder {
    @ZenProperty
    public final RecipeMap recipeMap;
    public final Map<MultiblockCapability<?>, ImmutableList.Builder<Content>> inputBuilder = new HashMap();
    public final Map<MultiblockCapability<?>, ImmutableList.Builder<Content>> tickInputBuilder = new HashMap();
    public final Map<MultiblockCapability<?>, ImmutableList.Builder<Content>> outputBuilder = new HashMap();
    public final Map<MultiblockCapability<?>, ImmutableList.Builder<Content>> tickOutputBuilder = new HashMap();
    public final Map<String, Object> data = new HashMap<String, Object>();
    @ZenProperty
    protected int duration;
    protected net.minecraft.util.text.ITextComponent text;
    protected StringBuilder keyBuilder = new StringBuilder();
    protected boolean perTick;
    protected String fixedName;
    protected String slotName;
    public final List<RecipeCondition> conditions = new ArrayList<RecipeCondition>();

    @ZenConstructor
    public RecipeBuilder(RecipeMap recipeMap) {
        this.recipeMap = recipeMap;
    }

    @ZenMethod
    public RecipeBuilder copy() {
        RecipeBuilder copy = new RecipeBuilder(this.recipeMap);
        this.inputBuilder.forEach((k, v) -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            copy.inputBuilder.put((MultiblockCapability<?>)k, (ImmutableList.Builder<Content>)builder.addAll((Iterable)v.build()));
        });
        this.outputBuilder.forEach((k, v) -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            copy.outputBuilder.put((MultiblockCapability<?>)k, (ImmutableList.Builder<Content>)builder.addAll((Iterable)v.build()));
        });
        this.tickInputBuilder.forEach((k, v) -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            copy.tickInputBuilder.put((MultiblockCapability<?>)k, (ImmutableList.Builder<Content>)builder.addAll((Iterable)v.build()));
        });
        this.tickOutputBuilder.forEach((k, v) -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            copy.tickOutputBuilder.put((MultiblockCapability<?>)k, (ImmutableList.Builder<Content>)builder.addAll((Iterable)v.build()));
        });
        this.data.forEach(copy.data::put);
        copy.conditions.addAll(this.conditions);
        copy.duration = this.duration;
        copy.keyBuilder = new StringBuilder(this.keyBuilder.toString());
        copy.fixedName = null;
        return copy;
    }

    @ZenMethod
    public RecipeBuilder duration(int duration) {
        this.duration = duration;
        return this;
    }

    public RecipeBuilder data(String key, Object object) {
        this.data.put(key, object);
        return this;
    }

    @ZenMethod
    @Optional.Method(modid="crafttweaker")
    public RecipeBuilder data(String key, IData object) {
        this.data.put(key, object);
        return this;
    }

    public RecipeBuilder text(net.minecraft.util.text.ITextComponent text) {
        this.text = text;
        return this;
    }

    @ZenMethod
    @Optional.Method(modid="crafttweaker")
    public RecipeBuilder text(ITextComponent text) {
        this.text = CraftTweakerMC.getITextComponent((ITextComponent)text);
        return this;
    }

    @ZenMethod
    public RecipeBuilder perTick(boolean perTick) {
        this.perTick = perTick;
        return this;
    }

    @ZenMethod
    public RecipeBuilder name(String name) {
        this.fixedName = name;
        return this;
    }

    @ZenMethod
    public RecipeBuilder slotName(String slotName) {
        this.slotName = slotName != null && !slotName.isEmpty() ? slotName : null;
        return this;
    }

    public RecipeBuilder input(MultiblockCapability<?> capability, float chance, Object ... obj) {
        this.keyBuilder.append(chance);
        (this.perTick ? this.tickInputBuilder : this.inputBuilder).computeIfAbsent(capability, c -> ImmutableList.builder()).addAll(Arrays.stream(obj).map(o -> new Content(o, chance, this.slotName)).iterator());
        return this;
    }

    public RecipeBuilder output(MultiblockCapability<?> capability, float chance, Object ... obj) {
        this.keyBuilder.append(chance);
        (this.perTick ? this.tickOutputBuilder : this.outputBuilder).computeIfAbsent(capability, c -> ImmutableList.builder()).addAll(Arrays.stream(obj).map(o -> new Content(o, chance, this.slotName)).iterator());
        return this;
    }

    public RecipeBuilder addCondition(RecipeCondition condition) {
        this.conditions.add(condition);
        return this;
    }

    @ZenMethod
    public RecipeBuilder inputFE(int forgeEnergy) {
        return this.inputFE(1.0f, forgeEnergy);
    }

    @ZenMethod
    public RecipeBuilder outputFE(int forgeEnergy) {
        return this.outputFE(1.0f, forgeEnergy);
    }

    @ZenMethod
    public RecipeBuilder inputFE(float chance, int forgeEnergy) {
        this.keyBuilder.append(MbdCapabilities.FE.name).append(forgeEnergy);
        return this.input(MbdCapabilities.FE, chance, forgeEnergy);
    }

    @ZenMethod
    public RecipeBuilder outputFE(float chance, int forgeEnergy) {
        this.keyBuilder.append(MbdCapabilities.FE.name).append(forgeEnergy);
        return this.output(MbdCapabilities.FE, chance, forgeEnergy);
    }

    public RecipeBuilder inputItems(ItemsIngredient ... inputs) {
        return this.inputItems(1.0f, inputs);
    }

    public RecipeBuilder outputItems(ItemStack ... outputs) {
        return this.outputItems(1.0f, outputs);
    }

    public RecipeBuilder inputItems(float chance, ItemsIngredient ... inputs) {
        this.keyBuilder.append(MbdCapabilities.ITEM.name);
        for (ItemsIngredient input : inputs) {
            this.keyBuilder.append(input.hashCode());
        }
        return this.input(MbdCapabilities.ITEM, chance, (Object[])inputs);
    }

    public RecipeBuilder outputItems(float chance, ItemStack ... outputs) {
        this.keyBuilder.append(MbdCapabilities.ITEM.name);
        for (ItemStack output : outputs) {
            this.keyBuilder.append(output.func_190916_E());
            ResourceLocation name = output.func_77973_b().getRegistryName();
            this.keyBuilder.append(name == null ? "" : Integer.valueOf(name.hashCode()));
        }
        return this.output(MbdCapabilities.ITEM, chance, Arrays.stream(outputs).map(xva$0 -> new ItemsIngredient((ItemStack)xva$0)).toArray());
    }

    public RecipeBuilder inputFluids(FluidStack ... inputs) {
        return this.inputFluids(1.0f, inputs);
    }

    public RecipeBuilder outputFluids(FluidStack ... outputs) {
        return this.outputFluids(1.0f, outputs);
    }

    public RecipeBuilder inputFluids(float chance, FluidStack ... inputs) {
        this.keyBuilder.append(MbdCapabilities.FLUID.name);
        for (FluidStack input : inputs) {
            this.keyBuilder.append(input.amount);
            this.keyBuilder.append(input.getUnlocalizedName());
        }
        return this.input(MbdCapabilities.FLUID, chance, inputs);
    }

    public RecipeBuilder outputFluids(float chance, FluidStack ... outputs) {
        this.keyBuilder.append(MbdCapabilities.FLUID.name);
        for (FluidStack output : outputs) {
            this.keyBuilder.append(output.amount);
            this.keyBuilder.append(output.getUnlocalizedName());
        }
        return this.output(MbdCapabilities.FLUID, chance, outputs);
    }

    public RecipeBuilder inputEntities(float chance, EntityIngredient ... inputs) {
        return this.input(EntityMultiblockCapability.CAP, chance, inputs);
    }

    public RecipeBuilder outputEntities(float chance, EntityIngredient ... outputs) {
        return this.output(EntityMultiblockCapability.CAP, chance, outputs);
    }

    public RecipeBuilder inputEntities(EntityIngredient ... inputs) {
        return this.inputEntities(1.0f, inputs);
    }

    public RecipeBuilder outputEntities(EntityIngredient ... outputs) {
        return this.outputEntities(1.0f, outputs);
    }

    @Optional.Method(modid="botania")
    @ZenMethod
    public RecipeBuilder inputMana(int mana) {
        return this.inputMana(1.0f, mana);
    }

    @Optional.Method(modid="botania")
    @ZenMethod
    public RecipeBuilder outputMana(int mana) {
        return this.outputMana(1.0f, mana);
    }

    @Optional.Method(modid="botania")
    @ZenMethod
    public RecipeBuilder inputMana(float chance, int mana) {
        this.keyBuilder.append(ManaBotaniaCapability.CAP.name).append(mana);
        return this.input(ManaBotaniaCapability.CAP, chance, mana);
    }

    @Optional.Method(modid="botania")
    @ZenMethod
    public RecipeBuilder outputMana(float chance, int mana) {
        this.keyBuilder.append(ManaBotaniaCapability.CAP.name).append(mana);
        return this.output(ManaBotaniaCapability.CAP, chance, mana);
    }

    @Optional.Method(modid="thaumcraft")
    public RecipeBuilder inputAspects(AspectStack ... inputs) {
        return this.inputAspects(1.0f, inputs);
    }

    @Optional.Method(modid="thaumcraft")
    public RecipeBuilder outputAspects(AspectStack ... outputs) {
        return this.outputAspects(1.0f, outputs);
    }

    @Optional.Method(modid="thaumcraft")
    public RecipeBuilder inputAspects(float chance, AspectStack ... inputs) {
        this.keyBuilder.append(AspectThaumcraftCapability.CAP.name);
        for (AspectStack input : inputs) {
            this.keyBuilder.append(input.amount);
            this.keyBuilder.append(input.aspect.getName());
        }
        return this.input(AspectThaumcraftCapability.CAP, chance, inputs);
    }

    @Optional.Method(modid="thaumcraft")
    public RecipeBuilder outputAspects(float chance, AspectStack ... outputs) {
        this.keyBuilder.append(AspectThaumcraftCapability.CAP.name);
        for (AspectStack output : outputs) {
            this.keyBuilder.append(output.amount);
            this.keyBuilder.append(output.aspect.getName());
        }
        return this.output(AspectThaumcraftCapability.CAP, chance, outputs);
    }

    @Optional.Method(modid="mekanism")
    @ZenMethod
    public RecipeBuilder inputHeat(double heat) {
        return this.inputHeat(1.0f, heat);
    }

    @Optional.Method(modid="mekanism")
    @ZenMethod
    public RecipeBuilder outputHeat(double heat) {
        return this.outputHeat(1.0f, heat);
    }

    @Optional.Method(modid="mekanism")
    @ZenMethod
    public RecipeBuilder inputHeat(float chance, double heat) {
        this.keyBuilder.append(HeatMekanismCapability.CAP.name).append(heat);
        return this.input(HeatMekanismCapability.CAP, chance, heat);
    }

    @Optional.Method(modid="mekanism")
    @ZenMethod
    public RecipeBuilder outputHeat(float chance, double heat) {
        this.keyBuilder.append(HeatMekanismCapability.CAP.name).append(heat);
        return this.output(HeatMekanismCapability.CAP, chance, heat);
    }

    @Optional.Method(modid="mekanism")
    @ZenMethod
    public RecipeBuilder inputLaser(double laser) {
        return this.inputLaser(1.0f, laser);
    }

    @Optional.Method(modid="mekanism")
    @ZenMethod
    public RecipeBuilder outputLaser(double laser) {
        return this.outputLaser(1.0f, laser);
    }

    @Optional.Method(modid="mekanism")
    @ZenMethod
    public RecipeBuilder inputLaser(float chance, double laser) {
        this.keyBuilder.append(LaserMekanismCapability.CAP.name).append(laser);
        return this.input(LaserMekanismCapability.CAP, chance, laser);
    }

    @Optional.Method(modid="mekanism")
    @ZenMethod
    public RecipeBuilder outputLaser(float chance, double laser) {
        this.keyBuilder.append(LaserMekanismCapability.CAP.name).append(laser);
        return this.output(LaserMekanismCapability.CAP, chance, laser);
    }

    @Optional.Method(modid="mekanism")
    public RecipeBuilder inputGas(GasStack ... inputs) {
        return this.inputGas(1.0f, inputs);
    }

    @Optional.Method(modid="mekanism")
    public RecipeBuilder outputGas(GasStack ... outputs) {
        return this.outputGas(1.0f, outputs);
    }

    @Optional.Method(modid="mekanism")
    public RecipeBuilder inputGas(float chance, GasStack ... inputs) {
        this.keyBuilder.append(GasMekanismCapability.CAP.name);
        for (GasStack input : inputs) {
            this.keyBuilder.append(input.amount);
            this.keyBuilder.append(input.getGas().getID());
        }
        return this.input(GasMekanismCapability.CAP, chance, inputs);
    }

    @Optional.Method(modid="mekanism")
    public RecipeBuilder outputGas(float chance, GasStack ... outputs) {
        this.keyBuilder.append(GasMekanismCapability.CAP.name);
        for (GasStack output : outputs) {
            this.keyBuilder.append(output.amount);
            this.keyBuilder.append(output.getGas().getID());
        }
        return this.output(GasMekanismCapability.CAP, chance, outputs);
    }

    @Optional.Method(modid="qmd")
    public RecipeBuilder inputParticles(ParticleStack ... inputs) {
        return this.inputParticles(1.0f, inputs);
    }

    @Optional.Method(modid="qmd")
    public RecipeBuilder outputParticles(ParticleStack ... outputs) {
        return this.outputParticles(1.0f, outputs);
    }

    @Optional.Method(modid="qmd")
    public RecipeBuilder inputParticles(float chance, ParticleStack ... inputs) {
        this.keyBuilder.append(ParticleQMDCapability.CAP.name);
        for (ParticleStack input : inputs) {
            this.keyBuilder.append(input.getAmount());
            this.keyBuilder.append(input.getParticle().getName());
            this.keyBuilder.append(input.getMeanEnergy());
            this.keyBuilder.append(input.getFocus());
        }
        return this.input(ParticleQMDCapability.CAP, chance, inputs);
    }

    @Optional.Method(modid="qmd")
    public RecipeBuilder outputParticles(float chance, ParticleStack ... outputs) {
        this.keyBuilder.append(ParticleQMDCapability.CAP.name);
        for (ParticleStack output : outputs) {
            this.keyBuilder.append(output.getAmount());
            this.keyBuilder.append(output.getParticle().getName());
            this.keyBuilder.append(output.getMeanEnergy());
            this.keyBuilder.append(output.getFocus());
        }
        return this.output(ParticleQMDCapability.CAP, chance, outputs);
    }

    @Optional.Method(modid="gregtech")
    @ZenMethod
    public RecipeBuilder inputEU(int eu) {
        return this.inputEU(1.0f, eu);
    }

    @Optional.Method(modid="gregtech")
    @ZenMethod
    public RecipeBuilder outputEU(int eu) {
        return this.outputEU(1.0f, eu);
    }

    @Optional.Method(modid="gregtech")
    @ZenMethod
    public RecipeBuilder inputEU(float chance, long eu) {
        this.keyBuilder.append(EnergyGTCECapability.CAP.name).append(eu);
        return this.input(EnergyGTCECapability.CAP, chance, eu);
    }

    @Optional.Method(modid="gregtech")
    @ZenMethod
    public RecipeBuilder outputEU(float chance, long eu) {
        this.keyBuilder.append(EnergyGTCECapability.CAP.name).append(eu);
        return this.output(EnergyGTCECapability.CAP, chance, eu);
    }

    @Optional.Method(modid="lightningcraft")
    @ZenMethod
    public RecipeBuilder inputLE(double le) {
        return this.inputLE(1.0f, le);
    }

    @Optional.Method(modid="lightningcraft")
    @ZenMethod
    public RecipeBuilder outputLE(double le) {
        return this.outputLE(1.0f, le);
    }

    @Optional.Method(modid="lightningcraft")
    @ZenMethod
    public RecipeBuilder inputLE(float chance, double le) {
        this.keyBuilder.append(LEMultiblockCapability.CAP.name).append(le);
        return this.input(LEMultiblockCapability.CAP, chance, le);
    }

    @Optional.Method(modid="lightningcraft")
    @ZenMethod
    public RecipeBuilder outputLE(float chance, double le) {
        this.keyBuilder.append(LEMultiblockCapability.CAP.name).append(le);
        return this.output(LEMultiblockCapability.CAP, chance, le);
    }

    @Optional.Method(modid="prodigytech")
    @ZenMethod
    public RecipeBuilder inputHotAir(int hotAir) {
        return this.inputHotAir(1.0f, hotAir);
    }

    @Optional.Method(modid="prodigytech")
    @ZenMethod
    public RecipeBuilder outputHotAir(int hotAir) {
        return this.outputHotAir(1.0f, hotAir);
    }

    @Optional.Method(modid="prodigytech")
    @ZenMethod
    public RecipeBuilder inputHotAir(float chance, int hotAir) {
        this.keyBuilder.append(HotAirProdigyCapability.CAP.name).append(hotAir);
        return this.input(HotAirProdigyCapability.CAP, chance, hotAir);
    }

    @Optional.Method(modid="prodigytech")
    @ZenMethod
    public RecipeBuilder outputHotAir(float chance, int hotAir) {
        this.keyBuilder.append(HotAirProdigyCapability.CAP.name).append(hotAir);
        return this.output(HotAirProdigyCapability.CAP, chance, hotAir);
    }

    @Optional.Method(modid="naturesaura")
    @ZenMethod
    public RecipeBuilder inputAura(int aura) {
        return this.inputAura(1.0f, aura);
    }

    @Optional.Method(modid="naturesaura")
    @ZenMethod
    public RecipeBuilder outputAura(int aura) {
        return this.outputAura(1.0f, aura);
    }

    @Optional.Method(modid="naturesaura")
    @ZenMethod
    public RecipeBuilder inputAura(float chance, int aura) {
        this.keyBuilder.append(AuraMultiblockCapability.CAP.name).append(aura);
        return this.input(AuraMultiblockCapability.CAP, chance, aura);
    }

    @Optional.Method(modid="naturesaura")
    @ZenMethod
    public RecipeBuilder outputAura(float chance, int aura) {
        this.keyBuilder.append(AuraMultiblockCapability.CAP.name).append(aura);
        return this.output(AuraMultiblockCapability.CAP, chance, aura);
    }

    @Optional.Method(modid="extrautils2")
    @ZenMethod
    public RecipeBuilder inputGP(float gp) {
        return this.inputGP(1.0f, gp);
    }

    @Optional.Method(modid="extrautils2")
    @ZenMethod
    public RecipeBuilder outputGP(float gp) {
        return this.outputGP(1.0f, gp);
    }

    @Optional.Method(modid="extrautils2")
    @ZenMethod
    public RecipeBuilder inputGP(float chance, float gp) {
        this.keyBuilder.append(GPExtraUtilities2Capability.CAP.name).append(gp);
        return this.input(GPExtraUtilities2Capability.CAP, chance, Float.valueOf(gp));
    }

    @Optional.Method(modid="extrautils2")
    @ZenMethod
    public RecipeBuilder outputGP(float chance, float gp) {
        this.keyBuilder.append(GPExtraUtilities2Capability.CAP.name).append(gp);
        return this.output(GPExtraUtilities2Capability.CAP, chance, Float.valueOf(gp));
    }

    @Optional.Method(modid="projecte")
    @ZenMethod
    public RecipeBuilder inputEMC(long emc) {
        return this.inputEMC(1.0f, emc);
    }

    @Optional.Method(modid="projecte")
    @ZenMethod
    public RecipeBuilder outputEMC(long emc) {
        return this.outputEMC(1.0f, emc);
    }

    @Optional.Method(modid="projecte")
    @ZenMethod
    public RecipeBuilder inputEMC(float chance, long emc) {
        this.keyBuilder.append(EMCProjectECapability.CAP.name).append(emc);
        return this.input(EMCProjectECapability.CAP, chance, emc);
    }

    @Optional.Method(modid="projecte")
    @ZenMethod
    public RecipeBuilder outputEMC(float chance, long emc) {
        this.keyBuilder.append(EMCProjectECapability.CAP.name).append(emc);
        return this.output(EMCProjectECapability.CAP, chance, emc);
    }

    @Optional.Method(modid="bloodmagic")
    @ZenMethod
    public RecipeBuilder inputLP(int lp) {
        return this.inputLP(1.0f, lp);
    }

    @Optional.Method(modid="bloodmagic")
    @ZenMethod
    public RecipeBuilder outputLP(int lp) {
        return this.outputLP(1.0f, lp);
    }

    @Optional.Method(modid="bloodmagic")
    @ZenMethod
    public RecipeBuilder inputLP(float chance, int lp) {
        this.keyBuilder.append(LPBloodMagicCapability.CAP.name).append(lp);
        return this.input(LPBloodMagicCapability.CAP, chance, lp);
    }

    @Optional.Method(modid="bloodmagic")
    @ZenMethod
    public RecipeBuilder outputLP(float chance, int lp) {
        this.keyBuilder.append(LPBloodMagicCapability.CAP.name).append(lp);
        return this.output(LPBloodMagicCapability.CAP, chance, lp);
    }

    @Optional.Method(modid="embers")
    @ZenMethod
    public RecipeBuilder inputEmber(double ember) {
        return this.inputEmber(1.0f, ember);
    }

    @Optional.Method(modid="embers")
    @ZenMethod
    public RecipeBuilder outputEmber(double ember) {
        return this.outputEmber(1.0f, ember);
    }

    @Optional.Method(modid="embers")
    @ZenMethod
    public RecipeBuilder inputEmber(float chance, double ember) {
        this.keyBuilder.append(EmberEmbersCapability.CAP.name).append(ember);
        return this.input(EmberEmbersCapability.CAP, chance, ember);
    }

    @Optional.Method(modid="embers")
    @ZenMethod
    public RecipeBuilder outputEmber(float chance, double ember) {
        this.keyBuilder.append(EmberEmbersCapability.CAP.name).append(ember);
        return this.output(EmberEmbersCapability.CAP, chance, ember);
    }

    @Optional.Method(modid="thaumicaugmentation")
    @ZenMethod
    public RecipeBuilder inputImpetus(int impetus) {
        return this.inputImpetus(1.0f, impetus);
    }

    @Optional.Method(modid="thaumicaugmentation")
    @ZenMethod
    public RecipeBuilder outputImpetus(int impetus) {
        return this.outputImpetus(1.0f, impetus);
    }

    @Optional.Method(modid="thaumicaugmentation")
    @ZenMethod
    public RecipeBuilder inputImpetus(float chance, long impetus) {
        this.keyBuilder.append(ImpetusThaumicAugmentationCapability.CAP.name).append(impetus);
        return this.input(ImpetusThaumicAugmentationCapability.CAP, chance, impetus);
    }

    @Optional.Method(modid="thaumicaugmentation")
    @ZenMethod
    public RecipeBuilder outputImpetus(float chance, long impetus) {
        this.keyBuilder.append(ImpetusThaumicAugmentationCapability.CAP.name).append(impetus);
        return this.output(ImpetusThaumicAugmentationCapability.CAP, chance, impetus);
    }

    @Optional.Method(modid="pneumaticcraft")
    @ZenMethod
    public RecipeBuilder inputPressure(float chance, float pressure) {
        this.keyBuilder.append(PneumaticPressureCapability.CAP.name).append(pressure);
        return this.input(PneumaticPressureCapability.CAP, chance, Float.valueOf(pressure));
    }

    @Optional.Method(modid="pneumaticcraft")
    @ZenMethod
    public RecipeBuilder inputPressure(float pressure) {
        return this.inputPressure(1.0f, pressure);
    }

    @Optional.Method(modid="astralsorcery")
    @ZenMethod
    public RecipeBuilder inputStarlight(float chance, int starlight, @Optional String constellation) {
        this.keyBuilder.append(StarlightAstralCapability.CAP.name).append(starlight).append(constellation);
        return this.input(StarlightAstralCapability.CAP, chance, new Starlight(starlight, ConstellationRegistry.getConstellationByName((String)constellation)));
    }

    @Optional.Method(modid="astralsorcery")
    @ZenMethod
    public RecipeBuilder outputStarlight(float chance, int starlight, @Optional String constellation) {
        this.keyBuilder.append(StarlightAstralCapability.CAP.name).append(starlight).append(constellation);
        return this.output(StarlightAstralCapability.CAP, chance, new Starlight(starlight, ConstellationRegistry.getConstellationByName((String)constellation)));
    }

    @Optional.Method(modid="astralsorcery")
    @ZenMethod
    public RecipeBuilder inputStarlight(int starlight, @Optional String constellation) {
        return this.inputStarlight(1.0f, starlight, constellation);
    }

    @Optional.Method(modid="astralsorcery")
    @ZenMethod
    public RecipeBuilder outputStarlight(int starlight, @Optional String constellation) {
        return this.outputStarlight(1.0f, starlight, constellation);
    }

    @Optional.Method(modid="mysticalmechanics")
    @ZenMethod
    public RecipeBuilder inputMystMechPower(float chance, double minimumPower) {
        this.keyBuilder.append(MystMechPowerCapability.CAP.name).append(minimumPower);
        return this.input(MystMechPowerCapability.CAP, 1.0f, minimumPower);
    }

    @Optional.Method(modid="mysticalmechanics")
    @ZenMethod
    public RecipeBuilder inputMystMechPower(double minimumPower) {
        return this.inputMystMechPower(1.0f, minimumPower);
    }

    @ZenMethod
    public RecipeBuilder dimension(String dimension, boolean reverse) {
        return this.addCondition(new DimensionCondition(dimension).setReverse(reverse));
    }

    @ZenMethod
    public RecipeBuilder dimension(String dimension) {
        return this.dimension(dimension, false);
    }

    public RecipeBuilder biome(ResourceLocation biome, boolean reverse) {
        return this.addCondition(new BiomeCondition(biome).setReverse(reverse));
    }

    @ZenMethod
    public RecipeBuilder biome(ResourceLocation biome) {
        return this.biome(biome, false);
    }

    @ZenMethod
    public RecipeBuilder rain(float level, boolean reverse) {
        return this.addCondition(new RainingCondition(level).setReverse(reverse));
    }

    public RecipeBuilder rain(float level) {
        return this.rain(level, false);
    }

    @ZenMethod
    public RecipeBuilder thunder(float level, boolean reverse) {
        return this.addCondition(new ThunderCondition(level).setReverse(reverse));
    }

    @ZenMethod
    public RecipeBuilder thunder(float level) {
        return this.thunder(level, false);
    }

    @ZenMethod
    public RecipeBuilder posY(int min, int max, boolean reverse) {
        return this.addCondition(new PositionYCondition(min, max).setReverse(reverse));
    }

    @ZenMethod
    public RecipeBuilder posY(int min, int max) {
        return this.posY(min, max, false);
    }

    @ZenMethod
    public RecipeBuilder predicate(IPredicateFunction predicate, String tooltip, boolean reverse) {
        this.conditions.add(new PredicateCondition(tooltip, predicate).setReverse(reverse));
        return this;
    }

    @ZenMethod
    public RecipeBuilder predicate(IPredicateFunction predicate, boolean reverse) {
        return this.predicate(predicate, "multiblocked.recipe.condition.predicate.tooltip.default", reverse);
    }

    @ZenMethod
    public RecipeBuilder predicate(IPredicateFunction predicate, String tooltip) {
        return this.predicate(predicate, tooltip, false);
    }

    @ZenMethod
    public RecipeBuilder predicate(IPredicateFunction predicate) {
        return this.predicate(predicate, "multiblocked.recipe.condition.predicate.tooltip.default", false);
    }

    @ZenMethod
    public Recipe build() {
        ImmutableMap.Builder inputBuilder = new ImmutableMap.Builder();
        for (Map.Entry<MultiblockCapability<?>, ImmutableList.Builder<Content>> entry : this.inputBuilder.entrySet()) {
            inputBuilder.put(entry.getKey(), (Object)entry.getValue().build());
        }
        ImmutableMap.Builder outputBuilder = new ImmutableMap.Builder();
        for (Map.Entry<MultiblockCapability<?>, ImmutableList.Builder<Content>> entry : this.outputBuilder.entrySet()) {
            outputBuilder.put(entry.getKey(), (Object)entry.getValue().build());
        }
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Map.Entry<MultiblockCapability<?>, ImmutableList.Builder<Content>> entry : this.tickInputBuilder.entrySet()) {
            builder.put(entry.getKey(), (Object)entry.getValue().build());
        }
        ImmutableMap.Builder builder2 = new ImmutableMap.Builder();
        for (Map.Entry<MultiblockCapability<?>, ImmutableList.Builder<Content>> entry : this.tickOutputBuilder.entrySet()) {
            builder2.put(entry.getKey(), (Object)entry.getValue().build());
        }
        return new Recipe(this.fixedName == null ? this.keyBuilder.toString() : this.fixedName, inputBuilder.build(), outputBuilder.build(), builder.build(), builder2.build(), (ImmutableList<RecipeCondition>)ImmutableList.copyOf(this.conditions), (ImmutableMap<String, Object>)(this.data.isEmpty() ? Recipe.EMPTY : ImmutableMap.copyOf(this.data)), this.text, this.duration);
    }

    @ZenMethod
    public void buildAndRegister() {
        this.buildAndRegister(false);
    }

    @ZenMethod
    public void buildAndRegister(boolean isFuel) {
        if (isFuel) {
            this.recipeMap.addFuelRecipe(this.build());
        } else {
            this.recipeMap.addRecipe(this.build());
        }
    }
}

