/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.recipe;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.capability.ICapabilityProxyHolder;
import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.capability.proxy.CapabilityProxy;
import com.cleanroommc.multiblocked.api.crafttweaker.functions.IApplyContentModifier;
import com.cleanroommc.multiblocked.api.definition.ControllerDefinition;
import com.cleanroommc.multiblocked.api.recipe.Content;
import com.cleanroommc.multiblocked.api.recipe.ContentModifier;
import com.cleanroommc.multiblocked.api.recipe.RecipeCondition;
import com.cleanroommc.multiblocked.api.recipe.RecipeLogic;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Table;
import crafttweaker.annotations.ZenRegister;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.util.text.ITextComponent;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenProperty;

@ZenClass(value="mods.multiblocked.recipe.Recipe")
@ZenRegister
public class Recipe {
    public static final ImmutableMap<String, Object> EMPTY = ImmutableMap.of();
    @ZenProperty
    public final String uid;
    public final ImmutableMap<MultiblockCapability<?>, ImmutableList<Content>> inputs;
    public final ImmutableMap<MultiblockCapability<?>, ImmutableList<Content>> outputs;
    public final ImmutableMap<MultiblockCapability<?>, ImmutableList<Content>> tickInputs;
    public final ImmutableMap<MultiblockCapability<?>, ImmutableList<Content>> tickOutputs;
    public final ImmutableMap<String, Object> data;
    @ZenProperty
    public final int duration;
    public final ITextComponent text;
    public final ImmutableList<RecipeCondition> conditions;

    public Recipe(String uid, ImmutableMap<MultiblockCapability<?>, ImmutableList<Content>> inputs, ImmutableMap<MultiblockCapability<?>, ImmutableList<Content>> outputs, ImmutableMap<MultiblockCapability<?>, ImmutableList<Content>> tickInputs, ImmutableMap<MultiblockCapability<?>, ImmutableList<Content>> tickOutputs, ImmutableList<RecipeCondition> conditions, int duration) {
        this(uid, inputs, outputs, tickInputs, tickOutputs, conditions, EMPTY, null, duration);
    }

    public Recipe(String uid, ImmutableMap<MultiblockCapability<?>, ImmutableList<Content>> inputs, ImmutableMap<MultiblockCapability<?>, ImmutableList<Content>> outputs, ImmutableMap<MultiblockCapability<?>, ImmutableList<Content>> tickInputs, ImmutableMap<MultiblockCapability<?>, ImmutableList<Content>> tickOutputs, ImmutableList<RecipeCondition> conditions, ImmutableMap<String, Object> data, ITextComponent text, int duration) {
        this.uid = uid;
        this.inputs = inputs;
        this.outputs = outputs;
        this.tickInputs = tickInputs;
        this.tickOutputs = tickOutputs;
        this.duration = duration;
        this.data = data;
        this.conditions = conditions;
        this.text = text;
    }

    public <T> T getData(String key) {
        if (this.data.containsKey((Object)key)) {
            return (T)this.data.get((Object)key);
        }
        return null;
    }

    @ZenMethod
    public List<Content> getInputContents(MultiblockCapability<?> capability) {
        if (this.inputs.containsKey(capability)) {
            return (List)this.inputs.get(capability);
        }
        return Collections.emptyList();
    }

    @ZenMethod
    public List<Content> getOutputContents(MultiblockCapability<?> capability) {
        if (this.outputs.containsKey(capability)) {
            return (List)this.outputs.get(capability);
        }
        return Collections.emptyList();
    }

    @ZenMethod
    public boolean matchRecipe(ICapabilityProxyHolder holder, RecipeLogic logic) {
        if (!holder.hasProxies()) {
            return false;
        }
        if (!this.matchRecipe(IO.IN, holder, this.inputs, logic, false)) {
            return false;
        }
        return this.matchRecipe(IO.OUT, holder, this.outputs, logic, false);
    }

    @ZenMethod
    public boolean matchTickRecipe(ICapabilityProxyHolder holder, RecipeLogic logic) {
        if (this.hasTick()) {
            if (!holder.hasProxies()) {
                return false;
            }
            if (!this.matchRecipe(IO.IN, holder, this.tickInputs, logic, true)) {
                return false;
            }
            return this.matchRecipe(IO.OUT, holder, this.tickOutputs, logic, true);
        }
        return true;
    }

    private boolean matchRecipe(IO io, ICapabilityProxyHolder holder, ImmutableMap<MultiblockCapability<?>, ImmutableList<Content>> contents, RecipeLogic logic, boolean isTickIO) {
        Table<IO, MultiblockCapability<?>, Long2ObjectOpenHashMap<CapabilityProxy<?>>> capabilityProxies = holder.getCapabilities();
        for (Map.Entry entry : contents.entrySet()) {
            List left;
            String key;
            Iterator iterator;
            HashSet<CapabilityProxy> used = new HashSet<CapabilityProxy>();
            List<Object> content = new ArrayList<Object>();
            HashMap<String, List> contentSlot = new HashMap<String, List>();
            MultiblockCapability cap = (MultiblockCapability)entry.getKey();
            for (Content cont : (ImmutableList)entry.getValue()) {
                ContentModifier modifier;
                IApplyContentModifier applyContentModifier = ((ControllerDefinition)logic.controller.getDefinition()).applyContentModifier;
                Object capContent = cont.content;
                if (applyContentModifier != null && (modifier = applyContentModifier.apply(logic, this, cont, cap, io, isTickIO)) != null) {
                    capContent = cap.copyInnerByModifier(capContent, modifier);
                }
                if (cont.slotName == null) {
                    content.add(capContent);
                    continue;
                }
                contentSlot.computeIfAbsent(cont.slotName, s -> new ArrayList()).add(capContent);
            }
            if (content.isEmpty()) {
                if (contentSlot.isEmpty()) continue;
                content = null;
            }
            if (capabilityProxies.contains((Object)io, (Object)cap)) {
                for (CapabilityProxy proxy : ((Long2ObjectOpenHashMap)capabilityProxies.get((Object)io, (Object)cap)).values()) {
                    if (used.contains(proxy)) continue;
                    used.add(proxy);
                    if (content != null) {
                        content = proxy.searchingRecipe(io, this, content, null);
                    }
                    if (proxy.slots != null) {
                        iterator = contentSlot.keySet().iterator();
                        while (iterator.hasNext()) {
                            key = (String)iterator.next();
                            if (!proxy.slots.contains(key) || (left = proxy.searchingRecipe(io, this, (List)contentSlot.get(key), key)) != null) continue;
                            iterator.remove();
                        }
                    }
                    if (content != null || !contentSlot.isEmpty()) continue;
                    break;
                }
            }
            if (content == null) {
                if (contentSlot.isEmpty()) {
                    continue;
                }
            } else if (content.isEmpty()) {
                content = null;
            }
            if (capabilityProxies.contains((Object)IO.BOTH, (Object)cap)) {
                for (CapabilityProxy proxy : ((Long2ObjectOpenHashMap)capabilityProxies.get((Object)IO.BOTH, (Object)cap)).values()) {
                    if (used.contains(proxy)) continue;
                    used.add(proxy);
                    if (content != null) {
                        content = proxy.searchingRecipe(io, this, content, null);
                    }
                    if (proxy.slots != null) {
                        iterator = contentSlot.keySet().iterator();
                        while (iterator.hasNext()) {
                            key = (String)iterator.next();
                            if (!proxy.slots.contains(key) || (left = proxy.searchingRecipe(io, this, (List)contentSlot.get(key), key)) != null) continue;
                            iterator.remove();
                        }
                    }
                    if (content != null || !contentSlot.isEmpty()) continue;
                    break;
                }
            }
            if (content == null && contentSlot.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @ZenMethod
    public boolean handleTickRecipeIO(IO io, ICapabilityProxyHolder holder, RecipeLogic logic) {
        if (!holder.hasProxies() || io == IO.BOTH) {
            return false;
        }
        return this.handleRecipe(io, holder, io == IO.IN ? this.tickInputs : this.tickOutputs, logic, true);
    }

    @ZenMethod
    public boolean handleRecipeIO(IO io, ICapabilityProxyHolder holder, RecipeLogic logic) {
        if (!holder.hasProxies() || io == IO.BOTH) {
            return false;
        }
        return this.handleRecipe(io, holder, io == IO.IN ? this.inputs : this.outputs, logic, false);
    }

    public boolean handleRecipe(IO io, ICapabilityProxyHolder holder, ImmutableMap<MultiblockCapability<?>, ImmutableList<Content>> contents, RecipeLogic logic, boolean isTick) {
        Table<IO, MultiblockCapability<?>, Long2ObjectOpenHashMap<CapabilityProxy<?>>> capabilityProxies = holder.getCapabilities();
        for (Map.Entry entry : contents.entrySet()) {
            List left;
            String key;
            MultiblockCapability cap = (MultiblockCapability)entry.getKey();
            HashSet<CapabilityProxy> used = new HashSet<CapabilityProxy>();
            List<Object> content = new ArrayList<Object>();
            HashMap<String, List> contentSlot = new HashMap<String, List>();
            for (Content cont : (ImmutableList)entry.getValue()) {
                ContentModifier modifier;
                float chance = cont.chance;
                IApplyContentModifier applyContentModifier = ((ControllerDefinition)logic.controller.getDefinition()).applyContentModifier;
                Object capContent = cont.content;
                if (applyContentModifier != null && (modifier = applyContentModifier.apply(logic, this, cont, cap, io, isTick)) != null) {
                    capContent = cap.copyInnerByModifier(capContent, modifier);
                    chance = modifier.applyToChance(chance);
                }
                if (chance != 1.0f && !(Multiblocked.RNG.nextFloat() < chance)) continue;
                if (cont.slotName == null) {
                    content.add(capContent);
                    continue;
                }
                contentSlot.computeIfAbsent(cont.slotName, s -> new ArrayList()).add(capContent);
            }
            if (content.isEmpty()) {
                if (contentSlot.isEmpty()) continue;
                content = null;
            }
            if (capabilityProxies.contains((Object)io, (Object)cap)) {
                for (CapabilityProxy proxy : ((Long2ObjectOpenHashMap)capabilityProxies.get((Object)io, (Object)cap)).values()) {
                    if (used.contains(proxy)) continue;
                    used.add(proxy);
                    if (content != null) {
                        content = proxy.handleRecipe(io, this, content, null);
                    }
                    if (proxy.slots != null) {
                        Iterator iterator = contentSlot.keySet().iterator();
                        while (iterator.hasNext()) {
                            key = (String)iterator.next();
                            if (!proxy.slots.contains(key) || (left = proxy.handleRecipe(io, this, (List)contentSlot.get(key), key)) != null) continue;
                            iterator.remove();
                        }
                    }
                    if (content != null || !contentSlot.isEmpty()) continue;
                    break;
                }
            }
            if (content == null) {
                if (contentSlot.isEmpty()) {
                    continue;
                }
            } else if (content.isEmpty()) {
                content = null;
            }
            if (capabilityProxies.contains((Object)IO.BOTH, (Object)cap)) {
                for (CapabilityProxy proxy : ((Long2ObjectOpenHashMap)capabilityProxies.get((Object)IO.BOTH, (Object)cap)).values()) {
                    if (used.contains(proxy)) continue;
                    used.add(proxy);
                    if (content != null) {
                        content = proxy.handleRecipe(io, this, content, null);
                    }
                    if (proxy.slots != null) {
                        Iterator iterator = contentSlot.keySet().iterator();
                        while (iterator.hasNext()) {
                            key = (String)iterator.next();
                            if (!proxy.slots.contains(key) || (left = proxy.handleRecipe(io, this, (List)contentSlot.get(key), key)) != null) continue;
                            iterator.remove();
                        }
                    }
                    if (content != null || !contentSlot.isEmpty()) continue;
                    break;
                }
            }
            if (content == null && contentSlot.isEmpty()) continue;
            Multiblocked.LOGGER.warn("io error while handling a recipe {} outputs. holder: {}", (Object)this.uid, (Object)holder);
            return false;
        }
        return true;
    }

    public boolean hasTick() {
        return !this.tickInputs.isEmpty() || !this.tickOutputs.isEmpty();
    }

    public boolean checkConditions(@Nonnull RecipeLogic recipeLogic) {
        if (this.conditions.isEmpty()) {
            return true;
        }
        HashMap<String, List> or = new HashMap<String, List>();
        for (RecipeCondition condition2 : this.conditions) {
            if (condition2.isOr()) {
                or.computeIfAbsent(condition2.getType(), type -> new ArrayList()).add(condition2);
                continue;
            }
            if (condition2.test(this, recipeLogic) != condition2.isReverse()) continue;
            return false;
        }
        for (List conditions : or.values()) {
            if (!conditions.stream().allMatch(condition -> condition.test(this, recipeLogic) == condition.isReverse())) continue;
            return false;
        }
        return true;
    }
}

