/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.recipe;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public class ItemsIngredient
extends Ingredient {
    private int amount;
    private String ore;
    private NonNullList<ItemStack> ores;
    private IntList itemIds = null;
    private ItemStack[] array = null;
    private int lastSizeA = -1;
    private int lastSizeL = -1;

    public ItemsIngredient(int amount, String ore) {
        super(0);
        this.amount = amount;
        this.ore = ore;
        this.ores = OreDictionary.getOres((String)ore);
    }

    public ItemsIngredient(ItemStack ... matchingStacks) {
        super(matchingStacks);
        this.amount = matchingStacks[0].func_190916_E();
    }

    public ItemsIngredient(int amount, ItemStack ... matchingStacks) {
        super(matchingStacks);
        for (ItemStack matchingStack : matchingStacks) {
            matchingStack.func_190920_e(amount);
        }
        this.amount = amount;
    }

    public String getOreDict() {
        return this.ore;
    }

    public boolean isOre() {
        return this.ore != null;
    }

    public ItemStack getOutputStack() {
        ItemStack[] matching = this.func_193365_a();
        ItemStack output = matching.length > 0 ? matching[0] : ItemStack.field_190927_a;
        output.func_190920_e(this.amount);
        return output;
    }

    @Nonnull
    public ItemStack[] func_193365_a() {
        if (this.ores == null) {
            return super.func_193365_a();
        }
        if (this.array == null || this.lastSizeA != this.ores.size()) {
            NonNullList lst = NonNullList.func_191196_a();
            for (ItemStack itemstack : this.ores) {
                if (itemstack.func_77960_j() == Short.MAX_VALUE) {
                    itemstack.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, lst);
                    continue;
                }
                lst.add((Object)itemstack);
            }
            this.array = (ItemStack[])lst.toArray((Object[])new ItemStack[0]);
            this.lastSizeA = this.ores.size();
        }
        return this.array;
    }

    @Nonnull
    public IntList func_194139_b() {
        if (this.ores == null) {
            return super.func_194139_b();
        }
        if (this.itemIds == null || this.lastSizeL != this.ores.size()) {
            this.itemIds = new IntArrayList(this.ores.size());
            for (ItemStack itemstack : this.ores) {
                if (itemstack.func_77960_j() == Short.MAX_VALUE) {
                    NonNullList lst = NonNullList.func_191196_a();
                    itemstack.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, lst);
                    for (ItemStack item : lst) {
                        this.itemIds.add(RecipeItemHelper.func_194113_b((ItemStack)item));
                    }
                    continue;
                }
                this.itemIds.add(RecipeItemHelper.func_194113_b((ItemStack)itemstack));
            }
            this.itemIds.sort((Comparator)IntComparators.NATURAL_COMPARATOR);
            this.lastSizeL = this.ores.size();
        }
        return this.itemIds;
    }

    public boolean apply(@Nullable ItemStack input) {
        if (input == null) {
            return false;
        }
        if (this.ores == null) {
            for (ItemStack matchingStack : this.field_193371_b) {
                boolean matched;
                if (matchingStack.func_77973_b() != input.func_77973_b()) continue;
                int metadata = matchingStack.func_77960_j();
                boolean bl = matched = !(metadata != Short.MAX_VALUE && metadata != input.func_77960_j() || matchingStack.func_77942_o() && !ItemStack.areItemStackShareTagsEqual((ItemStack)matchingStack, (ItemStack)input));
                if (!matched) continue;
                return true;
            }
        } else {
            for (ItemStack target : this.ores) {
                if (!OreDictionary.itemMatches((ItemStack)target, (ItemStack)input, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    protected void invalidate() {
        if (this.ores == null) {
            super.invalidate();
        }
        this.itemIds = null;
        this.array = null;
    }

    public boolean isSimple() {
        return this.ores != null || super.isSimple();
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public ItemsIngredient copy() {
        return this.ores == null ? new ItemsIngredient(this.amount, this.field_193371_b) : new ItemsIngredient(this.amount, this.ore);
    }

    public int hashCode() {
        int hash = this.amount;
        for (ItemStack stack : this.func_193365_a()) {
            ResourceLocation name = stack.func_77973_b().getRegistryName();
            hash += name == null ? 0 : name.hashCode();
        }
        return hash;
    }
}

