/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class EntityIngredient {
    public static final EntityEntry ITEM = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("item"));
    public EntityEntry type = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("pig"));
    public NBTTagCompound tag;

    public EntityIngredient() {
    }

    public EntityIngredient(EntityEntry type, NBTTagCompound tag) {
        this.type = type;
        this.tag = tag;
    }

    public boolean match(Entity entity) {
        if (EntityRegistry.getEntry(entity.getClass()) != this.type) {
            return false;
        }
        if (this.tag != null) {
            NBTTagCompound nbt = entity.serializeNBT();
            NBTTagCompound merged = nbt.func_74737_b();
            merged.func_179237_a(this.tag);
            return nbt.equals((Object)merged);
        }
        return true;
    }

    public static EntityIngredient fromJson(JsonElement json) {
        EntityIngredient ingredient = new EntityIngredient();
        if (json.isJsonPrimitive()) {
            EntityEntry entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(json.getAsString()));
            ingredient.type = entry == null ? ingredient.type : entry;
        } else if (json.isJsonObject()) {
            JsonObject object = json.getAsJsonObject();
            EntityEntry entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(JsonUtils.func_151200_h((JsonObject)object, (String)"type")));
            EntityEntry entityEntry = ingredient.type = entry == null ? ingredient.type : entry;
            if (object.has("tag")) {
                try {
                    ingredient.tag = JsonToNBT.func_180713_a((String)object.get("tag").getAsString());
                }
                catch (NBTException nBTException) {
                    // empty catch block
                }
            }
        }
        return ingredient;
    }

    public JsonElement toJson() {
        JsonObject object = new JsonObject();
        object.addProperty("type", this.type.getRegistryName().toString());
        if (this.tag != null) {
            object.addProperty("tag", this.tag.toString());
        }
        return object;
    }

    public static EntityIngredient of(Object o) {
        EntityIngredient ingredient = new EntityIngredient();
        if (o instanceof EntityIngredient) {
            ingredient = (EntityIngredient)o;
        } else if (o instanceof CharSequence) {
            EntityEntry entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(o.toString()));
            ingredient.type = entry == null ? ingredient.type : entry;
        } else if (o instanceof ResourceLocation) {
            EntityEntry entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(o.toString()));
            ingredient.type = entry == null ? ingredient.type : entry;
        }
        return ingredient;
    }

    public void spawn(World serverLevel, NBTTagCompound tag, BlockPos pos) {
        Entity entity = this.type.newInstance(serverLevel);
        entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        if (tag != null) {
            NBTTagCompound nbt = entity.serializeNBT();
            nbt.func_179237_a(tag);
            entity.deserializeNBT(nbt);
        }
        serverLevel.func_72838_d(entity);
    }

    public EntityIngredient copy() {
        EntityIngredient copy = new EntityIngredient();
        copy.type = this.type;
        if (this.tag != null) {
            copy.tag = this.tag.func_74737_b();
        }
        return copy;
    }

    public boolean isEntityItem() {
        return this.type == ITEM && this.tag != null && this.tag.func_74764_b("Item");
    }

    public ItemStack getEntityItem() {
        return new ItemStack(this.tag.func_74775_l("Item"));
    }
}

