/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.pattern.util;

import com.cleanroommc.multiblocked.util.world.DummyWorld;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockInfo {
    public static final BlockInfo EMPTY = new BlockInfo(Blocks.field_150350_a);
    private final IBlockState blockState;
    private TileEntity tileEntity;
    private final ItemStack itemStack;

    public BlockInfo(Block block) {
        this(block.func_176223_P());
    }

    public BlockInfo(IBlockState blockState) {
        this(blockState, null);
    }

    public BlockInfo(IBlockState blockState, TileEntity tileEntity) {
        this(blockState, tileEntity, null);
    }

    public BlockInfo(IBlockState blockState, TileEntity tileEntity, ItemStack itemStack) {
        this.blockState = blockState;
        this.tileEntity = tileEntity;
        this.itemStack = itemStack;
    }

    public static BlockInfo fromBlockState(IBlockState state) {
        try {
            TileEntity tileEntity;
            if (state.func_177230_c().hasTileEntity(state) && (tileEntity = state.func_177230_c().createTileEntity((World)new DummyWorld(), state)) != null) {
                return new BlockInfo(state, tileEntity);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new BlockInfo(state);
    }

    public void setTileEntity(TileEntity tileEntity) {
        this.tileEntity = tileEntity;
    }

    public IBlockState getBlockState() {
        return this.blockState;
    }

    public TileEntity getTileEntity() {
        return this.tileEntity;
    }

    public ItemStack getItemStackForm() {
        return this.itemStack == null ? new ItemStack(Item.func_150898_a((Block)this.blockState.func_177230_c()), 1, this.blockState.func_177230_c().func_180651_a(this.blockState)) : this.itemStack;
    }

    public void apply(World world, BlockPos pos) {
        world.func_175656_a(pos, this.blockState);
        if (this.tileEntity != null) {
            world.func_175690_a(pos, this.tileEntity);
        }
    }
}

