/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.pattern.predicates;

import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.gui.texture.ColorBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ColorRectTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceTexture;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ImageWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.LabelWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SelectorWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SwitchWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextFieldWidget;
import com.cleanroommc.multiblocked.api.pattern.MultiblockState;
import com.cleanroommc.multiblocked.api.pattern.TraceabilityPredicate;
import com.cleanroommc.multiblocked.api.pattern.error.PatternStringError;
import com.cleanroommc.multiblocked.api.pattern.error.SinglePredicateError;
import com.cleanroommc.multiblocked.api.pattern.util.BlockInfo;
import com.cleanroommc.multiblocked.util.LocalizationUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.longs.Long2ObjectArrayMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.JsonUtils;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SimplePredicate {
    public static SimplePredicate ANY = new SimplePredicate("any", x -> true, null);
    public static SimplePredicate AIR = new SimplePredicate("air", blockWorldState -> blockWorldState.getBlockState().func_177230_c().isAir(blockWorldState.getBlockState(), (IBlockAccess)blockWorldState.getWorld(), blockWorldState.getPos()), null);
    public Supplier<BlockInfo[]> candidates;
    public Predicate<MultiblockState> predicate;
    public List<String> toolTips;
    public int minCount = -1;
    public int maxCount = -1;
    public int previewCount = -1;
    public boolean disableRenderFormed = false;
    public IO io = IO.BOTH;
    public String slotName;
    public String customTips;
    public String nbtParser;
    public boolean isCTParser;
    public final String type;

    public SimplePredicate() {
        this("unknown");
    }

    public SimplePredicate(String type) {
        this.type = type;
    }

    public SimplePredicate(Predicate<MultiblockState> predicate, Supplier<BlockInfo[]> candidates) {
        this();
        this.predicate = predicate;
        this.candidates = candidates;
    }

    public SimplePredicate(String type, Predicate<MultiblockState> predicate, Supplier<BlockInfo[]> candidates) {
        this(type);
        this.predicate = predicate;
        this.candidates = candidates;
    }

    public SimplePredicate buildPredicate() {
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getToolTips(TraceabilityPredicate predicates) {
        ArrayList<String> result = new ArrayList<String>();
        if (this.toolTips != null) {
            this.toolTips.forEach(tip -> result.add(I18n.func_135052_a((String)tip, (Object[])new Object[0])));
        }
        if (this.customTips != null) {
            result.addAll(Arrays.stream(I18n.func_135052_a((String)this.customTips, (Object[])new Object[0]).split("\n")).collect(Collectors.toList()));
        }
        if (this.minCount == this.maxCount && this.maxCount != -1) {
            result.add(I18n.func_135052_a((String)"multiblocked.pattern.limited_exact", (Object[])new Object[]{this.minCount}));
        } else if (this.minCount != this.maxCount && this.minCount != -1 && this.maxCount != -1) {
            result.add(I18n.func_135052_a((String)"multiblocked.pattern.limited_within", (Object[])new Object[]{this.minCount, this.maxCount}));
        } else {
            if (this.minCount != -1) {
                result.add(I18n.func_135052_a((String)"multiblocked.pattern.error.limited.1", (Object[])new Object[]{this.minCount}));
            }
            if (this.maxCount != -1) {
                result.add(I18n.func_135052_a((String)"multiblocked.pattern.error.limited.0", (Object[])new Object[]{this.maxCount}));
            }
        }
        if (predicates == null) {
            return result;
        }
        if (predicates.isSingle()) {
            result.add(I18n.func_135052_a((String)"multiblocked.pattern.single", (Object[])new Object[0]));
        }
        if (predicates.hasAir()) {
            result.add(I18n.func_135052_a((String)"multiblocked.pattern.replaceable_air", (Object[])new Object[0]));
        }
        return result;
    }

    public boolean test(MultiblockState blockWorldState) {
        if (this.predicate.test(blockWorldState)) {
            return this.checkInnerConditions(blockWorldState);
        }
        return false;
    }

    public boolean testLimited(MultiblockState blockWorldState) {
        if (this.testGlobal(blockWorldState)) {
            return this.checkInnerConditions(blockWorldState);
        }
        return false;
    }

    private boolean checkInnerConditions(MultiblockState blockWorldState) {
        if (this.disableRenderFormed) {
            blockWorldState.getMatchContext().getOrCreate("renderMask", LongOpenHashSet::new).add(blockWorldState.getPos().func_177986_g());
        }
        if (this.io != IO.BOTH) {
            if (blockWorldState.io == IO.BOTH) {
                blockWorldState.io = this.io;
            } else if (blockWorldState.io != this.io) {
                blockWorldState.io = null;
            }
        }
        if (this.nbtParser != null && !blockWorldState.world.field_72995_K) {
            TileEntity te = blockWorldState.getTileEntity();
            if (!(te == null || this.isCTParser && Loader.isModLoaded((String)"crafttweaker"))) {
                NBTTagCompound nbt = te.serializeNBT();
                if (Pattern.compile(this.nbtParser).matcher(nbt.toString()).find()) {
                    return true;
                }
            }
            blockWorldState.setError(new PatternStringError("The NBT fails to match"));
            return false;
        }
        if (this.slotName != null) {
            Map slots = (Map)blockWorldState.getMatchContext().getOrCreate("slots", Long2ObjectArrayMap::new);
            slots.computeIfAbsent(blockWorldState.pos.func_177986_g(), s -> new HashSet()).add(this.slotName);
            return true;
        }
        return true;
    }

    public boolean testGlobal(MultiblockState blockWorldState) {
        if (this.minCount == -1 && this.maxCount == -1) {
            return true;
        }
        Integer count = blockWorldState.globalCount.get(this);
        boolean base = this.predicate.test(blockWorldState);
        count = (count == null ? 0 : count) + (base ? 1 : 0);
        blockWorldState.globalCount.put(this, count);
        if (this.maxCount == -1 || count <= this.maxCount) {
            return base;
        }
        blockWorldState.setError(new SinglePredicateError(this, 0));
        return false;
    }

    public List<ItemStack> getCandidates() {
        return this.candidates == null ? Collections.emptyList() : Arrays.stream((Object[])this.candidates.get()).filter(info -> info.getBlockState().func_177230_c() != Blocks.field_150350_a).map(BlockInfo::getItemStackForm).collect(Collectors.toList());
    }

    public List<WidgetGroup> getConfigWidget(List<WidgetGroup> groups) {
        WidgetGroup group = new WidgetGroup(0, 0, 300, 90);
        groups.add(group);
        group.setClientSideWidget();
        group.addWidget(new LabelWidget(0, 0, () -> LocalizationUtils.format("multiblocked.gui.label.type", new Object[0]) + " " + this.type).setTextColor(-1).setDrop(true));
        TextFieldWidget min = new TextFieldWidget(55, 15, 30, 15, true, () -> this.minCount + "", s -> {
            this.minCount = Integer.parseInt(s);
            if (this.minCount > this.maxCount) {
                this.maxCount = this.minCount;
            }
        }).setNumbersOnly(0, Integer.MAX_VALUE);
        group.addWidget(min);
        min.setHoverTooltip("multiblocked.gui.tips.min").setVisible(this.minCount != -1);
        group.addWidget(new SwitchWidget(0, 15, 50, 15, (cd, r) -> {
            min.setVisible((boolean)r);
            this.minCount = r != false ? 0 : -1;
        }).setPressed(this.minCount != -1).setHoverBorderTexture(1, -1).setBaseTexture(new ResourceTexture("multiblocked:textures/gui/button_common.png"), new TextTexture("min (N)", -1).setDropShadow(true)).setPressedTexture(new ResourceTexture("multiblocked:textures/gui/button_common.png"), new TextTexture("min (Y)", -1).setDropShadow(true)).setHoverTooltip("multiblocked.gui.predicate.min"));
        TextFieldWidget max = new TextFieldWidget(55, 33, 30, 15, true, () -> this.maxCount + "", s -> {
            this.maxCount = Integer.parseInt(s);
            if (this.minCount > this.maxCount) {
                this.minCount = this.maxCount;
            }
        }).setNumbersOnly(0, Integer.MAX_VALUE);
        group.addWidget(max);
        max.setHoverTooltip("multiblocked.gui.tips.max").setVisible(this.maxCount != -1);
        group.addWidget(new SwitchWidget(0, 33, 50, 15, (cd, r) -> {
            max.setVisible((boolean)r);
            this.maxCount = r != false ? 0 : -1;
        }).setPressed(this.maxCount != -1).setHoverBorderTexture(1, -1).setBaseTexture(new ResourceTexture("multiblocked:textures/gui/button_common.png"), new TextTexture("max (N)", -1).setDropShadow(true)).setPressedTexture(new ResourceTexture("multiblocked:textures/gui/button_common.png"), new TextTexture("max (Y)", -1).setDropShadow(true)).setHoverTooltip("multiblocked.gui.predicate.max"));
        TextFieldWidget preview = (TextFieldWidget)new TextFieldWidget(55, 51, 30, 15, true, () -> this.previewCount + "", s -> {
            this.previewCount = Integer.parseInt(s);
        }).setNumbersOnly(0, Integer.MAX_VALUE).setHoverTooltip("multiblocked.gui.predicate.preview");
        group.addWidget(preview);
        preview.setHoverTooltip("multiblocked.gui.predicate.jei").setVisible(this.previewCount != -1);
        group.addWidget(new SwitchWidget(0, 51, 50, 15, (cd, r) -> {
            preview.setVisible((boolean)r);
            this.previewCount = r != false ? 0 : -1;
        }).setPressed(this.previewCount != -1).setHoverBorderTexture(1, -1).setBaseTexture(new ResourceTexture("multiblocked:textures/gui/button_common.png"), new TextTexture("jei (N)", -1).setDropShadow(true)).setPressedTexture(new ResourceTexture("multiblocked:textures/gui/button_common.png"), new TextTexture("jei (Y)", -1).setDropShadow(true)).setHoverTooltip("multiblocked.gui.predicate.preview.1"));
        WidgetGroup widgetGroup = new WidgetGroup(0, 70, 100, 15).addWidget(new SwitchWidget(0, 0, 15, 15, (cd, r) -> {
            this.disableRenderFormed = r;
        }).setBaseTexture(new ResourceTexture("multiblocked:textures/gui/boolean.png").getSubTexture(0.0, 0.0, 1.0, 0.5)).setPressedTexture(new ResourceTexture("multiblocked:textures/gui/boolean.png").getSubTexture(0.0, 0.5, 1.0, 0.5)).setHoverTexture(new ColorBorderTexture(1, -1)).setPressed(this.disableRenderFormed).setHoverTooltip("multiblocked.gui.predicate.disabled")).addWidget(new ImageWidget(2, 2, 11, 11, new ColorBorderTexture(1, -1))).addWidget(new LabelWidget(20, 3, "disableRenderFormed").setTextColor(-1).setDrop(true));
        group.addWidget(widgetGroup);
        TextFieldWidget nbt = new TextFieldWidget(155, 15, 100, 15, true, null, s -> {
            this.nbtParser = s;
        });
        group.addWidget(nbt);
        nbt.setCurrentString(this.nbtParser == null ? "" : this.nbtParser).setHoverTooltip("nbt parser").setVisible(this.nbtParser != null);
        group.addWidget(new SwitchWidget(100, 15, 50, 15, (cd, r) -> {
            nbt.setVisible((boolean)r);
            this.nbtParser = r != false ? "" : null;
        }).setPressed(this.nbtParser != null).setHoverBorderTexture(1, -1).setBaseTexture(new ResourceTexture("multiblocked:textures/gui/button_common.png"), new TextTexture("nbt (N)", -1).setDropShadow(true)).setPressedTexture(new ResourceTexture("multiblocked:textures/gui/button_common.png"), new TextTexture("nbt (Y)", -1).setDropShadow(true)).setHoverTooltip("multiblocked.gui.predicate.nbt"));
        TextFieldWidget tooltips = new TextFieldWidget(155, 33, 100, 15, true, null, s -> {
            this.customTips = s;
        });
        group.addWidget(tooltips);
        tooltips.setCurrentString(this.customTips != null ? this.customTips : "").setHoverTooltip("multiblocked.gui.predicate.tips").setVisible(this.customTips != null);
        group.addWidget(new SwitchWidget(100, 33, 50, 15, (cd, r) -> {
            tooltips.setVisible((boolean)r);
            this.customTips = r != false ? "" : null;
        }).setPressed(this.customTips != null).setHoverBorderTexture(1, -1).setBaseTexture(new ResourceTexture("multiblocked:textures/gui/button_common.png"), new TextTexture("tips (N)", -1).setDropShadow(true)).setPressedTexture(new ResourceTexture("multiblocked:textures/gui/button_common.png"), new TextTexture("tips (Y)", -1).setDropShadow(true)).setHoverTooltip("multiblocked.gui.predicate.add_tips"));
        TextFieldWidget slot = new TextFieldWidget(155, 52, 100, 15, true, null, s -> {
            this.slotName = s;
        });
        group.addWidget(slot);
        slot.setCurrentString(this.slotName == null ? "" : this.slotName).setHoverTooltip("slot name").setVisible(this.slotName != null);
        group.addWidget(new SwitchWidget(100, 52, 50, 15, (cd, r) -> {
            slot.setVisible((boolean)r);
            this.slotName = r != false ? "" : null;
        }).setPressed(this.slotName != null).setHoverBorderTexture(1, -1).setBaseTexture(new ResourceTexture("multiblocked:textures/gui/button_common.png"), new TextTexture("slot (N)", -1).setDropShadow(true)).setPressedTexture(new ResourceTexture("multiblocked:textures/gui/button_common.png"), new TextTexture("slot (Y)", -1).setDropShadow(true)).setHoverTooltip("multiblocked.gui.predicate.slot"));
        group.addWidget(new SelectorWidget(130, 70, 40, 15, Arrays.asList("IN", "OUT", "BOTH", "NULL"), -1).setValue(this.io == null ? "NULL" : this.io.name()).setIsUp(true).setOnChanged(io -> {
            this.io = io.equals("NULL") ? null : IO.valueOf(io);
        }).setButtonBackground(ResourceBorderTexture.BUTTON_COMMON).setBackground(new ColorRectTexture(-13421773)).setHoverTooltip("multiblocked.gui.tips.io"));
        return groups;
    }

    public JsonObject toJson(JsonObject jsonObject) {
        jsonObject.add("type", (JsonElement)new JsonPrimitive(this.type));
        if (this.disableRenderFormed) {
            jsonObject.addProperty("disableRenderFormed", Boolean.valueOf(true));
        }
        if (this.minCount > -1) {
            jsonObject.addProperty("minCount", (Number)this.minCount);
        }
        if (this.maxCount > -1) {
            jsonObject.addProperty("maxCount", (Number)this.maxCount);
        }
        if (this.previewCount > -1) {
            jsonObject.addProperty("previewCount", (Number)this.previewCount);
        }
        if (this.io != IO.BOTH) {
            if (this.io == null) {
                jsonObject.addProperty("io", "null");
            } else {
                jsonObject.addProperty("io", this.io.name());
            }
        }
        if (this.nbtParser != null) {
            jsonObject.addProperty("nbtParser", this.nbtParser);
        }
        if (this.customTips != null) {
            jsonObject.addProperty("customTips", this.customTips);
        }
        if (this.isCTParser) {
            jsonObject.addProperty("isCTParser", Boolean.valueOf(true));
        }
        if (this.slotName != null) {
            jsonObject.addProperty("slotName", this.slotName);
        }
        return jsonObject;
    }

    public void fromJson(Gson gson, JsonObject jsonObject) {
        this.disableRenderFormed = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"disableRenderFormed", (boolean)this.disableRenderFormed);
        this.minCount = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"minCount", (int)this.minCount);
        this.maxCount = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"maxCount", (int)this.maxCount);
        this.previewCount = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"previewCount", (int)this.previewCount);
        this.io = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"io", (String)"").equals("null") ? null : IO.valueOf(JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"io", (String)IO.BOTH.name()));
        this.nbtParser = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"nbtParser", (String)this.nbtParser);
        this.customTips = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"customTips", (String)this.customTips);
        this.slotName = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"slotName", (String)this.slotName);
        this.isCTParser = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"isCTParser", (boolean)this.isCTParser);
    }
}

