/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.pattern.predicates;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.gui.texture.ColorRectTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceTexture;
import com.cleanroommc.multiblocked.api.gui.widget.Widget;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.BlockSelectorWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ButtonWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableScrollableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.LabelWidget;
import com.cleanroommc.multiblocked.api.pattern.predicates.SimplePredicate;
import com.cleanroommc.multiblocked.api.pattern.util.BlockInfo;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import org.apache.commons.lang3.ArrayUtils;

public class PredicateStates
extends SimplePredicate {
    public IBlockState[] states = new IBlockState[0];

    public PredicateStates() {
        super("states");
    }

    public PredicateStates(IBlockState ... states) {
        this();
        this.states = states;
        this.buildPredicate();
    }

    @Override
    public SimplePredicate buildPredicate() {
        this.states = (IBlockState[])Arrays.stream(this.states).filter(Objects::nonNull).toArray(IBlockState[]::new);
        if (this.states.length == 0) {
            this.states = new IBlockState[]{Blocks.field_180401_cv.func_176223_P()};
        }
        this.predicate = state -> ArrayUtils.contains((Object[])this.states, (Object)state.getBlockState());
        this.candidates = () -> (BlockInfo[])Arrays.stream(this.states).map(BlockInfo::fromBlockState).toArray(BlockInfo[]::new);
        return this;
    }

    @Override
    public List<WidgetGroup> getConfigWidget(List<WidgetGroup> groups) {
        super.getConfigWidget(groups);
        WidgetGroup group = new WidgetGroup(0, 0, 182, 100);
        groups.add(group);
        DraggableScrollableWidgetGroup container = new DraggableScrollableWidgetGroup(0, 25, 182, 80).setBackground(new ColorRectTexture(-5592406));
        group.addWidget(container);
        ArrayList<IBlockState> blockList = new ArrayList<IBlockState>(Arrays.asList(this.states));
        for (IBlockState blockState : blockList) {
            this.addBlockSelectorWidget(blockList, container, blockState);
        }
        group.addWidget(new LabelWidget(0, 6, "multiblocked.gui.label.block_settings"));
        group.addWidget(new ButtonWidget(162, 0, 20, 20, cd -> {
            blockList.add(null);
            this.addBlockSelectorWidget(blockList, container, null);
        }).setButtonTexture(new ResourceTexture("multiblocked:textures/gui/add.png")).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.predicate.states.add"));
        return groups;
    }

    private void addBlockSelectorWidget(List<IBlockState> blockList, DraggableScrollableWidgetGroup container, IBlockState blockState) {
        BlockSelectorWidget bsw = new BlockSelectorWidget(0, container.widgets.size() * 21 + 1, true);
        container.addWidget(bsw);
        bsw.addWidget(new ButtonWidget(163, 1, 18, 18, cd -> {
            int index = (bsw.getSelfPosition().y - 1) / 21;
            blockList.remove(index);
            this.updateStates(blockList);
            for (int i = index + 1; i < container.widgets.size(); ++i) {
                ((Widget)container.widgets.get(i)).addSelfPosition(0, -21);
            }
            container.waitToRemoved(bsw);
        }).setButtonTexture(new ResourceTexture("multiblocked:textures/gui/remove.png")).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.tips.remove"));
        if (blockState != null) {
            bsw.setBlock(blockState);
        }
        bsw.setOnBlockStateUpdate(state -> {
            int index = (bsw.getSelfPosition().y - 1) / 21;
            blockList.set(index, (IBlockState)state);
            this.updateStates(blockList);
        });
    }

    private void updateStates(List<IBlockState> blockList) {
        this.states = (IBlockState[])blockList.stream().filter(Objects::nonNull).toArray(IBlockState[]::new);
        this.buildPredicate();
    }

    @Override
    public JsonObject toJson(JsonObject jsonObject) {
        jsonObject.add("states", Multiblocked.GSON.toJsonTree((Object)this.states));
        return super.toJson(jsonObject);
    }

    @Override
    public void fromJson(Gson gson, JsonObject jsonObject) {
        this.states = (IBlockState[])gson.fromJson(jsonObject.get("states"), IBlockState[].class);
        super.fromJson(gson, jsonObject);
    }
}

