/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.pattern.predicates;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.block.BlockComponent;
import com.cleanroommc.multiblocked.api.definition.ComponentDefinition;
import com.cleanroommc.multiblocked.api.definition.ControllerDefinition;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.LabelWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextFieldWidget;
import com.cleanroommc.multiblocked.api.pattern.predicates.SimplePredicate;
import com.cleanroommc.multiblocked.api.pattern.util.BlockInfo;
import com.cleanroommc.multiblocked.api.registry.MbdComponents;
import com.cleanroommc.multiblocked.api.tile.ComponentTileEntity;
import com.cleanroommc.multiblocked.api.tile.ControllerTileTesterEntity;
import com.cleanroommc.multiblocked.api.tile.DummyComponentTileEntity;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public class PredicateComponent
extends SimplePredicate {
    public ResourceLocation location = new ResourceLocation("mod_id", "component_id");
    public ComponentDefinition definition;

    public PredicateComponent() {
        super("component");
    }

    public PredicateComponent(ComponentDefinition definition) {
        this(definition.location);
        this.definition = definition;
        this.buildPredicate();
    }

    public PredicateComponent(ResourceLocation location) {
        this();
        this.location = location;
        this.buildPredicate();
    }

    @Override
    public SimplePredicate buildPredicate() {
        this.predicate = state -> state.getTileEntity() instanceof ComponentTileEntity && ((ComponentDefinition)((ComponentTileEntity)state.getTileEntity()).getDefinition()).location.equals((Object)this.location);
        this.candidates = () -> {
            if (MbdComponents.COMPONENT_BLOCKS_REGISTRY.containsKey((Object)this.location)) {
                return new BlockInfo[]{new BlockInfo(((BlockComponent)MbdComponents.COMPONENT_BLOCKS_REGISTRY.get((Object)this.location)).func_176223_P(), ((ComponentDefinition)MbdComponents.DEFINITION_REGISTRY.get((Object)this.location)).createNewTileEntity(null))};
            }
            if (this.definition == null) {
                return new BlockInfo[0];
            }
            if (this.definition instanceof ControllerDefinition) {
                ControllerTileTesterEntity te = new ControllerTileTesterEntity();
                te.setDefinition(this.definition);
                return new BlockInfo[]{new BlockInfo(((BlockComponent)MbdComponents.COMPONENT_BLOCKS_REGISTRY.get((Object)ControllerTileTesterEntity.DEFAULT_DEFINITION.location)).func_176223_P(), te)};
            }
            DummyComponentTileEntity te = new DummyComponentTileEntity();
            te.setDefinition(this.definition);
            return new BlockInfo[]{new BlockInfo(MbdComponents.DummyComponentBlock.func_176223_P(), te)};
        };
        return this;
    }

    @Override
    public List<WidgetGroup> getConfigWidget(List<WidgetGroup> groups) {
        super.getConfigWidget(groups);
        WidgetGroup group = new WidgetGroup(0, 0, 100, 20);
        groups.add(group);
        group.addWidget(new LabelWidget(0, 0, "multiblocked.gui.label.component_registry_name"));
        group.addWidget(new TextFieldWidget(0, 10, 120, 20, true, null, s -> {
            if (s != null && !s.isEmpty()) {
                this.location = new ResourceLocation(s);
                this.buildPredicate();
            }
        }).setCurrentString(this.location.toString()));
        return groups;
    }

    @Override
    public JsonObject toJson(JsonObject jsonObject) {
        jsonObject.add("location", Multiblocked.GSON.toJsonTree((Object)this.location));
        return super.toJson(jsonObject);
    }

    @Override
    public void fromJson(Gson gson, JsonObject jsonObject) {
        this.location = (ResourceLocation)gson.fromJson(jsonObject.get("location"), ResourceLocation.class);
        super.fromJson(gson, jsonObject);
    }
}

