/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.pattern.predicates;

import com.cleanroommc.multiblocked.api.gui.texture.ColorRectTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceTexture;
import com.cleanroommc.multiblocked.api.gui.widget.Widget;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.BlockSelectorWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ButtonWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableScrollableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.LabelWidget;
import com.cleanroommc.multiblocked.api.pattern.predicates.SimplePredicate;
import com.cleanroommc.multiblocked.api.pattern.util.BlockInfo;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import org.apache.commons.lang3.ArrayUtils;

public class PredicateBlocks
extends SimplePredicate {
    public Block[] blocks = new Block[0];

    public PredicateBlocks() {
        super("blocks");
    }

    public PredicateBlocks(Block ... blocks) {
        this();
        this.blocks = blocks;
        this.buildPredicate();
    }

    @Override
    public SimplePredicate buildPredicate() {
        this.blocks = (Block[])Arrays.stream(this.blocks).filter(Objects::nonNull).toArray(Block[]::new);
        if (this.blocks.length == 0) {
            this.blocks = new Block[]{Blocks.field_180401_cv};
        }
        this.predicate = state -> ArrayUtils.contains((Object[])this.blocks, (Object)state.getBlockState().func_177230_c());
        this.candidates = () -> (BlockInfo[])Arrays.stream(this.blocks).map(block -> BlockInfo.fromBlockState(block.func_176223_P())).toArray(BlockInfo[]::new);
        return this;
    }

    @Override
    public List<WidgetGroup> getConfigWidget(List<WidgetGroup> groups) {
        super.getConfigWidget(groups);
        WidgetGroup group = new WidgetGroup(0, 0, 182, 100);
        groups.add(group);
        DraggableScrollableWidgetGroup container = new DraggableScrollableWidgetGroup(0, 25, 182, 80).setBackground(new ColorRectTexture(-5592406));
        group.addWidget(container);
        List<IBlockState> blockList = Arrays.stream(this.blocks).map(Block::func_176223_P).collect(Collectors.toList());
        for (IBlockState blockState : blockList) {
            this.addBlockSelectorWidget(blockList, container, blockState);
        }
        group.addWidget(new LabelWidget(0, 6, "multiblocked.gui.label.block_settings"));
        group.addWidget(new ButtonWidget(162, 0, 20, 20, cd -> {
            blockList.add(null);
            this.addBlockSelectorWidget(blockList, container, null);
        }).setButtonTexture(new ResourceTexture("multiblocked:textures/gui/add.png")).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.predicate.blocks.add"));
        return groups;
    }

    private void addBlockSelectorWidget(List<IBlockState> blockList, DraggableScrollableWidgetGroup container, IBlockState blockState) {
        BlockSelectorWidget bsw = new BlockSelectorWidget(0, container.widgets.size() * 21 + 1, false);
        container.addWidget(bsw);
        bsw.addWidget(new ButtonWidget(163, 1, 18, 18, cd -> {
            int index = (bsw.getSelfPosition().y - 1) / 21;
            blockList.remove(index);
            this.updateStates(blockList);
            for (int i = index + 1; i < container.widgets.size(); ++i) {
                ((Widget)container.widgets.get(i)).addSelfPosition(0, -21);
            }
            container.waitToRemoved(bsw);
        }).setButtonTexture(new ResourceTexture("multiblocked:textures/gui/remove.png")).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.tips.remove"));
        if (blockState != null) {
            bsw.setBlock(blockState);
        }
        bsw.setOnBlockStateUpdate(state -> {
            int index = (bsw.getSelfPosition().y - 1) / 21;
            blockList.set(index, (IBlockState)state);
            this.updateStates(blockList);
        });
    }

    private void updateStates(List<IBlockState> blockList) {
        this.blocks = (Block[])blockList.stream().filter(Objects::nonNull).map(IBlockState::func_177230_c).toArray(Block[]::new);
        this.buildPredicate();
    }

    @Override
    public JsonObject toJson(JsonObject jsonObject) {
        JsonArray jsonArray = new JsonArray();
        for (Block block : this.blocks) {
            if (block.getRegistryName() == null) continue;
            JsonObject blockObject = new JsonObject();
            blockObject.addProperty("id", block.getRegistryName().toString());
            jsonArray.add((JsonElement)blockObject);
        }
        jsonObject.add("blocks", (JsonElement)jsonArray);
        return super.toJson(jsonObject);
    }

    @Override
    public void fromJson(Gson gson, JsonObject jsonObject) {
        this.blocks = (Block[])gson.fromJson(jsonObject.get("blocks"), Block[].class);
        super.fromJson(gson, jsonObject);
    }
}

