/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.pattern.predicates;

import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.gui.texture.ColorRectTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceBorderTexture;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SelectorWidget;
import com.cleanroommc.multiblocked.api.pattern.MultiblockState;
import com.cleanroommc.multiblocked.api.pattern.error.PatternStringError;
import com.cleanroommc.multiblocked.api.pattern.predicates.SimplePredicate;
import com.cleanroommc.multiblocked.api.pattern.util.BlockInfo;
import com.cleanroommc.multiblocked.api.registry.MbdCapabilities;
import com.cleanroommc.multiblocked.util.LocalizationUtils;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.JsonUtils;

public class PredicateAnyCapability
extends SimplePredicate {
    public String capability = "item";

    public PredicateAnyCapability() {
        super("capability");
    }

    public PredicateAnyCapability(MultiblockCapability<?> capability) {
        this();
        this.capability = capability.name;
        this.buildPredicate();
    }

    @Override
    public SimplePredicate buildPredicate() {
        MultiblockCapability<?> capability = MbdCapabilities.get(this.capability);
        if (capability == null) {
            this.predicate = state -> false;
            this.candidates = () -> new BlockInfo[]{new BlockInfo(Blocks.field_180401_cv)};
            return this;
        }
        this.predicate = state -> state.getBlockState().func_177230_c() == capability.getAnyBlock() || PredicateAnyCapability.checkCapability(this.io, capability, state);
        this.candidates = () -> new BlockInfo[]{BlockInfo.fromBlockState(capability.getAnyBlock().func_176223_P())};
        this.toolTips = new ArrayList();
        this.toolTips.add(String.format("Any Capability: %s IO: %s", capability.name, this.io == null ? "NULL" : this.io.name()));
        return this;
    }

    private static boolean checkCapability(IO io, MultiblockCapability<?> capability, MultiblockState state) {
        TileEntity tileEntity;
        if (io != null && (tileEntity = state.getTileEntity()) != null && capability.isBlockHasCapability(io, tileEntity)) {
            Map capabilities = (Map)state.getMatchContext().getOrCreate("capabilities", Long2ObjectOpenHashMap::new);
            capabilities.computeIfAbsent(state.getPos().func_177986_g(), l -> new EnumMap(IO.class)).computeIfAbsent(io, x -> new HashSet()).add(capability);
            return true;
        }
        state.setError(new PatternStringError(LocalizationUtils.format("multiblocked.pattern.error.capability", LocalizationUtils.format(capability.getUnlocalizedName(), new Object[0]), io == null ? "NULL" : io.name())));
        return false;
    }

    @Override
    public List<WidgetGroup> getConfigWidget(List<WidgetGroup> groups) {
        super.getConfigWidget(groups);
        WidgetGroup group = new WidgetGroup(0, 0, 100, 20);
        groups.add(group);
        MultiblockCapability<?> current = MbdCapabilities.get(this.capability);
        group.addWidget(new SelectorWidget(0, 0, 120, 20, MbdCapabilities.CAPABILITY_REGISTRY.values().stream().map(MultiblockCapability::getUnlocalizedName).collect(Collectors.toList()), -1).setValue(current == null ? "" : current.getUnlocalizedName()).setOnChanged(capability -> {
            this.capability = capability.replace("multiblocked.capability.", "");
            this.buildPredicate();
        }).setButtonBackground(ResourceBorderTexture.BUTTON_COMMON).setBackground(new ColorRectTexture(-5592406)).setHoverTooltip("multiblocked.gui.predicate.capability"));
        return groups;
    }

    @Override
    public JsonObject toJson(JsonObject jsonObject) {
        jsonObject.addProperty("capability", this.capability);
        return super.toJson(jsonObject);
    }

    @Override
    public void fromJson(Gson gson, JsonObject jsonObject) {
        this.capability = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"capability", (String)"");
        super.fromJson(gson, jsonObject);
    }
}

