/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.pattern.error;

import com.cleanroommc.multiblocked.api.pattern.error.PatternError;
import com.cleanroommc.multiblocked.api.pattern.predicates.SimplePredicate;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SinglePredicateError
extends PatternError {
    public final SimplePredicate predicate;
    public final int type;

    public SinglePredicateError(SimplePredicate predicate, int type) {
        this.predicate = predicate;
        this.type = type;
    }

    @Override
    public List<List<ItemStack>> getCandidates() {
        return Collections.singletonList(this.predicate.getCandidates());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getErrorInfo() {
        int number = -1;
        if (this.type == 0) {
            number = this.predicate.maxCount;
        }
        if (this.type == 1) {
            number = this.predicate.minCount;
        }
        return I18n.func_135052_a((String)("multiblocked.pattern.error.limited." + this.type), (Object[])new Object[]{number});
    }
}

