/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.pattern.error;

import com.cleanroommc.multiblocked.api.pattern.MultiblockState;
import com.cleanroommc.multiblocked.api.pattern.TraceabilityPredicate;
import com.cleanroommc.multiblocked.api.pattern.predicates.SimplePredicate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PatternError {
    protected MultiblockState worldState;

    public void setWorldState(MultiblockState worldState) {
        this.worldState = worldState;
    }

    public World getWorld() {
        return this.worldState.getWorld();
    }

    public BlockPos getPos() {
        return this.worldState.getPos();
    }

    public List<List<ItemStack>> getCandidates() {
        TraceabilityPredicate predicate = this.worldState.predicate;
        ArrayList<List<ItemStack>> candidates = new ArrayList<List<ItemStack>>();
        for (SimplePredicate common : predicate.common) {
            candidates.add(common.getCandidates());
        }
        for (SimplePredicate limited : predicate.limited) {
            candidates.add(limited.getCandidates());
        }
        return candidates;
    }

    @SideOnly(value=Side.CLIENT)
    public String getErrorInfo() {
        List<List<ItemStack>> candidates = this.getCandidates();
        StringBuilder builder = new StringBuilder();
        for (List<ItemStack> candidate : candidates) {
            if (candidate.isEmpty()) continue;
            builder.append(candidate.get(0).func_82833_r());
            builder.append(", ");
        }
        builder.append("...");
        return I18n.func_135052_a((String)"gregtech.multiblock.pattern.error", (Object[])new Object[]{builder.toString(), this.worldState.pos});
    }
}

