/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.pattern;

import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.pattern.MultiblockState;
import com.cleanroommc.multiblocked.api.pattern.predicates.SimplePredicate;
import com.cleanroommc.multiblocked.api.pattern.util.BlockInfo;
import crafttweaker.annotations.ZenRegister;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import stanhebben.zenscript.annotations.OperatorType;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenOperator;

@ZenClass(value="mods.multiblocked.pattern.CTPredicate")
@ZenRegister
public class TraceabilityPredicate {
    public List<SimplePredicate> common = new ArrayList<SimplePredicate>();
    public List<SimplePredicate> limited = new ArrayList<SimplePredicate>();
    public boolean isCenter;

    public TraceabilityPredicate() {
    }

    public TraceabilityPredicate(TraceabilityPredicate predicate) {
        this.common.addAll(predicate.common);
        this.limited.addAll(predicate.limited);
        this.isCenter = predicate.isCenter;
    }

    public TraceabilityPredicate(Predicate<MultiblockState> predicate, Supplier<BlockInfo[]> candidates) {
        this.common.add(new SimplePredicate(predicate, candidates));
    }

    public TraceabilityPredicate(SimplePredicate simplePredicate) {
        if (simplePredicate.minCount != -1 || simplePredicate.maxCount != -1) {
            this.limited.add(simplePredicate);
        } else {
            this.common.add(simplePredicate);
        }
    }

    @ZenMethod
    public TraceabilityPredicate setCenter() {
        this.isCenter = true;
        return this;
    }

    @ZenMethod
    public TraceabilityPredicate sort() {
        this.limited.sort(Comparator.comparingInt(a -> a.minCount));
        return this;
    }

    @ZenMethod
    public TraceabilityPredicate addTooltips(String ... tips) {
        if (tips.length > 0) {
            List tooltips = Arrays.stream(tips).collect(Collectors.toList());
            this.common.forEach(predicate -> {
                if (predicate.candidates == null) {
                    return;
                }
                if (predicate.toolTips == null) {
                    predicate.toolTips = new ArrayList<String>();
                }
                predicate.toolTips.addAll(tooltips);
            });
            this.limited.forEach(predicate -> {
                if (predicate.candidates == null) {
                    return;
                }
                if (predicate.toolTips == null) {
                    predicate.toolTips = new ArrayList<String>();
                }
                predicate.toolTips.addAll(tooltips);
            });
        }
        return this;
    }

    @ZenMethod
    public TraceabilityPredicate setMinGlobalLimited(int min) {
        this.limited.addAll(this.common);
        this.common.clear();
        for (SimplePredicate predicate : this.limited) {
            predicate.minCount = min;
        }
        return this;
    }

    @ZenMethod
    public TraceabilityPredicate setMinGlobalLimited(int min, int previewCount) {
        return this.setMinGlobalLimited(min).setPreviewCount(previewCount);
    }

    @ZenMethod
    public TraceabilityPredicate setMaxGlobalLimited(int max) {
        this.limited.addAll(this.common);
        this.common.clear();
        for (SimplePredicate predicate : this.limited) {
            predicate.maxCount = max;
        }
        return this;
    }

    @ZenMethod
    public TraceabilityPredicate setMaxGlobalLimited(int max, int previewCount) {
        return this.setMaxGlobalLimited(max).setPreviewCount(previewCount);
    }

    @ZenMethod
    public TraceabilityPredicate setExactLimit(int limit) {
        return this.setMinGlobalLimited(limit).setMaxGlobalLimited(limit);
    }

    @ZenMethod
    public TraceabilityPredicate setPreviewCount(int count) {
        this.common.forEach(predicate -> {
            predicate.previewCount = count;
        });
        this.limited.forEach(predicate -> {
            predicate.previewCount = count;
        });
        return this;
    }

    @ZenMethod
    public TraceabilityPredicate disableRenderFormed() {
        this.common.forEach(predicate -> {
            predicate.disableRenderFormed = true;
        });
        this.limited.forEach(predicate -> {
            predicate.disableRenderFormed = true;
        });
        return this;
    }

    @ZenMethod
    public TraceabilityPredicate setIO(IO io) {
        this.common.forEach(predicate -> {
            predicate.io = io;
        });
        this.limited.forEach(predicate -> {
            predicate.io = io;
        });
        return this;
    }

    @ZenMethod
    public TraceabilityPredicate setNBTParser(String nbtParser) {
        this.common.forEach(predicate -> {
            predicate.nbtParser = nbtParser;
        });
        this.limited.forEach(predicate -> {
            predicate.nbtParser = nbtParser;
        });
        return this;
    }

    @ZenMethod
    public TraceabilityPredicate setSlotName(String slotName) {
        this.common.forEach(predicate -> {
            predicate.slotName = slotName;
        });
        this.limited.forEach(predicate -> {
            predicate.slotName = slotName;
        });
        return this;
    }

    public boolean test(MultiblockState blockWorldState) {
        blockWorldState.io = IO.BOTH;
        boolean flag = false;
        for (SimplePredicate predicate2 : this.limited) {
            if (!predicate2.testLimited(blockWorldState)) continue;
            flag = true;
        }
        return flag || this.common.stream().anyMatch(predicate -> predicate.test(blockWorldState));
    }

    @ZenMethod
    @ZenOperator(value=OperatorType.OR)
    public TraceabilityPredicate or(TraceabilityPredicate other) {
        if (other != null) {
            TraceabilityPredicate newPredicate = new TraceabilityPredicate(this);
            newPredicate.common.addAll(other.common);
            newPredicate.limited.addAll(other.limited);
            return newPredicate;
        }
        return this;
    }

    @ZenMethod
    public boolean isAny() {
        return this.common.size() == 1 && this.limited.isEmpty() && this.common.get(0) == SimplePredicate.ANY;
    }

    @ZenMethod
    public boolean isAir() {
        return this.common.size() == 1 && this.limited.isEmpty() && this.common.get(0) == SimplePredicate.AIR;
    }

    @ZenMethod
    public boolean isSingle() {
        return !this.isAny() && !this.isAir() && this.common.size() + this.limited.size() == 1;
    }

    @ZenMethod
    public boolean hasAir() {
        return this.common.contains(SimplePredicate.AIR);
    }
}

