/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.pattern;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.pattern.TraceabilityPredicate;
import com.cleanroommc.multiblocked.api.pattern.error.PatternError;
import com.cleanroommc.multiblocked.api.pattern.error.PatternStringError;
import com.cleanroommc.multiblocked.api.pattern.predicates.SimplePredicate;
import com.cleanroommc.multiblocked.api.pattern.util.PatternMatchContext;
import com.cleanroommc.multiblocked.api.tile.ControllerTileEntity;
import com.cleanroommc.multiblocked.network.MultiblockedNetworking;
import com.cleanroommc.multiblocked.network.s2c.SPacketRemoveDisabledRendering;
import com.cleanroommc.multiblocked.persistence.MultiblockWorldSavedData;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MultiblockState {
    public static final PatternError UNLOAD_ERROR = new PatternStringError("multiblocked.pattern.error.chunk");
    public static final PatternError UNINIT_ERROR = new PatternStringError("multiblocked.pattern.error.init");
    public BlockPos pos;
    public IBlockState state;
    public TileEntity tileEntity;
    public boolean tileEntityInitialized;
    public PatternMatchContext matchContext;
    public Map<SimplePredicate, Integer> globalCount;
    public TraceabilityPredicate predicate;
    public IO io;
    public PatternError error;
    public final World world;
    public final BlockPos controllerPos;
    public ControllerTileEntity lastController;
    public LongOpenHashSet cache;

    public MultiblockState(World world, BlockPos controllerPos) {
        this.world = world;
        this.controllerPos = controllerPos;
        this.error = UNINIT_ERROR;
    }

    public void clean() {
        this.matchContext = new PatternMatchContext();
        this.globalCount = new HashMap<SimplePredicate, Integer>();
        this.cache = new LongOpenHashSet();
    }

    public boolean update(BlockPos posIn, TraceabilityPredicate predicate) {
        this.pos = posIn;
        this.state = null;
        this.tileEntity = null;
        this.tileEntityInitialized = false;
        this.predicate = predicate;
        this.error = null;
        if (!this.world.func_175667_e(posIn)) {
            this.error = UNLOAD_ERROR;
            return false;
        }
        return true;
    }

    public ControllerTileEntity getController() {
        TileEntity tileEntity = this.world.func_175625_s(this.controllerPos);
        if (tileEntity instanceof ControllerTileEntity) {
            this.lastController = (ControllerTileEntity)tileEntity;
            return this.lastController;
        }
        return null;
    }

    public boolean isFormed() {
        return this.error == null;
    }

    public void setError(PatternError error) {
        this.error = error;
        if (error != null) {
            error.setWorldState(this);
        }
    }

    public PatternMatchContext getMatchContext() {
        return this.matchContext;
    }

    public IBlockState getBlockState() {
        if (this.state == null) {
            this.state = this.world.func_180495_p(this.pos);
        }
        return this.state;
    }

    @Nullable
    public TileEntity getTileEntity() {
        if (this.tileEntity == null && !this.tileEntityInitialized) {
            this.tileEntity = this.world.func_175625_s(this.pos);
            this.tileEntityInitialized = true;
        }
        return this.tileEntity;
    }

    public BlockPos getPos() {
        return this.pos.func_185334_h();
    }

    public IBlockState getOffsetState(EnumFacing face) {
        if (this.pos instanceof BlockPos.MutableBlockPos) {
            ((BlockPos.MutableBlockPos)this.pos).func_189536_c(face);
            IBlockState blockState = this.world.func_180495_p(this.pos);
            ((BlockPos.MutableBlockPos)this.pos).func_189536_c(face.func_176734_d());
            return blockState;
        }
        return this.world.func_180495_p(this.pos.func_177972_a(face));
    }

    public World getWorld() {
        return this.world;
    }

    public void addPosCache(BlockPos pos) {
        this.cache.add(pos.func_177986_g());
    }

    public boolean isPosInCache(BlockPos pos) {
        return this.cache.contains(pos.func_177986_g());
    }

    public Collection<BlockPos> getCache() {
        return this.cache.stream().map(BlockPos::func_177969_a).collect(Collectors.toList());
    }

    public void onBlockStateChanged(BlockPos pos) {
        if (pos.equals((Object)this.controllerPos)) {
            if (this.getMatchContext().containsKey("renderMask")) {
                MultiblockedNetworking.sendToWorld(new SPacketRemoveDisabledRendering(this.controllerPos), this.world);
            }
            if (this.lastController != null) {
                this.lastController.onStructureInvalid();
                if (this.lastController.hasOldBlock()) {
                    this.lastController.resetOldBlock(this.world, this.controllerPos);
                }
            }
            MultiblockWorldSavedData mbds = MultiblockWorldSavedData.getOrCreate(this.world);
            mbds.removeMapping(this);
            mbds.removeLoading(this.controllerPos);
        } else if (this.error != UNLOAD_ERROR) {
            ControllerTileEntity controller = this.getController();
            boolean hasRenderMask = this.getMatchContext().containsKey("renderMask");
            if (controller != null && !controller.checkPattern()) {
                controller.onStructureInvalid();
                if (controller.hasOldBlock()) {
                    if (hasRenderMask) {
                        MultiblockedNetworking.sendToWorld(new SPacketRemoveDisabledRendering(this.controllerPos), this.world);
                    }
                    MultiblockWorldSavedData.getOrCreate(this.world).removeLoading(this.controllerPos);
                    controller.resetOldBlock(this.world, this.controllerPos);
                }
                MultiblockWorldSavedData.getOrCreate(this.world).removeMapping(this);
            } else if (controller != null) {
                controller.onStructureFormed();
            }
        }
    }

    public void onChunkLoad() {
        try {
            ControllerTileEntity controller = this.getController();
            if (controller != null) {
                if (controller.checkPattern()) {
                    if (!controller.needAlwaysUpdate()) {
                        MultiblockWorldSavedData.getOrCreate(this.world).addLoading(controller);
                    }
                    if (controller.getCapabilities() == null) {
                        controller.onStructureFormed();
                    }
                } else {
                    this.error = UNLOAD_ERROR;
                }
            }
        }
        catch (Throwable e) {
            MultiblockWorldSavedData.getOrCreate(this.world).removeMapping(this);
            Multiblocked.LOGGER.error("An error while loading the controller world: {} pos: {}, {}", (Object)this.world.field_73011_w.func_186058_p().func_186067_c(), (Object)this.controllerPos, (Object)e);
        }
    }

    public void onChunkUnload() {
        ControllerTileEntity controller = this.getController();
        if (controller != null) {
            this.error = UNLOAD_ERROR;
            if (!controller.needAlwaysUpdate()) {
                MultiblockWorldSavedData.getOrCreate(this.world).removeLoading(this.controllerPos);
            }
        } else {
            MultiblockWorldSavedData.getOrCreate(this.world).removeLoading(this.controllerPos);
        }
    }

    public void deserialize(PacketBuffer buffer) {
        int size = buffer.func_150792_a();
        this.cache = new LongOpenHashSet();
        for (int i = 0; i < size; ++i) {
            this.cache.add(buffer.func_179260_f());
        }
    }

    public void serialize(PacketBuffer buffer) {
        buffer.func_150787_b(this.cache.size());
        for (Long aLong : this.cache) {
            buffer.func_179254_b(aLong.longValue());
        }
    }
}

