/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.pattern;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.pattern.BlockPattern;
import com.cleanroommc.multiblocked.api.pattern.Predicates;
import com.cleanroommc.multiblocked.api.pattern.TraceabilityPredicate;
import com.cleanroommc.multiblocked.api.pattern.predicates.PredicateComponent;
import com.cleanroommc.multiblocked.api.pattern.predicates.PredicateStates;
import com.cleanroommc.multiblocked.api.pattern.predicates.SimplePredicate;
import com.cleanroommc.multiblocked.api.pattern.util.RelativeDirection;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class JsonBlockPattern {
    public RelativeDirection[] structureDir;
    public String[][] pattern;
    public int[][] aisleRepetitions;
    public Map<String, SimplePredicate> predicates = new HashMap<String, SimplePredicate>();
    public Map<Character, Set<String>> symbolMap = new HashMap<Character, Set<String>>();

    public JsonBlockPattern() {
        this.structureDir = new RelativeDirection[]{RelativeDirection.LEFT, RelativeDirection.UP, RelativeDirection.FRONT};
        this.predicates.put("any", SimplePredicate.ANY);
        this.predicates.put("air", SimplePredicate.AIR);
        this.symbolMap.computeIfAbsent(Character.valueOf(' '), key -> new HashSet()).add("any");
        this.symbolMap.computeIfAbsent(Character.valueOf('-'), key -> new HashSet()).add("air");
        this.symbolMap.computeIfAbsent(Character.valueOf('@'), key -> new HashSet()).add("controller");
    }

    public JsonBlockPattern(World world, ResourceLocation location, BlockPos controllerPos, EnumFacing facing, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this();
        this.pattern = new String[1 + maxX - minX][1 + maxY - minY];
        if (facing == EnumFacing.WEST) {
            this.structureDir = new RelativeDirection[]{RelativeDirection.LEFT, RelativeDirection.UP, RelativeDirection.BACK};
        } else if (facing == EnumFacing.EAST) {
            this.structureDir = new RelativeDirection[]{RelativeDirection.RIGHT, RelativeDirection.UP, RelativeDirection.FRONT};
        } else if (facing == EnumFacing.NORTH) {
            this.structureDir = new RelativeDirection[]{RelativeDirection.BACK, RelativeDirection.UP, RelativeDirection.RIGHT};
        } else if (facing == EnumFacing.SOUTH) {
            this.structureDir = new RelativeDirection[]{RelativeDirection.FRONT, RelativeDirection.UP, RelativeDirection.LEFT};
        }
        for (int[] aisleRepetition : this.aisleRepetitions = new int[this.pattern.length][2]) {
            aisleRepetition[0] = 1;
            aisleRepetition[1] = 1;
        }
        this.predicates.put("controller", new PredicateComponent(location));
        HashMap<IBlockState, Character> map = new HashMap<IBlockState, Character>();
        map.put(Blocks.field_150350_a.func_176223_P(), Character.valueOf(' '));
        char c = 'A';
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                StringBuilder builder = new StringBuilder();
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (controllerPos.equals((Object)pos)) {
                        builder.append('@');
                        continue;
                    }
                    IBlockState state = world.func_180495_p(pos);
                    if (!map.containsKey(state)) {
                        map.put(state, Character.valueOf(c));
                        String name = String.valueOf(c);
                        this.predicates.put(name, new PredicateStates(state));
                        this.symbolMap.computeIfAbsent(Character.valueOf(c), key -> new HashSet()).add(name);
                        c = (char)(c + '\u0001');
                    }
                    builder.append(map.get(state));
                }
                this.pattern[x - minX][y - minY] = builder.toString();
            }
        }
    }

    public void changeDir(RelativeDirection charDir, RelativeDirection stringDir, RelativeDirection aisleDir) {
        int j;
        int i;
        if (charDir.isSameAxis(stringDir) || stringDir.isSameAxis(aisleDir) || aisleDir.isSameAxis(charDir)) {
            return;
        }
        char[][][] newPattern = new char[this.structureDir[0].isSameAxis(aisleDir) ? this.pattern[0][0].length() : (this.structureDir[1].isSameAxis(aisleDir) ? this.pattern[0].length : this.pattern.length)][this.structureDir[0].isSameAxis(stringDir) ? this.pattern[0][0].length() : (this.structureDir[1].isSameAxis(stringDir) ? this.pattern[0].length : this.pattern.length)][this.structureDir[0].isSameAxis(charDir) ? this.pattern[0][0].length() : (this.structureDir[1].isSameAxis(charDir) ? this.pattern[0].length : this.pattern.length)];
        for (i = 0; i < this.pattern.length; ++i) {
            for (j = 0; j < this.pattern[0].length; ++j) {
                for (int k = 0; k < this.pattern[0][0].length(); ++k) {
                    char c = this.pattern[i][j].charAt(k);
                    int x = 0;
                    int y = 0;
                    int z = 0;
                    if (this.structureDir[2].isSameAxis(aisleDir)) {
                        x = this.structureDir[2] == aisleDir ? i : this.pattern.length - i - 1;
                    } else if (this.structureDir[2].isSameAxis(stringDir)) {
                        y = this.structureDir[2] == stringDir ? i : this.pattern.length - i - 1;
                    } else if (this.structureDir[2].isSameAxis(charDir)) {
                        z = this.structureDir[2] == charDir ? i : this.pattern.length - i - 1;
                    }
                    if (this.structureDir[1].isSameAxis(aisleDir)) {
                        x = this.structureDir[1] == aisleDir ? j : this.pattern[0].length - j - 1;
                    } else if (this.structureDir[1].isSameAxis(stringDir)) {
                        y = this.structureDir[1] == stringDir ? j : this.pattern[0].length - j - 1;
                    } else if (this.structureDir[1].isSameAxis(charDir)) {
                        z = this.structureDir[1] == charDir ? j : this.pattern[0].length - j - 1;
                    }
                    if (this.structureDir[0].isSameAxis(aisleDir)) {
                        x = this.structureDir[0] == aisleDir ? k : this.pattern[0][0].length() - k - 1;
                    } else if (this.structureDir[0].isSameAxis(stringDir)) {
                        y = this.structureDir[0] == stringDir ? k : this.pattern[0][0].length() - k - 1;
                    } else if (this.structureDir[0].isSameAxis(charDir)) {
                        z = this.structureDir[0] == charDir ? k : this.pattern[0][0].length() - k - 1;
                    }
                    newPattern[x][y][z] = c;
                }
            }
        }
        this.pattern = new String[newPattern.length][newPattern[0].length];
        for (i = 0; i < this.pattern.length; ++i) {
            for (j = 0; j < this.pattern[0].length; ++j) {
                StringBuilder builder = new StringBuilder();
                for (char c : newPattern[i][j]) {
                    builder.append(c);
                }
                this.pattern[i][j] = builder.toString();
            }
        }
        for (int[] aisleRepetition : this.aisleRepetitions = new int[this.pattern.length][2]) {
            aisleRepetition[0] = 1;
            aisleRepetition[1] = 1;
        }
        this.structureDir = new RelativeDirection[]{charDir, stringDir, aisleDir};
    }

    public BlockPattern build() {
        int[] centerOffset = new int[5];
        TraceabilityPredicate[][][] predicate = (TraceabilityPredicate[][][])Array.newInstance(TraceabilityPredicate.class, this.pattern.length, this.pattern[0].length, this.pattern[0][0].length());
        int minZ = 0;
        int maxZ = 0;
        for (int i = 0; i < this.pattern.length; ++i) {
            for (int j = 0; j < this.pattern[0].length; ++j) {
                for (int k = 0; k < this.pattern[0][0].length(); ++k) {
                    Set<String> saves = this.symbolMap.get(Character.valueOf(this.pattern[i][j].charAt(k)));
                    if (saves == null || saves.isEmpty()) {
                        predicate[i][j][k] = Predicates.any();
                        continue;
                    }
                    predicate[i][j][k] = new TraceabilityPredicate();
                    for (String p : saves) {
                        predicate[i][j][k] = predicate[i][j][k].or(new TraceabilityPredicate(this.predicates.get(p)));
                        if (!p.equals("controller")) continue;
                        predicate[i][j][k].setCenter();
                        centerOffset = new int[]{k, j, i, minZ, maxZ};
                    }
                }
            }
            minZ += this.aisleRepetitions[i][0];
            maxZ += this.aisleRepetitions[i][1];
        }
        return new BlockPattern(predicate, this.structureDir, this.aisleRepetitions, centerOffset);
    }

    public BlockPos getActualPosOffset(int x, int y, int z, EnumFacing facing) {
        int[] c0 = new int[]{x, y, z};
        int[] c1 = new int[3];
        this.remapping(c0, c1, facing);
        return new BlockPos(c1[0], c1[1], c1[2]);
    }

    public int[] getActualPatternOffset(BlockPos pos, EnumFacing facing) {
        int[] c0 = new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()};
        int[] c1 = new int[3];
        this.remapping(c0, c1, facing);
        return c1;
    }

    public void remapping(int[] c0, int[] c1, EnumFacing facing) {
        for (int i = 0; i < 3; ++i) {
            EnumFacing realFacing = this.structureDir[i].getActualFacing(facing);
            if (realFacing == EnumFacing.UP) {
                c1[1] = c0[i];
                continue;
            }
            if (realFacing == EnumFacing.DOWN) {
                c1[1] = -c0[i];
                continue;
            }
            if (realFacing == EnumFacing.WEST) {
                c1[0] = -c0[i];
                continue;
            }
            if (realFacing == EnumFacing.EAST) {
                c1[0] = c0[i];
                continue;
            }
            if (realFacing == EnumFacing.NORTH) {
                c1[2] = -c0[i];
                continue;
            }
            if (realFacing != EnumFacing.SOUTH) continue;
            c1[2] = c0[i];
        }
    }

    public void cleanUp() {
        HashSet<Character> usedChar = new HashSet<Character>();
        HashSet usedPredicate = new HashSet();
        String[][] stringArray = this.pattern;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] strings;
            for (String string : strings = stringArray[i]) {
                for (char c : string.toCharArray()) {
                    usedChar.add(Character.valueOf(c));
                }
            }
        }
        this.symbolMap.entrySet().removeIf(entry -> !usedChar.contains(entry.getKey()));
        this.symbolMap.forEach((symbol, predicates) -> usedPredicate.addAll(predicates));
        this.predicates.entrySet().removeIf(entry -> !usedPredicate.contains(entry.getKey()));
    }

    public String toJson() {
        return Multiblocked.GSON.toJson((Object)this);
    }

    public int[] getCenterOffset() {
        int[] centerOffset = new int[3];
        for (int i = 0; i < this.pattern.length; ++i) {
            block1: for (int j = 0; j < this.pattern[0].length; ++j) {
                for (int k = 0; k < this.pattern[0][0].length(); ++k) {
                    if (this.pattern[i][j].charAt(k) != '@') continue;
                    centerOffset = new int[]{i, j, k};
                    continue block1;
                }
            }
        }
        return centerOffset;
    }

    public JsonBlockPattern copy() {
        int i;
        JsonBlockPattern newPattern = new JsonBlockPattern();
        System.arraycopy(this.structureDir, 0, newPattern.structureDir, 0, this.structureDir.length);
        newPattern.pattern = new String[this.pattern.length][this.pattern[0].length];
        for (i = 0; i < this.pattern.length; ++i) {
            System.arraycopy(this.pattern[i], 0, newPattern.pattern[i], 0, this.pattern[i].length);
        }
        newPattern.aisleRepetitions = new int[this.aisleRepetitions.length][2];
        for (i = 0; i < this.aisleRepetitions.length; ++i) {
            System.arraycopy(this.aisleRepetitions[i], 0, newPattern.aisleRepetitions[i], 0, this.aisleRepetitions[i].length);
        }
        this.predicates.forEach((k, v) -> {
            newPattern.predicates.put((String)k, (SimplePredicate)Multiblocked.GSON.fromJson(Multiblocked.GSON.toJsonTree(v, SimplePredicate.class), SimplePredicate.class));
            if (v instanceof PredicateComponent) {
                ((PredicateComponent)newPattern.predicates.get((Object)k)).definition = ((PredicateComponent)v).definition;
            }
        });
        this.symbolMap.forEach((k, v) -> {
            Set cfr_ignored_0 = newPattern.symbolMap.put((Character)k, new HashSet(v));
        });
        return newPattern;
    }
}

