/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.pattern;

import com.cleanroommc.multiblocked.api.block.BlockComponent;
import com.cleanroommc.multiblocked.api.block.CustomProperties;
import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.definition.ControllerDefinition;
import com.cleanroommc.multiblocked.api.pattern.MultiblockState;
import com.cleanroommc.multiblocked.api.pattern.TraceabilityPredicate;
import com.cleanroommc.multiblocked.api.pattern.error.PatternError;
import com.cleanroommc.multiblocked.api.pattern.error.PatternStringError;
import com.cleanroommc.multiblocked.api.pattern.error.SinglePredicateError;
import com.cleanroommc.multiblocked.api.pattern.predicates.SimplePredicate;
import com.cleanroommc.multiblocked.api.pattern.util.BlockInfo;
import com.cleanroommc.multiblocked.api.pattern.util.PatternMatchContext;
import com.cleanroommc.multiblocked.api.pattern.util.RelativeDirection;
import com.cleanroommc.multiblocked.api.tile.ComponentTileEntity;
import com.cleanroommc.multiblocked.api.tile.ControllerTileEntity;
import com.cleanroommc.multiblocked.api.tile.part.PartTileEntity;
import com.cleanroommc.multiblocked.client.renderer.impl.CycleBlockStateRenderer;
import crafttweaker.annotations.ZenRegister;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;
import stanhebben.zenscript.annotations.ZenClass;

@ZenClass(value="mods.multiblocked.pattern.BlockPattern")
@ZenRegister
public class BlockPattern {
    static EnumFacing[] FACINGS = new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.NORTH, EnumFacing.WEST, EnumFacing.EAST, EnumFacing.UP, EnumFacing.DOWN};
    public final int[][] aisleRepetitions;
    public final RelativeDirection[] structureDir;
    protected final TraceabilityPredicate[][][] blockMatches;
    protected final int fingerLength;
    protected final int thumbLength;
    protected final int palmLength;
    protected final int[] centerOffset;

    public BlockPattern(TraceabilityPredicate[][][] predicatesIn, RelativeDirection[] structureDir, int[][] aisleRepetitions, int[] centerOffset) {
        this.blockMatches = predicatesIn;
        this.fingerLength = predicatesIn.length;
        this.structureDir = structureDir;
        this.aisleRepetitions = aisleRepetitions;
        if (this.fingerLength > 0) {
            this.thumbLength = predicatesIn[0].length;
            this.palmLength = this.thumbLength > 0 ? predicatesIn[0][0].length : 0;
        } else {
            this.thumbLength = 0;
            this.palmLength = 0;
        }
        this.centerOffset = centerOffset;
    }

    public boolean checkPatternAt(MultiblockState worldState, boolean savePredicate) {
        EnumFacing[] facings;
        EnumFacing[] enumFacingArray;
        ControllerTileEntity controller = worldState.getController();
        if (controller == null) {
            worldState.setError(new PatternStringError("no controller found"));
            return false;
        }
        BlockPos centerPos = controller.func_174877_v();
        EnumFacing frontFacing = controller.getFrontFacing();
        Set<MultiblockCapability<?>> inputCapabilities = ((ControllerDefinition)controller.getDefinition()).getRecipeMap().inputCapabilities;
        Set<MultiblockCapability<?>> outputCapabilities = ((ControllerDefinition)controller.getDefinition()).getRecipeMap().outputCapabilities;
        if (((ControllerDefinition)controller.getDefinition()).properties.rotationState != CustomProperties.RotationState.NONE) {
            EnumFacing[] enumFacingArray2 = new EnumFacing[1];
            enumFacingArray = enumFacingArray2;
            enumFacingArray2[0] = frontFacing;
        } else {
            EnumFacing[] enumFacingArray3 = new EnumFacing[4];
            enumFacingArray3[0] = EnumFacing.SOUTH;
            enumFacingArray3[1] = EnumFacing.NORTH;
            enumFacingArray3[2] = EnumFacing.EAST;
            enumFacingArray = enumFacingArray3;
            enumFacingArray3[3] = EnumFacing.WEST;
        }
        for (EnumFacing facing : facings = enumFacingArray) {
            if (!this.checkPatternAt(worldState, centerPos, facing, savePredicate, inputCapabilities, outputCapabilities)) continue;
            return true;
        }
        return false;
    }

    public boolean checkPatternAt(MultiblockState worldState, BlockPos centerPos, EnumFacing facing, boolean savePredicate, Set<MultiblockCapability<?>> inputCapabilities, Set<MultiblockCapability<?>> outputCapabilities) {
        boolean findFirstAisle = false;
        int minZ = -this.centerOffset[4];
        worldState.clean();
        PatternMatchContext matchContext = worldState.matchContext;
        Map<SimplePredicate, Integer> globalCount = worldState.globalCount;
        int z = minZ++;
        for (int c = 0; c < this.fingerLength; ++c) {
            int r = 0;
            while (findFirstAisle ? r < this.aisleRepetitions[c][1] : z <= -this.centerOffset[3]) {
                block21: {
                    int b = 0;
                    int y = -this.centerOffset[1];
                    while (b < this.thumbLength) {
                        int a = 0;
                        int x = -this.centerOffset[0];
                        while (a < this.palmLength) {
                            Map capabilities;
                            worldState.setError(null);
                            TraceabilityPredicate predicate = this.blockMatches[c][b][a];
                            BlockPos pos = this.setActualRelativeOffset(x, y, z, facing).func_177982_a(centerPos.func_177958_n(), centerPos.func_177956_o(), centerPos.func_177952_p());
                            if (!worldState.update(pos, predicate)) {
                                return false;
                            }
                            if (!predicate.isAny()) {
                                worldState.addPosCache(pos);
                                if (savePredicate) {
                                    worldState.getMatchContext().getOrCreate("predicates", HashMap::new).put(pos, predicate);
                                }
                            }
                            boolean canPartShared = true;
                            TileEntity tileEntity = worldState.getTileEntity();
                            if (tileEntity instanceof PartTileEntity && !predicate.isAny()) {
                                PartTileEntity partTileEntity = (PartTileEntity)tileEntity;
                                if (partTileEntity.isFormed() && !partTileEntity.canShared() && !partTileEntity.controllerPos.contains(worldState.controllerPos)) {
                                    canPartShared = false;
                                    worldState.setError(new PatternStringError("multiblocked.pattern.error.share"));
                                } else {
                                    worldState.getMatchContext().getOrCreate("parts", LongOpenHashSet::new).add(worldState.getPos().func_177986_g());
                                }
                            }
                            if (!predicate.test(worldState) || !canPartShared) {
                                if (findFirstAisle) {
                                    if (r < this.aisleRepetitions[c][0]) {
                                        c = 0;
                                        r = 0;
                                        z = minZ++;
                                        matchContext.reset();
                                        findFirstAisle = false;
                                    }
                                } else {
                                    ++z;
                                }
                                break block21;
                            }
                            if (tileEntity != null && !predicate.isAny() && !(capabilities = (Map)worldState.getMatchContext().getOrCreate("capabilities", Long2ObjectOpenHashMap::new)).containsKey(worldState.getPos().func_177986_g()) && worldState.io != null) {
                                HashSet bothFound = new HashSet();
                                for (MultiblockCapability<?> capability : inputCapabilities) {
                                    if (worldState.io == IO.BOTH && outputCapabilities.contains(capability) && capability.isBlockHasCapability(IO.BOTH, tileEntity)) {
                                        bothFound.add(capability);
                                        capabilities.computeIfAbsent(worldState.getPos().func_177986_g(), l -> new EnumMap(IO.class)).computeIfAbsent(IO.BOTH, xx -> new HashSet()).add(capability);
                                        continue;
                                    }
                                    if (worldState.io == IO.OUT || !capability.isBlockHasCapability(IO.IN, tileEntity)) continue;
                                    capabilities.computeIfAbsent(worldState.getPos().func_177986_g(), l -> new EnumMap(IO.class)).computeIfAbsent(IO.IN, xx -> new HashSet()).add(capability);
                                }
                                if (worldState.io != IO.IN) {
                                    for (MultiblockCapability<?> capability : outputCapabilities) {
                                        if (bothFound.contains(capability) || !capability.isBlockHasCapability(IO.OUT, tileEntity)) continue;
                                        capabilities.computeIfAbsent(worldState.getPos().func_177986_g(), l -> new EnumMap(IO.class)).computeIfAbsent(IO.OUT, xx -> new HashSet()).add(capability);
                                    }
                                }
                            }
                            ++a;
                            ++x;
                        }
                        ++b;
                        ++y;
                    }
                    findFirstAisle = true;
                    ++z;
                }
                ++r;
            }
            if (r >= this.aisleRepetitions[c][0] && worldState.isFormed() && findFirstAisle) continue;
            if (worldState.isFormed()) {
                worldState.setError(new PatternError());
            }
            return false;
        }
        for (Map.Entry<SimplePredicate, Integer> entry : globalCount.entrySet()) {
            if (entry.getValue() >= entry.getKey().minCount) continue;
            worldState.setError(new SinglePredicateError(entry.getKey(), 1));
            return false;
        }
        worldState.setError(null);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void autoBuild(EntityPlayer player, MultiblockState worldState) {
        World world = player.field_70170_p;
        int minZ = -this.centerOffset[4];
        worldState.clean();
        ControllerTileEntity controller = worldState.getController();
        BlockPos centerPos = controller.func_174877_v();
        EnumFacing facing = controller.getFrontFacing();
        Map<SimplePredicate, Integer> cacheGlobal = worldState.globalCount;
        HashMap<BlockPos, Object> blocks = new HashMap<BlockPos, Object>();
        blocks.put(centerPos, controller);
        int z = minZ++;
        for (int c = 0; c < this.fingerLength; ++c) {
            for (int r = 0; r < this.aisleRepetitions[c][0]; ++r) {
                int b = 0;
                int y = -this.centerOffset[1];
                while (b < this.thumbLength) {
                    int a = 0;
                    int x = -this.centerOffset[0];
                    while (a < this.palmLength) {
                        TraceabilityPredicate predicate = this.blockMatches[c][b][a];
                        BlockPos pos2 = this.setActualRelativeOffset(x, y, z, facing).func_177982_a(centerPos.func_177958_n(), centerPos.func_177956_o(), centerPos.func_177952_p());
                        worldState.update(pos2, predicate);
                        if (!world.func_175623_d(pos2)) {
                            blocks.put(pos2, world.func_180495_p(pos2));
                            for (SimplePredicate limit : predicate.limited) {
                                limit.testLimited(worldState);
                            }
                        } else {
                            void var22_24;
                            boolean find = false;
                            Object[] infos = new BlockInfo[]{};
                            for (SimplePredicate simplePredicate : predicate.limited) {
                                if (simplePredicate.minCount <= 0) continue;
                                if (!cacheGlobal.containsKey(simplePredicate)) {
                                    cacheGlobal.put(simplePredicate, 1);
                                } else {
                                    if (cacheGlobal.get(simplePredicate) >= simplePredicate.minCount || simplePredicate.maxCount != -1 && cacheGlobal.get(simplePredicate) >= simplePredicate.maxCount) continue;
                                    cacheGlobal.put(simplePredicate, cacheGlobal.get(simplePredicate) + 1);
                                }
                                infos = simplePredicate.candidates == null ? null : simplePredicate.candidates.get();
                                find = true;
                                break;
                            }
                            if (!find) {
                                for (SimplePredicate simplePredicate : predicate.limited) {
                                    if (simplePredicate.maxCount != -1 && cacheGlobal.getOrDefault(simplePredicate, Integer.MAX_VALUE) == simplePredicate.maxCount) continue;
                                    if (cacheGlobal.containsKey(simplePredicate)) {
                                        cacheGlobal.put(simplePredicate, cacheGlobal.get(simplePredicate) + 1);
                                    } else {
                                        cacheGlobal.put(simplePredicate, 1);
                                    }
                                    infos = (BlockInfo[])ArrayUtils.addAll((Object[])infos, simplePredicate.candidates == null ? null : simplePredicate.candidates.get());
                                }
                                for (SimplePredicate simplePredicate : predicate.common) {
                                    infos = (BlockInfo[])ArrayUtils.addAll((Object[])infos, simplePredicate.candidates == null ? null : simplePredicate.candidates.get());
                                }
                            }
                            ArrayList<ItemStack> candidates = new ArrayList<ItemStack>();
                            if (infos != null) {
                                for (BlockInfo blockInfo : infos) {
                                    if (blockInfo.getBlockState().func_177230_c() == Blocks.field_150350_a) continue;
                                    IBlockState blockState = blockInfo.getBlockState();
                                    if (blockState.func_177230_c() instanceof BlockComponent && ((BlockComponent)blockState.func_177230_c()).definition != null) {
                                        if (((BlockComponent)blockState.func_177230_c()).definition.getRenderer() instanceof CycleBlockStateRenderer) {
                                            CycleBlockStateRenderer renderer = (CycleBlockStateRenderer)((BlockComponent)blockState.func_177230_c()).definition.getRenderer();
                                            for (BlockInfo blockInfo2 : renderer.blockInfos) {
                                                candidates.add(blockInfo2.getItemStackForm());
                                            }
                                            continue;
                                        }
                                        candidates.add(blockInfo.getItemStackForm());
                                        continue;
                                    }
                                    candidates.add(blockInfo.getItemStackForm());
                                }
                            }
                            Object var22_33 = null;
                            if (!player.func_184812_l_()) {
                                for (ItemStack itemStack : player.field_71071_by.field_70462_a) {
                                    if (!candidates.stream().anyMatch(candidate -> candidate.func_77969_a(itemStack)) || itemStack.func_190926_b() || !(itemStack.func_77973_b() instanceof ItemBlock)) continue;
                                    ItemStack itemStack2 = itemStack.func_77946_l();
                                    itemStack.func_190920_e(itemStack.func_190916_E() - 1);
                                    break;
                                }
                            } else {
                                ItemStack candidate2;
                                ItemStack itemStack;
                                Iterator iterator = candidates.iterator();
                                while (iterator.hasNext() && ((itemStack = (candidate2 = (ItemStack)iterator.next()).func_77946_l()).func_190926_b() || !(itemStack.func_77973_b() instanceof ItemBlock))) {
                                    Object var22_38 = null;
                                }
                            }
                            if (var22_24 != null) {
                                ItemBlock itemBlock = (ItemBlock)var22_24.func_77973_b();
                                int meta = itemBlock.func_77647_b(var22_24.func_77960_j());
                                float f = (float)pos2.func_177958_n() + 0.5f;
                                float hitY = pos2.func_177956_o();
                                float hitZ = (float)pos2.func_177952_p() + 0.5f;
                                IBlockState newState = itemBlock.func_179223_d().getStateForPlacement(world, pos2, facing, f, hitY, hitZ, meta, (EntityLivingBase)player, EnumHand.MAIN_HAND);
                                itemBlock.placeBlockAt((ItemStack)var22_24, player, world, pos2, player.func_174811_aO(), f, hitY, hitZ, newState);
                                TileEntity tileEntity = world.func_175625_s(pos2);
                                if (tileEntity instanceof ComponentTileEntity) {
                                    blocks.put(pos2, tileEntity);
                                }
                            }
                        }
                        ++a;
                        ++x;
                    }
                    ++b;
                    ++y;
                }
                ++z;
            }
        }
        EnumFacing[] facings = (EnumFacing[])ArrayUtils.addAll((Object[])new EnumFacing[]{facing}, (Object[])FACINGS);
        blocks.forEach((pos, block) -> {
            if (block instanceof ComponentTileEntity) {
                ComponentTileEntity componentTileEntity = (ComponentTileEntity)block;
                boolean find = false;
                for (EnumFacing enumFacing : facings) {
                    if (!componentTileEntity.isValidFrontFacing(enumFacing) || blocks.containsKey(pos.func_177972_a(enumFacing))) continue;
                    componentTileEntity.setFrontFacing(enumFacing);
                    find = true;
                    break;
                }
                if (!find) {
                    for (EnumFacing enumFacing : FACINGS) {
                        if (!world.func_175623_d(pos.func_177972_a(enumFacing)) || !componentTileEntity.isValidFrontFacing(enumFacing)) continue;
                        componentTileEntity.setFrontFacing(enumFacing);
                        break;
                    }
                }
            }
        });
    }

    public BlockInfo[][][] getPreview(int[] repetition) {
        HashMap<SimplePredicate, Integer> cacheGlobal = new HashMap<SimplePredicate, Integer>();
        HashMap<BlockPos, BlockInfo> blocks = new HashMap<BlockPos, BlockInfo>();
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        int x = 0;
        for (int l = 0; l < this.fingerLength; ++l) {
            for (int r = 0; r < repetition[l]; ++r) {
                for (int y = 0; y < this.thumbLength; ++y) {
                    for (int z = 0; z < this.palmLength; ++z) {
                        TraceabilityPredicate predicate = this.blockMatches[l][y][z];
                        boolean find = false;
                        BlockInfo[] infos = null;
                        for (SimplePredicate limit : predicate.limited) {
                            if (limit.minCount == -1 && limit.previewCount == -1) continue;
                            if (cacheGlobal.getOrDefault(limit, 0) < limit.previewCount) {
                                if (!cacheGlobal.containsKey(limit)) {
                                    cacheGlobal.put(limit, 1);
                                } else {
                                    if ((Integer)cacheGlobal.get(limit) >= limit.previewCount) continue;
                                    cacheGlobal.put(limit, (Integer)cacheGlobal.get(limit) + 1);
                                }
                            } else {
                                if (limit.minCount <= 0) continue;
                                if (!cacheGlobal.containsKey(limit)) {
                                    cacheGlobal.put(limit, 1);
                                } else {
                                    if ((Integer)cacheGlobal.get(limit) >= limit.minCount) continue;
                                    cacheGlobal.put(limit, (Integer)cacheGlobal.get(limit) + 1);
                                }
                            }
                            infos = limit.candidates == null ? null : limit.candidates.get();
                            find = true;
                            break;
                        }
                        if (!find) {
                            for (SimplePredicate common : predicate.common) {
                                if (common.previewCount <= 0) continue;
                                if (!cacheGlobal.containsKey(common)) {
                                    cacheGlobal.put(common, 1);
                                } else {
                                    if ((Integer)cacheGlobal.get(common) >= common.previewCount) continue;
                                    cacheGlobal.put(common, (Integer)cacheGlobal.get(common) + 1);
                                }
                                infos = common.candidates == null ? null : common.candidates.get();
                                find = true;
                                break;
                            }
                        }
                        if (!find) {
                            for (SimplePredicate common : predicate.common) {
                                if (common.previewCount != -1) continue;
                                infos = common.candidates == null ? null : common.candidates.get();
                                find = true;
                                break;
                            }
                        }
                        if (!find) {
                            for (SimplePredicate limit : predicate.limited) {
                                if (limit.previewCount != -1) continue;
                                if (limit.maxCount != -1) {
                                    if (cacheGlobal.getOrDefault(limit, 0) >= limit.maxCount) continue;
                                    if (!cacheGlobal.containsKey(limit)) {
                                        cacheGlobal.put(limit, 1);
                                    } else {
                                        cacheGlobal.put(limit, (Integer)cacheGlobal.get(limit) + 1);
                                    }
                                }
                                infos = limit.candidates == null ? null : limit.candidates.get();
                                break;
                            }
                        }
                        BlockInfo info2 = infos == null || infos.length == 0 ? BlockInfo.EMPTY : infos[0];
                        BlockPos pos2 = this.setActualRelativeOffset(z, y, x, EnumFacing.NORTH);
                        blocks.put(pos2, info2);
                        minX = Math.min(pos2.func_177958_n(), minX);
                        minY = Math.min(pos2.func_177956_o(), minY);
                        minZ = Math.min(pos2.func_177952_p(), minZ);
                        maxX = Math.max(pos2.func_177958_n(), maxX);
                        maxY = Math.max(pos2.func_177956_o(), maxY);
                        maxZ = Math.max(pos2.func_177952_p(), maxZ);
                    }
                }
                ++x;
            }
        }
        BlockInfo[][][] result = (BlockInfo[][][])Array.newInstance(BlockInfo.class, maxX - minX + 1, maxY - minY + 1, maxZ - minZ + 1);
        int finalMinX = minX;
        int finalMinY = minY;
        int finalMinZ = minZ;
        blocks.forEach((pos, info) -> {
            if (info.getTileEntity() instanceof ComponentTileEntity) {
                ComponentTileEntity componentTileEntity = (ComponentTileEntity)info.getTileEntity();
                boolean find = false;
                for (EnumFacing enumFacing : FACINGS) {
                    if (!componentTileEntity.isValidFrontFacing(enumFacing) || blocks.containsKey(pos.func_177972_a(enumFacing))) continue;
                    componentTileEntity.setFrontFacing(enumFacing);
                    find = true;
                    break;
                }
                if (!find) {
                    for (EnumFacing enumFacing : FACINGS) {
                        BlockInfo blockInfo = (BlockInfo)blocks.get(pos.func_177972_a(enumFacing));
                        if (blockInfo == null || blockInfo.getBlockState().func_177230_c() != Blocks.field_150350_a || !componentTileEntity.isValidFrontFacing(enumFacing)) continue;
                        componentTileEntity.setFrontFacing(enumFacing);
                        break;
                    }
                }
            }
            result[pos.func_177958_n() - finalMinX][pos.func_177956_o() - finalMinY][pos.func_177952_p() - finalMinZ] = info;
        });
        return result;
    }

    private BlockPos setActualRelativeOffset(int x, int y, int z, EnumFacing facing) {
        int[] c0 = new int[]{x, y, z};
        int[] c1 = new int[3];
        block8: for (int i = 0; i < 3; ++i) {
            switch (this.structureDir[i].getActualFacing(facing)) {
                case UP: {
                    c1[1] = c0[i];
                    continue block8;
                }
                case DOWN: {
                    c1[1] = -c0[i];
                    continue block8;
                }
                case WEST: {
                    c1[0] = -c0[i];
                    continue block8;
                }
                case EAST: {
                    c1[0] = c0[i];
                    continue block8;
                }
                case NORTH: {
                    c1[2] = -c0[i];
                    continue block8;
                }
                case SOUTH: {
                    c1[2] = c0[i];
                }
            }
        }
        return new BlockPos(c1[0], c1[1], c1[2]);
    }
}

