/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.json;

import com.cleanroommc.multiblocked.api.pattern.predicates.SimplePredicate;
import com.cleanroommc.multiblocked.api.registry.MbdPredicates;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

public class SimplePredicateFactory
implements TypeAdapterFactory {
    public static final SimplePredicateFactory INSTANCE = new SimplePredicateFactory();

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (SimplePredicate.class.isAssignableFrom(type.getRawType())) {
            return new SimplePredicateTypeAdapter(gson);
        }
        return null;
    }

    private static final class SimplePredicateTypeAdapter
    extends TypeAdapter<SimplePredicate> {
        private final Gson gson;

        private SimplePredicateTypeAdapter(Gson gson) {
            this.gson = gson;
        }

        public void write(JsonWriter out, SimplePredicate src) {
            if (src == null) {
                this.gson.toJson((JsonElement)JsonNull.INSTANCE, out);
                return;
            }
            this.gson.toJson((JsonElement)src.toJson(new JsonObject()), out);
        }

        public SimplePredicate read(JsonReader in) {
            JsonElement jsonElement = (JsonElement)this.gson.fromJson(in, JsonElement.class);
            if (jsonElement.isJsonNull()) {
                return null;
            }
            JsonObject jsonObj = jsonElement.getAsJsonObject();
            String type = jsonObj.get("type").getAsString();
            return MbdPredicates.createPredicate(type, jsonObj);
        }
    }
}

