/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.json;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceTexture;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.api.recipe.RecipeMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.minecraft.util.JsonUtils;

public class RecipeMapTypeAdapter
implements JsonSerializer<RecipeMap>,
JsonDeserializer<RecipeMap> {
    public static final RecipeMapTypeAdapter INSTANCE = new RecipeMapTypeAdapter();

    public RecipeMap deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject json = (JsonObject)jsonElement;
        RecipeMap recipeMap = new RecipeMap(json.get("name").getAsString());
        recipeMap.progressTexture = new ResourceTexture(json.get("progressTexture").getAsString());
        recipeMap.fuelTexture = new ResourceTexture(JsonUtils.func_151219_a((JsonObject)json, (String)"fuelTexture", (String)recipeMap.fuelTexture.imageLocation.toString()));
        for (JsonElement recipe : json.get("recipes").getAsJsonArray()) {
            recipeMap.addRecipe((Recipe)Multiblocked.GSON.fromJson(recipe, Recipe.class));
        }
        if (json.has("fuelRecipes")) {
            for (JsonElement recipe : json.get("fuelRecipes").getAsJsonArray()) {
                recipeMap.addFuelRecipe((Recipe)Multiblocked.GSON.fromJson(recipe, Recipe.class));
            }
        }
        return recipeMap;
    }

    public JsonElement serialize(RecipeMap recipeMap, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject json = new JsonObject();
        json.addProperty("name", recipeMap.name);
        json.addProperty("progressTexture", recipeMap.progressTexture.imageLocation.toString());
        json.addProperty("fuelTexture", recipeMap.fuelTexture.imageLocation.toString());
        JsonArray recipes = new JsonArray();
        recipeMap.recipes.values().forEach(v -> recipes.add(Multiblocked.GSON.toJsonTree(v)));
        json.add("recipes", (JsonElement)recipes);
        if (recipeMap.isFuelRecipeMap()) {
            json.add("fuelRecipes", Multiblocked.GSON.toJsonTree(recipeMap.fuelRecipes));
        }
        return json;
    }
}

