/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.json;

import com.cleanroommc.multiblocked.api.registry.MbdRenderers;
import com.cleanroommc.multiblocked.client.renderer.ICustomRenderer;
import com.cleanroommc.multiblocked.client.renderer.IRenderer;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import net.minecraft.util.JsonUtils;

public class IRendererTypeAdapterFactory
implements TypeAdapterFactory {
    public static final IRendererTypeAdapterFactory INSTANCE = new IRendererTypeAdapterFactory();

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (IRenderer.class.isAssignableFrom(type.getRawType())) {
            return new IRendererTypeAdapter(gson);
        }
        return null;
    }

    public boolean isPostRenderer(JsonElement jsonElement) {
        if (jsonElement.isJsonObject()) {
            if (jsonElement.getAsJsonObject().has("postRenderer")) {
                return JsonUtils.func_151209_a((JsonObject)jsonElement.getAsJsonObject(), (String)"postRenderer", (boolean)false);
            }
            String type = JsonUtils.func_151219_a((JsonObject)jsonElement.getAsJsonObject(), (String)"type", (String)"");
            return type.equals("blockstate");
        }
        return false;
    }

    private static final class IRendererTypeAdapter
    extends TypeAdapter<IRenderer> {
        private final Gson gson;

        private IRendererTypeAdapter(Gson gson) {
            this.gson = gson;
        }

        public void write(JsonWriter out, IRenderer value) {
            if (value instanceof ICustomRenderer) {
                JsonObject jsonObject = ((ICustomRenderer)value).toJson(this.gson, new JsonObject());
                jsonObject.addProperty("type", ((ICustomRenderer)value).getType());
                this.gson.toJson((JsonElement)jsonObject, out);
            } else {
                this.gson.toJson((JsonElement)JsonNull.INSTANCE, out);
            }
        }

        public IRenderer read(JsonReader in) {
            JsonElement jsonElement = (JsonElement)this.gson.fromJson(in, JsonElement.class);
            if (jsonElement.isJsonNull()) {
                return null;
            }
            JsonObject jsonObj = jsonElement.getAsJsonObject();
            String type = jsonObj.get("type").getAsString();
            ICustomRenderer renderer = MbdRenderers.getRenderer(type);
            if (renderer != null) {
                return renderer.fromJson(this.gson, jsonObj);
            }
            return null;
        }
    }
}

