/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.json;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;

public class IBlockStateTypeAdapterFactory
implements TypeAdapterFactory {
    public static final IBlockStateTypeAdapterFactory INSTANCE = new IBlockStateTypeAdapterFactory();

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (IBlockState.class.isAssignableFrom(type.getRawType())) {
            return new IBlockStateTypeAdapter(gson);
        }
        return null;
    }

    private static final class IBlockStateTypeAdapter
    extends TypeAdapter<IBlockState> {
        private final Gson gson;

        private IBlockStateTypeAdapter(Gson gson) {
            this.gson = gson;
        }

        public void write(JsonWriter out, IBlockState value) {
            if (value == null || value.func_177230_c().getRegistryName() == null) {
                this.gson.toJson((JsonElement)JsonNull.INSTANCE, out);
                return;
            }
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("id", value.func_177230_c().getRegistryName().toString());
            jsonObject.addProperty("meta", (Number)value.func_177230_c().func_176201_c(value));
            this.gson.toJson((JsonElement)jsonObject, out);
        }

        public IBlockState read(JsonReader in) {
            JsonElement jsonElement = (JsonElement)this.gson.fromJson(in, JsonElement.class);
            if (jsonElement.isJsonNull()) {
                return null;
            }
            Block block = Block.func_149684_b((String)jsonElement.getAsJsonObject().get("id").getAsString());
            if (block == null) {
                return null;
            }
            if (jsonElement.getAsJsonObject().has("meta")) {
                int meta = jsonElement.getAsJsonObject().get("meta").getAsInt();
                return block.func_176203_a(meta);
            }
            return block.func_176223_P();
        }
    }
}

