/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.item;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.definition.ControllerDefinition;
import com.cleanroommc.multiblocked.api.item.ItemBlueprint;
import com.cleanroommc.multiblocked.api.pattern.JsonBlockPattern;
import com.cleanroommc.multiblocked.api.pattern.MultiblockState;
import com.cleanroommc.multiblocked.api.registry.MbdItems;
import com.cleanroommc.multiblocked.api.tile.ControllerTileEntity;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemMultiblockBuilder
extends Item {
    public ItemMultiblockBuilder() {
        this.setRegistryName("multiblocked", "multiblock_builder");
        this.func_77637_a(Multiblocked.CREATIVE_TAB);
        this.func_77655_b("multiblocked.multiblock_builder");
    }

    public static boolean isItemMultiblockBuilder(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemMultiblockBuilder;
    }

    public static boolean isRaw(ItemStack stack) {
        return stack.func_77960_j() == 0;
    }

    public static boolean setPattern(ItemStack stack) {
        if (ItemMultiblockBuilder.isItemMultiblockBuilder(stack)) {
            stack.func_77964_b(1);
            return true;
        }
        return false;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (!world.field_72995_K) {
            TileEntity tileEntity = world.func_175625_s(pos);
            ItemStack hold = player.func_184586_b(hand);
            if (ItemMultiblockBuilder.isItemMultiblockBuilder(hold) && tileEntity instanceof ControllerTileEntity) {
                if (ItemMultiblockBuilder.isRaw(hold)) {
                    ((ControllerTileEntity)tileEntity).getPattern().autoBuild(player, new MultiblockState(world, pos));
                    return EnumActionResult.SUCCESS;
                }
                String json = hold.func_190925_c("pattern").func_74779_i("json");
                String controller = hold.func_190925_c("pattern").func_74779_i("controller");
                if (!json.isEmpty() && !controller.isEmpty() && controller.equals(((ControllerDefinition)((ControllerTileEntity)tileEntity).getDefinition()).location.toString())) {
                    JsonBlockPattern jsonBlockPattern = (JsonBlockPattern)Multiblocked.GSON.fromJson(json, JsonBlockPattern.class);
                    jsonBlockPattern.build().autoBuild(player, new MultiblockState(world, pos));
                    return EnumActionResult.SUCCESS;
                }
            }
        }
        return EnumActionResult.PASS;
    }

    @ParametersAreNonnullByDefault
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (ItemMultiblockBuilder.isItemMultiblockBuilder(stack)) {
            if (ItemMultiblockBuilder.isRaw(stack)) {
                tooltip.add("auto build");
            } else {
                ResourceLocation location = new ResourceLocation(stack.func_190925_c("pattern").func_74779_i("controller"));
                tooltip.add("pattern build");
                tooltip.add(String.format("Controller: %s", I18n.func_135052_a((String)(location.func_110624_b() + "." + location.func_110623_a() + ".name"), (Object[])new Object[0])));
            }
        }
    }

    public static class BuilderRecipeLogic
    extends ShapelessRecipes {
        private static final ItemStack resultStack = new ItemStack((Item)MbdItems.BUILDER);
        private static final Ingredient builder;
        private static final Ingredient blueprint;

        public BuilderRecipeLogic() {
            super("builder", resultStack, NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{builder, blueprint}));
        }

        public boolean func_77569_a(@Nonnull InventoryCrafting inv, @Nonnull World worldIn) {
            ItemStack a = null;
            ItemStack b = null;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack itemStack = inv.func_70301_a(i);
                if (itemStack.func_190926_b()) continue;
                if (a == null) {
                    a = itemStack;
                    continue;
                }
                if (b == null) {
                    b = itemStack;
                    continue;
                }
                return false;
            }
            if (a == null || b == null) {
                return false;
            }
            return builder.test(a) && blueprint.test(b) || builder.test(b) && blueprint.test((Object)a);
        }

        @Nonnull
        public ItemStack func_77572_b(@Nonnull InventoryCrafting inv) {
            ItemStack a = null;
            ItemStack b = null;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack itemStack = inv.func_70301_a(i);
                if (itemStack.func_190926_b()) continue;
                if (a == null) {
                    a = itemStack;
                    continue;
                }
                if (b == null) {
                    b = itemStack;
                    continue;
                }
                return ItemStack.field_190927_a;
            }
            if (a == null || b == null) {
                return ItemStack.field_190927_a;
            }
            ItemStack builder = new ItemStack((Item)MbdItems.BUILDER);
            ItemMultiblockBuilder.setPattern(builder);
            if (ItemBlueprint.isItemBlueprint(a) && !ItemBlueprint.isRaw(a)) {
                builder.func_190925_c("pattern").func_74778_a("json", a.func_190925_c("pattern").func_74779_i("json"));
                builder.func_190925_c("pattern").func_74778_a("controller", a.func_190925_c("pattern").func_74779_i("controller"));
            } else if (ItemBlueprint.isItemBlueprint(b) && !ItemBlueprint.isRaw(b)) {
                builder.func_190925_c("pattern").func_74778_a("json", b.func_190925_c("pattern").func_74779_i("json"));
                builder.func_190925_c("pattern").func_74778_a("controller", b.func_190925_c("pattern").func_74779_i("controller"));
            }
            return builder;
        }

        @Nonnull
        public NonNullList<ItemStack> func_179532_b(@Nonnull InventoryCrafting inv) {
            NonNullList ret = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
            ItemStack blueprint = null;
            ItemStack builder = null;
            int index = 0;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack itemStack = inv.func_70301_a(i).func_77946_l();
                if (ItemMultiblockBuilder.isItemMultiblockBuilder(itemStack) && !ItemMultiblockBuilder.isRaw(itemStack)) {
                    index = i;
                    builder = itemStack;
                    continue;
                }
                if (!ItemBlueprint.isItemBlueprint(itemStack)) continue;
                blueprint = itemStack;
            }
            if (builder != null && blueprint != null) {
                ret.set(index, blueprint);
                blueprint.func_190925_c("pattern").func_74778_a("json", builder.func_190925_c("pattern").func_74779_i("json"));
                blueprint.func_190925_c("pattern").func_74778_a("controller", builder.func_190925_c("pattern").func_74779_i("controller"));
            }
            return ret;
        }

        public boolean func_194133_a(int width, int height) {
            return width * height >= 2;
        }

        public boolean func_192399_d() {
            return true;
        }

        static {
            ItemMultiblockBuilder.setPattern(resultStack);
            ItemStack stack = new ItemStack((Item)MbdItems.BLUEPRINT);
            ItemBlueprint.setPattern(stack);
            blueprint = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack});
            stack = new ItemStack((Item)MbdItems.BUILDER);
            ItemMultiblockBuilder.setPattern(stack);
            builder = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)MbdItems.BUILDER), stack});
        }
    }
}

