/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.item;

import com.cleanroommc.multiblocked.Multiblocked;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemBlueprint
extends Item {
    public ItemBlueprint() {
        this.setRegistryName("multiblocked", "blueprint");
        this.func_77637_a(Multiblocked.CREATIVE_TAB);
        this.func_77655_b("multiblocked.blueprint");
    }

    public static boolean isItemBlueprint(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemBlueprint;
    }

    public static BlockPos[] getPos(ItemStack stack) {
        NBTTagCompound tag = stack.func_190925_c("blueprint");
        if (!tag.func_74764_b("minX")) {
            return null;
        }
        return new BlockPos[]{new BlockPos(tag.func_74762_e("minX"), tag.func_74762_e("minY"), tag.func_74762_e("minZ")), new BlockPos(tag.func_74762_e("maxX"), tag.func_74762_e("maxY"), tag.func_74762_e("maxZ"))};
    }

    public static void addPos(ItemStack stack, BlockPos pos) {
        NBTTagCompound tag = stack.func_190925_c("blueprint");
        if (!tag.func_74764_b("minX") || tag.func_74762_e("minX") > pos.func_177958_n()) {
            tag.func_74768_a("minX", pos.func_177958_n());
        }
        if (!tag.func_74764_b("maxX") || tag.func_74762_e("maxX") < pos.func_177958_n()) {
            tag.func_74768_a("maxX", pos.func_177958_n());
        }
        if (!tag.func_74764_b("minY") || tag.func_74762_e("minY") > pos.func_177956_o()) {
            tag.func_74768_a("minY", pos.func_177956_o());
        }
        if (!tag.func_74764_b("maxY") || tag.func_74762_e("maxY") < pos.func_177956_o()) {
            tag.func_74768_a("maxY", pos.func_177956_o());
        }
        if (!tag.func_74764_b("minZ") || tag.func_74762_e("minZ") > pos.func_177952_p()) {
            tag.func_74768_a("minZ", pos.func_177952_p());
        }
        if (!tag.func_74764_b("maxZ") || tag.func_74762_e("maxZ") < pos.func_177952_p()) {
            tag.func_74768_a("maxZ", pos.func_177952_p());
        }
    }

    public static void removePos(ItemStack stack) {
        NBTTagCompound tag = stack.func_190925_c("blueprint");
        tag.func_82580_o("minX");
        tag.func_82580_o("maxX");
        tag.func_82580_o("minY");
        tag.func_82580_o("maxY");
        tag.func_82580_o("minZ");
        tag.func_82580_o("maxZ");
    }

    public static boolean isRaw(ItemStack stack) {
        return stack.func_77960_j() == 0;
    }

    public static boolean setRaw(ItemStack stack) {
        if (ItemBlueprint.isItemBlueprint(stack)) {
            stack.func_77964_b(0);
            return true;
        }
        return false;
    }

    public static boolean setPattern(ItemStack stack) {
        if (ItemBlueprint.isItemBlueprint(stack)) {
            stack.func_77964_b(1);
            return true;
        }
        return false;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_70093_af()) {
            ItemBlueprint.addPos(stack, pos);
        } else {
            ItemBlueprint.removePos(stack);
            ItemBlueprint.setRaw(stack);
        }
        return EnumActionResult.SUCCESS;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            ItemBlueprint.removePos(stack);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }
}

