/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp.tester;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.crafttweaker.CTHelper;
import com.cleanroommc.multiblocked.api.gui.texture.ColorRectTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceTexture;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.util.ClickData;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ButtonWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableScrollableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ImageWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SelectableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextBoxWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.controller.PageWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.tab.TabContainer;
import com.cleanroommc.multiblocked.util.FileUtility;
import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.network.PacketBuffer;

public class ZSScriptWidget
extends PageWidget {
    private static final ResourceTexture PAGE = new ResourceTexture("multiblocked:textures/gui/ct_loader_page.png");
    private final DraggableScrollableWidgetGroup zsList;
    private final TextBoxWidget textBox;
    private final DraggableScrollableWidgetGroup tfGroup;
    private File selected;

    public ZSScriptWidget(TabContainer tabContainer) {
        super(PAGE, tabContainer);
        this.addWidget(new ImageWidget(5, 5, 166, 95, ResourceBorderTexture.BORDERED_BACKGROUND_BLUE));
        this.zsList = new DraggableScrollableWidgetGroup(10, 10, 156, 85).setBackground(new ColorRectTexture(-16777216));
        this.addWidget(this.zsList);
        this.addWidget(new ButtonWidget(5, 105, 20, 20, new ResourceTexture("multiblocked:textures/gui/save.png"), cd -> {
            if (!cd.isRemote) {
                return;
            }
            try {
                File dir = new File("scripts");
                Desktop.getDesktop().open(dir.isDirectory() ? dir : dir.getParentFile());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.tips.open_folder"));
        this.addWidget(new ButtonWidget(30, 105, 140, 20, null, this::loadZS).setButtonTexture(ResourceBorderTexture.BUTTON_COMMON, new TextTexture("load script", -1).setDropShadow(true)).setHoverBorderTexture(1, -1));
        this.tfGroup = new DraggableScrollableWidgetGroup(5, 130, 166, 120).setBackground(new ColorRectTexture(-1354480572)).setYScrollBarWidth(4).setYBarStyle(null, new ColorRectTexture(-1));
        this.textBox = new TextBoxWidget(0, 0, 162, Collections.singletonList("")).setFontColor(-1).setShadow(true);
        this.tfGroup.addWidget(this.textBox);
        this.addWidget(this.tfGroup);
        this.updateList();
    }

    private void loadZS(ClickData clickData) {
        if (this.selected != null) {
            try {
                String zs = FileUtility.readInputStream(new FileInputStream(this.selected));
                if (!CTHelper.executeDynamicScript(zs)) {
                    zs = CTHelper.getError() == null ? "error" : CTHelper.getError();
                }
                this.textBox.setContent(Collections.singletonList(zs));
                this.tfGroup.computeMax();
            }
            catch (IOException exception) {
                Multiblocked.LOGGER.error("tester: loading ct", (Throwable)exception);
            }
        }
    }

    private void updateList() {
        this.zsList.clearAllWidgets();
        this.selected = null;
        File path = new File("scripts");
        if (!path.isDirectory() && !path.mkdirs()) {
            return;
        }
        for (File file : Optional.ofNullable(path.listFiles()).orElse(new File[0])) {
            if (!file.isFile() || !file.getName().endsWith(".zs")) continue;
            this.zsList.addWidget(new SelectableWidgetGroup(0, 1 + this.zsList.widgets.size() * 11, this.zsList.getSize().width, 10).setSelectedTexture(-1, -1).setOnSelected(W -> {
                this.selected = file;
                this.writeClientAction(-1, buffer -> {
                    buffer.writeBoolean(this.selected != null);
                    if (this.selected != null) {
                        buffer.func_180714_a(file.getName());
                    }
                });
            }).addWidget(new ImageWidget(0, 0, this.zsList.getSize().width, 10, new ColorRectTexture(-16777216))).addWidget(new ImageWidget(0, 0, this.zsList.getSize().width, 10, new TextTexture(file.getName().replace(".zs", "")).setWidth(this.zsList.getSize().width).setType(TextTexture.TextType.ROLL))));
        }
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        if (id == -1) {
            this.selected = buffer.readBoolean() ? new File(new File("scripts"), buffer.func_150789_c(Short.MAX_VALUE)) : null;
        } else {
            super.handleClientAction(id, buffer);
        }
    }
}

