/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp.tab;

import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.tab.TabButton;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Optional;
import java.util.function.BiConsumer;

public class TabContainer
extends WidgetGroup {
    public final BiMap<TabButton, WidgetGroup> tabs = HashBiMap.create();
    public final WidgetGroup buttonGroup;
    public final WidgetGroup containerGroup;
    public WidgetGroup focus;
    public BiConsumer<WidgetGroup, WidgetGroup> onChanged;

    public TabContainer(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.buttonGroup = new WidgetGroup(x, y, width, height);
        this.containerGroup = new WidgetGroup(x, y, width, height);
        this.addWidget(this.containerGroup);
        this.addWidget(this.buttonGroup);
    }

    public TabContainer setOnChanged(BiConsumer<WidgetGroup, WidgetGroup> onChanged) {
        this.onChanged = onChanged;
        return this;
    }

    public void switchTag(WidgetGroup tabWidget) {
        if (this.focus == tabWidget) {
            return;
        }
        if (this.focus != null) {
            ((TabButton)this.tabs.inverse().get((Object)this.focus)).setPressed(false);
            this.focus.setVisible(false);
            this.focus.setActive(false);
        }
        if (this.onChanged != null) {
            this.onChanged.accept(this.focus, tabWidget);
        }
        this.focus = tabWidget;
        Optional.ofNullable(this.tabs.inverse().get((Object)tabWidget)).ifPresent(tab -> {
            tab.setPressed(true);
            tabWidget.setActive(true);
            tabWidget.setVisible(true);
        });
    }

    public void addTab(TabButton tabButton, WidgetGroup tabWidget) {
        tabButton.setContainer(this);
        this.tabs.put((Object)tabButton, (Object)tabWidget);
        this.containerGroup.addWidget(tabWidget);
        this.buttonGroup.addWidget(tabButton);
        if (this.focus == null) {
            this.focus = tabWidget;
        }
        tabButton.setPressed(this.focus == tabWidget);
        tabWidget.setVisible(this.focus == tabWidget);
        tabWidget.setActive(this.focus == tabWidget);
    }
}

