/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp.recipe;

import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.gui.texture.ColorRectTexture;
import com.cleanroommc.multiblocked.api.gui.texture.IGuiTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ProgressTexture;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ButtonWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableScrollableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ImageWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.LabelWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.ProgressWidget;
import com.cleanroommc.multiblocked.api.recipe.Content;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.api.recipe.RecipeCondition;
import com.cleanroommc.multiblocked.api.recipe.RecipeMap;
import com.cleanroommc.multiblocked.jei.JeiPlugin;
import com.cleanroommc.multiblocked.util.Size;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.DoubleSupplier;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.Loader;

public class RecipeWidget
extends WidgetGroup {
    public final RecipeMap recipeMap;
    public final Recipe recipe;
    public final DraggableScrollableWidgetGroup inputs;
    public final DraggableScrollableWidgetGroup outputs;

    public RecipeWidget(RecipeMap recipeMap, @Nullable Recipe recipe, DoubleSupplier progress, DoubleSupplier fuel) {
        super(0, 0, 176, 84);
        MultiblockCapability capability;
        this.recipeMap = recipeMap;
        this.recipe = recipe;
        this.setClientSideWidget();
        ColorRectTexture overlay = new ColorRectTexture(0x1F000000);
        this.inputs = new DraggableScrollableWidgetGroup(5, 5, 64, 64).setBackground(overlay);
        this.outputs = new DraggableScrollableWidgetGroup(107, 5, 64, 64).setBackground(overlay);
        this.addWidget(this.inputs);
        this.addWidget(this.outputs);
        this.addWidget(new ProgressWidget(progress, 78, 27, 20, 20, recipeMap.progressTexture).setFillDirection(ProgressTexture.FillDirection.LEFT_TO_RIGHT));
        this.addWidget(new ButtonWidget(78, 27, 20, 20, IGuiTexture.EMPTY, cd -> {
            if (Loader.isModLoaded((String)"jei")) {
                JeiPlugin.getJeiRuntime().getRecipesGui().showCategories(Collections.singletonList(new ResourceLocation("multiblocked", recipeMap.name).toString()));
            }
        }).setHoverTexture(overlay));
        if (recipeMap.isFuelRecipeMap()) {
            this.addWidget(new ProgressWidget(fuel, 78, 47, 20, 20, recipeMap.fuelTexture).setFillDirection(ProgressTexture.FillDirection.DOWN_TO_UP));
            this.addWidget(new ButtonWidget(78, 47, 20, 20, IGuiTexture.EMPTY, cd -> {
                if (Loader.isModLoaded((String)"jei")) {
                    JeiPlugin.getJeiRuntime().getRecipesGui().showCategories(Collections.singletonList(new ResourceLocation("multiblocked", recipeMap.name + ".fuel").toString()));
                }
            }).setHoverTexture(overlay));
        }
        if (recipe == null) {
            return;
        }
        this.addWidget(new LabelWidget(5, 73, I18n.func_135052_a((String)"multiblocked.recipe.duration", (Object[])new Object[]{(double)recipe.duration / 20.0})).setTextColor(-16777216).setDrop(false));
        if (recipe.text != null) {
            this.addWidget(new LabelWidget(80, 73, recipe.text.func_150254_d()).setTextColor(-16777216).setDrop(false));
        }
        int index = 0;
        for (Map.Entry entry : recipe.inputs.entrySet()) {
            capability = (MultiblockCapability)entry.getKey();
            for (Content in : (ImmutableList)entry.getValue()) {
                this.inputs.addWidget(capability.createContentWidget().setContent(IO.IN, in, false).setSelfPosition(2 + 20 * (index % 3), 2 + 20 * (index / 3)));
                ++index;
            }
        }
        for (Map.Entry entry : recipe.tickInputs.entrySet()) {
            capability = (MultiblockCapability)entry.getKey();
            for (Content in : (ImmutableList)entry.getValue()) {
                this.inputs.addWidget(capability.createContentWidget().setContent(IO.IN, in, true).setSelfPosition(2 + 20 * (index % 3), 2 + 20 * (index / 3)));
                ++index;
            }
        }
        if (index > 9) {
            this.inputs.setSize(new Size(68, 64));
            this.inputs.setYScrollBarWidth(4).setYBarStyle(null, new ColorRectTexture(-1));
        }
        index = 0;
        for (Map.Entry entry : recipe.outputs.entrySet()) {
            capability = (MultiblockCapability)entry.getKey();
            for (Content out : (ImmutableList)entry.getValue()) {
                this.outputs.addWidget(capability.createContentWidget().setContent(IO.OUT, out, false).setSelfPosition(2 + 20 * (index % 3), 2 + 20 * (index / 3)));
                ++index;
            }
        }
        for (Map.Entry entry : recipe.tickOutputs.entrySet()) {
            capability = (MultiblockCapability)entry.getKey();
            for (Content out : (ImmutableList)entry.getValue()) {
                this.outputs.addWidget(capability.createContentWidget().setContent(IO.OUT, out, true).setSelfPosition(2 + 20 * (index % 3), 2 + 20 * (index / 3)));
                ++index;
            }
        }
        if (index > 9) {
            this.outputs.setSize(new Size(68, 64));
            this.outputs.setYScrollBarWidth(4).setYBarStyle(null, new ColorRectTexture(-1));
        }
        HashMap<String, List> conditionMap = new HashMap<String, List>();
        for (RecipeCondition condition : recipe.conditions) {
            if (condition.isReverse()) {
                conditionMap.computeIfAbsent(condition.getType(), s -> new ArrayList()).add(condition);
                continue;
            }
            conditionMap.computeIfAbsent(condition.getType(), s -> new ArrayList()).add(0, condition);
        }
        index = 0;
        for (Map.Entry entry : conditionMap.entrySet()) {
            List list = (List)entry.getValue();
            if (list.isEmpty()) continue;
            ++index;
            boolean reversed = false;
            ArrayList<Object> components = new ArrayList<Object>();
            for (RecipeCondition condition : list) {
                if (!reversed && condition.isReverse()) {
                    reversed = true;
                    components.add(new TextComponentTranslation("multiblocked.gui.condition.reverse", new Object[0]));
                }
                components.add(condition.getTooltips());
            }
            this.addWidget(new ImageWidget(168 - index * 16, 70, 16, 16, ((RecipeCondition)list.get(0)).getValidTexture()).setHoverTooltip(((ITextComponent)components.stream().reduce(new TextComponentString(""), ITextComponent::func_150257_a)).func_150254_d()));
        }
    }
}

