/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp.recipe;

import com.cleanroommc.multiblocked.api.gui.texture.IGuiTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ProgressTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceTexture;
import com.cleanroommc.multiblocked.api.gui.widget.Widget;
import com.cleanroommc.multiblocked.util.Position;
import com.cleanroommc.multiblocked.util.Size;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import net.minecraft.network.PacketBuffer;

public class ProgressWidget
extends Widget {
    public static final DoubleSupplier JEIProgress = () -> (double)Math.abs(System.currentTimeMillis() % 2000L) / 2000.0;
    public final DoubleSupplier progressSupplier;
    private ProgressTexture progressBar;
    private Function<Double, String> dynamicHoverTips;
    private double lastProgressValue;

    public ProgressWidget(DoubleSupplier progressSupplier, int x, int y, int width, int height, ResourceTexture fullImage) {
        super(new Position(x, y), new Size(width, height));
        this.progressSupplier = progressSupplier;
        this.progressBar = new ProgressTexture(fullImage.getSubTexture(0.0, 0.0, 1.0, 0.5), fullImage.getSubTexture(0.0, 0.5, 1.0, 0.5));
        this.lastProgressValue = -1.0;
    }

    public ProgressWidget(DoubleSupplier progressSupplier, int x, int y, int width, int height) {
        super(new Position(x, y), new Size(width, height));
        this.progressSupplier = progressSupplier;
    }

    public ProgressWidget setProgressBar(IGuiTexture emptyBarArea, IGuiTexture filledBarArea) {
        this.progressBar = new ProgressTexture(emptyBarArea, filledBarArea);
        return this;
    }

    public ProgressWidget setDynamicHoverTips(Function<Double, String> hoverTips) {
        this.dynamicHoverTips = hoverTips;
        return this;
    }

    public ProgressWidget setFillDirection(ProgressTexture.FillDirection fillDirection) {
        this.progressBar.setFillDirection(fillDirection);
        return this;
    }

    @Override
    public void initWidget() {
        super.initWidget();
        this.lastProgressValue = this.progressSupplier.getAsDouble();
    }

    @Override
    public void writeInitialData(PacketBuffer buffer) {
        super.writeInitialData(buffer);
        buffer.writeDouble(this.lastProgressValue);
    }

    @Override
    public void readInitialData(PacketBuffer buffer) {
        super.readInitialData(buffer);
        this.lastProgressValue = buffer.readDouble();
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks) {
        Position pos = this.getPosition();
        Size size = this.getSize();
        if (this.progressSupplier == JEIProgress || this.isClientSideWidget) {
            this.lastProgressValue = this.progressSupplier.getAsDouble();
            if (this.dynamicHoverTips != null) {
                this.setHoverTooltip(this.dynamicHoverTips.apply(this.lastProgressValue));
            }
        }
        this.progressBar.setProgress(this.lastProgressValue);
        this.progressBar.draw(mouseX, mouseY, pos.x, pos.y, size.width, size.height);
    }

    @Override
    public void detectAndSendChanges() {
        double actualValue = this.progressSupplier.getAsDouble();
        if (actualValue - this.lastProgressValue != 0.0) {
            this.lastProgressValue = actualValue;
            this.writeUpdateInfo(0, buffer -> buffer.writeDouble(actualValue));
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        if (id == 0) {
            this.lastProgressValue = buffer.readDouble();
            if (this.dynamicHoverTips != null) {
                this.setHoverTooltip(this.dynamicHoverTips.apply(this.lastProgressValue));
            }
        }
    }
}

