/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp.recipe;

import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.gui.texture.ColorRectTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ProgressTexture;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableScrollableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ImageWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.LabelWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.ProgressWidget;
import com.cleanroommc.multiblocked.api.recipe.Content;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.api.recipe.RecipeCondition;
import com.cleanroommc.multiblocked.api.recipe.RecipeMap;
import com.cleanroommc.multiblocked.util.Size;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class FuelWidget
extends WidgetGroup {
    public final RecipeMap recipeMap;
    public final Recipe recipe;
    public final DraggableScrollableWidgetGroup inputs;

    public FuelWidget(RecipeMap recipeMap, Recipe recipe) {
        super(0, 0, 176, 44);
        MultiblockCapability capability;
        this.recipeMap = recipeMap;
        this.recipe = recipe;
        String duration = I18n.func_135052_a((String)"multiblocked.recipe.duration", (Object[])new Object[]{(double)recipe.duration / 20.0});
        this.setClientSideWidget();
        this.inputs = new DraggableScrollableWidgetGroup(5, 5, 64, 24).setBackground(new ColorRectTexture(0x1F000000));
        this.addWidget(this.inputs);
        this.addWidget(new ImageWidget(129, 7, 20, 20, recipeMap.categoryTexture));
        this.addWidget(new ProgressWidget(ProgressWidget.JEIProgress, 78, 7, 20, 20, recipeMap.fuelTexture).setFillDirection(ProgressTexture.FillDirection.DOWN_TO_UP).setHoverTooltip(duration));
        this.addWidget(new LabelWidget(5, 33, duration).setTextColor(-16777216).setDrop(false));
        int index = 0;
        for (Map.Entry entry : recipe.inputs.entrySet()) {
            capability = (MultiblockCapability)entry.getKey();
            for (Content in : (ImmutableList)entry.getValue()) {
                this.inputs.addWidget(capability.createContentWidget().setContent(IO.IN, in, false).setSelfPosition(2 + 20 * (index % 3), 2 + 20 * (index / 3)));
                ++index;
            }
        }
        for (Map.Entry entry : recipe.tickInputs.entrySet()) {
            capability = (MultiblockCapability)entry.getKey();
            for (Content in : (ImmutableList)entry.getValue()) {
                this.inputs.addWidget(capability.createContentWidget().setContent(IO.IN, in, true).setSelfPosition(2 + 20 * (index % 3), 2 + 20 * (index / 3)));
                ++index;
            }
        }
        if (index > 9) {
            this.inputs.setSize(new Size(68, 64));
            this.inputs.setYScrollBarWidth(4).setYBarStyle(null, new ColorRectTexture(-1));
        }
        HashMap<String, List> conditionMap = new HashMap<String, List>();
        for (RecipeCondition condition : recipe.conditions) {
            if (condition.isReverse()) {
                conditionMap.computeIfAbsent(condition.getType(), s -> new ArrayList()).add(condition);
                continue;
            }
            conditionMap.computeIfAbsent(condition.getType(), s -> new ArrayList()).add(0, condition);
        }
        index = 0;
        for (Map.Entry entry : conditionMap.entrySet()) {
            List list = (List)entry.getValue();
            if (list.isEmpty()) continue;
            ++index;
            boolean reversed = false;
            ArrayList<Object> components = new ArrayList<Object>();
            for (RecipeCondition condition : list) {
                if (!reversed && condition.isReverse()) {
                    reversed = true;
                    components.add(new TextComponentTranslation("multiblocked.gui.condition.reverse", new Object[0]));
                }
                components.add(condition.getTooltips());
            }
            this.addWidget(new ImageWidget(168 - index * 16, 70, 16, 16, ((RecipeCondition)list.get(0)).getValidTexture()).setHoverTooltip(((ITextComponent)components.stream().reduce(new TextComponentString(""), ITextComponent::func_150257_a)).func_150254_d()));
        }
    }
}

