/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp.recipe;

import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.gui.texture.IGuiTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceTexture;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.util.DrawerHelper;
import com.cleanroommc.multiblocked.api.gui.widget.Widget;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ButtonWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DialogWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ImageWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.LabelWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SelectableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SwitchWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextFieldWidget;
import com.cleanroommc.multiblocked.api.recipe.Content;
import com.cleanroommc.multiblocked.util.LocalizationUtils;
import com.cleanroommc.multiblocked.util.Position;
import com.cleanroommc.multiblocked.util.Size;
import com.google.common.collect.Lists;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IGhostIngredientHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ContentWidget<T>
extends SelectableWidgetGroup {
    protected T content;
    protected float chance;
    protected IO io;
    protected String slotName;
    protected boolean perTick;
    protected IGuiTexture background;
    protected Consumer<ContentWidget<T>> onPhantomUpdate;
    protected Consumer<ContentWidget<T>> onMouseClicked;

    public ContentWidget() {
        super(0, 0, 20, 20);
        this.setClientSideWidget();
    }

    public ContentWidget<T> setSelfPosition(int x, int y) {
        this.setSelfPosition(new Position(x, y));
        return this;
    }

    @Deprecated
    public final ContentWidget<T> setContent(@Nonnull IO io, @Nonnull Object content, float chance, boolean perTick) {
        this.io = io;
        this.content = content;
        this.chance = chance;
        this.perTick = perTick;
        this.onContentUpdate();
        return this;
    }

    public final ContentWidget<T> setContent(@Nonnull IO io, Content content, boolean perTick) {
        this.io = io;
        this.content = content.content;
        this.chance = content.chance;
        this.perTick = perTick;
        this.slotName = content.slotName;
        this.onContentUpdate();
        return this;
    }

    @Override
    public List<IGhostIngredientHandler.Target<?>> getPhantomTargets(Object ingredient) {
        List<IGhostIngredientHandler.Target<?>> pattern = super.getPhantomTargets(ingredient);
        if (pattern != null && pattern.size() > 0) {
            return pattern;
        }
        Object ingredientContent = this.getJEIIngredient(this.getContent());
        if (ingredientContent == null || !ingredient.getClass().equals(ingredientContent.getClass())) {
            return Collections.emptyList();
        }
        final Rectangle rectangle = this.toRectangleBox();
        return Lists.newArrayList((Object[])new IGhostIngredientHandler.Target[]{new IGhostIngredientHandler.Target<Object>(){

            @Nonnull
            public Rectangle getArea() {
                return rectangle;
            }

            public void accept(@Nonnull Object ingredient) {
                Object content;
                Object ingredientContent = ContentWidget.this.getJEIIngredient(ContentWidget.this.getContent());
                if (ingredientContent != null && ingredient.getClass().equals(ingredientContent.getClass()) && (content = ContentWidget.this.getJEIContent(ingredient)) != null) {
                    ContentWidget.this.setContent(ContentWidget.this.io, content, ContentWidget.this.chance, ContentWidget.this.perTick);
                    if (ContentWidget.this.onPhantomUpdate != null) {
                        ContentWidget.this.onPhantomUpdate.accept(ContentWidget.this);
                    }
                }
            }
        }});
    }

    @Override
    public Object getIngredientOverMouse(int mouseX, int mouseY) {
        Object result = super.getIngredientOverMouse(mouseX, mouseY);
        if (result != null) {
            return result;
        }
        if (this.isMouseOverElement(mouseX, mouseY)) {
            return this.getJEIIngredient(this.getContent());
        }
        return null;
    }

    public T getJEIContent(Object content) {
        return (T)content;
    }

    @Nullable
    public Object getJEIIngredient(T content) {
        return content;
    }

    public IO getIo() {
        return this.io;
    }

    public T getContent() {
        return this.content;
    }

    public float getChance() {
        return this.chance;
    }

    public String getSlotName() {
        return this.slotName;
    }

    public boolean getPerTick() {
        return this.perTick;
    }

    public ContentWidget<T> setOnMouseClicked(Consumer<ContentWidget<T>> onMouseClicked) {
        this.onMouseClicked = onMouseClicked;
        return this;
    }

    public ContentWidget<T> setOnPhantomUpdate(Consumer<ContentWidget<T>> onPhantomUpdate) {
        this.onPhantomUpdate = onPhantomUpdate;
        return this;
    }

    @Override
    public boolean allowSelected(int mouseX, int mouseY, int button) {
        return this.onSelected != null && this.isMouseOverElement(mouseX, mouseY);
    }

    @Override
    public void onUnSelected() {
        this.isSelected = false;
    }

    protected abstract void onContentUpdate();

    public void openConfigurator(WidgetGroup dialog) {
        dialog.addWidget(new LabelWidget(5, 8, "multiblocked.gui.label.chance"));
        dialog.addWidget(new TextFieldWidget(65, 5, 30, 15, true, null, number -> this.setContent(this.io, this.content, Float.parseFloat(number), this.perTick)).setNumbersOnly(0.0f, 1.0f).setCurrentString(this.chance + ""));
        dialog.addWidget(new ButtonWidget(100, 5, 15, 15, new ResourceTexture("multiblocked:textures/gui/option.png"), cd -> {
            DialogWidget dialogWidget = new DialogWidget(dialog, true);
            dialogWidget.addWidget(new ImageWidget(0, 0, dialog.getSize().width, dialog.getSize().height, ResourceBorderTexture.BORDERED_BACKGROUND)).addWidget(new LabelWidget(25, 8, "perTick")).addWidget(new SwitchWidget(5, 5, 15, 15, (x, r) -> this.setContent(this.io, this.content, this.chance, (boolean)r)).setBaseTexture(new ResourceTexture("multiblocked:textures/gui/boolean.png").getSubTexture(0.0, 0.0, 1.0, 0.5)).setPressedTexture(new ResourceTexture("multiblocked:textures/gui/boolean.png").getSubTexture(0.0, 0.5, 1.0, 0.5)).setHoverBorderTexture(1, -1).setPressed(this.perTick).setHoverTooltip("multiblocked.gui.content.per_tick")).addWidget(new TextFieldWidget(5, 25, dialog.getSize().width - 10, 15, true, null, s -> this.setContent(this.io, new Content(this.content, this.chance, s != null && !s.isEmpty() ? s : null), this.perTick)).setCurrentString(this.slotName == null ? "" : this.slotName).setHoverTooltip("multiblocked.gui.content.slot_name")).addWidget(new ButtonWidget(5, dialog.getSize().height - 20, dialog.getSize().width - 10, 15, null, c -> dialogWidget.close()).setButtonTexture(ResourceBorderTexture.BUTTON_COMMON, new TextTexture("multiblocked.gui.content.back")));
        }).setHoverTooltip("multiblocked.gui.content.more_option"));
    }

    public ContentWidget<T> setBackground(IGuiTexture background) {
        this.background = background;
        return this;
    }

    @Override
    public ContentWidget<T> addWidget(Widget widget) {
        super.addWidget(widget);
        return this;
    }

    @Override
    public ContentWidget<T> setHoverTooltip(String tooltipText) {
        if (this.chance < 1.0f) {
            tooltipText = tooltipText + "\n" + (this.chance == 0.0f ? LocalizationUtils.format("multiblocked.gui.content.chance_0", new Object[0]) : LocalizationUtils.format("multiblocked.gui.content.chance_1", String.format("%.1f", Float.valueOf(this.chance * 100.0f)) + "%%"));
        }
        if (this.perTick) {
            tooltipText = tooltipText + "\n" + LocalizationUtils.format("multiblocked.gui.content.per_tick", new Object[0]);
        }
        super.setHoverTooltip(tooltipText);
        return this;
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        if (this.background != null) {
            this.background.updateTick();
        }
    }

    @Override
    public Widget mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY) && this.onMouseClicked != null) {
            this.onMouseClicked.accept(this);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public final void drawInBackground(int mouseX, int mouseY, float partialTicks) {
        Position position = this.getPosition();
        Size size = this.getSize();
        if (this.background != null) {
            this.background.draw(mouseX, mouseY, position.x, position.y, size.width, size.height);
        }
        this.drawHookBackground(mouseX, mouseY, partialTicks);
        super.drawInBackground(mouseX, mouseY, partialTicks);
        this.drawChance();
        this.drawTick();
        this.drawHoverOverlay(mouseX, mouseY);
        if (this.isSelected) {
            DrawerHelper.drawBorder(this.getPosition().x, this.getPosition().y, this.getSize().width, this.getSize().height, -16733696, 1);
        }
    }

    protected void drawHookBackground(int mouseX, int mouseY, float partialTicks) {
    }

    @SideOnly(value=Side.CLIENT)
    public void drawChance() {
        if (this.chance == 1.0f) {
            return;
        }
        Position pos = this.getPosition();
        Size size = this.getSize();
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
        GlStateManager.func_179097_i();
        String s = this.chance == 0.0f ? LocalizationUtils.format("multiblocked.gui.content.chance_0_short", new Object[0]) : String.format("%.1f", Float.valueOf(this.chance * 100.0f)) + "%";
        int color = this.chance == 0.0f ? 0xFF0000 : 0xFFFF00;
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.func_175063_a(s, ((float)pos.x + (float)size.width / 3.0f) * 2.0f - (float)fontRenderer.func_78256_a(s) + 23.0f, ((float)pos.y + (float)size.height / 3.0f + 6.0f) * 2.0f - (float)size.height, color);
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawTick() {
        if (this.perTick) {
            Position pos = this.getPosition();
            Size size = this.getSize();
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
            GlStateManager.func_179097_i();
            String s = LocalizationUtils.format("multiblocked.gui.content.tips.per_tick_short", new Object[0]);
            int color = 0xFFFF00;
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            fontRenderer.func_175063_a(s, ((float)pos.x + (float)size.width / 3.0f) * 2.0f - (float)fontRenderer.func_78256_a(s) + 23.0f, ((float)pos.y + (float)size.height / 3.0f + 6.0f) * 2.0f - (float)size.height + (float)(this.chance == 1.0f ? 0 : 10), color);
            GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)1.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawHoverOverlay(int mouseX, int mouseY) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            GlStateManager.func_179097_i();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            DrawerHelper.drawSolidRect(this.getPosition().x + 1, this.getPosition().y + 1, 18, 18, -2130706433);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179126_j();
            GlStateManager.func_179147_l();
        }
    }
}

