/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp.controller.structure;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.definition.ControllerDefinition;
import com.cleanroommc.multiblocked.api.gui.texture.ColorRectTexture;
import com.cleanroommc.multiblocked.api.gui.texture.IGuiTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceTexture;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.util.ClickData;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ButtonWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ImageWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SceneWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SlotWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SwitchWidget;
import com.cleanroommc.multiblocked.api.pattern.MultiblockShapeInfo;
import com.cleanroommc.multiblocked.api.pattern.MultiblockState;
import com.cleanroommc.multiblocked.api.pattern.TraceabilityPredicate;
import com.cleanroommc.multiblocked.api.pattern.predicates.SimplePredicate;
import com.cleanroommc.multiblocked.api.pattern.util.BlockInfo;
import com.cleanroommc.multiblocked.api.tile.ControllerTileEntity;
import com.cleanroommc.multiblocked.client.util.TrackedDummyWorld;
import com.cleanroommc.multiblocked.util.CycleItemStackHandler;
import com.cleanroommc.multiblocked.util.ItemStackKey;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

@SideOnly(value=Side.CLIENT)
public class PatternWidget
extends WidgetGroup {
    private static final TrackedDummyWorld world = new TrackedDummyWorld();
    private static BlockPos LAST_POS = new BlockPos(50, 50, 50);
    private static final ResourceTexture PAGE = new ResourceTexture("multiblocked:textures/gui/structure_page.png");
    private static final Map<ControllerDefinition, PatternWidget> CACHE = new HashMap<ControllerDefinition, PatternWidget>();
    private static final IGuiTexture BACKGROUND = PAGE.getSubTexture(0.0, 0.0, 0.6875, 0.86328125);
    private static final IGuiTexture LEFT_BUTTON = PAGE.getSubTexture(0.9296875, 0.2109375, 0.0703125, 0.0703125);
    private static final IGuiTexture LEFT_BUTTON_HOVER = PAGE.getSubTexture(0.9296875, 0.140625, 0.0703125, 0.0703125);
    private static final IGuiTexture RIGHT_BUTTON = PAGE.getSubTexture(0.9296875, 0.0703125, 0.0703125, 0.0703125);
    private static final IGuiTexture RIGHT_BUTTON_HOVER = PAGE.getSubTexture(0.9296875, 0.0, 0.0703125, 0.0703125);
    private static final IGuiTexture FORMED_BUTTON = PAGE.getSubTexture(0.8671875, 0.0, 0.0625, 0.0625);
    private static final IGuiTexture FORMED_BUTTON_PRESSED = PAGE.getSubTexture(0.8671875, 0.0625, 0.0625, 0.0625);
    private final SceneWidget sceneWidget;
    private final ButtonWidget leftButton;
    private final ButtonWidget rightButton;
    private final SwitchWidget switchWidget;
    public final ControllerDefinition controllerDefinition;
    public final MBPattern[] patterns;
    public final List<ItemStack> allItemStackInputs;
    private final List<SimplePredicate> predicates;
    private int index;
    public int layer;
    private SlotWidget[] slotWidgets;
    private SlotWidget[] candidates;

    private PatternWidget(ControllerDefinition controllerDefinition) {
        super(0, 0, 176, 219);
        this.setClientSideWidget();
        this.allItemStackInputs = new ArrayList<ItemStack>();
        this.predicates = new ArrayList<SimplePredicate>();
        this.layer = -1;
        this.addWidget(new ImageWidget(7, 7, 162, 16, new TextTexture(controllerDefinition.location.func_110623_a() + ".name", -1).setType(TextTexture.TextType.ROLL).setWidth(162).setDropShadow(true)).setHoverTooltip(controllerDefinition.getDescription()));
        this.sceneWidget = new SceneWidget(6, 30, 164, 140, world).useCacheBuffer().setOnSelected(this::onPosSelected).setRenderFacing(false).setRenderFacing(false);
        this.addWidget(this.sceneWidget);
        this.controllerDefinition = controllerDefinition;
        HashSet<ItemStackKey> drops = new HashSet<ItemStackKey>();
        drops.add(new ItemStackKey(this.controllerDefinition.getStackForm()));
        this.patterns = (MBPattern[])controllerDefinition.getDesigns().stream().map(it -> this.initializePattern((MultiblockShapeInfo)it, drops)).filter(Objects::nonNull).toArray(MBPattern[]::new);
        drops.forEach(it -> this.allItemStackInputs.add(it.getItemStack()));
        this.switchWidget = (SwitchWidget)new SwitchWidget(151, 33, 16, 16, this::onFormedSwitch).setTexture(FORMED_BUTTON, FORMED_BUTTON_PRESSED).setHoverTooltip("multiblocked.structure_page.switch");
        this.addWidget(this.switchWidget);
        this.leftButton = new ButtonWidget(9, 151, 18, 18, LEFT_BUTTON, x -> this.reset(this.index - 1)).setHoverTexture(LEFT_BUTTON_HOVER);
        this.addWidget(this.leftButton);
        this.rightButton = new ButtonWidget(150, 53, 18, 18, RIGHT_BUTTON, x -> this.reset(this.index + 1)).setHoverTexture(RIGHT_BUTTON_HOVER);
        this.addWidget(this.rightButton);
        this.addWidget(new ButtonWidget(10, 80, 10, 10, new ResourceTexture("multiblocked:textures/gui/up.png"), cd -> this.updateLayer(1)).setHoverTooltip("multiblocked.gui.dialogs.pattern.next_aisle"));
        this.addWidget(new ImageWidget(10, 90, 10, 10, new TextTexture("").setSupplier(() -> this.layer == -1 ? "all" : this.layer + "")));
        this.addWidget(new ButtonWidget(10, 100, 10, 10, new ResourceTexture("multiblocked:textures/gui/down.png"), cd -> this.updateLayer(-1)).setHoverTooltip("multiblocked.gui.dialogs.pattern.last_aisle"));
        if (controllerDefinition.getCatalyst() != null && !controllerDefinition.getCatalyst().func_190926_b()) {
            ItemStackHandler itemStackHandler = new ItemStackHandler();
            this.addWidget(new SlotWidget((IItemHandler)itemStackHandler, 0, 149, 131, false, false).setBackgroundTexture(ResourceBorderTexture.BUTTON_COMMON).setOnAddedTooltips((slot, list) -> list.add("multiblocked.gui.catalyst." + controllerDefinition.consumeCatalyst.ordinal())));
            itemStackHandler.setStackInSlot(0, controllerDefinition.getCatalyst());
        }
    }

    private void updateLayer(int add) {
        MBPattern pattern = this.patterns[this.index];
        if (this.layer + add >= -1 && this.layer + add <= pattern.maxY - pattern.minY) {
            if (pattern.controllerBase.isFormed()) {
                this.onFormedSwitch(null, false);
                this.switchWidget.setPressed(pattern.controllerBase.isFormed());
            }
            this.layer += add;
        }
        this.setupScene(pattern);
    }

    private void setupScene(MBPattern pattern) {
        Stream<BlockPos> stream = pattern.blockMap.keySet().stream().filter(pos -> this.layer == -1 || this.layer + pattern.minY == pos.func_177956_o());
        if (pattern.controllerBase.isFormed()) {
            LongSet set = (LongSet)pattern.controllerBase.state.getMatchContext().getOrDefault("renderMask", LongSets.EMPTY_SET);
            Set modelDisabled = set.stream().map(BlockPos::func_177969_a).collect(Collectors.toSet());
            if (!modelDisabled.isEmpty()) {
                this.sceneWidget.setRenderedCore(stream.filter(pos -> !modelDisabled.contains(pos)).collect(Collectors.toList()), null);
            } else {
                this.sceneWidget.setRenderedCore(stream.collect(Collectors.toList()), null);
            }
        } else {
            this.sceneWidget.setRenderedCore(stream.collect(Collectors.toList()), null);
        }
    }

    public static PatternWidget getPatternWidget(ControllerDefinition controllerDefinition) {
        PatternWidget patternWidget = CACHE.computeIfAbsent(controllerDefinition, PatternWidget::new);
        patternWidget.reset(0);
        return patternWidget;
    }

    private void reset(int index) {
        if (index >= this.patterns.length || index < 0) {
            return;
        }
        this.index = index;
        this.layer = -1;
        MBPattern pattern = this.patterns[index];
        this.setupScene(pattern);
        if (this.slotWidgets != null) {
            for (SlotWidget slotWidget : this.slotWidgets) {
                this.removeWidget(slotWidget);
            }
        }
        this.slotWidgets = new SlotWidget[Math.min(pattern.parts.size(), 18)];
        ItemStackHandler itemHandler = new ItemStackHandler(pattern.parts);
        for (int i = 0; i < this.slotWidgets.length; ++i) {
            this.slotWidgets[i] = new SlotWidget((IItemHandler)itemHandler, i, 7 + i % 9 * 18, 176 + i / 9 * 18, false, false);
            this.addWidget(this.slotWidgets[i]);
        }
        this.leftButton.setVisible(index > 0);
        this.rightButton.setVisible(index < this.patterns.length - 1);
        this.updateClientSlots();
        this.switchWidget.setPressed(pattern.controllerBase.isFormed());
    }

    private void onFormedSwitch(ClickData clickData, Boolean isPressed) {
        MBPattern pattern = this.patterns[this.index];
        ControllerTileEntity controllerBase = pattern.controllerBase;
        if (isPressed.booleanValue()) {
            this.layer = -1;
            this.loadControllerFormed(pattern.blockMap.keySet(), controllerBase);
        } else {
            this.sceneWidget.setRenderedCore(pattern.blockMap.keySet(), null);
            controllerBase.state = null;
            controllerBase.onStructureInvalid();
        }
    }

    private void onPosSelected(BlockPos pos, EnumFacing facing) {
        if (this.index >= this.patterns.length || this.index < 0) {
            return;
        }
        TraceabilityPredicate predicate = this.patterns[this.index].predicateMap.get(pos);
        if (predicate != null) {
            this.predicates.clear();
            this.predicates.addAll(predicate.common);
            this.predicates.addAll(predicate.limited);
            this.predicates.removeIf(p -> p == null || p.candidates == null);
            if (this.candidates != null) {
                for (SlotWidget candidate : this.candidates) {
                    this.removeWidget(candidate);
                }
            }
            ArrayList<List<ItemStack>> candidateStacks = new ArrayList<List<ItemStack>>();
            ArrayList<List<String>> predicateTips = new ArrayList<List<String>>();
            for (SimplePredicate simplePredicate : this.predicates) {
                List<ItemStack> itemStacks = simplePredicate.getCandidates();
                if (itemStacks.isEmpty()) continue;
                candidateStacks.add(itemStacks);
                predicateTips.add(simplePredicate.getToolTips(predicate));
            }
            this.candidates = new SlotWidget[candidateStacks.size()];
            CycleItemStackHandler itemHandler = new CycleItemStackHandler(candidateStacks);
            for (int i = 0; i < candidateStacks.size(); ++i) {
                int finalI = i;
                this.candidates[i] = new SlotWidget(itemHandler, i, 9 + i / 6 * 18, 33 + i % 6 * 18, false, false).setBackgroundTexture(new ColorRectTexture(0x4FFFFFFF)).setOnAddedTooltips((slot, list) -> list.addAll((Collection)predicateTips.get(finalI)));
                this.addWidget(this.candidates[i]);
            }
            this.updateClientSlots();
        }
    }

    private void updateClientSlots() {
        if (this.gui == null || this.gui.getModularUIGui() == null) {
            return;
        }
        this.gui.getModularUIGui().field_147002_h.field_75151_b.clear();
        for (SlotWidget slotWidget : this.getNativeWidgets()) {
            this.gui.getModularUIGui().field_147002_h.field_75151_b.add(slotWidget.getHandle());
        }
    }

    public static BlockPos locateNextRegion(int range) {
        BlockPos pos = LAST_POS;
        LAST_POS = LAST_POS.func_177982_a(range, 0, range);
        return pos;
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks) {
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        int width = this.getSize().width;
        int height = this.getSize().height;
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        BACKGROUND.draw(mouseX, mouseY, x, y, width, height);
        super.drawInBackground(mouseX, mouseY, partialTicks);
    }

    private MBPattern initializePattern(MultiblockShapeInfo shapeInfo, HashSet<ItemStackKey> blockDrops) {
        HashMap<BlockPos, BlockInfo> blockMap = new HashMap<BlockPos, BlockInfo>();
        ControllerTileEntity controllerBase = null;
        BlockPos multiPos = PatternWidget.locateNextRegion(500);
        BlockInfo[][][] blocks = shapeInfo.getBlocks();
        for (int x = 0; x < blocks.length; ++x) {
            BlockInfo[][] aisle = blocks[x];
            for (int y = 0; y < aisle.length; ++y) {
                BlockInfo[] column = aisle[y];
                for (int z = 0; z < column.length; ++z) {
                    TileEntity tileEntity = column[z].getTileEntity();
                    IBlockState blockState = column[z].getBlockState();
                    if (tileEntity == null && blockState.func_177230_c().hasTileEntity(blockState)) {
                        tileEntity = blockState.func_177230_c().createTileEntity((World)world, blockState);
                    }
                    if (tileEntity instanceof ControllerTileEntity) {
                        controllerBase = (ControllerTileEntity)tileEntity;
                    }
                    blockMap.put(multiPos.func_177982_a(x, y, z), new BlockInfo(blockState, tileEntity));
                }
            }
        }
        world.addBlocks(blockMap);
        Map<ItemStackKey, PartInfo> parts = this.gatherBlockDrops(blockMap);
        blockDrops.addAll(parts.keySet());
        HashMap<BlockPos, TraceabilityPredicate> predicateMap = new HashMap();
        if (controllerBase != null) {
            this.loadControllerFormed(predicateMap.keySet(), controllerBase);
            predicateMap = (Map)controllerBase.state.getMatchContext().get("predicates");
        }
        return controllerBase == null ? null : new MBPattern(blockMap, (ItemStack[])parts.values().stream().sorted((one, two) -> {
            if (one.isController) {
                return -1;
            }
            if (two.isController) {
                return 1;
            }
            if (one.isTile && !two.isTile) {
                return -1;
            }
            if (two.isTile && !one.isTile) {
                return 1;
            }
            if (one.blockId != two.blockId) {
                return two.blockId - one.blockId;
            }
            return two.amount - one.amount;
        }).map(PartInfo::getItemStack).toArray(ItemStack[]::new), predicateMap, controllerBase);
    }

    private void loadControllerFormed(Collection<BlockPos> poses, ControllerTileEntity controllerBase) {
        controllerBase.state = new MultiblockState(world, controllerBase.func_174877_v());
        if (controllerBase.getPattern().checkPatternAt(controllerBase.state, true)) {
            controllerBase.onStructureFormed();
        }
        if (controllerBase.isFormed()) {
            LongSet set = (LongSet)controllerBase.state.getMatchContext().getOrDefault("renderMask", LongSets.EMPTY_SET);
            Set modelDisabled = set.stream().map(BlockPos::func_177969_a).collect(Collectors.toSet());
            if (!modelDisabled.isEmpty()) {
                this.sceneWidget.setRenderedCore(poses.stream().filter(pos -> !modelDisabled.contains(pos)).collect(Collectors.toList()), null);
            } else {
                this.sceneWidget.setRenderedCore(poses, null);
            }
        } else {
            Multiblocked.LOGGER.warn("Pattern formed checking failed: {}", (Object)((ControllerDefinition)controllerBase.getDefinition()).location);
        }
    }

    private Map<ItemStackKey, PartInfo> gatherBlockDrops(Map<BlockPos, BlockInfo> blocks) {
        Object2ObjectOpenHashMap partsMap = new Object2ObjectOpenHashMap();
        for (Map.Entry<BlockPos, BlockInfo> entry : blocks.entrySet()) {
            BlockPos pos = entry.getKey();
            IBlockState blockState = world.func_180495_p(pos);
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            ItemStack itemStack = player == null ? blockState.func_177230_c().func_185473_a((World)world, BlockPos.field_177992_a, blockState) : blockState.func_177230_c().getPickBlock(blockState, new RayTraceResult(new Vec3d(0.5, 1.0, 0.5).func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), EnumFacing.UP, pos), (World)world, pos, (EntityPlayer)player);
            ItemStackKey itemStackKey = new ItemStackKey(itemStack);
            ++partsMap.computeIfAbsent(itemStackKey, (Function<ItemStackKey, PartInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$gatherBlockDrops$16(java.util.Map$Entry com.cleanroommc.multiblocked.util.ItemStackKey ), (Lcom/cleanroommc/multiblocked/util/ItemStackKey;)Lcom/cleanroommc/multiblocked/api/gui/widget/imp/controller/structure/PatternWidget$PartInfo;)(entry)).amount;
        }
        return partsMap;
    }

    private static /* synthetic */ PartInfo lambda$gatherBlockDrops$16(Map.Entry entry, ItemStackKey key) {
        return new PartInfo(key, (BlockInfo)entry.getValue());
    }

    private static class MBPattern {
        @Nonnull
        final NonNullList<ItemStack> parts;
        @Nonnull
        final Map<BlockPos, TraceabilityPredicate> predicateMap;
        @Nonnull
        final Map<BlockPos, BlockInfo> blockMap;
        @Nonnull
        final ControllerTileEntity controllerBase;
        final int maxY;
        final int minY;

        public MBPattern(@Nonnull Map<BlockPos, BlockInfo> blockMap, @Nonnull ItemStack[] parts, @Nonnull Map<BlockPos, TraceabilityPredicate> predicateMap, @Nonnull ControllerTileEntity controllerBase) {
            this.parts = NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])parts);
            this.blockMap = blockMap;
            this.predicateMap = predicateMap;
            this.controllerBase = controllerBase;
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            for (BlockPos pos : blockMap.keySet()) {
                min = Math.min(min, pos.func_177956_o());
                max = Math.max(max, pos.func_177956_o());
            }
            this.minY = min;
            this.maxY = max;
        }
    }

    private static class PartInfo {
        final ItemStackKey itemStackKey;
        boolean isController = false;
        boolean isTile = false;
        final int blockId;
        int amount = 0;

        PartInfo(ItemStackKey itemStackKey, BlockInfo blockInfo) {
            this.itemStackKey = itemStackKey;
            this.blockId = Block.func_149682_b((Block)blockInfo.getBlockState().func_177230_c());
            TileEntity tileEntity = blockInfo.getTileEntity();
            if (tileEntity != null) {
                this.isTile = true;
                if (tileEntity instanceof ControllerTileEntity) {
                    this.isController = true;
                }
            }
        }

        ItemStack getItemStack() {
            ItemStack result = this.itemStackKey.getItemStack();
            result.func_190920_e(this.amount);
            return result;
        }
    }
}

