/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp.controller;

import com.cleanroommc.multiblocked.api.definition.ControllerDefinition;
import com.cleanroommc.multiblocked.api.gui.texture.IGuiTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceTexture;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableScrollableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ImageWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.LabelWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SwitchWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.controller.PageWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.ProgressWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.RecipeWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.tab.TabContainer;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.api.recipe.RecipeLogic;
import com.cleanroommc.multiblocked.api.recipe.RecipeMap;
import com.cleanroommc.multiblocked.api.tile.ControllerTileEntity;
import com.cleanroommc.multiblocked.util.Position;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RecipePage
extends PageWidget {
    public static ResourceTexture resourceTexture = new ResourceTexture("multiblocked:textures/gui/recipe_page.png");
    public final ControllerTileEntity controller;
    public final DraggableScrollableWidgetGroup tips;
    private Recipe recipe;
    @SideOnly(value=Side.CLIENT)
    private RecipeWidget recipeWidget;
    private RecipeLogic.Status status;
    private int progress;
    private int duration;
    private int fuelTime;
    private int fuelMaxTime = 1;

    public RecipePage(ControllerTileEntity controller, TabContainer tabContainer) {
        super(resourceTexture, tabContainer);
        this.controller = controller;
        this.status = RecipeLogic.Status.IDLE;
        this.tips = new DraggableScrollableWidgetGroup(8, 34, 160, 112);
        this.addWidget(this.tips);
        this.tips.addWidget(new LabelWidget(5, 5, () -> I18n.func_135052_a((String)("multiblocked.recipe.status." + this.status.name), (Object[])new Object[0])).setTextColor(-1));
        this.tips.addWidget(new LabelWidget(5, 20, () -> I18n.func_135052_a((String)"multiblocked.recipe.remaining", (Object[])new Object[]{this.recipe == null ? 0 : (this.duration - this.progress) / 20})).setTextColor(-1));
        this.addWidget(new SwitchWidget(153, 131, 12, 12, (cd, r) -> {
            controller.asyncRecipeSearching = r;
            if (!cd.isRemote) {
                controller.markAsDirty();
            }
        }).setPressed(controller.asyncRecipeSearching).setSupplier(() -> controller.asyncRecipeSearching).setTexture(resourceTexture.getSubTexture(0.6875, 0.55859375, 0.046875, 0.046875), resourceTexture.getSubTexture(0.6875, 0.60546875, 0.046875, 0.046875)).setHoverTooltip("Async/Sync recipes searching:\nAsync has better performance and only tries to match recipes when the internal contents changed\nSync always tries to match recipes, never miss matching recipes"));
        if (((ControllerDefinition)controller.getDefinition()).getRecipeMap().isFuelRecipeMap()) {
            this.tips.addWidget(new LabelWidget(5, 35, () -> this.status == RecipeLogic.Status.SUSPEND && this.fuelTime == 0 ? I18n.func_135052_a((String)"multiblocked.recipe.lack_fuel", (Object[])new Object[0]) : I18n.func_135052_a((String)"multiblocked.recipe.remaining_fuel", (Object[])new Object[]{this.fuelTime / 20})).setTextColor(-1));
        }
        this.addWidget(new ImageWidget(7, 7, 162, 16, new TextTexture(controller.getUnlocalizedName(), -1).setType(TextTexture.TextType.ROLL).setWidth(162).setDropShadow(true)));
        this.addWidget(new ProgressWidget(this::getProgress, 17, 154, 143, 9).setProgressBar((mouseX, mouseY, x, y, width, height) -> {
            double imageU = 0.72265625;
            double imageV = 0.0;
            double imageWidth = 0.03515625;
            double imageHeight = 0.55859375;
            Minecraft.func_71410_x().field_71446_o.func_110577_a(RecipePage.resourceTexture.imageLocation);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bufferbuilder.func_181662_b(x, y + (double)height, 0.0).func_187315_a(imageU + imageWidth, imageV + imageHeight).func_181675_d();
            bufferbuilder.func_181662_b(x + (double)width, y + (double)height, 0.0).func_187315_a(imageU + imageWidth, imageV).func_181675_d();
            bufferbuilder.func_181662_b(x + (double)width, y, 0.0).func_187315_a(imageU, imageV).func_181675_d();
            bufferbuilder.func_181662_b(x, y, 0.0).func_187315_a(imageU, imageV + imageHeight).func_181675_d();
            tessellator.func_78381_a();
        }, new IGuiTexture(){

            @Override
            public void draw(int mouseX, int mouseY, double x, double y, int width, int height) {
            }

            @Override
            public void drawSubArea(double x, double y, int width, int height, double drawnU, double drawnV, double drawnWidth, double drawnHeight) {
                double imageU = 0.6875;
                double imageV = 0.0;
                double imageWidth = 0.03515625;
                double imageHeight = 0.55859375;
                Minecraft.func_71410_x().field_71446_o.func_110577_a(RecipePage.resourceTexture.imageLocation);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                bufferbuilder.func_181662_b(x, y + (double)height, 0.0).func_187315_a(imageU + imageWidth, imageV + imageHeight).func_181675_d();
                bufferbuilder.func_181662_b(x + (double)width, y + (double)height, 0.0).func_187315_a(imageU + imageWidth, imageV + imageHeight - drawnWidth * imageHeight).func_181675_d();
                bufferbuilder.func_181662_b(x + (double)width, y, 0.0).func_187315_a(imageU, imageV + imageHeight - drawnWidth * imageHeight).func_181675_d();
                bufferbuilder.func_181662_b(x, y, 0.0).func_187315_a(imageU, imageV + imageHeight).func_181675_d();
                tessellator.func_78381_a();
            }
        }));
    }

    private double getProgress() {
        if (this.recipe == null) {
            return 0.0;
        }
        return (double)this.progress * 1.0 / (double)this.duration;
    }

    private double getFuelProgress() {
        return (double)Math.min(this.fuelTime, this.fuelMaxTime) * 1.0 / (double)Math.max(1, this.fuelMaxTime);
    }

    @Override
    public void writeInitialData(PacketBuffer buffer) {
        super.writeInitialData(buffer);
        this.detectAndSendChanges();
        this.writeRecipe(buffer);
        this.writeStatus(buffer);
    }

    @Override
    public void readInitialData(PacketBuffer buffer) {
        super.readInitialData(buffer);
        this.readRecipe(buffer);
        this.readStatus(buffer);
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (this.controller.getRecipeLogic() != null) {
            RecipeLogic recipeLogic = this.controller.getRecipeLogic();
            if (this.recipe != recipeLogic.lastRecipe) {
                this.recipe = recipeLogic.lastRecipe;
                this.duration = recipeLogic.duration;
                this.writeUpdateInfo(-1, this::writeRecipe);
            }
            if (this.status != recipeLogic.getStatus() || this.progress != recipeLogic.progress || this.fuelTime != recipeLogic.fuelTime || this.fuelMaxTime != recipeLogic.fuelMaxTime) {
                this.status = recipeLogic.getStatus();
                this.progress = recipeLogic.progress;
                this.fuelTime = recipeLogic.fuelTime;
                this.fuelMaxTime = recipeLogic.fuelMaxTime;
                this.writeUpdateInfo(-2, this::writeStatus);
            }
        } else if (this.recipe != null) {
            this.recipe = null;
            this.writeUpdateInfo(-1, this::writeRecipe);
        }
    }

    private void writeStatus(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.status);
        buffer.func_150787_b(this.progress);
        buffer.func_150787_b(this.fuelTime);
        buffer.func_150787_b(this.fuelMaxTime);
    }

    private void readStatus(PacketBuffer buffer) {
        this.status = (RecipeLogic.Status)buffer.func_179257_a(RecipeLogic.Status.class);
        this.progress = buffer.func_150792_a();
        this.fuelTime = buffer.func_150792_a();
        this.fuelMaxTime = buffer.func_150792_a();
    }

    private void writeRecipe(PacketBuffer buffer) {
        if (this.recipe == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.func_150787_b(this.duration);
            buffer.func_180714_a(this.recipe.uid);
        }
    }

    private void readRecipe(PacketBuffer buffer) {
        if (buffer.readBoolean()) {
            this.duration = buffer.func_150792_a();
            RecipeMap recipeMap = ((ControllerDefinition)this.controller.getDefinition()).getRecipeMap();
            this.recipe = recipeMap.recipes.get(buffer.func_150789_c(Short.MAX_VALUE));
            if (this.recipeWidget != null) {
                this.removeWidget(this.recipeWidget);
            }
            this.recipeWidget = new RecipeWidget(recipeMap, this.recipe, ProgressWidget.JEIProgress, this::getFuelProgress);
            this.addWidget(this.recipeWidget);
            this.recipeWidget.inputs.addSelfPosition(5, 0);
            this.recipeWidget.outputs.addSelfPosition(-5, 0);
            this.recipeWidget.setSelfPosition(new Position(0, 167));
        } else {
            if (this.recipeWidget != null) {
                this.removeWidget(this.recipeWidget);
            }
            RecipeMap recipeMap = ((ControllerDefinition)this.controller.getDefinition()).getRecipeMap();
            this.recipeWidget = new RecipeWidget(recipeMap, null, () -> 0.0, this::getFuelProgress);
            this.addWidget(this.recipeWidget);
            this.recipeWidget.inputs.addSelfPosition(5, 0);
            this.recipeWidget.outputs.addSelfPosition(-5, 0);
            this.recipeWidget.setSelfPosition(new Position(0, 167));
            this.status = RecipeLogic.Status.IDLE;
            this.fuelTime = 0;
            this.fuelMaxTime = 1;
            this.progress = 0;
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        if (id == -1) {
            this.readRecipe(buffer);
        } else if (id == -2) {
            this.readStatus(buffer);
        } else {
            super.readUpdateInfo(id, buffer);
        }
    }
}

