/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp.controller;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.capability.proxy.CapabilityProxy;
import com.cleanroommc.multiblocked.api.gui.texture.ColorRectTexture;
import com.cleanroommc.multiblocked.api.gui.texture.IGuiTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceTexture;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.util.ClickData;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ButtonWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ImageWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SceneWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SelectorWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.controller.PageWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.tab.TabContainer;
import com.cleanroommc.multiblocked.api.registry.MbdCapabilities;
import com.cleanroommc.multiblocked.api.tile.ControllerTileEntity;
import com.cleanroommc.multiblocked.client.renderer.scene.WorldSceneRenderer;
import com.cleanroommc.multiblocked.client.util.RenderUtils;
import com.cleanroommc.multiblocked.util.BlockPosFace;
import com.google.common.collect.Table;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class IOPageWidget
extends PageWidget {
    private static final ResourceTexture PAGE = new ResourceTexture("multiblocked:textures/gui/io_page.png");
    private static final IGuiTexture RIGHT_BUTTON = PAGE.getSubTexture(0.6875, 0.328125, 0.01953125, 0.06640625);
    private static final IGuiTexture RIGHT_BUTTON_HOVER = PAGE.getSubTexture(0.70703125, 0.328125, 0.01953125, 0.06640625);
    private static final IGuiTexture LEFT_BUTTON = PAGE.getSubTexture(0.6875, 0.39453125, 0.01953125, 0.06640625);
    private static final IGuiTexture LEFT_BUTTON_HOVER = PAGE.getSubTexture(0.70703125, 0.39453125, 0.01953125, 0.06640625);
    private static final Map<IO, IGuiTexture> LINE_0_MAP = new EnumMap<IO, IGuiTexture>(IO.class);
    private static final Map<IO, IGuiTexture> LINE_1_MAP;
    private final ControllerTileEntity controller;
    private final ImageWidget[][] lines;
    private final TextTexture[] labels;
    private final SelectorWidget[] selectors;
    private Map<Long, EnumMap<IO, Set<MultiblockCapability<?>>>> capabilityMap;
    @SideOnly(value=Side.CLIENT)
    private Map<MultiblockCapability<?>, Tuple<IO, EnumFacing>> capabilitySettings;
    private BlockPos pos;
    int index;

    public IOPageWidget(ControllerTileEntity controller, TabContainer container) {
        super(PAGE, container);
        this.controller = controller;
        if (controller.state.cache == null) {
            controller.checkPattern();
        }
        this.capabilityMap = (Map)controller.state.getMatchContext().get("capabilities");
        Map<Object, Object> map = this.capabilityMap = this.capabilityMap == null ? new HashMap() : this.capabilityMap;
        if (controller.isRemote()) {
            this.capabilitySettings = new HashMap();
        }
        this.lines = new ImageWidget[2][3];
        ImageWidget imageWidget = new ImageWidget(14, 172, 45, 28);
        this.lines[0][0] = imageWidget;
        this.addWidget(imageWidget);
        ImageWidget imageWidget2 = new ImageWidget(66, 172, 45, 28);
        this.lines[0][1] = imageWidget2;
        this.addWidget(imageWidget2);
        ImageWidget imageWidget3 = new ImageWidget(118, 172, 45, 28);
        this.lines[0][2] = imageWidget3;
        this.addWidget(imageWidget3);
        ImageWidget imageWidget4 = new ImageWidget(34, 202, 4, 35);
        this.lines[1][0] = imageWidget4;
        this.addWidget(imageWidget4);
        ImageWidget imageWidget5 = new ImageWidget(86, 202, 4, 35);
        this.lines[1][1] = imageWidget5;
        this.addWidget(imageWidget5);
        ImageWidget imageWidget6 = new ImageWidget(138, 202, 4, 35);
        this.lines[1][2] = imageWidget6;
        this.addWidget(imageWidget6);
        SceneWidget sceneWidget = new SceneWidget(6, 6, 164, 132, Multiblocked.isClient() ? this.getWorld() : null).useCacheBuffer().setRenderedCore(controller.state.getCache(), null).setOnSelected(this::onPosSelected).setRenderFacing(false);
        this.addWidget(sceneWidget);
        this.addWidget(new ButtonWidget(4, 156, 5, 17, LEFT_BUTTON, this::onLeftClick).setHoverTexture(LEFT_BUTTON_HOVER));
        this.addWidget(new ButtonWidget(167, 156, 5, 17, RIGHT_BUTTON, this::onRightClick).setHoverTexture(RIGHT_BUTTON_HOVER));
        this.labels = new TextTexture[3];
        this.labels[0] = new TextTexture("Empty", -1).setType(TextTexture.TextType.ROLL).setWidth(50).setDropShadow(true);
        this.addWidget(new ImageWidget(11, 156, 50, 15).setImage(this.labels[0]));
        this.labels[1] = new TextTexture("Empty", -1).setType(TextTexture.TextType.ROLL).setWidth(50).setDropShadow(true);
        this.addWidget(new ImageWidget(63, 156, 50, 15).setImage(this.labels[1]));
        this.labels[2] = new TextTexture("Empty", -1).setType(TextTexture.TextType.ROLL).setWidth(50).setDropShadow(true);
        this.addWidget(new ImageWidget(115, 156, 50, 15).setImage(this.labels[2]));
        this.selectors = new SelectorWidget[3];
        List<String> facings = Arrays.stream(EnumFacing.field_82609_l).map(Enum::name).collect(Collectors.toList());
        this.selectors[0] = new SelectorWidget(11, 142, 50, 12, facings, -1).setIsUp(true).setOnChanged(facing -> this.setFacing(EnumFacing.valueOf((String)facing), 0));
        this.addWidget(this.selectors[0]);
        this.selectors[1] = new SelectorWidget(63, 142, 50, 12, facings, -1).setIsUp(true).setOnChanged(facing -> this.setFacing(EnumFacing.valueOf((String)facing), 1));
        this.addWidget(this.selectors[1]);
        this.selectors[2] = new SelectorWidget(115, 142, 50, 12, facings, -1).setIsUp(true).setOnChanged(facing -> this.setFacing(EnumFacing.valueOf((String)facing), 2));
        this.addWidget(this.selectors[2]);
        this.selectors[0].setHoverTooltip("set the io facing").setVisible(false);
        this.selectors[1].setHoverTooltip("set the io facing").setVisible(false);
        this.selectors[2].setHoverTooltip("set the io facing").setVisible(false);
        if (Multiblocked.isClient()) {
            this.setupSceneWidget(sceneWidget);
        }
        this.addWidget(new ButtonWidget(30, 208, 12, 12, IGuiTexture.EMPTY, cd -> this.click((ClickData)cd, this.index, IO.IN)).setHoverTexture(new ColorRectTexture(0x4FFFFFFF)));
        this.addWidget(new ButtonWidget(30, 229, 12, 12, IGuiTexture.EMPTY, cd -> this.click((ClickData)cd, this.index, IO.OUT)).setHoverTexture(new ColorRectTexture(0x4FFFFFFF)));
        this.addWidget(new ButtonWidget(82, 208, 12, 12, IGuiTexture.EMPTY, cd -> this.click((ClickData)cd, this.index + 1, IO.IN)).setHoverTexture(new ColorRectTexture(0x4FFFFFFF)));
        this.addWidget(new ButtonWidget(82, 229, 12, 12, IGuiTexture.EMPTY, cd -> this.click((ClickData)cd, this.index + 1, IO.OUT)).setHoverTexture(new ColorRectTexture(0x4FFFFFFF)));
        this.addWidget(new ButtonWidget(134, 208, 12, 12, IGuiTexture.EMPTY, cd -> this.click((ClickData)cd, this.index + 2, IO.IN)).setHoverTexture(new ColorRectTexture(0x4FFFFFFF)));
        this.addWidget(new ButtonWidget(134, 229, 12, 12, IGuiTexture.EMPTY, cd -> this.click((ClickData)cd, this.index + 2, IO.OUT)).setHoverTexture(new ColorRectTexture(0x4FFFFFFF)));
    }

    private void setFacing(EnumFacing facing, int i) {
        MultiblockCapability capability;
        ArrayList values;
        if (this.isRemote() && (values = new ArrayList(this.capabilitySettings.keySet())).size() > i + this.index && this.capabilitySettings.get(capability = (MultiblockCapability)values.get(i + this.index)) != null && this.capabilitySettings.get(capability).func_76341_a() != null) {
            this.capabilitySettings.put(capability, (Tuple<IO, EnumFacing>)new Tuple(this.capabilitySettings.get(capability).func_76341_a(), (Object)facing));
            this.writeClientAction(-2, buffer -> {
                Tuple<IO, EnumFacing> tuple = this.capabilitySettings.get(capability);
                buffer.func_180714_a(capability.name);
                buffer.func_179249_a((Enum)tuple.func_76341_a());
                buffer.func_179249_a((Enum)tuple.func_76340_b());
            });
        }
    }

    @SideOnly(value=Side.CLIENT)
    private World getWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @SideOnly(value=Side.CLIENT)
    private void setupSceneWidget(SceneWidget sceneWidget) {
        sceneWidget.getRenderer().setAfterWorldRender(renderer -> {
            sceneWidget.renderBlockOverLay((WorldSceneRenderer)renderer);
            RenderUtils.useLightMap(240.0f, 240.0f, () -> {
                GlStateManager.func_179097_i();
                GlStateManager.func_179129_p();
                int inner = 0;
                for (Map.Entry<MultiblockCapability<?>, Tuple<IO, EnumFacing>> entry : this.capabilitySettings.entrySet()) {
                    if (entry.getValue() == null) continue;
                    sceneWidget.drawFacingBorder(new BlockPosFace(this.pos, (EnumFacing)entry.getValue().func_76340_b()), entry.getKey().color, inner);
                    ++inner;
                }
                GlStateManager.func_179089_o();
                GlStateManager.func_179126_j();
            });
        });
    }

    private void refresh() {
        ArrayList values = new ArrayList(this.capabilitySettings.keySet());
        for (int i = this.index; i < this.index + 3; ++i) {
            MultiblockCapability capability = null;
            if (i < values.size()) {
                capability = (MultiblockCapability)values.get(i);
                this.labels[i - this.index].setBackgroundColor(capability.color).updateText(capability.getUnlocalizedName());
                if (this.capabilitySettings.get(capability) != null && this.capabilitySettings.get(capability).func_76341_a() != null) {
                    this.selectors[i - this.index].setValue(((EnumFacing)this.capabilitySettings.get(capability).func_76340_b()).name()).setVisible(true);
                } else {
                    this.selectors[i - this.index].setVisible(false);
                }
            } else {
                this.labels[i - this.index].setBackgroundColor(0).updateText("Empty");
                this.selectors[i - this.index].setVisible(false);
            }
            IO io = this.capabilitySettings.get(capability) == null ? null : (IO)((Object)this.capabilitySettings.get(capability).func_76341_a());
            this.lines[0][i - this.index].setImage(LINE_0_MAP.get((Object)io));
            this.lines[1][i - this.index].setImage(LINE_1_MAP.get((Object)io));
        }
    }

    private void click(ClickData clickData, int index, IO io) {
        if (clickData.isRemote) {
            if (this.pos == null || !this.capabilityMap.containsKey(this.pos.func_177986_g())) {
                return;
            }
            EnumMap<IO, Set<MultiblockCapability<?>>> enumMap = this.capabilityMap.get(this.pos.func_177986_g());
            ArrayList values = new ArrayList(this.capabilitySettings.keySet());
            if (index >= 0 && index < values.size()) {
                boolean find;
                MultiblockCapability capability = (MultiblockCapability)values.get(index);
                Tuple<IO, EnumFacing> tuple = this.capabilitySettings.get(capability);
                IO originalIO = tuple == null ? null : (IO)((Object)tuple.func_76341_a());
                EnumFacing originalFacing = tuple == null ? EnumFacing.UP : (EnumFacing)tuple.func_76340_b();
                boolean bl = find = enumMap.get((Object)io) != null && enumMap.get((Object)io).contains(capability);
                if (enumMap.get((Object)IO.BOTH) != null && enumMap.get((Object)IO.BOTH).contains(capability)) {
                    find = true;
                }
                if (!find) {
                    return;
                }
                if (originalIO == null) {
                    this.capabilitySettings.put(capability, (Tuple<IO, EnumFacing>)new Tuple((Object)io, (Object)originalFacing));
                } else if (originalIO == io) {
                    this.capabilitySettings.put(capability, (Tuple<IO, EnumFacing>)new Tuple(null, (Object)originalFacing));
                } else if (originalIO == IO.BOTH) {
                    this.capabilitySettings.put(capability, (Tuple<IO, EnumFacing>)new Tuple((Object)(io == IO.IN ? IO.OUT : IO.IN), (Object)originalFacing));
                } else {
                    this.capabilitySettings.put(capability, (Tuple<IO, EnumFacing>)new Tuple((Object)IO.BOTH, (Object)originalFacing));
                }
                this.writeClientAction(-1, buffer -> {
                    IO newIO;
                    buffer.func_180714_a(capability.name);
                    buffer.writeBoolean(originalIO != null);
                    if (originalIO != null) {
                        buffer.func_179249_a((Enum)originalIO);
                    }
                    buffer.writeBoolean((newIO = (IO)((Object)((Object)this.capabilitySettings.get(capability).func_76341_a()))) != null);
                    if (newIO != null) {
                        buffer.func_179249_a((Enum)newIO);
                        buffer.func_179249_a((Enum)this.capabilitySettings.get(capability).func_76340_b());
                    }
                });
                this.refresh();
            }
        }
    }

    private void onRightClick(ClickData clickData) {
        ArrayList values;
        if (clickData.isRemote && this.index < (values = new ArrayList(this.capabilitySettings.keySet())).size() - 3) {
            ++this.index;
            this.refresh();
        }
    }

    private void onLeftClick(ClickData clickData) {
        if (clickData.isRemote && this.index > 0) {
            --this.index;
            this.refresh();
        }
    }

    private void onPosSelected(BlockPos pos, EnumFacing facing) {
        if (Objects.equals(pos, this.pos)) {
            return;
        }
        this.pos = pos;
        if (!this.isRemote()) {
            if (!this.capabilityMap.containsKey(pos.func_177986_g()) || this.controller.getCapabilities() == null) {
                return;
            }
            this.writeUpdateInfo(-1, buffer -> {
                long posLong = pos.func_177986_g();
                Table<IO, MultiblockCapability<?>, Long2ObjectOpenHashMap<CapabilityProxy<?>>> capabilities = this.controller.getCapabilities();
                ArrayList<Tuple> real = new ArrayList<Tuple>();
                for (Map.Entry<IO, Set<MultiblockCapability<?>>> entry : this.capabilityMap.get(pos.func_177986_g()).entrySet()) {
                    Set<MultiblockCapability<?>> set = entry.getValue();
                    for (MultiblockCapability<?> capability : set) {
                        if (capabilities.contains((Object)entry.getKey(), capability) && ((Long2ObjectOpenHashMap)capabilities.get((Object)entry.getKey(), capability)).containsKey(posLong)) {
                            real.add(new Tuple((Object)entry.getKey(), ((Long2ObjectOpenHashMap)capabilities.get((Object)entry.getKey(), capability)).get(posLong)));
                        }
                        if (entry.getKey() != IO.BOTH) continue;
                        if (capabilities.contains((Object)IO.IN, capability) && ((Long2ObjectOpenHashMap)capabilities.get((Object)IO.IN, capability)).containsKey(posLong)) {
                            real.add(new Tuple((Object)IO.IN, ((Long2ObjectOpenHashMap)capabilities.get((Object)IO.IN, capability)).get(posLong)));
                        }
                        if (!capabilities.contains((Object)IO.OUT, capability) || !((Long2ObjectOpenHashMap)capabilities.get((Object)IO.OUT, capability)).containsKey(posLong)) continue;
                        real.add(new Tuple((Object)IO.OUT, ((Long2ObjectOpenHashMap)capabilities.get((Object)IO.OUT, capability)).get(posLong)));
                    }
                }
                buffer.func_150787_b(real.size());
                for (Tuple tuple : real) {
                    buffer.func_179249_a((Enum)tuple.func_76341_a());
                    buffer.func_180714_a(((CapabilityProxy)tuple.func_76340_b()).capability.name);
                    buffer.func_179249_a((Enum)((CapabilityProxy)tuple.func_76340_b()).facing);
                }
            });
        } else {
            this.capabilitySettings.clear();
            if (this.capabilityMap.containsKey(pos.func_177986_g())) {
                this.capabilityMap.get(pos.func_177986_g()).values().stream().flatMap(Collection::stream).forEach(capability -> {
                    Tuple cfr_ignored_0 = this.capabilitySettings.put((MultiblockCapability<?>)capability, (Tuple<IO, EnumFacing>)null);
                });
            } else {
                this.refresh();
            }
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        if (id == -1) {
            int size;
            for (int i = size = buffer.func_150792_a(); i > 0; --i) {
                IO io = (IO)buffer.func_179257_a(IO.class);
                MultiblockCapability<?> capability = MbdCapabilities.get(buffer.func_150789_c(Short.MAX_VALUE));
                EnumFacing facing = (EnumFacing)buffer.func_179257_a(EnumFacing.class);
                this.capabilitySettings.put(capability, (Tuple<IO, EnumFacing>)new Tuple((Object)io, (Object)facing));
            }
            this.refresh();
        } else {
            super.readUpdateInfo(id, buffer);
        }
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        if (id == -1) {
            IO io;
            Map slotsMap;
            MultiblockCapability<?> capability = MbdCapabilities.get(buffer.func_150789_c(Short.MAX_VALUE));
            Table<IO, MultiblockCapability<?>, Long2ObjectOpenHashMap<CapabilityProxy<?>>> capabilities = this.controller.getCapabilities();
            Map map = slotsMap = this.controller.state != null && this.controller.state.getMatchContext() != null ? (Map)this.controller.state.getMatchContext().get("slots") : null;
            if (buffer.readBoolean()) {
                io = (IO)buffer.func_179257_a(IO.class);
                ((Long2ObjectOpenHashMap)capabilities.get((Object)io, capability)).remove(this.pos.func_177986_g());
                if (((Long2ObjectOpenHashMap)capabilities.get((Object)io, capability)).isEmpty()) {
                    capabilities.remove((Object)io, capability);
                }
            }
            if (buffer.readBoolean()) {
                io = (IO)buffer.func_179257_a(IO.class);
                TileEntity entity = this.controller.func_145831_w().func_175625_s(this.pos);
                if (entity != null && capability.isBlockHasCapability(io, entity)) {
                    if (!capabilities.contains((Object)io, capability)) {
                        capabilities.put((Object)io, capability, (Object)new Long2ObjectOpenHashMap());
                    }
                    CapabilityProxy<?> proxy = capability.createProxy(io, entity, (EnumFacing)buffer.func_179257_a(EnumFacing.class), slotsMap);
                    ((Long2ObjectOpenHashMap)capabilities.get((Object)io, capability)).put(this.pos.func_177986_g(), proxy);
                }
            }
            this.controller.markAsDirty();
        } else if (id == -2) {
            MultiblockCapability<?> capability = MbdCapabilities.get(buffer.func_150789_c(Short.MAX_VALUE));
            Table<IO, MultiblockCapability<?>, Long2ObjectOpenHashMap<CapabilityProxy<?>>> capabilities = this.controller.getCapabilities();
            Map slotsMap = this.controller.state != null && this.controller.state.getMatchContext() != null ? (Map)this.controller.state.getMatchContext().get("slots") : null;
            IO io = (IO)buffer.func_179257_a(IO.class);
            TileEntity entity = this.controller.func_145831_w().func_175625_s(this.pos);
            if (entity != null && capability.isBlockHasCapability(io, entity)) {
                if (!capabilities.contains((Object)io, capability)) {
                    capabilities.put((Object)io, capability, (Object)new Long2ObjectOpenHashMap());
                }
                CapabilityProxy<?> proxy = capability.createProxy(io, entity, (EnumFacing)buffer.func_179257_a(EnumFacing.class), slotsMap);
                ((Long2ObjectOpenHashMap)capabilities.get((Object)io, capability)).put(this.pos.func_177986_g(), proxy);
            }
            this.controller.markAsDirty();
        } else {
            super.handleClientAction(id, buffer);
        }
    }

    static {
        LINE_0_MAP.put(IO.IN, PAGE.getSubTexture(0.82421875, 0.0, 0.17578125, 0.109375));
        LINE_0_MAP.put(IO.OUT, PAGE.getSubTexture(0.82421875, 0.109375, 0.17578125, 0.109375));
        LINE_0_MAP.put(IO.BOTH, PAGE.getSubTexture(0.82421875, 0.21875, 0.17578125, 0.109375));
        LINE_1_MAP = new EnumMap<IO, IGuiTexture>(IO.class);
        LINE_1_MAP.put(IO.IN, PAGE.getSubTexture(0.7265625, 0.0, 0.015625, 0.13671875));
        LINE_1_MAP.put(IO.OUT, PAGE.getSubTexture(0.7421875, 0.0, 0.015625, 0.13671875));
        LINE_1_MAP.put(IO.BOTH, PAGE.getSubTexture(0.7578125, 0.0, 0.015625, 0.13671875));
    }
}

