/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp.blueprint_table.dialogs;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.gui.texture.ColorBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ColorRectTexture;
import com.cleanroommc.multiblocked.api.gui.texture.GuiTextureGroup;
import com.cleanroommc.multiblocked.api.gui.texture.IGuiTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceTexture;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.util.FileNode;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ButtonWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DialogWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ImageWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TreeListWidget;
import com.cleanroommc.multiblocked.util.Size;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class ResourceTextureWidget
extends DialogWidget {
    private static final int HEIGHT = 128;
    private static final int WIDTH = 184;

    public ResourceTextureWidget(WidgetGroup parent, Consumer<ResourceTexture> result) {
        super(parent, true);
        Size size = parent.getSize();
        int x = 130 + (size.width - 133 - 184) / 2;
        int y = (size.height - 128) / 2;
        File dir = new File(Multiblocked.location, "assets/multiblocked/textures");
        if (!dir.isDirectory() && !dir.mkdirs()) {
            this.close();
        }
        ImageWidget imageWidget = new ImageWidget(x + 67, y + 39, 50, 50, new ColorBorderTexture(2, -1));
        this.addWidget(new ImageWidget(0, 0, parent.getSize().width, parent.getSize().height, new ColorRectTexture(0x4F000000)));
        AtomicReference selected = new AtomicReference();
        this.addWidget(new TreeListWidget(0, 0, 130, size.height, new FileNode(dir).setValid(DialogWidget.suffixFilter(".png")), node -> {
            if (node != null && node.isLeaf() && ((File)node.getContent()).isFile()) {
                selected.set(this.getTextureFromFile(dir, (File)node.getKey()));
                imageWidget.setImage(new GuiTextureGroup(new ColorBorderTexture(2, -1), (IGuiTexture)selected.get()));
            }
        }).setNodeTexture(ResourceBorderTexture.BORDERED_BACKGROUND).canSelectNode(true).setLeafTexture(new ResourceTexture("multiblocked:textures/gui/darkened_slot.png")));
        this.addWidget(new ImageWidget(x, y, 184, 128, ResourceBorderTexture.BORDERED_BACKGROUND));
        this.addWidget(new ButtonWidget(x + 92 - 30 - 20, y + 128 - 32, 40, 20, cd -> {
            this.close();
            if (result != null) {
                result.accept((ResourceTexture)selected.get());
            }
        }).setButtonTexture(new ResourceTexture("multiblocked:textures/gui/darkened_slot.png"), new TextTexture("multiblocked.gui.tips.confirm", -1).setDropShadow(true)).setHoverBorderTexture(1, -16777216));
        this.addWidget(new ButtonWidget(x + 92 + 30 - 20, y + 128 - 32, 40, 20, cd -> {
            this.close();
            if (result != null) {
                result.accept(null);
            }
        }).setButtonTexture(new ResourceTexture("multiblocked:textures/gui/darkened_slot.png"), new TextTexture("multiblocked.gui.tips.cancel", -65536).setDropShadow(true)).setHoverBorderTexture(1, -16777216));
        this.addWidget(imageWidget);
        this.addWidget(new ButtonWidget(x + 15, y + 15, 20, 20, cd -> {
            try {
                Desktop.getDesktop().open(dir.isDirectory() ? dir : dir.getParentFile());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }).setButtonTexture(new ResourceTexture("multiblocked:textures/gui/darkened_slot.png"), new TextTexture("F", -1).setDropShadow(true)).setHoverBorderTexture(1, -16777216).setHoverTooltip("multiblocked.gui.tips.open_folder"));
        this.addWidget(new ImageWidget(x + 15, y + 20, 154, 10, new TextTexture("multiblocked.gui.tips.texture", -1).setWidth(154).setDropShadow(true)));
    }

    private ResourceTexture getTextureFromFile(File path, File r) {
        return new ResourceTexture("multiblocked:" + r.getPath().replace(path.getPath(), "textures").replace('\\', '/'));
    }
}

