/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp.blueprint_table.dialogs;

import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.gui.texture.ColorRectTexture;
import com.cleanroommc.multiblocked.api.gui.texture.GuiTextureGroup;
import com.cleanroommc.multiblocked.api.gui.texture.ItemStackTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ProgressTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceTexture;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.util.ClickData;
import com.cleanroommc.multiblocked.api.gui.util.DrawerHelper;
import com.cleanroommc.multiblocked.api.gui.widget.Widget;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ButtonWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DialogWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableScrollableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ImageWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.LabelWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SelectableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextFieldWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.blueprint_table.dialogs.ResourceTextureWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.ContentWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.ProgressWidget;
import com.cleanroommc.multiblocked.api.recipe.Content;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.api.recipe.RecipeCondition;
import com.cleanroommc.multiblocked.api.recipe.RecipeMap;
import com.cleanroommc.multiblocked.api.registry.MbdCapabilities;
import com.cleanroommc.multiblocked.api.registry.MbdRecipeConditions;
import com.cleanroommc.multiblocked.util.Size;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.Items;

public class RecipeMapWidget
extends DialogWidget {
    protected RecipeMap recipeMap;
    protected final DraggableScrollableWidgetGroup recipesList;
    protected final WidgetGroup configurator;
    protected final WidgetGroup recipeIO;
    protected WidgetGroup contentCandidates;
    protected final List<RecipeItem> recipes;
    protected final Consumer<RecipeMap> onSave;
    protected WidgetGroup conditionGroup;

    public RecipeMapWidget(WidgetGroup parent, RecipeMap recipeMap, Consumer<RecipeMap> onSave) {
        super(parent, true);
        this.setParentInVisible();
        this.recipeMap = recipeMap;
        this.onSave = onSave;
        this.recipes = new ArrayList<RecipeItem>();
        this.addWidget(new ImageWidget(0, 0, this.getSize().width, this.getSize().height, new ResourceTexture("multiblocked:textures/gui/blueprint_page.png")));
        this.addWidget(new LabelWidget(20, 25, "ID:"));
        this.addWidget(new TextFieldWidget(40, 20, 130, 15, true, null, s -> {
            recipeMap.name = s;
        }).setCurrentString(recipeMap.name));
        this.addWidget(new ButtonWidget(180, 17, 40, 20, this::onSave).setButtonTexture(ResourceBorderTexture.BUTTON_COMMON, new TextTexture("multiblocked.gui.tips.save_1", -1).setDropShadow(true)).setHoverBorderTexture(1, -1));
        this.addWidget(new ImageWidget(250, 3, 130, 128, ResourceBorderTexture.BORDERED_BACKGROUND_BLUE));
        this.recipesList = new DraggableScrollableWidgetGroup(250, 7, 130, 120);
        this.addWidget(this.recipesList);
        this.configurator = new WidgetGroup(250, 132, 130, 120);
        this.addWidget(this.configurator);
        this.recipeIO = new WidgetGroup(50, 50, 176, 100);
        this.addWidget(this.recipeIO);
        this.addWidget(new ButtonWidget(230, 10, 20, 20, new ResourceTexture("multiblocked:textures/gui/add.png"), cd -> {
            Recipe recipe = new Recipe(UUID.randomUUID().toString(), ImmutableMap.of(), ImmutableMap.of(), ImmutableMap.of(), ImmutableMap.of(), (ImmutableList<RecipeCondition>)ImmutableList.of(), 1);
            this.recipes.add(new RecipeItem(recipe, false));
            this.recipesList.addWidget(this.recipes.get(this.recipes.size() - 1));
        }).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.dialogs.recipe_map.add_recipe"));
        this.addWidget(new ButtonWidget(230, 32, 20, 20, new GuiTextureGroup(new ResourceTexture("multiblocked:textures/gui/add.png"), new ItemStackTexture(Items.field_151044_h)), cd -> {
            Recipe recipe = new Recipe(UUID.randomUUID().toString(), ImmutableMap.of(), ImmutableMap.of(), ImmutableMap.of(), ImmutableMap.of(), (ImmutableList<RecipeCondition>)ImmutableList.of(), 1);
            this.recipes.add(new RecipeItem(recipe, true));
            this.recipesList.addWidget(this.recipes.get(this.recipes.size() - 1));
        }).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.dialogs.recipe_map.add_fuel_tip"));
        if (recipeMap.isFuelRecipeMap()) {
            for (Recipe recipe : recipeMap.fuelRecipes) {
                this.recipes.add(new RecipeItem(recipe, true));
                this.recipesList.addWidget(this.recipes.get(this.recipes.size() - 1));
            }
        }
        for (Recipe recipe : recipeMap.recipes.values()) {
            this.recipes.add(new RecipeItem(recipe, false));
            this.recipesList.addWidget(this.recipes.get(this.recipes.size() - 1));
        }
        this.conditionGroup = new WidgetGroup(50, 170, 176, 70);
        this.addWidget(this.conditionGroup);
    }

    public boolean isFuelRecipeMap() {
        return this.recipes.stream().anyMatch(r -> ((RecipeItem)r).isFuel);
    }

    @Override
    public void close() {
        super.close();
        this.onSave.accept(null);
    }

    private void onSave(ClickData clickData) {
        if (this.recipeMap.isFuelRecipeMap()) {
            this.recipeMap.fuelRecipes.clear();
        }
        this.recipeMap.recipes.clear();
        this.recipeMap.inputCapabilities.clear();
        this.recipeMap.outputCapabilities.clear();
        for (RecipeItem recipeItem : this.recipes) {
            if (!recipeItem.isFuel) {
                this.recipeMap.addRecipe(recipeItem.getRecipe());
                continue;
            }
            this.recipeMap.addFuelRecipe(recipeItem.getRecipe());
        }
        this.onSave.accept(this.recipeMap);
        super.close();
    }

    @Override
    public Widget mouseClicked(int mouseX, int mouseY, int button) {
        Widget widget;
        if (this.contentCandidates != null && this.contentCandidates.isMouseOverElement(mouseX, mouseY)) {
            widget = this.contentCandidates;
            this.contentCandidates.mouseClicked(mouseX, mouseY, button);
        } else {
            widget = super.mouseClicked(mouseX, mouseY, button);
        }
        if (this.contentCandidates != null) {
            if (this.widgets.contains(this.contentCandidates)) {
                this.removeWidget(this.contentCandidates);
                this.contentCandidates = null;
            } else {
                this.addWidget(this.contentCandidates);
            }
        }
        return widget;
    }

    class RecipeItem
    extends WidgetGroup
    implements DraggableScrollableWidgetGroup.ISelected {
        private final boolean isFuel;
        private Recipe recipe;
        private boolean isSelected;
        private String uid;
        private int duration;
        private final Map<MultiblockCapability<?>, List<ContentWidget<?>>> inputs;
        private final Map<MultiblockCapability<?>, List<ContentWidget<?>>> outputs;
        private final List<RecipeCondition> conditions;
        private ContentWidget<?> selectedContent;
        private ButtonWidget removed;

        public RecipeItem(Recipe recipe, boolean isFuel) {
            super(5, 5 + RecipeMapWidget.this.recipesList.widgets.size() * 22, 120, 20);
            this.isFuel = isFuel;
            this.uid = recipe.uid;
            this.recipe = recipe;
            this.duration = recipe.duration;
            this.inputs = new HashMap();
            this.outputs = new HashMap();
            this.conditions = new ArrayList<RecipeCondition>();
            this.addWidget(new ImageWidget(0, 0, 120, 20, new ColorRectTexture(1598682972)));
            this.addWidget(new ButtonWidget(104, 4, 12, 12, new ResourceTexture("multiblocked:textures/gui/remove.png"), cd -> {
                boolean find = false;
                for (Widget widget : RecipeMapWidget.this.recipesList.widgets) {
                    if (widget == this) {
                        find = true;
                        continue;
                    }
                    if (!find) continue;
                    widget.addSelfPosition(0, -22);
                }
                if (this.isSelected) {
                    RecipeMapWidget.this.configurator.clearAllWidgets();
                    RecipeMapWidget.this.recipeIO.clearAllWidgets();
                }
                RecipeMapWidget.this.recipes.remove(this);
                RecipeMapWidget.this.recipesList.waitToRemoved(this);
            }).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.dialogs.recipe_map.remove_recipe"));
            for (RecipeCondition condition : recipe.conditions) {
                this.conditions.add(condition.createTemplate().deserialize(condition.serialize()));
            }
        }

        @Override
        public void drawInBackground(int mouseX, int mouseY, float partialTicks) {
            super.drawInBackground(mouseX, mouseY, partialTicks);
            if (this.inputs.isEmpty() && this.outputs.isEmpty()) {
                this.updateIOContentWidgets();
            }
            List in = this.inputs.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            for (int i = 0; i < Math.min(2, in.size()); ++i) {
                ContentWidget widget = (ContentWidget)in.get(i);
                int x = this.getPosition().x - widget.getPosition().x + i * 20;
                int y = this.getPosition().y - widget.getPosition().y;
                GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
                widget.drawInBackground(-1, -1, partialTicks);
                GlStateManager.func_179109_b((float)(-x), (float)(-y), (float)0.0f);
            }
            if (this.isFuel) {
                new TextTexture("multiblocked.gui.dialogs.recipe_map.fuel_recipe").setType(TextTexture.TextType.LEFT).draw(mouseX, mouseY, this.getPosition().x + 60, this.getPosition().y + 6, 100, 10);
            } else {
                List out = this.outputs.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
                for (int i = 0; i < Math.min(2, out.size()); ++i) {
                    ContentWidget widget = (ContentWidget)out.get(i);
                    int x = this.getPosition().x - widget.getPosition().x + i * 20 + 60;
                    int y = this.getPosition().y - widget.getPosition().y;
                    GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
                    widget.drawInBackground(-1, -1, partialTicks);
                    GlStateManager.func_179109_b((float)(-x), (float)(-y), (float)0.0f);
                }
            }
            if (this.isSelected) {
                DrawerHelper.drawBorder(this.getPosition().x + 1, this.getPosition().y + 1, this.getSize().width - 2, this.getSize().height - 2, -564651, 2);
            }
        }

        @Override
        public boolean allowSelected(int mouseX, int mouseY, int button) {
            return this.isMouseOverElement(mouseX, mouseY);
        }

        @Override
        public void onSelected() {
            if (!this.isSelected) {
                this.isSelected = true;
                this.updateRecipeWidget();
            }
        }

        @Override
        public void onUnSelected() {
            this.isSelected = false;
            this.updateRecipe();
        }

        private void updateRecipe() {
            this.recipe = new Recipe(this.uid, this.rebuild(this.inputs, false), this.rebuild(this.outputs, false), this.rebuild(this.inputs, true), this.rebuild(this.outputs, true), (ImmutableList<RecipeCondition>)ImmutableList.copyOf(this.conditions), this.duration);
        }

        private ImmutableMap<MultiblockCapability<?>, ImmutableList<Content>> rebuild(Map<MultiblockCapability<?>, List<ContentWidget<?>>> contents, boolean perTick) {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (Map.Entry<MultiblockCapability<?>, List<ContentWidget<?>>> entry : contents.entrySet()) {
                MultiblockCapability<?> capability = entry.getKey();
                if (capability == null || entry.getValue().isEmpty()) continue;
                ImmutableList.Builder listBuilder = new ImmutableList.Builder();
                for (ContentWidget<?> content : entry.getValue()) {
                    if (content.getPerTick() != perTick) continue;
                    listBuilder.add((Object)new Content(content.getContent(), content.getChance(), content.getSlotName()));
                }
                ImmutableList list = listBuilder.build();
                if (list.isEmpty()) continue;
                builder.put(capability, (Object)listBuilder.build());
            }
            return builder.build();
        }

        public Recipe getRecipe() {
            if (!this.isSelected) {
                return this.recipe;
            }
            this.updateRecipe();
            return this.recipe;
        }

        private void updateIOContentWidgets() {
            ContentWidget contentWidget;
            MultiblockCapability capability;
            this.inputs.clear();
            this.outputs.clear();
            for (Map.Entry entry : this.recipe.inputs.entrySet()) {
                capability = (MultiblockCapability)entry.getKey();
                for (Content in : (ImmutableList)entry.getValue()) {
                    contentWidget = (ContentWidget)capability.createContentWidget().setOnPhantomUpdate(w -> this.onContentSelectedOrUpdate(true, capability, (ContentWidget<?>)w)).setContent(IO.IN, in, false).setOnSelected(w -> this.onContentSelectedOrUpdate(true, capability, (ContentWidget)w)).setSelectedTexture(-1, 0);
                    this.inputs.computeIfAbsent(capability, c -> new ArrayList()).add(contentWidget);
                }
            }
            for (Map.Entry entry : this.recipe.tickInputs.entrySet()) {
                capability = (MultiblockCapability)entry.getKey();
                for (Content in : (ImmutableList)entry.getValue()) {
                    contentWidget = (ContentWidget)capability.createContentWidget().setOnPhantomUpdate(w -> this.onContentSelectedOrUpdate(true, capability, (ContentWidget<?>)w)).setContent(IO.IN, in, true).setOnSelected(w -> this.onContentSelectedOrUpdate(true, capability, (ContentWidget)w)).setSelectedTexture(-1, 0);
                    this.inputs.computeIfAbsent(capability, c -> new ArrayList()).add(contentWidget);
                }
            }
            for (Map.Entry entry : this.recipe.outputs.entrySet()) {
                capability = (MultiblockCapability)entry.getKey();
                for (Content out : (ImmutableList)entry.getValue()) {
                    contentWidget = (ContentWidget)capability.createContentWidget().setOnPhantomUpdate(w -> this.onContentSelectedOrUpdate(false, capability, (ContentWidget<?>)w)).setContent(IO.OUT, out, false).setOnSelected(w -> this.onContentSelectedOrUpdate(false, capability, (ContentWidget)w));
                    this.outputs.computeIfAbsent(capability, c -> new ArrayList()).add(contentWidget);
                }
            }
            for (Map.Entry entry : this.recipe.tickOutputs.entrySet()) {
                capability = (MultiblockCapability)entry.getKey();
                for (Content out : (ImmutableList)entry.getValue()) {
                    contentWidget = (ContentWidget)capability.createContentWidget().setOnPhantomUpdate(w -> this.onContentSelectedOrUpdate(false, capability, (ContentWidget<?>)w)).setContent(IO.OUT, out, true).setOnSelected(w -> this.onContentSelectedOrUpdate(false, capability, (ContentWidget)w));
                    this.outputs.computeIfAbsent(capability, c -> new ArrayList()).add(contentWidget);
                }
            }
        }

        public void updateRecipeWidget() {
            ProgressWidget progressWidget;
            RecipeMapWidget.this.configurator.clearAllWidgets();
            WidgetGroup group = RecipeMapWidget.this.recipeIO;
            WidgetGroup conditionGroup = RecipeMapWidget.this.conditionGroup;
            conditionGroup.clearAllWidgets();
            group.clearAllWidgets();
            group.addWidget(new ImageWidget(-10, -10, group.getSize().width + 20, group.getSize().height + 20, ResourceBorderTexture.BORDERED_BACKGROUND));
            if (!this.isFuel) {
                group.addWidget(new LabelWidget(5, 5, "multiblocked.gui.label.uid"));
                group.addWidget(new TextFieldWidget(30, 5, 120, 10, () -> this.uid, s -> {
                    this.uid = s;
                }).setHoverTooltip("multiblocked.gui.tips.unique"));
                this.inputs.clear();
            } else {
                group.addWidget(new ImageWidget(5, -3, 180, 20, new TextTexture("multiblocked.gui.dialogs.recipe_map.fuel_tip").setWidth(180).setType(TextTexture.TextType.LEFT)));
            }
            this.outputs.clear();
            DraggableScrollableWidgetGroup inputs = new DraggableScrollableWidgetGroup(this.isFuel ? 56 : 5, 20, 64, 64).setBackground(new ColorRectTexture(0x3F000000));
            DraggableScrollableWidgetGroup outputs = new DraggableScrollableWidgetGroup(107, 20, 64, 64).setBackground(new ColorRectTexture(0x3F000000));
            group.addWidget(inputs);
            if (!this.isFuel) {
                group.addWidget(outputs);
                progressWidget = new ProgressWidget(ProgressWidget.JEIProgress, 78, 42, 20, 20, RecipeMapWidget.this.recipeMap.progressTexture);
                group.addWidget(progressWidget);
                group.addWidget(new ButtonWidget(78, 42, 20, 20, null, cd -> new ResourceTextureWidget((WidgetGroup)RecipeMapWidget.this, texture -> {
                    if (texture != null) {
                        RecipeMapWidget.this.recipeMap.progressTexture = texture;
                        progressWidget.setProgressBar(texture.getSubTexture(0.0, 0.0, 1.0, 0.5), texture.getSubTexture(0.0, 0.5, 1.0, 0.5));
                    }
                })).setHoverTexture(new ColorRectTexture(-1350006648)).setHoverTooltip("multiblocked.gui.dialogs.recipe_map.progress"));
            } else {
                progressWidget = new ProgressWidget(ProgressWidget.JEIProgress, 5, 42, 20, 20, RecipeMapWidget.this.recipeMap.fuelTexture);
                progressWidget.setFillDirection(ProgressTexture.FillDirection.DOWN_TO_UP);
                group.addWidget(progressWidget);
                group.addWidget(new ButtonWidget(5, 42, 20, 20, null, cd -> new ResourceTextureWidget((WidgetGroup)RecipeMapWidget.this, texture -> {
                    if (texture != null) {
                        RecipeMapWidget.this.recipeMap.fuelTexture = texture;
                        progressWidget.setProgressBar(texture.getSubTexture(0.0, 0.0, 1.0, 0.5), texture.getSubTexture(0.0, 0.5, 1.0, 0.5));
                    }
                })).setHoverTexture(new ColorRectTexture(-1350006648)).setHoverTooltip("multiblocked.gui.dialogs.recipe_map.fuel_progress"));
            }
            group.addWidget(new LabelWidget(5, 90, "multiblocked.gui.label.duration"));
            group.addWidget(new TextFieldWidget(60, 90, 60, 10, true, () -> this.duration + "", s -> {
                this.duration = Integer.parseInt(s);
            }).setNumbersOnly(1, Integer.MAX_VALUE));
            group.addWidget(new LabelWidget(122, 90, "multiblocked.gui.label.ticks"));
            this.updateIOContentWidgets();
            int index = 0;
            for (List<ContentWidget<?>> widgets : this.inputs.values()) {
                for (ContentWidget<?> contentWidget : widgets) {
                    inputs.addWidget(contentWidget.setSelfPosition(2 + 20 * (index % 3), 2 + 20 * (index / 3)));
                    ++index;
                }
            }
            int X = 2 + 20 * (index % 3);
            int Y = 2 + 20 * (index / 3);
            inputs.addWidget(new ButtonWidget(X + 2, Y + 2, 16, 16, new ResourceTexture("multiblocked:textures/gui/add.png"), cd -> this.addContent(this.inputs, X - inputs.getScrollXOffset() + group.getSelfPosition().x + 5, Y - inputs.getScrollYOffset() + group.getSelfPosition().y + 5)).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.dialogs.recipe_map.add_in"));
            if (index > 8) {
                inputs.setSize(new Size(68, 64));
                inputs.setYScrollBarWidth(4).setYBarStyle(null, new ColorRectTexture(-1));
            }
            if (!this.isFuel) {
                index = 0;
                for (List list : this.outputs.values()) {
                    for (ContentWidget widget : list) {
                        outputs.addWidget(widget.setSelfPosition(2 + 20 * (index % 3), 2 + 20 * (index / 3)));
                        ++index;
                    }
                }
                int X2 = 2 + 20 * (index % 3);
                int n = 2 + 20 * (index / 3);
                outputs.addWidget(new ButtonWidget(X2 + 2, n + 2, 16, 16, new ResourceTexture("multiblocked:textures/gui/add.png"), cd -> this.addContent(this.outputs, X2 - outputs.getScrollXOffset() + group.getSelfPosition().x + 176 - 74 + 5, Y2 - outputs.getScrollYOffset() + group.getSelfPosition().y + 5)).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.dialogs.recipe_map.add_out"));
                if (index > 8) {
                    outputs.setSize(new Size(68, 64));
                    outputs.setYScrollBarWidth(4).setYBarStyle(null, new ColorRectTexture(-1));
                }
            }
            DraggableScrollableWidgetGroup conditionsGroup = new DraggableScrollableWidgetGroup(0, 0, 86, 70).setBackground(new ColorRectTexture(0x6F444444));
            DraggableScrollableWidgetGroup draggableScrollableWidgetGroup = new DraggableScrollableWidgetGroup(-28, 0, 20, 70).setBackground(new ColorRectTexture(0x6F444444));
            WidgetGroup configurator = new WidgetGroup(90, 0, 70, 70);
            conditionGroup.addWidget(new ImageWidget(-5, -5, conditionGroup.getSize().width + 10, conditionGroup.getSize().height + 10, ResourceBorderTexture.BORDERED_BACKGROUND));
            conditionGroup.addWidget(new ImageWidget(-32, -4, 28, 78, ResourceBorderTexture.BORDERED_BACKGROUND_BLUE));
            conditionGroup.addWidget(conditionsGroup);
            conditionGroup.addWidget(draggableScrollableWidgetGroup);
            conditionGroup.addWidget(configurator);
            for (RecipeCondition condition : MbdRecipeConditions.RECIPE_CONDITIONS_REGISTRY.values()) {
                draggableScrollableWidgetGroup.addWidget(new ButtonWidget(2, draggableScrollableWidgetGroup.getAllWidgetSize() * 18, 16, 16, condition.getValidTexture(), cd -> {
                    this.conditions.add(condition.createTemplate().deserialize(condition.serialize()));
                    this.updateRecipeWidget();
                }).setHoverTooltip(condition.getTranlationKey()));
            }
            for (RecipeCondition condition : this.conditions) {
                SelectableWidgetGroup conditionWidget = (SelectableWidgetGroup)new SelectableWidgetGroup(0, conditionsGroup.getAllWidgetSize() * 20, conditionsGroup.getSize().width, 20).setOnSelected(selected -> {
                    configurator.clearAllWidgets();
                    condition.openConfigurator(configurator);
                }).setSelectedTexture(-2, -16733696).addWidget(new ImageWidget(0, 0, conditionsGroup.getSize().width, 20, new ColorRectTexture(0x4FAAAAAA))).addWidget(new ButtonWidget(conditionsGroup.getSize().width - 15, 4, 12, 12, new ResourceTexture("multiblocked:textures/gui/remove.png"), cd -> {
                    this.conditions.remove(condition);
                    this.updateRecipeWidget();
                }).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.tips.remove")).addWidget(new ImageWidget(22, 0, conditionsGroup.getSize().width - 22 - 17, 20, new TextTexture("").setSupplier(() -> condition.getTooltips().func_150254_d()).setWidth(conditionsGroup.getSize().width - 22 - 17).setType(TextTexture.TextType.ROLL))).addWidget(new ImageWidget(2, 2, 18, 18, condition.getValidTexture()));
                conditionsGroup.addWidget(conditionWidget);
            }
        }

        private void addContent(Map<MultiblockCapability<?>, List<ContentWidget<?>>> contents, int mouseX, int mouseY) {
            if (RecipeMapWidget.this.contentCandidates != null) {
                RecipeMapWidget.this.waitToRemoved(RecipeMapWidget.this.contentCandidates);
            }
            Collection<MultiblockCapability<?>> capabilities = MbdCapabilities.CAPABILITY_REGISTRY.values();
            int size = capabilities.size();
            RecipeMapWidget.this.contentCandidates = new WidgetGroup(mouseX + 10 - Math.min(size, 5) * 10, mouseY + 25, Math.min(size, 5) * 20, (1 + size / 5) * 20);
            RecipeMapWidget.this.contentCandidates.addWidget(new ImageWidget(-2, -2, RecipeMapWidget.this.contentCandidates.getSize().width + 4, RecipeMapWidget.this.contentCandidates.getSize().height + 4, new ResourceTexture("multiblocked:textures/gui/darkened_slot.png")));
            int i = 0;
            for (MultiblockCapability<?> capability : capabilities) {
                RecipeMapWidget.this.contentCandidates.addWidget(capability.createContentWidget().setContent(IO.IN, capability.defaultContent(), 1.0f, false).setOnMouseClicked(contentWidget -> {
                    contents.computeIfAbsent(capability, c -> new ArrayList()).add(contentWidget);
                    this.updateRecipe();
                    this.updateRecipeWidget();
                }).setSelfPosition(i % 5 * 20, i / 5 * 20));
                ++i;
            }
        }

        private void onContentSelectedOrUpdate(boolean input, MultiblockCapability<?> capability, ContentWidget<?> widget) {
            if (this.selectedContent != null && this.selectedContent != widget) {
                this.selectedContent.onUnSelected();
                this.selectedContent.waitToRemoved(this.removed);
            }
            if (this.selectedContent != widget) {
                this.removed = (ButtonWidget)new ButtonWidget(14, 0, 6, 6, cd -> {
                    (input ? this.inputs : this.outputs).get(capability).remove(widget);
                    this.updateRecipe();
                    this.updateRecipeWidget();
                }).setButtonTexture(new ResourceTexture("multiblocked:textures/gui/remove.png")).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.tips.remove");
                widget.addWidget(this.removed);
                this.selectedContent = widget;
            }
            WidgetGroup group = RecipeMapWidget.this.configurator;
            group.clearAllWidgets();
            group.addWidget(new ImageWidget(0, 0, group.getSize().width, group.getSize().height, ResourceBorderTexture.BORDERED_BACKGROUND));
            widget.openConfigurator(group);
        }
    }
}

