/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp.blueprint_table.dialogs;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.block.BlockComponent;
import com.cleanroommc.multiblocked.api.definition.PartDefinition;
import com.cleanroommc.multiblocked.api.gui.texture.ColorRectTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceTexture;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.util.ClickData;
import com.cleanroommc.multiblocked.api.gui.util.DrawerHelper;
import com.cleanroommc.multiblocked.api.gui.widget.Widget;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ButtonWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DialogWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableScrollableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ImageWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.LabelWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SceneWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SelectorWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SlotWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SwitchWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextBoxWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextFieldWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.tab.TabButton;
import com.cleanroommc.multiblocked.api.gui.widget.imp.tab.TabContainer;
import com.cleanroommc.multiblocked.api.pattern.JsonBlockPattern;
import com.cleanroommc.multiblocked.api.pattern.predicates.PredicateComponent;
import com.cleanroommc.multiblocked.api.pattern.predicates.SimplePredicate;
import com.cleanroommc.multiblocked.api.pattern.util.BlockInfo;
import com.cleanroommc.multiblocked.api.pattern.util.RelativeDirection;
import com.cleanroommc.multiblocked.api.registry.MbdComponents;
import com.cleanroommc.multiblocked.api.registry.MbdPredicates;
import com.cleanroommc.multiblocked.api.tile.part.PartTileEntity;
import com.cleanroommc.multiblocked.client.renderer.IRenderer;
import com.cleanroommc.multiblocked.client.renderer.impl.BlockStateRenderer;
import com.cleanroommc.multiblocked.client.renderer.impl.CycleBlockStateRenderer;
import com.cleanroommc.multiblocked.client.renderer.scene.WorldSceneRenderer;
import com.cleanroommc.multiblocked.client.util.RenderBufferUtils;
import com.cleanroommc.multiblocked.client.util.RenderUtils;
import com.cleanroommc.multiblocked.client.util.TrackedDummyWorld;
import com.cleanroommc.multiblocked.util.BlockPosFace;
import com.cleanroommc.multiblocked.util.CycleItemStackHandler;
import com.cleanroommc.multiblocked.util.LocalizationUtils;
import com.cleanroommc.multiblocked.util.Position;
import com.cleanroommc.multiblocked.util.Size;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class JsonBlockPatternWidget
extends DialogWidget {
    public static BlockComponent symbolBlock;
    public JsonBlockPattern pattern;
    public TabContainer container;
    public BlockPatternSceneWidget sceneWidget;
    public SelectorWidget[] selectors;
    public TextFieldWidget[] repeats;
    public DraggableScrollableWidgetGroup symbolSelector;
    public DraggableScrollableWidgetGroup predicateGroup;
    public DraggableScrollableWidgetGroup tfGroup;
    public TextBoxWidget textBox;
    public boolean needUpdatePredicateSelector;
    public boolean isPretty;

    public JsonBlockPatternWidget(WidgetGroup parent, JsonBlockPattern pattern, Consumer<JsonBlockPattern> onClose) {
        super(parent, true);
        this.setParentInVisible();
        this.setOnClosed(() -> onClose.accept(null));
        this.pattern = pattern;
        this.addWidget(new ImageWidget(0, 0, this.getSize().width, this.getSize().height, new ResourceTexture("multiblocked:textures/gui/json_block_pattern.png")));
        this.sceneWidget = new BlockPatternSceneWidget();
        this.addWidget(this.sceneWidget);
        this.container = new TabContainer(0, 0, 384, 256);
        this.addWidget(this.container);
        this.addWidget(new ButtonWidget(280, 29, 70, 20, cd -> {
            if (onClose != null) {
                onClose.accept(pattern);
            }
            if (this.isParentInVisible) {
                for (Widget widget : parent.widgets) {
                    widget.setVisible(true);
                    widget.setActive(true);
                }
            }
            parent.waitToRemoved(this);
        }).setButtonTexture(ResourceBorderTexture.BUTTON_COMMON, new TextTexture("multiblocked.gui.label.save_pattern", -1).setDropShadow(true)).setHoverBorderTexture(1, -1));
        ResourceTexture tabPattern = new ResourceTexture("multiblocked:textures/gui/tab_pattern.png");
        WidgetGroup patternTab = new WidgetGroup(0, 0, this.getSize().width, this.getSize().height);
        this.container.addTab(new TabButton(171, 29, 20, 20).setTexture(tabPattern.getSubTexture(0.0, 0.0, 1.0, 0.5), tabPattern.getSubTexture(0.0, 0.5, 1.0, 0.5)).setHoverTooltip("multiblocked.gui.dialogs.pattern.pattern"), patternTab);
        int bgColor = -1894706927;
        patternTab.addWidget(new LabelWidget(174, 92, "multiblocked.gui.label.repeat"));
        this.repeats = new TextFieldWidget[2];
        patternTab.addWidget(new ImageWidget(266, 86, 29, 18, new ResourceTexture("multiblocked:textures/gui/repeat.png")).setHoverTooltip("multiblocked.gui.dialogs.pattern.repeat"));
        this.repeats[0] = new TextFieldWidget(215, 87, 40, 15, true, () -> this.sceneWidget.selected == null ? "" : pattern.aisleRepetitions[this.sceneWidget.selected.a][0] + "", s -> {
            if (this.sceneWidget.selected != null && this.sceneWidget.centerOffset[0] != this.sceneWidget.selected.a) {
                pattern.aisleRepetitions[this.sceneWidget.selected.a][0] = Integer.parseInt(s);
                if (pattern.aisleRepetitions[this.sceneWidget.selected.a][0] > pattern.aisleRepetitions[this.sceneWidget.selected.a][1]) {
                    pattern.aisleRepetitions[this.sceneWidget.selected.a][1] = pattern.aisleRepetitions[this.sceneWidget.selected.a][0];
                }
            }
        }).setNumbersOnly(1, Integer.MAX_VALUE);
        patternTab.addWidget(this.repeats[0]);
        this.repeats[1] = new TextFieldWidget(305, 87, 40, 15, true, () -> this.sceneWidget.selected == null ? "" : pattern.aisleRepetitions[this.sceneWidget.selected.a][1] + "", s -> {
            if (this.sceneWidget.selected != null && this.sceneWidget.centerOffset[0] != this.sceneWidget.selected.a) {
                pattern.aisleRepetitions[this.sceneWidget.selected.a][1] = Integer.parseInt(s);
                if (pattern.aisleRepetitions[this.sceneWidget.selected.a][0] > pattern.aisleRepetitions[this.sceneWidget.selected.a][1]) {
                    pattern.aisleRepetitions[this.sceneWidget.selected.a][0] = pattern.aisleRepetitions[this.sceneWidget.selected.a][1];
                }
            }
        }).setNumbersOnly(0, Integer.MAX_VALUE);
        patternTab.addWidget(this.repeats[1]);
        this.repeats[0].setActive(false);
        this.repeats[1].setActive(false);
        this.repeats[0].setHoverTooltip("multiblocked.gui.tips.min");
        this.repeats[1].setHoverTooltip("multiblocked.gui.tips.max");
        this.symbolSelector = new DraggableScrollableWidgetGroup(215, 105, 130, 35).setBackground(new ColorRectTexture(bgColor));
        patternTab.addWidget(this.symbolSelector);
        patternTab.addWidget(new ButtonWidget(174, 105, 35, 35, cd -> {
            char next = (char)(pattern.symbolMap.keySet().stream().max(Comparator.comparingInt(a -> a.charValue())).get().charValue() + '\u0001');
            pattern.symbolMap.put(Character.valueOf(next), new HashSet());
            this.updateSymbolButton();
        }).setButtonTexture(new ResourceTexture("multiblocked:textures/gui/button_wood.png"), new TextTexture("multiblocked.gui.tips.add", -1).setDropShadow(true).setWidth(40)).setHoverBorderTexture(1, -1));
        this.updateSymbolButton();
        patternTab.addWidget(new LabelWidget(174, 143, "multiblocked.gui.label.tips"));
        List<String> candidates = Arrays.stream(RelativeDirection.values()).map(Enum::name).collect(Collectors.toList());
        patternTab.addWidget(new LabelWidget(174, 70, "multiblocked.gui.label.dir"));
        patternTab.addWidget(new ImageWidget(193, 60, 20, 20, new ResourceTexture("multiblocked:textures/gui/axis.png")).setHoverTooltip("multiblocked.gui.dialogs.pattern.direction"));
        patternTab.addWidget(new ImageWidget(215, 57, 40, 10, new TextTexture("multiblocked.gui.dialogs.pattern.char", -1).setDropShadow(true)));
        patternTab.addWidget(new ImageWidget(260, 57, 40, 10, new TextTexture("multiblocked.gui.dialogs.pattern.string", -1).setDropShadow(true)));
        patternTab.addWidget(new ImageWidget(305, 57, 40, 10, new TextTexture("multiblocked.gui.dialogs.pattern.aisle", -1).setDropShadow(true)));
        this.selectors = new SelectorWidget[3];
        this.selectors[0] = new SelectorWidget(215, 67, 40, 15, candidates, -1).setOnChanged(s -> this.onDirChange(0, (String)s)).setButtonBackground(new ColorRectTexture(bgColor)).setValue(pattern.structureDir[0].name());
        patternTab.addWidget(this.selectors[0]);
        this.selectors[1] = new SelectorWidget(260, 67, 40, 15, candidates, -1).setOnChanged(s -> this.onDirChange(1, (String)s)).setButtonBackground(new ColorRectTexture(bgColor)).setValue(pattern.structureDir[1].name());
        patternTab.addWidget(this.selectors[1]);
        this.selectors[2] = new SelectorWidget(305, 67, 40, 15, candidates, -1).setOnChanged(s -> this.onDirChange(2, (String)s)).setButtonBackground(new ColorRectTexture(bgColor)).setValue(pattern.structureDir[2].name());
        patternTab.addWidget(this.selectors[2]);
        ResourceTexture tabPredicate = new ResourceTexture("multiblocked:textures/gui/tab_predicate.png");
        WidgetGroup predicateTab = new WidgetGroup(0, 0, this.getSize().width, this.getSize().height);
        this.container.addTab(new TabButton(196, 29, 20, 20).setTexture(tabPredicate.getSubTexture(0.0, 0.0, 1.0, 0.5), tabPredicate.getSubTexture(0.0, 0.5, 1.0, 0.5)).setHoverTooltip("multiblocked.gui.dialogs.pattern.predicate"), predicateTab);
        DraggableScrollableWidgetGroup predicatesContainer = new DraggableScrollableWidgetGroup(171, 52, 179, 84).setBackground(new ColorRectTexture(bgColor)).setYScrollBarWidth(4).setYBarStyle(null, new ColorRectTexture(-1));
        predicateTab.addWidget(predicatesContainer);
        AtomicReference selectedPredicate = new AtomicReference();
        SelectorWidget sw = new SelectorWidget(172, 138, 60, 16, new ArrayList<String>(MbdPredicates.PREDICATE_REGISTRY.keySet()), -1).setButtonBackground(new ColorRectTexture(bgColor)).setValue("blocks");
        predicateTab.addWidget(sw);
        TextFieldWidget fw = new TextFieldWidget(232, 138, 50, 16, true, null, null);
        predicateTab.addWidget(fw);
        predicateTab.addWidget(new ButtonWidget(285, 138, 16, 16, cd -> {
            if (sw.getValue() == null) {
                return;
            }
            SimplePredicate predicate = MbdPredicates.createPredicate(sw.getValue());
            String predicateName = fw.getCurrentString();
            if (predicate != null && !pattern.predicates.containsKey(predicateName)) {
                pattern.predicates.put(fw.getCurrentString(), predicate);
                predicatesContainer.addWidget(new PredicateWidget(0, predicatesContainer.widgets.size() * 21, predicate, predicateName, selectedPredicate));
            }
        }).setButtonTexture(new ResourceTexture("multiblocked:textures/gui/add.png")).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.dialogs.pattern.create_predicate"));
        predicateTab.addWidget(new ButtonWidget(314, 138, 16, 16, cd -> {
            if (selectedPredicate.get() == null) {
                return;
            }
            String name = ((PredicateWidget)selectedPredicate.get()).name;
            if (this.sceneWidget.selected != null && !name.equals("controller")) {
                pattern.symbolMap.get(Character.valueOf(this.sceneWidget.selected.symbol)).add(name);
                this.needUpdatePredicateSelector = true;
                for (SymbolTileEntity tile : this.sceneWidget.tiles.values()) {
                    tile.updateRenderer();
                }
                if (this.sceneWidget != null) {
                    this.sceneWidget.needCompileCache();
                }
            }
        }).setButtonTexture(new ResourceTexture("multiblocked:textures/gui/move_down.png")).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.dialogs.pattern.add_predicate"));
        predicateTab.addWidget(new ButtonWidget(332, 138, 16, 16, cd -> {
            if (selectedPredicate.get() == null) {
                return;
            }
            String name = ((PredicateWidget)selectedPredicate.get()).name;
            if (this.sceneWidget.selected != null) {
                pattern.symbolMap.get(Character.valueOf(this.sceneWidget.selected.symbol)).remove(name);
            }
            pattern.symbolMap.values().forEach(set -> set.remove(name));
            pattern.predicates.remove(name);
            this.needUpdatePredicateSelector = true;
            boolean found = false;
            for (Widget widget : predicatesContainer.widgets) {
                if (found) {
                    widget.addSelfPosition(0, -21);
                    widget.setVisible(true);
                    continue;
                }
                if (widget != selectedPredicate.get()) continue;
                predicatesContainer.waitToRemoved(widget);
                found = true;
            }
            for (SymbolTileEntity tile : this.sceneWidget.tiles.values()) {
                tile.updateRenderer();
            }
            if (this.sceneWidget != null) {
                this.sceneWidget.needCompileCache();
            }
        }).setButtonTexture(new ResourceTexture("multiblocked:textures/gui/remove.png")).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.dialogs.pattern.remove_predicate"));
        pattern.predicates.forEach((predicateName, predicate) -> {
            if (predicateName.equals("controller")) {
                return;
            }
            predicatesContainer.addWidget(new PredicateWidget(0, predicatesContainer.widgets.size() * 21, (SimplePredicate)predicate, (String)predicateName, selectedPredicate));
        });
        ResourceTexture tabTextField = new ResourceTexture("multiblocked:textures/gui/tab_text_field.png");
        WidgetGroup textFieldTab = new WidgetGroup(0, 0, this.getSize().width, this.getSize().height);
        this.container.addTab(new TabButton(221, 29, 20, 20).setTexture(tabTextField.getSubTexture(0.0, 0.0, 1.0, 0.5), tabTextField.getSubTexture(0.0, 0.5, 1.0, 0.5)).setHoverTooltip("multiblocked.gui.tips.json"), textFieldTab);
        textFieldTab.addWidget(new ImageWidget(171, 52, 179, 20, ResourceBorderTexture.BAR));
        textFieldTab.addWidget(new SwitchWidget(173, 54, 16, 16, (cd, r) -> {
            this.isPretty = r;
            this.updatePatternJson();
        }).setHoverBorderTexture(1, -1).setTexture(new ResourceTexture("multiblocked:textures/gui/pretty.png"), new ResourceTexture("multiblocked:textures/gui/pretty_active.png")).setHoverTooltip("multiblocked.gui.tips.pretty"));
        textFieldTab.addWidget(new ButtonWidget(193, 54, 16, 16, cd -> GuiScreen.func_146275_d((String)(this.isPretty ? Multiblocked.prettyJson(this.getPatternJson()) : this.getPatternJson()))).setButtonTexture(new ResourceTexture("multiblocked:textures/gui/copy.png")).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.tips.copy"));
        this.tfGroup = new DraggableScrollableWidgetGroup(171, 72, 179, 84).setBackground(new ColorRectTexture(bgColor)).setYScrollBarWidth(4).setYBarStyle(null, new ColorRectTexture(-1));
        textFieldTab.addWidget(this.tfGroup);
        this.textBox = new TextBoxWidget(0, 0, 175, Collections.singletonList("")).setFontColor(-1).setShadow(true);
        this.tfGroup.addWidget(this.textBox);
        this.container.setOnChanged((a, b) -> {
            if (b == textFieldTab) {
                this.updatePatternJson();
            }
        });
        this.addWidget(new LabelWidget(31, 166, () -> LocalizationUtils.format("multiblocked.gui.label.symbol", new Object[0]) + " " + (this.sceneWidget.selected == null ? "" : "'" + this.sceneWidget.selected.symbol + "'")).setTextColor(-1));
        this.addWidget(new LabelWidget(31, 178, () -> {
            if (this.sceneWidget.selected == null) {
                return "Aisle Repetition: ";
            }
            return String.format("Aisle Index: %d", this.sceneWidget.selected.a);
        }).setTextColor(-1));
        this.addWidget(new LabelWidget(31, 190, () -> {
            if (this.sceneWidget.selected == null) {
                return "Aisle Repetition: ";
            }
            int[] repeat = pattern.aisleRepetitions[this.sceneWidget.selected.a];
            return String.format("Aisle Repetition: (%d, %d)", repeat[0], repeat[1]);
        }).setTextColor(-1));
        this.predicateGroup = new DraggableScrollableWidgetGroup(171, 166, 179, 58).setBackground(new ColorRectTexture(bgColor)).setYScrollBarWidth(4).setYBarStyle(null, new ColorRectTexture(-1));
        this.addWidget(this.predicateGroup);
        this.updatePredicateSelector();
        for (SymbolTileEntity tile : this.sceneWidget.tiles.values()) {
            tile.updateRenderer();
        }
        if (this.sceneWidget != null) {
            this.sceneWidget.needCompileCache();
        }
    }

    public void updatePatternJson() {
        this.textBox.setContent(Collections.singletonList(this.isPretty ? Multiblocked.prettyJson(this.getPatternJson()) : this.getPatternJson()));
        this.tfGroup.computeMax();
    }

    public String getPatternJson() {
        return this.pattern.toJson();
    }

    public static int getColor(char symbol) {
        switch (symbol) {
            case '@': {
                return -16776961;
            }
            case ' ': {
                return -11604489;
            }
            case '-': {
                return -14799369;
            }
        }
        return EnumDyeColor.values()[(symbol - 65) % EnumDyeColor.values().length].field_193351_w | 0xFF000000;
    }

    private void updatePredicateSelector() {
        this.predicateGroup.clearAllWidgets();
        if (this.sceneWidget.selected != null && this.pattern.symbolMap.containsKey(Character.valueOf(this.sceneWidget.selected.symbol))) {
            for (String predicateName : this.pattern.symbolMap.get(Character.valueOf(this.sceneWidget.selected.symbol))) {
                SimplePredicate predicate = this.pattern.predicates.get(predicateName);
                if (predicate == null) continue;
                this.predicateGroup.addWidget(new PredicateWidget(0, this.predicateGroup.widgets.size() * 21, predicate, predicateName, name -> {
                    if (this.sceneWidget.selected != null) {
                        this.pattern.symbolMap.get(Character.valueOf(this.sceneWidget.selected.symbol)).remove(name);
                        this.needUpdatePredicateSelector = true;
                        for (SymbolTileEntity tile : this.sceneWidget.tiles.values()) {
                            tile.updateRenderer();
                        }
                        if (this.sceneWidget != null) {
                            this.sceneWidget.needCompileCache();
                        }
                    }
                }));
            }
        }
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        if (this.needUpdatePredicateSelector) {
            this.updatePredicateSelector();
            this.needUpdatePredicateSelector = false;
        }
    }

    private void updateSymbolButton() {
        this.symbolSelector.clearAllWidgets();
        int i = 0;
        Iterator iterator = this.pattern.symbolMap.keySet().stream().sorted().collect(Collectors.toList()).iterator();
        while (iterator.hasNext()) {
            char c = ((Character)iterator.next()).charValue();
            this.symbolSelector.addWidget(new SymbolButton(13 * (i % 9) + 8, 13 * (i / 9) + 6, 10, 10, c, this.sceneWidget, cd -> {
                if (this.sceneWidget.selected != null && c != '@' && this.sceneWidget.selected.symbol != '@') {
                    String newString;
                    this.sceneWidget.selected.symbol = c;
                    this.sceneWidget.selected.updateRenderer();
                    String old = this.pattern.pattern[this.sceneWidget.selected.a][this.sceneWidget.selected.b];
                    this.pattern.pattern[this.sceneWidget.selected.a][this.sceneWidget.selected.b] = newString = old.substring(0, this.sceneWidget.selected.c) + c + old.substring(this.sceneWidget.selected.c + 1);
                    this.sceneWidget.updateCharacterView();
                    BlockPos pos = this.sceneWidget.selected.func_174877_v();
                    this.sceneWidget.onSelected(pos, EnumFacing.NORTH);
                    this.sceneWidget.onSelected(pos, EnumFacing.NORTH);
                }
            }).setHoverTooltip(c == '@' ? "controller" : (c == ' ' ? "any" : (c == '-' ? "air" : null))));
            ++i;
        }
        if (this.sceneWidget != null) {
            this.sceneWidget.needCompileCache();
        }
    }

    private void onDirChange(int index, String candidate) {
        RelativeDirection dir = RelativeDirection.valueOf(candidate);
        RelativeDirection[] newDirs = new RelativeDirection[3];
        newDirs[index] = dir;
        for (int i = 0; i < this.pattern.structureDir.length; ++i) {
            if (this.pattern.structureDir[i].isSameAxis(dir) && i != index) {
                newDirs[i] = this.pattern.structureDir[index];
            } else if (i != index) {
                newDirs[i] = this.pattern.structureDir[i];
            }
            this.selectors[i].setValue(newDirs[i].name());
        }
        this.pattern.changeDir(newDirs[0], newDirs[1], newDirs[2]);
        this.sceneWidget.reloadBlocks();
    }

    public static void registerBlock() {
        PartDefinition definition = new PartDefinition(new ResourceLocation("multiblocked", "symbol"), (Class<? extends PartTileEntity<?>>)SymbolTileEntity.class);
        definition.properties.isOpaque = false;
        definition.properties.showInJei = false;
        MbdComponents.registerComponent(definition);
        symbolBlock = (BlockComponent)MbdComponents.COMPONENT_BLOCKS_REGISTRY.get((Object)definition.location);
        symbolBlock.func_149647_a(null);
    }

    public static class SymbolTileEntity
    extends PartTileEntity<PartDefinition> {
        public char symbol;
        public IRenderer renderer;
        public JsonBlockPatternWidget widget;
        public int a;
        public int b;
        public int c;

        public void init(char symbol, JsonBlockPatternWidget widget, int a, int b, int c) {
            this.symbol = symbol;
            this.widget = widget;
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public void updateRenderer() {
            if (this.widget.pattern.symbolMap.containsKey(Character.valueOf(this.symbol))) {
                HashSet<Object> candidates = new HashSet<Object>();
                for (String s : this.widget.pattern.symbolMap.get(Character.valueOf(this.symbol))) {
                    SimplePredicate predicate = this.widget.pattern.predicates.get(s);
                    if (predicate instanceof PredicateComponent && ((PredicateComponent)predicate).definition != null) {
                        this.renderer = ((PredicateComponent)predicate).definition.getRenderer();
                        candidates = null;
                        break;
                    }
                    if (predicate == null || predicate.candidates == null) continue;
                    candidates.addAll(Arrays.asList((Object[])predicate.candidates.get()));
                }
                if (candidates != null) {
                    this.renderer = candidates.size() == 1 ? new BlockStateRenderer(candidates.toArray(new BlockInfo[0])[0]) : (!candidates.isEmpty() ? new CycleBlockStateRenderer(candidates.toArray(new BlockInfo[0])) : null);
                }
            }
        }

        @Override
        public boolean isFormed() {
            return false;
        }

        @Override
        public IRenderer getRenderer() {
            return this.widget == null ? null : (this.widget.sceneWidget.viewMode == 1 ? null : this.renderer);
        }
    }

    public static class SymbolButton
    extends ButtonWidget {
        private final BlockPatternSceneWidget sceneWidget;
        private final char c;

        public SymbolButton(int xPosition, int yPosition, int width, int height, char c, BlockPatternSceneWidget sceneWidget, Consumer<ClickData> onPressed) {
            super(xPosition, yPosition, width, height, new TextTexture(c + "", JsonBlockPatternWidget.getColor(c)), onPressed);
            this.c = c;
            this.sceneWidget = sceneWidget;
        }

        @Override
        public void drawInBackground(int mouseX, int mouseY, float partialTicks) {
            Position position = this.getPosition();
            Size size = this.getSize();
            DrawerHelper.drawBorder(position.x, position.y, size.width, size.height, this.sceneWidget.selected != null && this.sceneWidget.selected.symbol == this.c ? -16711936 : -1, 1);
            super.drawInBackground(mouseX, mouseY, partialTicks);
        }
    }

    public class PredicateWidget
    extends WidgetGroup {
        public SimplePredicate predicate;
        public CycleItemStackHandler itemHandler;
        public String name;
        public boolean isSelected;
        public AtomicReference<PredicateWidget> atomicReference;

        public PredicateWidget(int x, int y, SimplePredicate predicate, String name, int xC) {
            super(x, y, 175, 20);
            this.setClientSideWidget();
            this.predicate = predicate;
            this.name = name;
            this.itemHandler = new CycleItemStackHandler(Collections.singletonList(predicate.getCandidates()));
            this.addWidget(new ImageWidget(0, 0, 179, 20, new ResourceTexture("multiblocked:textures/gui/predicate_selector_bar.png")));
            this.addWidget(new SlotWidget(this.itemHandler, 0, 1, 1, false, false));
            this.addWidget(new ImageWidget(20, 0, 120, 20, new TextTexture(name, -1358954496).setWidth(120).setType(TextTexture.TextType.ROLL)));
            if (name.equals("controller") || name.equals("air") || name.equals("any")) {
                return;
            }
            this.addWidget(new ButtonWidget(xC, 3, 14, 14, new ResourceTexture("multiblocked:textures/gui/option.png"), cd -> {
                DialogWidget dialogWidget = new DialogWidget(JsonBlockPatternWidget.this, true).setOnClosed(() -> JsonBlockPatternWidget.this.sceneWidget.tiles.values().forEach(SymbolTileEntity::updateRenderer));
                dialogWidget.addWidget(new ImageWidget(0, 0, 384, 256, new ColorRectTexture(-1355599053)));
                int yOffset = 30;
                int xOffset = 30;
                for (WidgetGroup widget : predicate.getConfigWidget(new ArrayList<WidgetGroup>())) {
                    widget.addSelfPosition(xOffset, yOffset);
                    dialogWidget.addWidget(widget);
                    yOffset += widget.getSize().height + 5;
                }
            }).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.tips.configuration"));
        }

        public PredicateWidget(int x, int y, SimplePredicate predicate, String name, Consumer<String> closeCallBack) {
            this(x, y, predicate, name, 144);
            if (name.equals("controller")) {
                return;
            }
            this.addWidget(new ButtonWidget(160, 3, 14, 14, new ResourceTexture("multiblocked:textures/gui/remove.png"), cd -> {
                if (closeCallBack != null) {
                    closeCallBack.accept(name);
                }
            }).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.dialogs.pattern.remove_predicate"));
        }

        public PredicateWidget(int x, int y, SimplePredicate predicate, String name, AtomicReference<PredicateWidget> atomicReference) {
            this(x, y, predicate, name, 160);
            this.atomicReference = atomicReference;
        }

        @Override
        public void drawInBackground(int mouseX, int mouseY, float partialTicks) {
            super.drawInBackground(mouseX, mouseY, partialTicks);
            if (this.isSelected) {
                DrawerHelper.drawBorder(this.getPosition().x + 1, this.getPosition().y + 1, this.getSize().width - 2, this.getSize().height - 2, -16733696, 1);
            }
        }

        @Override
        public Widget mouseClicked(int mouseX, int mouseY, int button) {
            if (this.isMouseOverElement(mouseX, mouseY) && this.atomicReference != null) {
                if (this.atomicReference.get() == this) {
                    this.atomicReference.set(null);
                    this.isSelected = false;
                } else {
                    if (this.atomicReference.get() != null) {
                        this.atomicReference.get().isSelected = false;
                    }
                    this.atomicReference.set(this);
                    this.isSelected = true;
                }
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }

        @Override
        public void updateScreen() {
            super.updateScreen();
            this.itemHandler.updateStacks(Collections.singletonList(this.predicate.getCandidates()));
        }
    }

    public class BlockPatternSceneWidget
    extends SceneWidget {
        public Map<BlockPos, SymbolTileEntity> tiles;
        public Set<SymbolTileEntity> sameSymbol;
        public Set<SymbolTileEntity> sameAisle;
        public SymbolTileEntity selected;
        public int[] centerOffset;
        public int offset;
        public TextTexture texture;
        public int aisleRender;
        public int viewMode;
        public DraggableScrollableWidgetGroup characterView;
        public WidgetGroup layerSwitch;
        @SideOnly(value=Side.CLIENT)
        TrackedDummyWorld world;

        public BlockPatternSceneWidget() {
            super(31, 31, 125, 125, null);
            this.tiles = new HashMap<BlockPos, SymbolTileEntity>();
            this.sameSymbol = new HashSet<SymbolTileEntity>();
            this.sameAisle = new HashSet<SymbolTileEntity>();
            this.centerOffset = new int[3];
            this.aisleRender = -1;
            this.texture = new TextTexture("", -1).setWidth(125).setType(TextTexture.TextType.ROLL);
            this.characterView = new DraggableScrollableWidgetGroup(0, 0, 125, 125);
            this.addWidget(this.characterView);
            this.reloadBlocks();
            this.layerSwitch = new WidgetGroup(0, 0, 125, 125);
            this.addWidget(this.layerSwitch);
            this.layerSwitch.addWidget(new ImageWidget(5, 0, 125, 20, this.texture));
            this.layerSwitch.addWidget(new ButtonWidget(5, 50, 10, 10, new ResourceTexture("multiblocked:textures/gui/up.png"), cd -> this.addAisle(1)).setHoverTooltip("multiblocked.gui.dialogs.pattern.next_aisle"));
            this.layerSwitch.addWidget(new LabelWidget(5, 60, () -> this.aisleRender == -1 ? "all" : this.aisleRender + "").setTextColor(-1));
            this.layerSwitch.addWidget(new ButtonWidget(5, 70, 10, 10, new ResourceTexture("multiblocked:textures/gui/down.png"), cd -> this.addAisle(-1)).setHoverTooltip("multiblocked.gui.dialogs.pattern.last_aisle"));
            this.addWidget(new ButtonWidget(110, 110, 10, 10, new ResourceTexture("multiblocked:textures/gui/button_view.png"), this::switchPatternView).setHoverTooltip("multiblocked.gui.tips.switch_view"));
        }

        public void updateCharacterView() {
            this.characterView.clearAllWidgets();
            int x = 5;
            int y = 5;
            for (int i = 0; i < JsonBlockPatternWidget.this.pattern.pattern.length; ++i) {
                for (int j = 0; j < JsonBlockPatternWidget.this.pattern.pattern[0].length; ++j) {
                    for (int k = 0; k < JsonBlockPatternWidget.this.pattern.pattern[0][0].length(); ++k) {
                        char c = JsonBlockPatternWidget.this.pattern.pattern[i][j].charAt(k);
                        BlockPos pos = JsonBlockPatternWidget.this.pattern.getActualPosOffset(k - this.centerOffset[2], j - this.centerOffset[1], i - this.centerOffset[0], EnumFacing.NORTH).func_177982_a(this.offset, this.offset, this.offset);
                        this.characterView.addWidget(new SymbolButton(x, y, 10, 10, c, this, cd -> this.onSelected(pos, EnumFacing.NORTH)));
                        x += 13;
                    }
                    x += 5;
                }
                y += 13;
                x = 5;
            }
            this.characterView.setVisible(this.viewMode == 2);
        }

        private void switchPatternView(ClickData clickData) {
            this.viewMode = (this.viewMode + 1) % 3;
            if (this.viewMode == 2) {
                this.characterView.setVisible(true);
                this.characterView.setActive(true);
                this.layerSwitch.setVisible(false);
                this.layerSwitch.setActive(false);
            } else {
                this.characterView.setVisible(false);
                this.characterView.setActive(false);
                this.layerSwitch.setVisible(true);
                this.layerSwitch.setActive(true);
            }
            if (this.viewMode == 1 || this.viewMode == 2) {
                JsonBlockPatternWidget.this.sceneWidget.needCompileCache();
            }
        }

        private void addAisle(int add) {
            if (this.aisleRender + add >= -1 && this.aisleRender + add < JsonBlockPatternWidget.this.pattern.pattern.length) {
                this.aisleRender += add;
            }
            JsonBlockPatternWidget.this.sceneWidget.needCompileCache();
        }

        public void updateTips(String tips) {
            this.texture.updateText(tips);
        }

        public void reloadBlocks() {
            this.updateTips("");
            this.aisleRender = -1;
            this.selected = null;
            this.tiles.clear();
            this.sameSymbol.clear();
            this.sameAisle.clear();
            this.world = new TrackedDummyWorld();
            this.createScene(this.world);
            this.useCacheBuffer();
            this.world.setRenderFilter(pos -> {
                if (this.aisleRender > -1) {
                    return this.tiles.containsKey(pos) && this.tiles.get((Object)pos).a == this.aisleRender;
                }
                return true;
            });
            this.centerOffset = JsonBlockPatternWidget.this.pattern.getCenterOffset();
            String[][] pattern = JsonBlockPatternWidget.this.pattern.pattern;
            HashSet<BlockPos> posSet = new HashSet<BlockPos>();
            this.offset = Math.max(pattern.length, Math.max(pattern[0].length, pattern[0][0].length()));
            for (int i = 0; i < pattern.length; ++i) {
                for (int j = 0; j < pattern[0].length; ++j) {
                    for (int k = 0; k < pattern[0][0].length(); ++k) {
                        char c = pattern[i][j].charAt(k);
                        BlockPos pos2 = JsonBlockPatternWidget.this.pattern.getActualPosOffset(k - this.centerOffset[2], j - this.centerOffset[1], i - this.centerOffset[0], EnumFacing.NORTH).func_177982_a(this.offset, this.offset, this.offset);
                        this.world.addBlock(pos2, new BlockInfo(symbolBlock.func_176223_P()));
                        SymbolTileEntity tileEntity = (SymbolTileEntity)this.world.func_175625_s(pos2);
                        assert (tileEntity != null);
                        tileEntity.init(c, JsonBlockPatternWidget.this, i, j, k);
                        tileEntity.setDefinition(JsonBlockPatternWidget.symbolBlock.definition);
                        tileEntity.func_145834_a(this.world);
                        tileEntity.func_145829_t();
                        posSet.add(pos2);
                        this.tiles.put(pos2, tileEntity);
                        tileEntity.updateRenderer();
                    }
                }
            }
            this.setRenderedCore(posSet, null);
            this.setOnSelected(this::onSelected);
            this.setRenderFacing(false);
            this.updateCharacterView();
            this.needCompileCache();
        }

        @Override
        public Widget mouseClicked(int mouseX, int mouseY, int button) {
            return super.mouseClicked(mouseX, mouseY, button);
        }

        @Override
        public void renderBlockOverLay(WorldSceneRenderer renderer) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            GlStateManager.func_179147_l();
            GlStateManager.func_179090_x();
            if (this.viewMode == 1) {
                RenderHelper.func_74518_a();
                float lastBrightnessX = OpenGlHelper.lastBrightnessX;
                float lastBrightnessY = OpenGlHelper.lastBrightnessY;
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
                if (this.selected != null) {
                    for (SymbolTileEntity tile : this.sameSymbol) {
                        this.drawSymbolTE(tessellator, buffer, tile, JsonBlockPatternWidget.getColor(tile.symbol), 1.0f);
                    }
                }
                if (this.selected != null) {
                    GlStateManager.func_179132_a((boolean)false);
                }
                for (SymbolTileEntity tile : this.tiles.values()) {
                    if (this.aisleRender > -1 && tile.a != this.aisleRender || this.sameSymbol.contains(tile)) continue;
                    float dd = Math.abs(System.currentTimeMillis() % 3000L);
                    this.drawSymbolTE(tessellator, buffer, tile, JsonBlockPatternWidget.getColor(tile.symbol), this.selected == null ? 1.0f : (dd > 1500.0f ? 3000.0f - dd : dd) / 1500.0f * 0.3f);
                }
                if (this.selected != null) {
                    GlStateManager.func_179132_a((boolean)true);
                }
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
                RenderHelper.func_74519_b();
            }
            super.renderBlockOverLay(renderer);
            GlStateManager.func_179147_l();
            GlStateManager.func_179090_x();
            if (this.selected != null) {
                int[] minPos = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE};
                int[] maxPos = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE};
                for (SymbolTileEntity symbol : this.sameAisle) {
                    BlockPos pos = symbol.func_174877_v();
                    if (pos.func_177958_n() > maxPos[0]) {
                        maxPos[0] = pos.func_177958_n();
                    }
                    if (pos.func_177956_o() > maxPos[1]) {
                        maxPos[1] = pos.func_177956_o();
                    }
                    if (pos.func_177952_p() > maxPos[2]) {
                        maxPos[2] = pos.func_177952_p();
                    }
                    if (pos.func_177958_n() < minPos[0]) {
                        minPos[0] = pos.func_177958_n();
                    }
                    if (pos.func_177956_o() < minPos[1]) {
                        minPos[1] = pos.func_177956_o();
                    }
                    if (pos.func_177952_p() >= minPos[2]) continue;
                    minPos[2] = pos.func_177952_p();
                }
                GlStateManager.func_179112_b((int)770, (int)1);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                RenderUtils.renderCubeFace(buffer, (double)minPos[0] - 0.01, (double)minPos[1] - 0.01, (double)minPos[2] - 0.01, (double)maxPos[0] + 1.01, (double)maxPos[1] + 1.01, (double)maxPos[2] + 1.01, 0.3f, 0.5f, 0.7f, 1.0f);
                tessellator.func_78381_a();
                GlStateManager.func_179112_b((int)770, (int)771);
            }
            GlStateManager.func_179098_w();
        }

        private void drawSymbolTE(Tessellator tessellator, BufferBuilder buffer, SymbolTileEntity tile, int color, float a) {
            float r = (float)((color & 0xFF0000) >> 16) / 255.0f;
            float g = (float)((color & 0xFF00) >> 8) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            float scale = 0.8f;
            GlStateManager.func_179137_b((double)((double)tile.func_174877_v().func_177958_n() + 0.5), (double)((double)tile.func_174877_v().func_177956_o() + 0.5), (double)((double)tile.func_174877_v().func_177952_p() + 0.5));
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            RenderBufferUtils.renderCubeFace(buffer, -0.5, -0.5, -0.5, 0.5, 0.5, 0.5, r, g, b, a, true);
            tessellator.func_78381_a();
            GlStateManager.func_179152_a((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
            GlStateManager.func_179137_b((double)(-((double)tile.func_174877_v().func_177958_n() + 0.5)), (double)(-((double)tile.func_174877_v().func_177956_o() + 0.5)), (double)(-((double)tile.func_174877_v().func_177952_p() + 0.5)));
        }

        private void onSelected(BlockPos pos, EnumFacing facing) {
            if (this.selected == this.tiles.get(pos)) {
                this.selectedPosFace = null;
                this.selected = null;
                this.sameSymbol.clear();
                this.sameAisle.clear();
                this.updateTips("");
                JsonBlockPatternWidget.this.repeats[0].setActive(false);
                JsonBlockPatternWidget.this.repeats[1].setActive(false);
            } else {
                this.selectedPosFace = new BlockPosFace(pos, facing);
                this.selected = this.tiles.get(pos);
                this.sameSymbol.clear();
                this.sameAisle.clear();
                for (SymbolTileEntity symbol : this.tiles.values()) {
                    if (symbol.symbol == this.selected.symbol) {
                        this.sameSymbol.add(symbol);
                    }
                    if (this.selected.a != symbol.a) continue;
                    this.sameAisle.add(symbol);
                }
                JsonBlockPatternWidget.this.repeats[0].setActive(true);
                JsonBlockPatternWidget.this.repeats[1].setActive(true);
            }
            JsonBlockPatternWidget.this.needUpdatePredicateSelector = true;
        }

        @Override
        public Widget mouseReleased(int mouseX, int mouseY, int button) {
            if (this.viewMode == 2) {
                this.clickPosFace = null;
                this.dragging = false;
                return null;
            }
            Widget widget = null;
            if (button != 1) {
                widget = super.mouseReleased(mouseX, mouseY, button);
            }
            if (widget == null && this.isMouseOverElement(mouseX, mouseY) && this.hoverPosFace == null && this.selectedPosFace != null && button == 0) {
                this.onSelected(this.selectedPosFace.pos, this.selectedPosFace.facing);
                return this;
            }
            return widget;
        }
    }
}

