/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp.blueprint_table.dialogs;

import com.cleanroommc.multiblocked.api.gui.texture.ColorRectTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.util.ClickData;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ButtonWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DialogWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableScrollableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.GuiUtils;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ImageWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SearchComponentWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SelectableWidgetGroup;
import com.cleanroommc.multiblocked.api.sound.ComponentSound;
import com.cleanroommc.multiblocked.api.sound.SoundState;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ISoundWidget
extends DialogWidget
implements SearchComponentWidget.IWidgetSearch<SoundEvent> {
    public Consumer<SoundState> onSave;
    private SoundState sound;
    @SideOnly(value=Side.CLIENT)
    private ComponentSound componentSound;
    private final DraggableScrollableWidgetGroup soundList;
    private final WidgetGroup settings;

    public ISoundWidget(WidgetGroup parent, SoundState soundState, Consumer<SoundState> onSave) {
        super(parent, true);
        this.onSave = onSave;
        this.sound = soundState.copy();
        this.addWidget(new ImageWidget(0, 0, this.getSize().width, this.getSize().height, new ColorRectTexture(-1358954496)));
        this.addWidget(new ImageWidget(35, 45, 130, 170, ResourceBorderTexture.BORDERED_BACKGROUND_BLUE));
        this.soundList = new DraggableScrollableWidgetGroup(35, 49, 130, 162).setYScrollBarWidth(4).setYBarStyle(null, new ColorRectTexture(-1));
        this.addWidget(this.soundList);
        this.addWidget(new ButtonWidget(180, 55, 40, 20, this::play).setButtonTexture(ResourceBorderTexture.BUTTON_COMMON, new TextTexture("Play", -1).setDropShadow(true)).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.tips.play"));
        this.addWidget(new ButtonWidget(230, 55, 40, 20, cd -> {
            if (this.componentSound != null) {
                this.componentSound.stopSound();
            }
            onSave.accept(this.sound);
            super.close();
        }).setButtonTexture(ResourceBorderTexture.BUTTON_COMMON, new TextTexture("multiblocked.gui.tips.save_1", -1).setDropShadow(true)).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.tips.save"));
        this.settings = new WidgetGroup(0, 0, this.getSize().width, this.getSize().height);
        this.addWidget(this.settings);
        this.addWidget(new SearchComponentWidget<SoundEvent>(35, 22, 130, 20, this));
        this.updateStatusList();
    }

    protected void updateStatusList() {
        this.soundList.clearAllWidgets();
        SelectableWidgetGroup selected = new SelectableWidgetGroup(5, 1 + this.soundList.widgets.size() * 22, this.soundList.getSize().width - 10, 20);
        selected.setSelectedTexture(-2, -16733696).setOnSelected(W -> {
            this.sound = SoundState.EMPTY;
            this.updateSettings();
        }).addWidget(new ImageWidget(0, 0, 120, 20, new ColorRectTexture(0x4FAAAAAA))).addWidget(new ImageWidget(2, 0, this.soundList.getSize().width - 14, 20, new TextTexture("NULL").setWidth(this.soundList.getSize().width - 14).setType(TextTexture.TextType.ROLL)));
        this.soundList.addWidget(selected);
        for (SoundEvent soundEvent : ForgeRegistries.SOUND_EVENTS.getValues()) {
            SelectableWidgetGroup group = new SelectableWidgetGroup(5, 1 + this.soundList.widgets.size() * 22, this.soundList.getSize().width - 10, 20);
            group.setSelectedTexture(-2, -16733696).setOnSelected(W -> {
                this.sound = this.sound.copy(soundEvent.getRegistryName());
                this.updateSettings();
            }).addWidget(new ImageWidget(0, 0, 120, 20, new ColorRectTexture(0x4FAAAAAA))).addWidget(new ImageWidget(2, 0, this.soundList.getSize().width - 14, 20, new TextTexture(this.getName(soundEvent)).setWidth(this.soundList.getSize().width - 14).setType(TextTexture.TextType.ROLL)));
            this.soundList.addWidget(group);
            if (!soundEvent.getRegistryName().equals((Object)this.sound.sound)) continue;
            selected = group;
        }
        this.soundList.setSelected(selected);
    }

    private String getName(SoundEvent soundEvent) {
        ITextComponent textComponent;
        SoundEventAccessor eventAccessor;
        if (this.isRemote() && (eventAccessor = Minecraft.func_71410_x().func_147118_V().func_184398_a(soundEvent.func_187503_a())) != null && (textComponent = eventAccessor.func_188712_c()) != null) {
            return textComponent.func_150254_d();
        }
        return soundEvent.getRegistryName().toString();
    }

    private void updateSettings() {
        this.settings.clearAllWidgets();
        if (this.sound != SoundState.EMPTY) {
            this.settings.addWidget(GuiUtils.createBoolSwitch(181, 80, "loop", "multiblocked.gui.widget.sound.loop", this.sound.loop, r -> {
                this.sound.loop = r;
            }));
            this.settings.addWidget(GuiUtils.createIntField(181, 95, "delay", "multiblocked.gui.widget.sound.delay", this.sound.delay, 0, Integer.MAX_VALUE, r -> {
                this.sound.delay = r;
            }));
            this.settings.addWidget(GuiUtils.createFloatField(181, 110, "volume", "multiblocked.gui.widget.sound.volume", this.sound.volume, 0.0f, 1.0f, r -> {
                this.sound.volume = r.floatValue();
            }));
            this.settings.addWidget(GuiUtils.createFloatField(181, 125, "pitch", "multiblocked.gui.widget.sound.pitch", this.sound.pitch, 0.0f, Float.MAX_VALUE, r -> {
                this.sound.pitch = r.floatValue();
            }));
        }
    }

    @Override
    public void close() {
        if (this.componentSound != null) {
            this.componentSound.stopSound();
        }
        super.close();
    }

    private void play(ClickData clickData) {
        if (this.componentSound != null) {
            this.componentSound.stopSound();
        }
        this.componentSound = this.sound.playGUISound();
    }

    @Override
    public String resultDisplay(SoundEvent sound) {
        return this.getName(sound);
    }

    @Override
    public void selectResult(SoundEvent sound) {
        int index = ForgeRegistries.SOUND_EVENTS.getValues().indexOf(sound);
        this.soundList.setScrollYOffset(index * 22 + 1);
    }

    @Override
    public void search(String word, Consumer<SoundEvent> find) {
        for (SoundEvent sound : ForgeRegistries.SOUND_EVENTS.getValues()) {
            if (!sound.getRegistryName().toString().toLowerCase().contains(word.toLowerCase()) && !this.getName(sound).toLowerCase().contains(word.toLowerCase())) continue;
            find.accept(sound);
        }
    }
}

