/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp.blueprint_table.dialogs;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.gui.modular.ModularUI;
import com.cleanroommc.multiblocked.api.gui.texture.ColorBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ColorRectTexture;
import com.cleanroommc.multiblocked.api.gui.texture.GuiTextureGroup;
import com.cleanroommc.multiblocked.api.gui.texture.IGuiTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ShaderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ButtonWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DialogWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableScrollableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ImageWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextBoxWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextFieldWidget;
import com.cleanroommc.multiblocked.util.FileUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;

public class IShaderWidget
extends DialogWidget {
    private static final String HELP = "\u00c2\u00a72#version 120\u00c2\u00a7r\n\n\u00c2\u00a72uniform\u00c2\u00a7r \u00c2\u00a73vec2\u00c2\u00a7r iResolution; \u00c2\u00a77// iResolution as Shadertoy (width, height)\u00c2\u00a7r\n\u00c2\u00a72uniform\u00c2\u00a7r \u00c2\u00a73vec2\u00c2\u00a7r iMouse; \u00c2\u00a77// iMouse as Shadertoy (mouseX, mouseY)\u00c2\u00a7r\n\u00c2\u00a72uniform\u00c2\u00a7r \u00c2\u00a73float\u00c2\u00a7r iTime; \u00c2\u00a77// iTime as Shadertoy (second)\u00c2\u00a7r\n\n\u00c2\u00a73void\u00c2\u00a7r mainImage( out \u00c2\u00a73vec4\u00c2\u00a7r fragColor, in \u00c2\u00a73vec2\u00c2\u00a7r fragCoord) {\n    \u00c2\u00a77// write shader here like Shadertoy\u00c2\u00a7r\n}\n\n\u00c2\u00a73void\u00c2\u00a7r main() {\n    mainImage(gl_FragColor.rgba, \u00c2\u00a73vec2\u00c2\u00a7r(gl_TexCoord[0].x * iResolution.x, gl_TexCoord[0].y * iResolution.y));\n}\n";
    public final ShaderTexture shaderTexture;

    public IShaderWidget(WidgetGroup parent, String init) {
        super(parent, true);
        this.addWidget(new ImageWidget(0, 0, this.getSize().width, this.getSize().height, new ColorRectTexture(-1358954496)));
        IGuiTexture[] iGuiTextureArray = new IGuiTexture[2];
        iGuiTextureArray[0] = new ColorBorderTexture(3, -1);
        this.shaderTexture = ShaderTexture.createRawShader(init);
        iGuiTextureArray[1] = this.shaderTexture;
        this.addWidget(new ImageWidget(35, 59, 138, 138, new GuiTextureGroup(iGuiTextureArray)));
        TextFieldWidget textFieldWidget = new TextFieldWidget(181, 55, 120, 20, true, null, null).setAllowEnter(true).setCurrentString(init);
        DraggableScrollableWidgetGroup tfGroup = new DraggableScrollableWidgetGroup(181, 80, 170, 120).setBackground(new ColorRectTexture(0x3FAAAAAA)).setYScrollBarWidth(4).setYBarStyle(null, new ColorRectTexture(-1));
        TextBoxWidget textBox = new TextBoxWidget(0, 0, 165, Collections.singletonList(init)).setFontColor(-1).setShadow(true);
        this.addWidget(tfGroup);
        this.addWidget(textFieldWidget);
        this.addWidget(new ButtonWidget(305, 55, 40, 20, cd -> {
            try {
                textBox.setContent(Collections.singletonList(textFieldWidget.getCurrentString()));
                this.shaderTexture.updateRawShader(textFieldWidget.getCurrentString());
            }
            catch (Throwable e) {
                textBox.setContent(Collections.singletonList(e.getMessage()));
            }
            tfGroup.computeMax();
        }).setButtonTexture(ResourceBorderTexture.BUTTON_COMMON, new TextTexture("multiblocked.gui.tips.update", -1).setDropShadow(true)).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.tips.update"));
        File path = new File(Multiblocked.location, "assets/multiblocked/shaders");
        this.addWidget(new ButtonWidget(350, 55, 20, 20, cd -> DialogWidget.showFileDialog(this, "select a shader file", path, true, DialogWidget.suffixFilter(".frag"), r -> {
            if (r != null && r.isFile()) {
                try {
                    String result = FileUtility.readInputStream(new FileInputStream((File)r));
                    textFieldWidget.setCurrentString(result);
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            }
        })).setButtonTexture(new ResourceTexture("multiblocked:textures/gui/darkened_slot.png"), new TextTexture("F", -1)).setHoverTooltip("multiblocked.gui.dialogs.renderer.shader"));
        tfGroup.addWidget(textBox);
        this.addWidget(new ButtonWidget(305, 15, 40, 20, cd -> new DialogWidget(this, true).addWidget(new ImageWidget(0, 0, this.getSize().width, this.getSize().height, new ColorRectTexture(-553648128))).addWidget(new TextBoxWidget(2, 2, this.getSize().width - 4, Collections.singletonList(HELP)).setFontColor(-1).setShadow(true)).addWidget(new ImageWidget(0, 0, this.getSize().width, this.getSize().height, new ColorBorderTexture(1, -1)))).setButtonTexture(ResourceBorderTexture.BUTTON_COMMON, new TextTexture("multiblocked.gui.tips.help", -1).setDropShadow(true)).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.tips.help"));
    }

    @Override
    public void setGui(ModularUI gui) {
        super.setGui(gui);
        if (gui != null && this.shaderTexture != null) {
            gui.registerCloseListener(this.shaderTexture::dispose);
        }
    }
}

