/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp.blueprint_table.components;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.definition.ComponentDefinition;
import com.cleanroommc.multiblocked.api.definition.ControllerDefinition;
import com.cleanroommc.multiblocked.api.gui.texture.ColorBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ColorRectTexture;
import com.cleanroommc.multiblocked.api.gui.texture.GuiTextureGroup;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceTexture;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.util.ClickData;
import com.cleanroommc.multiblocked.api.gui.widget.Widget;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ButtonWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.GuiUtils;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ImageWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.LabelWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.PhantomSlotWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SceneWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SwitchWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextBoxWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextFieldWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.blueprint_table.RecipeMapBuilderWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.blueprint_table.TemplateBuilderWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.blueprint_table.components.ComponentWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.blueprint_table.dialogs.JsonBlockPatternWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.tab.TabButton;
import com.cleanroommc.multiblocked.api.pattern.JsonBlockPattern;
import com.cleanroommc.multiblocked.api.pattern.predicates.PredicateComponent;
import com.cleanroommc.multiblocked.api.pattern.predicates.SimplePredicate;
import com.cleanroommc.multiblocked.api.pattern.util.BlockInfo;
import com.cleanroommc.multiblocked.api.recipe.RecipeMap;
import com.cleanroommc.multiblocked.api.registry.MbdComponents;
import com.cleanroommc.multiblocked.api.tile.DummyComponentTileEntity;
import com.cleanroommc.multiblocked.client.renderer.impl.BlockStateRenderer;
import com.cleanroommc.multiblocked.client.util.TrackedDummyWorld;
import com.google.common.util.concurrent.AtomicDouble;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class ControllerWidget
extends ComponentWidget<ControllerDefinition> {
    protected JsonBlockPattern pattern;
    protected final WidgetGroup S4;
    protected final WidgetGroup S5;
    protected final SceneWidget sceneWidget;
    protected final Set<DummyComponentTileEntity> tiles = new HashSet<DummyComponentTileEntity>();
    protected boolean isFormed;
    protected String recipeMap;
    @SideOnly(value=Side.CLIENT)
    Thread thread;

    public ControllerWidget(WidgetGroup group, ControllerDefinition definition, JsonBlockPattern pattern, String recipeMap, Consumer<JsonObject> onSave) {
        super(group, definition, onSave);
        this.pattern = pattern;
        this.recipeMap = recipeMap;
        int x = 47;
        SimplePredicate predicate = this.pattern.predicates.get("controller");
        if (predicate instanceof PredicateComponent) {
            ((PredicateComponent)predicate).definition = definition;
        }
        WidgetGroup consumeCatalystWidget = GuiUtils.createSelector(x + 140, 165, "consumeCatalyst", "multiblocked.gui.widget.controller.consume", definition.consumeCatalyst.name(), Arrays.stream(ControllerDefinition.CatalystState.values()).map(Enum::name).collect(Collectors.toList()), r -> {
            definition.consumeCatalyst = ControllerDefinition.CatalystState.valueOf(r);
        });
        this.S1.addWidget(consumeCatalystWidget);
        ((Widget)consumeCatalystWidget).setVisible(definition.getCatalyst() != null);
        WidgetGroup noNeedControllerWidget = GuiUtils.createBoolSwitch(x + 140, 180, "noNeedController", "multiblocked.gui.widget.controller.no_controller", definition.noNeedController, r -> {
            definition.noNeedController = r;
        });
        this.S1.addWidget(noNeedControllerWidget);
        ((Widget)noNeedControllerWidget).setVisible(definition.getCatalyst() != null && !definition.getCatalyst().func_190926_b());
        ItemStackHandler handler = new ItemStackHandler(1);
        PhantomSlotWidget phantomSlotWidget = new PhantomSlotWidget((IItemHandlerModifiable)handler, 0, x + 250, 145);
        this.S1.addWidget(phantomSlotWidget);
        phantomSlotWidget.setClearSlotOnRightClick(true).setChangeListener(() -> ControllerWidget.lambda$new$2(definition, (IItemHandlerModifiable)handler, noNeedControllerWidget)).setBackgroundTexture(new ColorBorderTexture(1, -1)).setHoverTooltip("multiblocked.gui.widget.controller.catalyst").setVisible(definition.getCatalyst() != null);
        handler.setStackInSlot(0, definition.getCatalyst() == null ? ItemStack.field_190927_a : definition.getCatalyst());
        this.S1.addWidget(GuiUtils.createBoolSwitch(x + 140, 150, "needCatalyst", "multiblocked.gui.widget.controller.need_catalyst", definition.getCatalyst() != null, arg_0 -> ControllerWidget.lambda$new$3(definition, phantomSlotWidget, consumeCatalystWidget, noNeedControllerWidget, (IItemHandlerModifiable)handler, arg_0)));
        this.S4 = new WidgetGroup(0, 0, this.getSize().width, this.getSize().height);
        this.tabContainer.addTab(new TabButton(111, 26, 20, 20).setPressedTexture(new ResourceTexture("multiblocked:textures/gui/switch_common.png").getSubTexture(0.0, 0.5, 1.0, 0.5), new TextTexture("S4")).setBaseTexture(new ResourceTexture("multiblocked:textures/gui/switch_common.png").getSubTexture(0.0, 0.0, 1.0, 0.5), new TextTexture("S4")).setHoverTooltip("multiblocked.gui.widget.controller.s3"), this.S4);
        this.S4.addWidget(new ImageWidget(50, 66, 138, 138, new GuiTextureGroup(new ColorBorderTexture(3, -1), new ColorRectTexture(-1354480572))));
        this.sceneWidget = new SceneWidget(50, 66, 138, 138, null).useCacheBuffer().setRenderFacing(false).setRenderSelect(false);
        this.S4.addWidget(this.sceneWidget);
        ResourceTexture PAGE = new ResourceTexture("multiblocked:textures/gui/structure_page.png");
        this.sceneWidget.addWidget(new SwitchWidget(118, 118, 16, 16, this::onFormedSwitch).setPressed(this.isFormed).setTexture(PAGE.getSubTexture(0.8671875, 0.0, 0.0625, 0.0625), PAGE.getSubTexture(0.8671875, 0.0625, 0.0625, 0.0625)).setHoverTooltip("multiblocked.structure_page.switch"));
        this.S4.addWidget(new TextBoxWidget(200, 0, 175, Collections.singletonList("")).setFontColor(-1).setShadow(true));
        this.S4.addWidget(new ButtonWidget(200, 66, 100, 20, new GuiTextureGroup(ResourceBorderTexture.BAR, new TextTexture("multiblocked.gui.label.pattern_settings", -1).setDropShadow(true)), cd -> new JsonBlockPatternWidget(this, this.pattern.copy(), this::savePattern)).setHoverBorderTexture(1, -1));
        this.updateScene(this.pattern);
        this.S5 = new WidgetGroup(0, 0, this.getSize().width, this.getSize().height);
        this.tabContainer.addTab(new TabButton(134, 26, 20, 20).setPressedTexture(new ResourceTexture("multiblocked:textures/gui/switch_common.png").getSubTexture(0.0, 0.5, 1.0, 0.5), new TextTexture("S5")).setBaseTexture(new ResourceTexture("multiblocked:textures/gui/switch_common.png").getSubTexture(0.0, 0.0, 1.0, 0.5), new TextTexture("S5")).setHoverTooltip("multiblocked.gui.widget.controller.s4"), this.S5);
        this.S5.addWidget(new LabelWidget(80, 55, "multiblocked.gui.label.recipe_map"));
        this.S5.addWidget(new TextFieldWidget(80, 70, 100, 15, true, () -> this.recipeMap, s -> {
            this.recipeMap = s;
        }));
        this.S5.addWidget(new RecipeMapBuilderWidget(this, 188, 50, 150, 170).setOnRecipeMapSelected(recipeMap1 -> {
            this.recipeMap = recipeMap1.name;
        }));
    }

    @Override
    protected JsonObject getJsonObj() {
        JsonObject jsonObject = super.getJsonObj();
        jsonObject.add("basePattern", Multiblocked.GSON.toJsonTree((Object)this.pattern));
        jsonObject.addProperty("recipeMap", this.recipeMap == null ? RecipeMap.EMPTY.name : this.recipeMap);
        return jsonObject;
    }

    private void onFormedSwitch(ClickData clickData, boolean isPressed) {
        this.isFormed = isPressed;
        if (this.thread == null) {
            this.tiles.forEach(t -> {
                t.isFormed = this.isFormed;
            });
        }
        this.sceneWidget.needCompileCache();
    }

    @SideOnly(value=Side.CLIENT)
    private void updateScene(JsonBlockPattern jsonPattern) {
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
        TrackedDummyWorld world = new TrackedDummyWorld();
        this.tiles.clear();
        this.sceneWidget.createScene(world);
        ImageWidget imageWidget = new ImageWidget(0, 0, this.sceneWidget.getSize().width, this.sceneWidget.getSize().height);
        this.sceneWidget.addWidget(imageWidget);
        imageWidget.setVisible(jsonPattern.pattern.length * jsonPattern.pattern[0].length * jsonPattern.pattern[0][0].length() > 1000);
        this.thread = new Thread(() -> {
            int[] centerOffset = jsonPattern.getCenterOffset();
            String[][] pattern = jsonPattern.pattern;
            HashSet<BlockPos> posSet = new HashSet<BlockPos>();
            int offset = Math.max(pattern.length, Math.max(pattern[0].length, pattern[0][0].length()));
            int sum = jsonPattern.pattern.length * jsonPattern.pattern[0].length * jsonPattern.pattern[0][0].length();
            AtomicDouble progress = new AtomicDouble(0.0);
            imageWidget.setImage(new TextTexture("building scene!").setSupplier(() -> "building scene! " + String.format("%.1f", progress.get()) + "%%").setWidth(this.sceneWidget.getSize().width));
            int count = 0;
            for (int i = 0; i < pattern.length; ++i) {
                for (int j = 0; j < pattern[0].length; ++j) {
                    for (int k = 0; k < pattern[0][0].length(); ++k) {
                        if (Thread.interrupted()) {
                            this.sceneWidget.waitToRemoved(imageWidget);
                            return;
                        }
                        progress.set((double)(++count) * 100.0 / (double)sum);
                        char symbol = pattern[i][j].charAt(k);
                        BlockPos pos = jsonPattern.getActualPosOffset(k - centerOffset[2], j - centerOffset[1], i - centerOffset[0], EnumFacing.NORTH).func_177982_a(offset, offset, offset);
                        world.addBlock(pos, new BlockInfo(MbdComponents.DummyComponentBlock));
                        DummyComponentTileEntity tileEntity = (DummyComponentTileEntity)world.func_175625_s(pos);
                        ComponentDefinition definition = null;
                        assert (tileEntity != null);
                        boolean disableFormed = false;
                        if (jsonPattern.symbolMap.containsKey(Character.valueOf(symbol))) {
                            HashSet<BlockInfo> candidates = new HashSet<BlockInfo>();
                            for (String s : jsonPattern.symbolMap.get(Character.valueOf(symbol))) {
                                SimplePredicate predicate = jsonPattern.predicates.get(s);
                                if (predicate instanceof PredicateComponent && ((PredicateComponent)predicate).definition != null) {
                                    definition = ((PredicateComponent)predicate).definition;
                                    disableFormed |= predicate.disableRenderFormed;
                                    break;
                                }
                                if (predicate == null || predicate.candidates == null) continue;
                                candidates.addAll(Arrays.asList((Object[])predicate.candidates.get()));
                                disableFormed |= predicate.disableRenderFormed;
                            }
                            definition = TemplateBuilderWidget.getComponentDefinition(definition, candidates);
                        }
                        if (definition != null) {
                            tileEntity.setDefinition(definition);
                            if (disableFormed) {
                                definition.getIdleStatus().setRenderer(new BlockStateRenderer(Blocks.field_150350_a.func_176223_P()));
                            }
                        }
                        tileEntity.isFormed = this.isFormed;
                        tileEntity.func_145834_a(world);
                        tileEntity.func_145829_t();
                        posSet.add(pos);
                        this.tiles.add(tileEntity);
                    }
                }
            }
            Minecraft.func_71410_x().func_152344_a(() -> {
                this.sceneWidget.setRenderedCore(posSet, null);
                this.sceneWidget.waitToRemoved(imageWidget);
            });
            this.thread = null;
        });
        this.thread.start();
    }

    private void savePattern(JsonBlockPattern patternResult) {
        if (patternResult != null) {
            this.pattern = patternResult;
            this.pattern.cleanUp();
            this.updateScene(this.pattern);
        }
    }

    @Override
    protected void updateRegistryName(String s) {
        super.updateRegistryName(s);
        SimplePredicate predicate = this.pattern.predicates.get("controller");
        if (predicate instanceof PredicateComponent) {
            ((PredicateComponent)predicate).location = this.location;
        }
    }

    private static /* synthetic */ void lambda$new$3(ControllerDefinition definition, PhantomSlotWidget phantomSlotWidget, Widget consumeCatalystWidget, Widget noNeedControllerWidget, IItemHandlerModifiable handler, Boolean r) {
        definition.setCatalyst(r == false ? null : ItemStack.field_190927_a);
        phantomSlotWidget.setVisible(r);
        consumeCatalystWidget.setVisible(r);
        noNeedControllerWidget.setVisible(r != false && !handler.getStackInSlot(0).func_190926_b());
    }

    private static /* synthetic */ void lambda$new$2(ControllerDefinition definition, IItemHandlerModifiable handler, Widget noNeedControllerWidget) {
        definition.setCatalyst(handler.getStackInSlot(0));
        noNeedControllerWidget.setVisible(!handler.getStackInSlot(0).func_190926_b());
    }
}

