/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp.blueprint_table.components;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.block.CustomProperties;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.capability.trait.CapabilityTrait;
import com.cleanroommc.multiblocked.api.definition.ComponentDefinition;
import com.cleanroommc.multiblocked.api.definition.ControllerDefinition;
import com.cleanroommc.multiblocked.api.definition.PartDefinition;
import com.cleanroommc.multiblocked.api.definition.StatusProperties;
import com.cleanroommc.multiblocked.api.gui.texture.ColorBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ColorRectTexture;
import com.cleanroommc.multiblocked.api.gui.texture.IGuiTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceTexture;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.widget.Widget;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ButtonWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DialogWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableScrollableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.GuiUtils;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ImageWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.LabelWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SceneWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SelectableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SelectorWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SwitchWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextBoxWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextFieldWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.blueprint_table.dialogs.IRendererWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.blueprint_table.dialogs.IShapeWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.blueprint_table.dialogs.ISoundWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.blueprint_table.dialogs.ResourceTextureWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.tab.TabButton;
import com.cleanroommc.multiblocked.api.gui.widget.imp.tab.TabContainer;
import com.cleanroommc.multiblocked.api.pattern.util.BlockInfo;
import com.cleanroommc.multiblocked.api.registry.MbdCapabilities;
import com.cleanroommc.multiblocked.api.registry.MbdComponents;
import com.cleanroommc.multiblocked.api.sound.SoundState;
import com.cleanroommc.multiblocked.api.tile.DummyComponentTileEntity;
import com.cleanroommc.multiblocked.client.renderer.IRenderer;
import com.cleanroommc.multiblocked.client.renderer.scene.WorldSceneRenderer;
import com.cleanroommc.multiblocked.client.util.RenderBufferUtils;
import com.cleanroommc.multiblocked.client.util.TrackedDummyWorld;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ComponentWidget<T extends ComponentDefinition>
extends DialogWidget {
    protected final T definition;
    protected ResourceLocation location;
    protected final TabContainer tabContainer;
    protected final WidgetGroup S1;
    protected final WidgetGroup S2;
    protected final WidgetGroup S3;
    protected final WidgetGroup JSON;
    private final DraggableScrollableWidgetGroup tfGroup;
    private final DraggableScrollableWidgetGroup statusList;
    private final WidgetGroup statusSettings;
    private final TextBoxWidget textBox;
    private final Consumer<JsonObject> onSave;
    private boolean isPretty;

    public ComponentWidget(WidgetGroup group, T definition, Consumer<JsonObject> onSave) {
        super(group, true);
        this.setParentInVisible();
        this.onSave = onSave;
        this.definition = definition;
        this.location = ((ComponentDefinition)definition).location;
        this.addWidget(new ImageWidget(0, 0, 384, 256, new ResourceTexture("multiblocked:textures/gui/component.png")));
        this.tabContainer = new TabContainer(0, 0, 384, 256).setOnChanged(this::onTabChanged);
        this.addWidget(this.tabContainer);
        this.S1 = new WidgetGroup(0, 0, this.getSize().width, this.getSize().height);
        this.tabContainer.addTab(new TabButton(42, 26, 20, 20).setPressedTexture(new ResourceTexture("multiblocked:textures/gui/switch_common.png").getSubTexture(0.0, 0.5, 1.0, 0.5), new TextTexture("S1")).setBaseTexture(new ResourceTexture("multiblocked:textures/gui/switch_common.png").getSubTexture(0.0, 0.0, 1.0, 0.5), new TextTexture("S1")).setHoverTooltip("multiblocked.gui.widget.component.s1"), this.S1);
        int x = 47;
        this.S1.addWidget(new LabelWidget(x, 57, "multiblocked.gui.label.registry_name"));
        this.S1.addWidget(new TextFieldWidget(x + 80, 54, 150, 15, true, null, this::updateRegistryName).setCurrentString(this.location.toString()));
        if (definition instanceof ControllerDefinition) {
            this.S1.addWidget(GuiUtils.createSelector(x, 75, "rotateState", "multiblocked.gui.widget.component.rotate_state", ((ComponentDefinition)definition).properties.rotationState == CustomProperties.RotationState.NONE ? "NONE" : CustomProperties.RotationState.NON_Y_AXIS.name(), Stream.of(CustomProperties.RotationState.NONE, CustomProperties.RotationState.NON_Y_AXIS).map(Enum::name).collect(Collectors.toList()), r -> {
                definition.properties.rotationState = CustomProperties.RotationState.valueOf(r);
            }));
        } else {
            this.S1.addWidget(GuiUtils.createSelector(x, 75, "rotateState", "multiblocked.gui.widget.component.rotate_state", ((ComponentDefinition)definition).properties.rotationState.name(), Arrays.stream(CustomProperties.RotationState.values()).map(Enum::name).collect(Collectors.toList()), r -> {
                definition.properties.rotationState = CustomProperties.RotationState.valueOf(r);
            }));
        }
        this.S1.addWidget(GuiUtils.createBoolSwitch(x, 90, "showInJei", "multiblocked.gui.widget.component.jei", ((ComponentDefinition)definition).properties.showInJei, r -> {
            definition.properties.showInJei = r;
        }));
        this.S1.addWidget(GuiUtils.createBoolSwitch(x, 105, "isOpaqueCube", "multiblocked.gui.widget.component.opaque", ((ComponentDefinition)definition).properties.isOpaque, r -> {
            definition.properties.isOpaque = r;
        }));
        this.S1.addWidget(GuiUtils.createBoolSwitch(x, 120, "hasCollision", "multiblocked.gui.widget.component.collision", ((ComponentDefinition)definition).properties.hasCollision, r -> {
            definition.properties.hasCollision = r;
        }));
        this.S1.addWidget(GuiUtils.createFloatField(x, 135, "destroyTime", "multiblocked.gui.widget.component.destroy_time", ((ComponentDefinition)definition).properties.destroyTime, 0.0f, Float.MAX_VALUE, r -> {
            definition.properties.destroyTime = r.floatValue();
        }));
        this.S1.addWidget(GuiUtils.createFloatField(x, 150, "explosionResistance", "multiblocked.gui.widget.component.explosion_resistance", ((ComponentDefinition)definition).properties.explosionResistance, 0.0f, Float.MAX_VALUE, r -> {
            definition.properties.explosionResistance = r.floatValue();
        }));
        this.S1.addWidget(GuiUtils.createIntField(x, 165, "harvestLevel", "multiblocked.gui.widget.component.harvest", ((ComponentDefinition)definition).properties.harvestLevel, 0, Integer.MAX_VALUE, r -> {
            definition.properties.harvestLevel = r;
        }));
        this.S1.addWidget(GuiUtils.createIntField(x, 180, "stackSize", "multiblocked.gui.widget.component.stack_size", ((ComponentDefinition)definition).properties.stackSize, 1, 64, r -> {
            definition.properties.stackSize = r;
        }));
        this.S1.addWidget(GuiUtils.createStringField(x, 195, "tabGroup", "multiblocked.gui.widget.component.tab_group", ((ComponentDefinition)definition).properties.tabGroup, r -> {
            definition.properties.tabGroup = r;
        }));
        this.S2 = new WidgetGroup(0, 0, this.getSize().width, this.getSize().height);
        this.tabContainer.addTab(new TabButton(65, 26, 20, 20).setPressedTexture(new ResourceTexture("multiblocked:textures/gui/switch_common.png").getSubTexture(0.0, 0.5, 1.0, 0.5), new TextTexture("S2")).setBaseTexture(new ResourceTexture("multiblocked:textures/gui/switch_common.png").getSubTexture(0.0, 0.0, 1.0, 0.5), new TextTexture("S2")).setHoverTooltip("multiblocked.gui.widget.component.status"), this.S2);
        WidgetGroup statuesGroup = new WidgetGroup(20, 50, 150, 170);
        this.S2.addWidget(statuesGroup);
        this.S2.addWidget(new ImageWidget(170, 50, 168, 170, ResourceBorderTexture.BORDERED_BACKGROUND));
        this.statusSettings = new WidgetGroup(170, 50, 168, 170);
        this.S2.addWidget(this.statusSettings);
        statuesGroup.addWidget(new ImageWidget(20, 0, 130, 70, ResourceBorderTexture.BORDERED_BACKGROUND_BLUE));
        this.statusList = new DraggableScrollableWidgetGroup(20, 4, 130, 62);
        statuesGroup.addWidget(this.statusList);
        statuesGroup.addWidget(new ButtonWidget(0, 3, 20, 20, new ResourceTexture("multiblocked:textures/gui/add.png"), cd -> {
            int i = 1;
            while (definition.status.containsKey("new_status_" + i)) {
                ++i;
            }
            String name = "new_status_" + i;
            definition.status.put(name, new StatusProperties(name));
            this.updateStatusList();
        }).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.widget.component.status.create"));
        this.updateStatusList();
        this.S3 = new WidgetGroup(0, 0, this.getSize().width, this.getSize().height);
        this.tabContainer.addTab(new TabButton(88, 26, 20, 20).setPressedTexture(new ResourceTexture("multiblocked:textures/gui/switch_common.png").getSubTexture(0.0, 0.5, 1.0, 0.5), new TextTexture("S3")).setBaseTexture(new ResourceTexture("multiblocked:textures/gui/switch_common.png").getSubTexture(0.0, 0.0, 1.0, 0.5), new TextTexture("S3")).setHoverTooltip("multiblocked.gui.widget.component.s2"), this.S3);
        int y = 55;
        for (MultiblockCapability<?> capability : MbdCapabilities.getTraitCaps()) {
            WidgetGroup widgetGroup = new WidgetGroup(47, y, 100, 15);
            Runnable configurator = () -> {
                DialogWidget dialog = new DialogWidget(group, true);
                CapabilityTrait trait = capability.createTrait();
                trait.serialize(definition.traits.get(capability.name));
                int xOffset = 104;
                dialog.addWidget(new ImageWidget(0, 0, 384, 256, new ColorRectTexture(-1358954496)));
                ImageWidget imageWidget = new ImageWidget(xOffset, 0, 176, 256, null);
                dialog.addWidget(imageWidget);
                imageWidget.setImage(new ResourceTexture(JsonUtils.func_151219_a((JsonObject)definition.traits, (String)"background", (String)"multiblocked:textures/gui/custom_gui.png")));
                dialog.addWidget(new ButtonWidget(xOffset - 20, 10, 20, 20, new ResourceTexture("multiblocked:textures/gui/option.png"), cd2 -> new ResourceTextureWidget((WidgetGroup)dialog, texture -> {
                    if (texture != null) {
                        imageWidget.setImage((IGuiTexture)texture);
                    }
                })).setHoverTooltip("multiblocked.gui.widget.component.set_bg"));
                trait.openConfigurator(dialog);
                dialog.setOnClosed(() -> {
                    String background = ((ResourceTexture)imageWidget.getImage()).imageLocation.toString();
                    if (!background.equals("multiblocked:textures/gui/custom_gui.png")) {
                        definition.traits.addProperty("background", background);
                    }
                    definition.traits.add(capability.name, trait.deserialize());
                });
            };
            ButtonWidget buttonWidget = new ButtonWidget(20, 0, 15, 15, new ResourceTexture("multiblocked:textures/gui/option.png"), cd -> {
                if (definition.traits.has(capability.name)) {
                    configurator.run();
                }
            });
            buttonWidget.setVisible(((ComponentDefinition)definition).traits.has(capability.name));
            widgetGroup.addWidget(buttonWidget);
            widgetGroup.addWidget(new SwitchWidget(0, 0, 15, 15, (cd, r) -> {
                if (r.booleanValue()) {
                    configurator.run();
                } else {
                    definition.traits.remove(capability.name);
                }
                buttonWidget.setVisible((boolean)r);
            }).setBaseTexture(new ResourceTexture("multiblocked:textures/gui/boolean.png").getSubTexture(0.0, 0.0, 1.0, 0.5)).setPressedTexture(new ResourceTexture("multiblocked:textures/gui/boolean.png").getSubTexture(0.0, 0.5, 1.0, 0.5)).setHoverTexture(new ColorBorderTexture(1, -11249833)).setPressed(((ComponentDefinition)definition).traits.has(capability.name)).setHoverTooltip(capability.getUnlocalizedName()));
            widgetGroup.addWidget(new LabelWidget(40, 3, capability.getUnlocalizedName()));
            this.S3.addWidget(widgetGroup);
            y += 15;
        }
        this.JSON = new WidgetGroup(0, 0, this.getSize().width, this.getSize().height);
        this.tabContainer.addTab(new TabButton(235, 26, 20, 20).setPressedTexture(new ResourceTexture("multiblocked:textures/gui/switch_common.png").getSubTexture(0.0, 0.5, 1.0, 0.5), new TextTexture("J")).setBaseTexture(new ResourceTexture("multiblocked:textures/gui/switch_common.png").getSubTexture(0.0, 0.0, 1.0, 0.5), new TextTexture("F")).setHoverTooltip("multiblocked.gui.widget.component.f"), this.JSON);
        this.JSON.addWidget(new SwitchWidget(50, 54, 16, 16, (cd, r) -> {
            this.isPretty = r;
            this.updatePatternJson();
        }).setHoverBorderTexture(1, -1).setTexture(new ResourceTexture("multiblocked:textures/gui/pretty.png"), new ResourceTexture("multiblocked:textures/gui/pretty_active.png")).setHoverTooltip("multiblocked.gui.tips.pretty"));
        this.JSON.addWidget(new ButtonWidget(70, 54, 16, 16, cd -> GuiScreen.func_146275_d((String)(this.isPretty ? Multiblocked.prettyJson(this.getComponentJson()) : this.getComponentJson()))).setButtonTexture(new ResourceTexture("multiblocked:textures/gui/copy.png")).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.tips.copy"));
        this.JSON.addWidget(new ImageWidget(47, 75, 285, 136, new ColorBorderTexture(1, -1347440896)));
        this.tfGroup = new DraggableScrollableWidgetGroup(47, 75, 285, 136).setBackground(new ColorRectTexture(-1894706927)).setYScrollBarWidth(4).setYBarStyle(null, new ColorRectTexture(-1));
        this.JSON.addWidget(this.tfGroup);
        this.textBox = new TextBoxWidget(0, 0, 285, Collections.singletonList("")).setFontColor(-1).setShadow(true);
        this.tfGroup.addWidget(this.textBox);
        this.addWidget(new ButtonWidget(260, 26, 80, 20, null, cd -> {
            if (onSave != null) {
                onSave.accept(this.getJsonObj());
            }
            super.close();
        }).setButtonTexture(ResourceBorderTexture.BUTTON_COMMON, new TextTexture("multiblocked.gui.label.save_pattern", -1).setDropShadow(true)).setHoverBorderTexture(1, -1));
    }

    @Override
    public void close() {
        super.close();
        if (this.onSave != null) {
            this.onSave.accept(null);
        }
    }

    protected void onTabChanged(WidgetGroup oldTag, WidgetGroup newTag) {
        if (newTag == this.JSON) {
            this.updatePatternJson();
        }
    }

    protected JsonObject getJsonObj() {
        JsonObject jsonObject = ((ComponentDefinition)this.definition).toJson(new JsonObject());
        jsonObject.addProperty("location", this.location.toString());
        return jsonObject;
    }

    private String getComponentJson() {
        return Multiblocked.GSON.toJson((JsonElement)this.getJsonObj());
    }

    private void updatePatternJson() {
        this.textBox.setContent(Collections.singletonList(this.isPretty ? Multiblocked.prettyJson(this.getComponentJson()) : this.getComponentJson()));
        this.tfGroup.computeMax();
    }

    protected void updateStatusList() {
        this.statusList.clearAllWidgets();
        this.statusSettings.clearAllWidgets();
        for (StatusProperties status : ((ComponentDefinition)this.definition).status.values()) {
            SelectableWidgetGroup group = new SelectableWidgetGroup(5, 1 + this.statusList.widgets.size() * 22, this.statusList.getSize().width - 10, 20);
            group.setSelectedTexture(-2, -16733696).setOnSelected(W -> {
                this.statusSettings.clearAllWidgets();
                DraggableWidgetGroup panel = new DraggableWidgetGroup(0, 0, this.statusSettings.getSize().width, this.statusSettings.getSize().height);
                WidgetGroup scene = this.createScene(() -> status.renderer != null, status::getRenderer, status::getShape, status::setRenderer);
                this.statusSettings.addWidget(scene);
                this.statusSettings.addWidget(panel);
                panel.addWidget(new LabelWidget(4, 7, "multiblocked.gui.label.registry_name"));
                panel.addWidget(new LabelWidget(4, 24, "Parent:"));
                if (status.builtin) {
                    panel.addWidget(new LabelWidget(80, 7, status.getName()));
                    panel.addWidget(new LabelWidget(50, 24, status.getParent() == null ? "null" : status.getParent().getName()));
                } else {
                    ArrayList<String> candidates = new ArrayList<String>();
                    candidates.add("null");
                    candidates.addAll(((ComponentDefinition)this.definition).status.values().stream().filter(s -> s != status).map(StatusProperties::getName).collect(Collectors.toList()));
                    panel.addWidget(new TextFieldWidget(80, 4, 80, 15, true, null, s -> {
                        String lastName = status.getName();
                        status.setName((String)s);
                        ((ComponentDefinition)this.definition).status.remove(lastName);
                        ((ComponentDefinition)this.definition).status.put((String)s, status);
                    }).setCurrentString(status.getName()).setHoverTooltip("multiblocked.gui.widget.component.status.name"));
                    panel.addWidget(new SelectorWidget(50, 22, 110, 15, candidates, -1).setValue(status.getParent() == null ? "null" : status.getParent().getName()).setOnChanged(newParent -> status.setParent(((ComponentDefinition)this.definition).status.getOrDefault(newParent, null))).setButtonBackground(ResourceBorderTexture.BUTTON_COMMON).setBackground(new ColorRectTexture(-5592406)).setHoverTooltip("multiblocked.gui.widget.component.status.parent"));
                }
                panel.addWidget(this.createStatusBoolSwitch(4, 40, "renderer", "multiblocked.gui.widget.component.status.renderer", status.renderer != null, widgetGroup -> {
                    if (widgetGroup == null) {
                        status.renderer = null;
                    } else {
                        status.setRenderer(status.renderer == null ? null : status.getRenderer());
                    }
                }));
                panel.addWidget(this.createStatusBoolSwitch(4, 60, "lightEmissive", "multiblocked.gui.widget.component.status.light_emissive", status.lightEmissive != null, widgetGroup -> {
                    if (widgetGroup == null) {
                        status.lightEmissive = null;
                    } else {
                        status.setLightEmissive(status.lightEmissive == null ? 0 : status.getLightEmissive());
                        widgetGroup.addWidget(GuiUtils.createIntField(30, 0, "", "light level", status.getLightEmissive(), 0, 15, status::setLightEmissive));
                    }
                }));
                panel.addWidget(this.createStatusBoolSwitch(4, 80, "shape", "multiblocked.gui.widget.component.status.shape", status.shape != null, widgetGroup -> {
                    if (widgetGroup == null) {
                        status.shape = null;
                    } else {
                        status.setShape(status.shape == null ? Collections.singletonList(Block.field_185505_j) : status.getShape());
                        widgetGroup.addWidget(new ButtonWidget(20, 0, 15, 15, new ResourceTexture("multiblocked:textures/gui/option.png"), cd -> {
                            scene.setVisible(false);
                            new IShapeWidget(this, status.getRenderer(), status.getShape(), s -> {
                                status.setShape((List<AxisAlignedBB>)s);
                                scene.setVisible(true);
                            });
                        }).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.tips.settings"));
                    }
                }));
                panel.addWidget(this.createStatusBoolSwitch(4, 100, "sound", "multiblocked.gui.widget.component.status.sound", status.sound != null, widgetGroup -> {
                    if (widgetGroup == null) {
                        status.sound = null;
                    } else {
                        status.setSound(status.sound == null ? SoundState.EMPTY : status.getSound());
                        widgetGroup.addWidget(new ButtonWidget(20, 0, 15, 15, new ResourceTexture("multiblocked:textures/gui/option.png"), cd -> new ISoundWidget(this, status.getSound(), status::setSound)).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.tips.settings"));
                    }
                }));
            }).addWidget(new ImageWidget(0, 0, 120, 20, new ColorRectTexture(0x4FAAAAAA))).addWidget(new ImageWidget(2, 0, this.statusList.getSize().width - 14, 20, new TextTexture(status.getName()).setSupplier(status::getName).setWidth(this.statusList.getSize().width - 14).setType(TextTexture.TextType.ROLL)));
            if (!status.builtin) {
                group.addWidget(new ButtonWidget(104, 4, 12, 12, new ResourceTexture("multiblocked:textures/gui/remove.png"), cd -> {
                    ((ComponentDefinition)this.definition).status.remove(status.getName());
                    this.updateStatusList();
                }).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.tips.remove"));
            }
            this.statusList.addWidget(group);
        }
    }

    protected void updateRegistryName(String s) {
        this.location = s != null && !s.isEmpty() ? new ResourceLocation(s) : this.location;
    }

    protected WidgetGroup createStatusBoolSwitch(int x, int y, String text, String tips, boolean init, Consumer<WidgetGroup> onPressed) {
        WidgetGroup widgetGroup = new WidgetGroup(x, y, 100, 15);
        AtomicReference<WidgetGroup> group = new AtomicReference<WidgetGroup>();
        widgetGroup.addWidget(new SwitchWidget(0, 0, 15, 15, (cd, r) -> {
            if (r.booleanValue()) {
                group.set(new WidgetGroup(60, 0, 100, 100));
                widgetGroup.addWidget((Widget)group.get());
                onPressed.accept((WidgetGroup)group.get());
            } else {
                widgetGroup.removeWidget((Widget)group.get());
                onPressed.accept(null);
            }
        }).setBaseTexture(new ResourceTexture("multiblocked:textures/gui/boolean.png").getSubTexture(0.0, 0.0, 1.0, 0.5)).setPressedTexture(new ResourceTexture("multiblocked:textures/gui/boolean.png").getSubTexture(0.0, 0.5, 1.0, 0.5)).setHoverTexture(new ColorBorderTexture(1, -11249833)).setPressed(init).setHoverTooltip(tips));
        if (init) {
            group.set(new WidgetGroup(60, 0, 100, 100));
            widgetGroup.addWidget((Widget)group.get());
            onPressed.accept((WidgetGroup)group.get());
        }
        widgetGroup.addWidget(new LabelWidget(20, 3, text));
        return widgetGroup;
    }

    @SideOnly(value=Side.CLIENT)
    protected WidgetGroup createScene(final Supplier<Boolean> custom, final Supplier<IRenderer> init, final Supplier<List<AxisAlignedBB>> shape, Consumer<IRenderer> onUpdate) {
        int width = 90;
        int height = 90;
        TrackedDummyWorld world = new TrackedDummyWorld();
        world.addBlock(BlockPos.field_177992_a, BlockInfo.fromBlockState(MbdComponents.DummyComponentBlock.func_176223_P()));
        final DummyComponentTileEntity tileEntity = (DummyComponentTileEntity)world.func_175625_s(BlockPos.field_177992_a);
        tileEntity.setDefinition(new PartDefinition(new ResourceLocation("multiblocked", "component_widget")));
        ((ComponentDefinition)tileEntity.getDefinition()).getBaseStatus().setRenderer(init.get());
        final ButtonWidget buttonWidget = (ButtonWidget)new ButtonWidget(73, 2, 15, 15, new ResourceTexture("multiblocked:textures/gui/option.png"), null).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.tips.settings");
        buttonWidget.setVisible(custom.get());
        WidgetGroup widgetGroup = new WidgetGroup(-110, 75, 90, 90){

            @Override
            public void updateScreen() {
                super.updateScreen();
                IRenderer currentRenderer = tileEntity.getRenderer();
                IRenderer newRenderer = (IRenderer)init.get();
                if (currentRenderer != newRenderer) {
                    ((ComponentDefinition)tileEntity.getDefinition()).getBaseStatus().setRenderer(newRenderer);
                }
                buttonWidget.setVisible((Boolean)custom.get());
            }
        };
        buttonWidget.setOnPressCallback(cd -> {
            widgetGroup.setVisible(false);
            new IRendererWidget(this, tileEntity.getRenderer(), r -> {
                widgetGroup.setVisible(true);
                ((ComponentDefinition)tileEntity.getDefinition()).getBaseStatus().setRenderer((IRenderer)r);
                onUpdate.accept((IRenderer)r);
            });
        });
        widgetGroup.addWidget(new ImageWidget(0, 0, 90, 90, new ColorBorderTexture(2, -11894025)));
        widgetGroup.addWidget(new SceneWidget(0, 0, 90, 90, world){

            @Override
            @SideOnly(value=Side.CLIENT)
            public void renderBlockOverLay(WorldSceneRenderer renderer) {
                super.renderBlockOverLay(renderer);
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)770, (int)771);
                Tessellator tessellator = Tessellator.func_178181_a();
                GlStateManager.func_179090_x();
                BufferBuilder buffer = tessellator.func_178180_c();
                buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
                GlStateManager.func_187441_d((float)2.0f);
                for (AxisAlignedBB aabb : (List)shape.get()) {
                    RenderBufferUtils.renderCubeFrame(buffer, aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f, 0.0f, 0.0f, 0.0f, 1.0f);
                }
                tessellator.func_78381_a();
            }
        }.setRenderedCore(Collections.singleton(BlockPos.field_177992_a), null).setRenderSelect(false).setRenderFacing(false));
        widgetGroup.addWidget(buttonWidget);
        return widgetGroup;
    }
}

