/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp.blueprint_table;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.definition.ComponentDefinition;
import com.cleanroommc.multiblocked.api.definition.PartDefinition;
import com.cleanroommc.multiblocked.api.gui.texture.ColorBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ColorRectTexture;
import com.cleanroommc.multiblocked.api.gui.texture.GuiTextureGroup;
import com.cleanroommc.multiblocked.api.gui.texture.ItemStackTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceTexture;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.util.ClickData;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ButtonWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableScrollableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ImageWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.LabelWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SceneWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SelectableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.blueprint_table.dialogs.JsonBlockPatternWidget;
import com.cleanroommc.multiblocked.api.item.ItemBlueprint;
import com.cleanroommc.multiblocked.api.pattern.JsonBlockPattern;
import com.cleanroommc.multiblocked.api.pattern.predicates.PredicateComponent;
import com.cleanroommc.multiblocked.api.pattern.predicates.SimplePredicate;
import com.cleanroommc.multiblocked.api.pattern.util.BlockInfo;
import com.cleanroommc.multiblocked.api.registry.MbdComponents;
import com.cleanroommc.multiblocked.api.registry.MbdItems;
import com.cleanroommc.multiblocked.api.tile.BlueprintTableTileEntity;
import com.cleanroommc.multiblocked.api.tile.ComponentTileEntity;
import com.cleanroommc.multiblocked.api.tile.ControllerTileEntity;
import com.cleanroommc.multiblocked.api.tile.DummyComponentTileEntity;
import com.cleanroommc.multiblocked.client.renderer.impl.BlockStateRenderer;
import com.cleanroommc.multiblocked.client.renderer.impl.CycleBlockStateRenderer;
import com.cleanroommc.multiblocked.client.util.TrackedDummyWorld;
import com.cleanroommc.multiblocked.util.LocalizationUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TemplateBuilderWidget
extends WidgetGroup {
    public final BlueprintTableTileEntity table;
    public final ButtonWidget templateButton;
    public SceneWidget sceneWidget;
    public ItemStack selected;
    public int selectedSlot;
    public BlockPos pos;
    public EnumFacing facing;
    protected DraggableScrollableWidgetGroup containers;
    private boolean init;

    public TemplateBuilderWidget(BlueprintTableTileEntity table) {
        super(0, 0, 384, 256);
        this.table = table;
        this.addWidget(0, new ImageWidget(0, 0, this.getSize().width, this.getSize().height, new ResourceTexture("multiblocked:textures/gui/blueprint_page.png")));
        this.addWidget(new ImageWidget(30, 34, 160, 180, new GuiTextureGroup(new ColorBorderTexture(3, -1), new ColorRectTexture(-1354480572))));
        this.addWidget(new LabelWidget(200, 34, this::status).setTextColor(-1).setDrop(true));
        this.addWidget(new LabelWidget(200, 49, this::size).setTextColor(-1).setDrop(true));
        this.addWidget(new LabelWidget(200, 64, this::description).setTextColor(-1).setDrop(true));
        this.templateButton = new ButtonWidget(200, 100, 20, 20, new ItemStackTexture(MbdItems.BUILDER), this::onBuildTemplate);
        this.addWidget(this.templateButton);
        this.sceneWidget = (SceneWidget)new SceneWidget(30, 34, 160, 180, null).useCacheBuffer().setOnSelected((pos, facing) -> {
            this.pos = pos;
            this.facing = facing;
        }).setRenderSelect(false).setRenderFacing(false).setClientSideWidget();
        this.addWidget(this.sceneWidget);
        this.addWidget(new ImageWidget(196, 116, 158, 106, ResourceBorderTexture.BORDERED_BACKGROUND_BLUE));
        this.templateButton.setHoverTooltip("multiblocked.gui.builder.template.create");
        this.templateButton.setVisible(false);
    }

    protected void onBuildTemplate(ClickData clickData) {
        if (this.isRemote() && ItemBlueprint.isItemBlueprint(this.selected)) {
            JsonBlockPattern pattern = null;
            if (ItemBlueprint.isRaw(this.selected)) {
                BlockPos[] poses = ItemBlueprint.getPos(this.selected);
                World world = this.table.func_145831_w();
                if (poses != null && world.func_175707_a(poses[0], poses[1])) {
                    ComponentTileEntity controller = null;
                    for (int x = poses[0].func_177958_n(); x <= poses[1].func_177958_n(); ++x) {
                        for (int y = poses[0].func_177956_o(); y <= poses[1].func_177956_o(); ++y) {
                            for (int z = poses[0].func_177952_p(); z <= poses[1].func_177952_p(); ++z) {
                                TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
                                if (!(te instanceof ControllerTileEntity)) continue;
                                controller = (ControllerTileEntity)te;
                            }
                        }
                    }
                    if (controller != null) {
                        pattern = new JsonBlockPattern(this.table.func_145831_w(), controller.getLocation(), controller.func_174877_v(), controller.getFrontFacing(), poses[0].func_177958_n(), poses[0].func_177956_o(), poses[0].func_177952_p(), poses[1].func_177958_n(), poses[1].func_177956_o(), poses[1].func_177952_p());
                    }
                }
            } else if (this.selected.func_179543_a("pattern") != null) {
                String json = this.selected.func_179543_a("pattern").func_74779_i("json");
                pattern = (JsonBlockPattern)Multiblocked.GSON.fromJson(json, JsonBlockPattern.class);
            }
            if (pattern != null) {
                new JsonBlockPatternWidget(this, pattern, patternResult -> {
                    if (patternResult != null && ItemBlueprint.setPattern(this.selected) && patternResult.predicates.get("controller") instanceof PredicateComponent) {
                        patternResult.cleanUp();
                        String json = patternResult.toJson();
                        String controller = ((PredicateComponent)patternResult.predicates.get((Object)"controller")).location.toString();
                        this.selected.func_190925_c("pattern").func_74778_a("json", json);
                        this.selected.func_190925_c("pattern").func_74778_a("controller", controller);
                        this.writeClientAction(-1, buffer -> {
                            buffer.func_150787_b(this.selectedSlot);
                            buffer.func_180714_a(json);
                            buffer.func_180714_a(controller);
                        });
                    }
                });
            }
        }
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (this.init) {
            return;
        }
        this.init = true;
        this.writeUpdateInfo(-1, this::writeInitialData);
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        if (id == -1) {
            this.readInitialData(buffer);
        } else {
            super.readUpdateInfo(id, buffer);
        }
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        if (id == -1) {
            ItemStack itemStack;
            IItemHandler handler;
            int slotIndex = buffer.func_150792_a();
            String json = buffer.func_150789_c(Short.MAX_VALUE);
            String controller = buffer.func_150789_c(Short.MAX_VALUE);
            TileEntity tileEntity = this.table.func_145831_w().func_175625_s(this.table.func_174877_v().func_177972_a(EnumFacing.UP).func_177972_a(this.table.getFrontFacing().func_176734_d()).func_177972_a(this.table.getFrontFacing().func_176746_e()));
            if (tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && (handler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null && handler.getSlots() > slotIndex && ItemBlueprint.isItemBlueprint(itemStack = handler.getStackInSlot(slotIndex))) {
                ItemBlueprint.setPattern(itemStack);
                itemStack.func_190925_c("pattern").func_74778_a("json", json);
                itemStack.func_190925_c("pattern").func_74778_a("controller", controller);
            }
        } else {
            super.handleClientAction(id, buffer);
        }
    }

    @Override
    public void writeInitialData(PacketBuffer buffer) {
        IItemHandler handler;
        super.writeInitialData(buffer);
        TileEntity tileEntity = this.table.func_145831_w().func_175625_s(this.table.func_174877_v().func_177972_a(EnumFacing.UP).func_177972_a(this.table.getFrontFacing().func_176734_d()).func_177972_a(this.table.getFrontFacing().func_176746_e()));
        Int2ObjectOpenHashMap caught = new Int2ObjectOpenHashMap();
        if (tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && (handler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack itemStack = handler.getStackInSlot(i);
                if (!ItemBlueprint.isItemBlueprint(itemStack)) continue;
                caught.put(i, itemStack);
            }
        }
        buffer.func_150787_b(caught.size());
        caught.forEach((k, v) -> {
            buffer.func_150788_a(v);
            buffer.func_150787_b(k.intValue());
        });
    }

    @Override
    public void readInitialData(PacketBuffer buffer) {
        super.readInitialData(buffer);
        this.containers = new DraggableScrollableWidgetGroup(200, 120, 150, 98);
        this.addWidget(this.containers);
        this.containers.setClientSideWidget();
        try {
            for (int i = buffer.func_150792_a(); i > 0; --i) {
                ItemStack itemStack = buffer.func_150791_c();
                int slotIndex = buffer.func_150792_a();
                this.containers.addWidget(new SelectableWidgetGroup(0, this.containers.widgets.size() * 22, this.containers.getSize().width, 20).setSelectedTexture(-2, -16733696).setOnSelected(w -> this.onSelected(itemStack, slotIndex)).addWidget(new ImageWidget(0, 0, 150, 20, new ColorRectTexture(0x4FAAAAAA))).addWidget(new ImageWidget(32, 0, 100, 20, new TextTexture(itemStack.func_82833_r()).setWidth(100).setType(TextTexture.TextType.ROLL))).addWidget(new ImageWidget(4, 2, 18, 18, new ItemStackTexture(itemStack))));
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    private String size() {
        BlockPos[] poses;
        String result = LocalizationUtils.format("multiblocked.gui.builder.template.size", new Object[0]);
        if (this.selected != null && (poses = ItemBlueprint.getPos(this.selected)) != null) {
            result = result + String.format("(%dX%dX%d)", poses[1].func_177958_n() - poses[0].func_177958_n() + 1, poses[1].func_177956_o() - poses[0].func_177956_o() + 1, poses[1].func_177952_p() - poses[0].func_177952_p() + 1);
        }
        return result;
    }

    private String description() {
        BlockPos[] poses;
        String result = LocalizationUtils.format("multiblocked.gui.builder.template.description", new Object[0]) + "\n";
        if (this.selected != null && (poses = ItemBlueprint.getPos(this.selected)) != null) {
            result = result + LocalizationUtils.format("multiblocked.gui.builder.template.from", poses[0].func_177958_n(), poses[0].func_177956_o(), poses[0].func_177952_p()) + "\n";
            result = result + LocalizationUtils.format("multiblocked.gui.builder.template.to", poses[0].func_177958_n(), poses[0].func_177956_o(), poses[0].func_177952_p());
        }
        return result;
    }

    private String status() {
        return LocalizationUtils.format("multiblocked.gui.builder.template.status", new Object[0]) + " " + (this.selected == null ? "" : (ItemBlueprint.isRaw(this.selected) ? TextFormatting.YELLOW + LocalizationUtils.format("multiblocked.gui.builder.template.raw", new Object[0]) : TextFormatting.GREEN + LocalizationUtils.format("multiblocked.gui.builder.template.pattern", new Object[0])));
    }

    @SideOnly(value=Side.CLIENT)
    public void onSelected(ItemStack itemStack, int slot) {
        if (this.selected != itemStack) {
            this.selected = itemStack;
            this.selectedSlot = slot;
            if (this.selected != null && this.isRemote()) {
                this.pos = null;
                this.facing = null;
                this.templateButton.setVisible(true);
                if (ItemBlueprint.isRaw(itemStack)) {
                    BlockPos[] poses = ItemBlueprint.getPos(itemStack);
                    World world = this.table.func_145831_w();
                    this.sceneWidget.createScene(world);
                    if (poses != null && world.func_175707_a(poses[0], poses[1])) {
                        HashSet<BlockPos> rendered = new HashSet<BlockPos>();
                        for (int x = poses[0].func_177958_n(); x <= poses[1].func_177958_n(); ++x) {
                            for (int y = poses[0].func_177956_o(); y <= poses[1].func_177956_o(); ++y) {
                                for (int z = poses[0].func_177952_p(); z <= poses[1].func_177952_p(); ++z) {
                                    if (world.func_175623_d(new BlockPos(x, y, z))) continue;
                                    rendered.add(new BlockPos(x, y, z));
                                }
                            }
                        }
                        this.sceneWidget.setRenderedCore(rendered, null);
                    }
                } else if (itemStack.func_179543_a("pattern") != null) {
                    String json = itemStack.func_179543_a("pattern").func_74779_i("json");
                    JsonBlockPattern pattern = (JsonBlockPattern)Multiblocked.GSON.fromJson(json, JsonBlockPattern.class);
                    int[] centerOffset = pattern.getCenterOffset();
                    String[][] patternString = pattern.pattern;
                    HashSet<BlockPos> rendered = new HashSet<BlockPos>();
                    TrackedDummyWorld world = new TrackedDummyWorld();
                    this.sceneWidget.createScene(world);
                    int offset = Math.max(patternString.length, Math.max(patternString[0].length, patternString[0][0].length()));
                    for (int i = 0; i < patternString.length; ++i) {
                        for (int j = 0; j < patternString[0].length; ++j) {
                            for (int k = 0; k < patternString[0][0].length(); ++k) {
                                char symbol = patternString[i][j].charAt(k);
                                BlockPos pos = pattern.getActualPosOffset(k - centerOffset[2], j - centerOffset[1], i - centerOffset[0], EnumFacing.NORTH).func_177982_a(offset, offset, offset);
                                world.addBlock(pos, new BlockInfo(MbdComponents.DummyComponentBlock));
                                DummyComponentTileEntity tileEntity = (DummyComponentTileEntity)world.func_175625_s(pos);
                                ComponentDefinition definition = null;
                                assert (tileEntity != null);
                                if (pattern.symbolMap.containsKey(Character.valueOf(symbol))) {
                                    HashSet<BlockInfo> candidates = new HashSet<BlockInfo>();
                                    for (String s : pattern.symbolMap.get(Character.valueOf(symbol))) {
                                        SimplePredicate predicate = pattern.predicates.get(s);
                                        if (predicate instanceof PredicateComponent && ((PredicateComponent)predicate).definition != null) {
                                            definition = ((PredicateComponent)predicate).definition;
                                            break;
                                        }
                                        if (predicate == null || predicate.candidates == null) continue;
                                        candidates.addAll(Arrays.asList((Object[])predicate.candidates.get()));
                                    }
                                    definition = TemplateBuilderWidget.getComponentDefinition(definition, candidates);
                                }
                                if (definition != null) {
                                    tileEntity.setDefinition(definition);
                                }
                                tileEntity.isFormed = false;
                                tileEntity.func_145834_a(world);
                                tileEntity.func_145829_t();
                                rendered.add(pos);
                            }
                        }
                    }
                    this.sceneWidget.setRenderedCore(rendered, null);
                }
            }
        }
    }

    public static ComponentDefinition getComponentDefinition(ComponentDefinition definition, Set<BlockInfo> candidates) {
        if (candidates.size() == 1) {
            definition = new PartDefinition(new ResourceLocation("multiblocked", "i_renderer"));
            definition.getBaseStatus().setRenderer(new BlockStateRenderer(candidates.toArray(new BlockInfo[0])[0]));
        } else if (!candidates.isEmpty()) {
            definition = new PartDefinition(new ResourceLocation("multiblocked", "i_renderer"));
            definition.getBaseStatus().setRenderer(new CycleBlockStateRenderer(candidates.toArray(new BlockInfo[0])));
        }
        return definition;
    }
}

