/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp.blueprint_table;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.definition.ControllerDefinition;
import com.cleanroommc.multiblocked.api.gui.texture.ColorRectTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ItemStackTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceTexture;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.util.ClickData;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ButtonWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ImageWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SelectableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.blueprint_table.TemplateBuilderWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.blueprint_table.components.ControllerWidget;
import com.cleanroommc.multiblocked.api.item.ItemBlueprint;
import com.cleanroommc.multiblocked.api.pattern.JsonBlockPattern;
import com.cleanroommc.multiblocked.api.pattern.predicates.PredicateComponent;
import com.cleanroommc.multiblocked.api.pattern.predicates.SimplePredicate;
import com.cleanroommc.multiblocked.api.pattern.util.BlockInfo;
import com.cleanroommc.multiblocked.api.registry.MbdComponents;
import com.cleanroommc.multiblocked.api.tile.BlueprintTableTileEntity;
import com.cleanroommc.multiblocked.api.tile.DummyComponentTileEntity;
import com.cleanroommc.multiblocked.client.renderer.impl.BlockStateRenderer;
import com.cleanroommc.multiblocked.client.util.TrackedDummyWorld;
import com.cleanroommc.multiblocked.util.FileUtility;
import com.google.common.util.concurrent.AtomicDouble;
import com.google.gson.JsonElement;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ControllerBuilderWidget
extends TemplateBuilderWidget {
    List<SelectableWidgetGroup> files = new ArrayList<SelectableWidgetGroup>();
    @SideOnly(value=Side.CLIENT)
    Thread thread;

    public ControllerBuilderWidget(BlueprintTableTileEntity table) {
        super(table);
        this.templateButton.setHoverTooltip("multiblocked.gui.builder.controller.create");
        this.addWidget(new ButtonWidget(330, 96, 20, 20, new ResourceTexture("multiblocked:textures/gui/save.png"), cd -> {
            if (cd.isRemote) {
                try {
                    File dir = new File(Multiblocked.location, "definition/controller");
                    Desktop.getDesktop().open(dir.isDirectory() ? dir : dir.getParentFile());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.tips.open_folder"));
    }

    @Override
    protected void onBuildTemplate(ClickData clickData) {
        BlockPos[] poses;
        if (clickData.isRemote && this.pos != null && this.facing != null && this.selected != null && this.facing.func_176740_k() != EnumFacing.Axis.Y && (poses = ItemBlueprint.getPos(this.selected)) != null) {
            World world = this.table.func_145831_w();
            ResourceLocation location = new ResourceLocation("mod_id:component_id");
            ControllerDefinition controllerDefinition = new ControllerDefinition(location);
            controllerDefinition.getBaseStatus().setRenderer(new BlockStateRenderer(world.func_180495_p(this.pos)));
            new ControllerWidget(this, controllerDefinition, new JsonBlockPattern(world, location, this.pos, this.facing, poses[0].func_177958_n(), poses[0].func_177956_o(), poses[0].func_177952_p(), poses[1].func_177958_n(), poses[1].func_177956_o(), poses[1].func_177952_p()), "empty", jsonObject -> {
                if (jsonObject != null) {
                    FileUtility.saveJson(new File(Multiblocked.location, "definition/controller/" + jsonObject.get("location").getAsString().replace(":", "_") + ".json"), (JsonElement)jsonObject);
                    this.updateList();
                }
            });
        }
    }

    @Override
    public void writeInitialData(PacketBuffer buffer) {
        IItemHandler handler;
        TileEntity tileEntity = this.table.func_145831_w().func_175625_s(this.table.func_174877_v().func_177972_a(EnumFacing.UP).func_177972_a(this.table.getFrontFacing().func_176734_d()).func_177972_a(this.table.getFrontFacing().func_176746_e()));
        Int2ObjectOpenHashMap caught = new Int2ObjectOpenHashMap();
        if (tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && (handler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack itemStack = handler.getStackInSlot(i);
                if (!ItemBlueprint.isItemBlueprint(itemStack) || !ItemBlueprint.isRaw(itemStack)) continue;
                caught.put(i, itemStack);
            }
        }
        buffer.func_150787_b(caught.size());
        caught.forEach((k, v) -> {
            buffer.func_150788_a(v);
            buffer.func_150787_b(k.intValue());
        });
    }

    protected void updateList() {
        int size = this.files.size();
        this.files.forEach(this.containers::waitToRemoved);
        this.files.clear();
        File path = new File(Multiblocked.location, "definition/controller");
        if (!path.isDirectory() && !path.mkdirs()) {
            return;
        }
        for (File file : Optional.ofNullable(path.listFiles((s, name) -> name.endsWith(".json"))).orElse(new File[0])) {
            SelectableWidgetGroup widgetGroup = (SelectableWidgetGroup)new SelectableWidgetGroup(0, (this.containers.widgets.size() - size) * 22, this.containers.getSize().width, 20).setSelectedTexture(-2, -16733696).setOnSelected(W -> {
                this.templateButton.setVisible(false);
                this.selected = null;
                this.onJsonSelected(file);
            }).addWidget(new ImageWidget(0, 0, 150, 20, new ColorRectTexture(0x4FAAAAAA))).addWidget(new ButtonWidget(134, 4, 12, 12, new ResourceTexture("multiblocked:textures/gui/option.png"), cd -> {
                JsonElement jsonElement = FileUtility.loadJson(file);
                if (jsonElement != null) {
                    try {
                        String recipeMap = jsonElement.getAsJsonObject().get("recipeMap").getAsString();
                        JsonBlockPattern pattern = (JsonBlockPattern)Multiblocked.GSON.fromJson(jsonElement.getAsJsonObject().get("basePattern"), JsonBlockPattern.class);
                        ControllerDefinition definition = new ControllerDefinition(new ResourceLocation(jsonElement.getAsJsonObject().get("location").getAsString()));
                        definition.fromJson(jsonElement.getAsJsonObject());
                        new ControllerWidget(this, definition, pattern, recipeMap, jsonObject -> {
                            if (jsonObject != null) {
                                FileUtility.saveJson(file, (JsonElement)jsonObject);
                            }
                        });
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.tips.settings")).addWidget(new ImageWidget(32, 0, 100, 20, new TextTexture(file.getName().replace(".json", "")).setWidth(100).setType(TextTexture.TextType.ROLL))).addWidget(new ImageWidget(4, 2, 18, 18, new ItemStackTexture(Items.field_151121_aF)));
            this.files.add(widgetGroup);
            this.containers.addWidget(widgetGroup);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onJsonSelected(File file) {
        JsonElement jsonElement = FileUtility.loadJson(file);
        if (jsonElement != null) {
            JsonBlockPattern pattern = (JsonBlockPattern)Multiblocked.GSON.fromJson(jsonElement.getAsJsonObject().get("basePattern"), JsonBlockPattern.class);
            this.updateScene(pattern);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateScene(JsonBlockPattern jsonPattern) {
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
        TrackedDummyWorld world = new TrackedDummyWorld();
        this.sceneWidget.createScene(world);
        ImageWidget imageWidget = new ImageWidget(0, 0, this.sceneWidget.getSize().width, this.sceneWidget.getSize().height);
        this.sceneWidget.addWidget(imageWidget);
        imageWidget.setVisible(jsonPattern.pattern.length * jsonPattern.pattern[0].length * jsonPattern.pattern[0][0].length() > 1000);
        this.thread = new Thread(() -> {
            int[] centerOffset = jsonPattern.getCenterOffset();
            String[][] pattern = jsonPattern.pattern;
            HashSet<BlockPos> posSet = new HashSet<BlockPos>();
            int offset = Math.max(pattern.length, Math.max(pattern[0].length, pattern[0][0].length()));
            int sum = jsonPattern.pattern.length * jsonPattern.pattern[0].length * jsonPattern.pattern[0][0].length();
            AtomicDouble progress = new AtomicDouble(0.0);
            imageWidget.setImage(new TextTexture("multiblocked.gui.tips.building_scene").setSupplier(() -> I18n.func_135052_a((String)"multiblocked.gui.tips.building_scene", (Object[])new Object[0]) + String.format(" %.1f", progress.get()) + "%%").setWidth(this.sceneWidget.getSize().width));
            int count = 0;
            for (int i = 0; i < pattern.length; ++i) {
                for (int j = 0; j < pattern[0].length; ++j) {
                    for (int k = 0; k < pattern[0][0].length(); ++k) {
                        if (Thread.interrupted()) {
                            this.sceneWidget.waitToRemoved(imageWidget);
                            return;
                        }
                        progress.set((double)(++count) * 100.0 / (double)sum);
                        char symbol = pattern[i][j].charAt(k);
                        BlockPos pos = jsonPattern.getActualPosOffset(k - centerOffset[2], j - centerOffset[1], i - centerOffset[0], EnumFacing.NORTH).func_177982_a(offset, offset, offset);
                        if (!jsonPattern.symbolMap.containsKey(Character.valueOf(symbol))) continue;
                        ArrayList<Object> candidates = new ArrayList<Object>();
                        for (String s : jsonPattern.symbolMap.get(Character.valueOf(symbol))) {
                            SimplePredicate predicate = jsonPattern.predicates.get(s);
                            if (predicate instanceof PredicateComponent && ((PredicateComponent)predicate).definition != null) {
                                world.addBlock(pos, new BlockInfo(MbdComponents.DummyComponentBlock));
                                DummyComponentTileEntity tileEntity = (DummyComponentTileEntity)world.func_175625_s(pos);
                                assert (tileEntity != null);
                                tileEntity.setDefinition(((PredicateComponent)predicate).definition);
                                tileEntity.isFormed = false;
                                tileEntity.func_145834_a(world);
                                tileEntity.func_145829_t();
                                posSet.add(pos);
                                break;
                            }
                            if (predicate == null || predicate.candidates == null) continue;
                            candidates.addAll(Arrays.asList((Object[])predicate.candidates.get()));
                        }
                        if (candidates.size() <= 0) continue;
                        world.addBlock(pos, (BlockInfo)candidates.get(0));
                        posSet.add(pos);
                    }
                }
            }
            Minecraft.func_71410_x().func_152344_a(() -> {
                this.sceneWidget.setRenderedCore(posSet, null);
                this.sceneWidget.waitToRemoved(imageWidget);
            });
            this.thread = null;
        });
        this.thread.start();
    }

    @Override
    public void readInitialData(PacketBuffer buffer) {
        super.readInitialData(buffer);
        this.updateList();
    }

    @Override
    public void onSelected(ItemStack selected, int slot) {
        super.onSelected(selected, slot);
        if (this.sceneWidget != null) {
            this.sceneWidget.setRenderFacing(true);
            this.sceneWidget.setRenderSelect(true);
        }
    }
}

