/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp;

import com.cleanroommc.multiblocked.api.gui.texture.IGuiTexture;
import com.cleanroommc.multiblocked.api.gui.util.DrawerHelper;
import com.cleanroommc.multiblocked.api.gui.util.TreeNode;
import com.cleanroommc.multiblocked.api.gui.widget.Widget;
import com.cleanroommc.multiblocked.client.util.RenderUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;

public class TreeListWidget<K, T>
extends Widget {
    private static final int ITEM_HEIGHT = 11;
    protected int scrollOffset;
    protected List<TreeNode<K, T>> list = new ArrayList<TreeNode<K, T>>();
    protected TreeNode<K, T> selected;
    protected IGuiTexture background;
    protected IGuiTexture nodeTexture;
    protected IGuiTexture leafTexture;
    protected Consumer<TreeNode<K, T>> onSelected;
    protected Function<K, IGuiTexture> keyIconSupplier;
    protected Function<K, String> keyNameSupplier;
    protected Function<T, IGuiTexture> contentIconSupplier;
    protected Function<T, String> contentNameSupplier;
    protected boolean canSelectNode;
    private int tick;

    public TreeListWidget(int xPosition, int yPosition, int width, int height, TreeNode<K, T> root, Consumer<TreeNode<K, T>> onSelected) {
        super(xPosition, yPosition, width, height);
        if (root.getChildren() != null) {
            this.list.addAll(root.getChildren());
        }
        this.onSelected = onSelected;
    }

    public TreeListWidget<K, T> canSelectNode(boolean canSelectNode) {
        this.canSelectNode = canSelectNode;
        return this;
    }

    public TreeListWidget<K, T> setBackground(IGuiTexture background) {
        this.background = background;
        return this;
    }

    public TreeListWidget<K, T> setNodeTexture(IGuiTexture nodeTexture) {
        this.nodeTexture = nodeTexture;
        return this;
    }

    public TreeListWidget<K, T> setLeafTexture(IGuiTexture leafTexture) {
        this.leafTexture = leafTexture;
        return this;
    }

    public TreeListWidget<K, T> setContentIconSupplier(Function<T, IGuiTexture> iconSupplier) {
        this.contentIconSupplier = iconSupplier;
        return this;
    }

    public TreeListWidget<K, T> setKeyIconSupplier(Function<K, IGuiTexture> iconSupplier) {
        this.keyIconSupplier = iconSupplier;
        return this;
    }

    public TreeListWidget<K, T> setContentNameSupplier(Function<T, String> nameSupplier) {
        this.contentNameSupplier = nameSupplier;
        return this;
    }

    public TreeListWidget<K, T> setKeyNameSupplier(Function<K, String> nameSupplier) {
        this.keyNameSupplier = nameSupplier;
        return this;
    }

    @Override
    public void updateScreen() {
        ++this.tick;
    }

    @Override
    public Widget mouseWheelMove(int mouseX, int mouseY, int wheelDelta) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            int moveDelta = -MathHelper.func_76125_a((int)wheelDelta, (int)-1, (int)1) * 5;
            this.scrollOffset = MathHelper.func_76125_a((int)(this.scrollOffset + moveDelta), (int)0, (int)Math.max(this.list.size() * 11 - this.getSize().height, 0));
            return this;
        }
        return null;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks) {
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        int width = this.getSize().width;
        int height = this.getSize().height;
        if (this.background != null) {
            this.background.draw(x, y, width, height);
        } else {
            DrawerHelper.drawGradientRect(x, y, width, height, -1895825408, -1895825408);
        }
        RenderUtils.useScissor(x, y, width, height, () -> {
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            int minToRender = this.scrollOffset / 11;
            int maxToRender = Math.min(this.list.size(), height / 11 + 2 + minToRender);
            for (int i = minToRender; i < maxToRender; ++i) {
                IGuiTexture icon;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                TreeNode<K, T> node = this.list.get(i);
                int sX = x + 10 * node.dimension;
                int sY = y - this.scrollOffset + i * 11;
                String name = node.toString();
                if (node.isLeaf()) {
                    if (this.leafTexture != null) {
                        this.leafTexture.draw(x, sY, width, 11);
                    } else {
                        DrawerHelper.drawSolidRect(x, sY, width, 11, -65536);
                    }
                    if (node.getContent() != null) {
                        String nameS = this.contentNameSupplier == null ? null : this.contentNameSupplier.apply(node.getContent());
                        name = nameS == null ? name : nameS;
                        IGuiTexture iGuiTexture = icon = this.contentIconSupplier == null ? null : this.contentIconSupplier.apply(node.getContent());
                        if (icon != null) {
                            icon.draw(sX - 9, sY + 1, 8, 8);
                        }
                    }
                } else {
                    if (this.nodeTexture != null) {
                        this.nodeTexture.draw(x, sY, width, 11);
                    } else {
                        DrawerHelper.drawSolidRect(x, sY, width, 11, -256);
                    }
                    String nameS = this.keyNameSupplier == null ? null : this.keyNameSupplier.apply(node.getKey());
                    name = nameS == null ? name : nameS;
                    IGuiTexture iGuiTexture = icon = this.keyIconSupplier == null ? null : this.keyIconSupplier.apply(node.getKey());
                    if (icon != null) {
                        icon.draw(sX - 9, sY + 1, 8, 8);
                    }
                }
                if (node == this.selected) {
                    DrawerHelper.drawSolidRect(x, sY, width, 11, 0x7F000000);
                }
                int textW = Math.max(width - 10 * node.dimension, 10);
                List list = fr.func_78271_c(I18n.func_135052_a((String)name, (Object[])new Object[0]), textW);
                fr.func_78276_b((String)list.get(Math.abs(this.tick / 20 % list.size())), sX, sY + 2, -16777216);
            }
        });
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public TreeNode<K, T> jumpTo(List<K> path) {
        this.list.removeIf(node -> node.dimension != 1);
        this.selected = null;
        int dim = 1;
        int index = 0;
        boolean flag = false;
        TreeNode<K, T> node2 = null;
        for (K key : path) {
            flag = false;
            for (int i = index; i < this.list.size(); ++i) {
                node2 = this.list.get(i);
                if (node2.dimension != dim) {
                    return null;
                }
                if (node2.getKey().equals(key)) {
                    if (!node2.isLeaf() && path.size() > dim) {
                        for (int j = 0; j < node2.getChildren().size(); ++j) {
                            this.list.add(index + 1 + j, node2.getChildren().get(j));
                        }
                    }
                    ++index;
                    ++dim;
                    flag = true;
                    break;
                }
                ++index;
            }
            if (flag) continue;
            return null;
        }
        if (flag) {
            this.selected = node2;
            this.scrollOffset = MathHelper.func_76125_a((int)(11 * (index - 1)), (int)0, (int)Math.max(this.list.size() * 11 - this.getSize().height, 0));
            return this.selected;
        }
        return null;
    }

    @Override
    public Widget mouseClicked(int mouseX, int mouseY, int button) {
        block6: {
            block7: {
                block9: {
                    TreeNode<T, K> node;
                    int index;
                    block8: {
                        if (!this.isMouseOverElement(mouseX, mouseY)) break block6;
                        index = (mouseY - this.getPosition().y + this.scrollOffset) / 11;
                        if (index >= this.list.size()) break block7;
                        node = this.list.get(index);
                        if (!node.isLeaf()) break block8;
                        if (node == this.selected) break block9;
                        this.selected = node;
                        if (this.onSelected == null) break block9;
                        this.onSelected.accept(node);
                        break block9;
                    }
                    if (this.canSelectNode && this.selected != node) {
                        this.selected = node;
                        if (this.onSelected != null) {
                            this.onSelected.accept(node);
                        }
                    } else if (node.getChildren().size() > 0 && this.list.contains(node.getChildren().get(0))) {
                        this.removeNode(node);
                    } else {
                        for (int i = 0; i < node.getChildren().size(); ++i) {
                            this.list.add(index + 1 + i, node.getChildren().get(i));
                        }
                    }
                }
                TreeListWidget.playButtonClickSound();
            }
            return this;
        }
        return null;
    }

    private void removeNode(TreeNode<?, T> node) {
        if (node.isLeaf()) {
            return;
        }
        for (TreeNode<?, T> child : node.getChildren()) {
            this.list.remove(child);
            this.removeNode(child);
        }
    }
}

