/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.gui.texture.IGuiTexture;
import com.cleanroommc.multiblocked.api.gui.util.DrawerHelper;
import com.cleanroommc.multiblocked.api.gui.widget.Widget;
import com.cleanroommc.multiblocked.util.Position;
import com.cleanroommc.multiblocked.util.Size;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TextFieldWidget
extends Widget {
    @SideOnly(value=Side.CLIENT)
    protected GuiTextField textField;
    protected int maxStringLength = Integer.MAX_VALUE;
    protected Function<String, String> textValidator = s -> s;
    protected Supplier<String> textSupplier;
    protected Consumer<String> textResponder;
    protected String currentString;
    private IGuiTexture background;
    private boolean enableBackground;
    private boolean allowEnter;
    protected int textColor = -1;
    protected float wheelDur;
    protected NumberFormat numberInstance;
    protected ITextComponent hover;

    public TextFieldWidget(int xPosition, int yPosition, int width, int height, Supplier<String> textSupplier, Consumer<String> textResponder) {
        this(xPosition, yPosition, width, height, true, textSupplier, textResponder);
    }

    public TextFieldWidget(int xPosition, int yPosition, int width, int height, boolean enableBackground, Supplier<String> textSupplier, Consumer<String> textResponder) {
        super(new Position(xPosition, yPosition), new Size(width, height));
        if (Multiblocked.isClient()) {
            this.enableBackground = enableBackground;
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            this.textField = enableBackground ? new GuiTextField(0, fontRenderer, xPosition, yPosition, width, height) : new GuiTextField(0, fontRenderer, xPosition + 1, yPosition + (height - fontRenderer.field_78288_b) / 2 + 1, width - 2, height);
            this.textField.func_146205_d(true);
            this.textField.func_146185_a(enableBackground);
            this.textField.func_146203_f(this.maxStringLength);
            this.textField.func_175207_a(TextFieldWidget.createTextFieldResponder(this::onTextChanged));
        }
        this.textSupplier = textSupplier;
        this.textResponder = textResponder;
    }

    public TextFieldWidget setTextSupplier(Supplier<String> textSupplier) {
        this.textSupplier = textSupplier;
        return this;
    }

    public TextFieldWidget setTextResponder(Consumer<String> textResponder) {
        this.textResponder = textResponder;
        return this;
    }

    public TextFieldWidget setBackground(IGuiTexture background) {
        this.background = background;
        return this;
    }

    public TextFieldWidget setAllowEnter(boolean allowEnter) {
        this.allowEnter = allowEnter;
        return this;
    }

    public TextFieldWidget setCurrentString(String currentString) {
        this.currentString = currentString;
        if (Multiblocked.isClient() && !this.textField.func_146179_b().equals(currentString)) {
            this.textField.func_146180_a(currentString);
        }
        return this;
    }

    public String getCurrentString() {
        if (Multiblocked.isClient()) {
            return this.textField.func_146179_b();
        }
        return this.currentString;
    }

    @Override
    public void setFocus(boolean focus) {
        super.setFocus(focus);
        if (!focus) {
            this.textField.func_146195_b(false);
        }
    }

    @Override
    protected void onPositionUpdate() {
        if (Multiblocked.isClient() && this.textField != null) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            Position position = this.getPosition();
            Size size = this.getSize();
            GuiTextField textField = this.textField;
            textField.field_146209_f = this.enableBackground ? position.x : position.x + 1;
            textField.field_146210_g = this.enableBackground ? position.y : position.y + (size.height - fontRenderer.field_78288_b) / 2 + 1;
        }
    }

    @Override
    protected void onSizeUpdate() {
        if (Multiblocked.isClient() && this.textField != null) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            Position position = this.getPosition();
            Size size = this.getSize();
            GuiTextField textField = this.textField;
            textField.field_146218_h = this.enableBackground ? size.width : size.width - 2;
            textField.field_146219_i = size.height;
            textField.field_146210_g = this.enableBackground ? position.y : position.y + (this.getSize().height - fontRenderer.field_78288_b) / 2 + 1;
        }
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks) {
        super.drawInBackground(mouseX, mouseY, partialTicks);
        if (this.background != null) {
            Position position = this.getPosition();
            Size size = this.getSize();
            this.background.draw(position.x, position.y, size.width, size.height);
        }
        this.textField.func_146194_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public Widget mouseClicked(int mouseX, int mouseY, int button) {
        return this.textField.func_146192_a(mouseX, mouseY, button) ? this : null;
    }

    @Override
    public Widget keyTyped(char charTyped, int keyCode) {
        if (this.allowEnter) {
            if (!this.textField.func_146206_l()) {
                return null;
            }
            if (GuiScreen.func_175279_e((int)keyCode)) {
                String s = GuiScreen.func_146277_j();
                if (this.textValidator != null) {
                    s = this.textValidator.apply(s);
                }
                if (this.textResponder != null) {
                    this.textResponder.accept(s);
                }
                this.setCurrentString(s);
                return this;
            }
        }
        return this.textField.func_146201_a(charTyped, keyCode) ? this : null;
    }

    @Override
    public Widget mouseDragged(int mouseX, int mouseY, int button, long timeDragged) {
        return this.isFocus() ? this : super.mouseDragged(mouseX, mouseY, button, timeDragged);
    }

    @Override
    public Widget mouseReleased(int mouseX, int mouseY, int button) {
        return this.isFocus() ? this : super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public void updateScreen() {
        if (this.background != null) {
            this.background.updateTick();
        }
        if (this.textSupplier != null && this.isClientSideWidget && !this.textSupplier.get().equals(this.getCurrentString())) {
            this.setCurrentString(this.textSupplier.get());
        }
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (this.textSupplier != null && !this.textSupplier.get().equals(this.getCurrentString())) {
            this.setCurrentString(this.textSupplier.get());
            this.writeUpdateInfo(1, buffer -> buffer.func_180714_a(this.getCurrentString()));
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        super.readUpdateInfo(id, buffer);
        if (id == 1) {
            this.setCurrentString(buffer.func_150789_c(Short.MAX_VALUE));
        }
    }

    protected void onTextChanged(String newTextString) {
        String lastText = this.currentString;
        String newText = this.textValidator.apply(newTextString);
        if (!newText.equals(lastText)) {
            this.textField.func_146193_g(this.textColor);
            this.setCurrentString(newText);
            if (this.isClientSideWidget && this.textResponder != null) {
                this.textResponder.accept(newText);
            }
            this.writeClientAction(1, buffer -> buffer.func_180714_a(newText));
        } else if (!newTextString.equals(newText)) {
            this.textField.func_146193_g(-2162688);
        } else {
            this.textField.func_146193_g(this.textColor);
        }
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        super.handleClientAction(id, buffer);
        if (id == 1) {
            String lastText = this.getCurrentString();
            String newText = this.textValidator.apply(buffer.func_150789_c(Short.MAX_VALUE));
            if (!lastText.equals(newText = newText.substring(0, Math.min(newText.length(), this.maxStringLength)))) {
                this.setCurrentString(newText);
                if (this.textResponder != null) {
                    this.textResponder.accept(newText);
                }
            }
        }
    }

    public TextFieldWidget setTextColor(int textColor) {
        this.textColor = textColor;
        if (Multiblocked.isClient()) {
            this.textField.func_146193_g(textColor);
        }
        return this;
    }

    public TextFieldWidget setMaxStringLength(int maxStringLength) {
        this.maxStringLength = maxStringLength;
        if (Multiblocked.isClient()) {
            this.textField.func_146203_f(maxStringLength);
        }
        return this;
    }

    public TextFieldWidget setValidator(Function<String, String> validator) {
        this.textValidator = validator;
        return this;
    }

    public TextFieldWidget setNumbersOnly(long minValue, long maxValue) {
        this.setValidator(s -> {
            try {
                if (s == null || s.isEmpty()) {
                    return minValue + "";
                }
                long value = Long.parseLong(s);
                if (minValue <= value && value <= maxValue) {
                    return s;
                }
                if (value < minValue) {
                    return minValue + "";
                }
                return maxValue + "";
            }
            catch (NumberFormatException numberFormatException) {
                return this.currentString;
            }
        });
        this.hover = minValue == Long.MIN_VALUE && maxValue == Long.MAX_VALUE ? new TextComponentTranslation("multiblocked.gui.text_field.number.3", new Object[0]) : (minValue == Long.MIN_VALUE ? new TextComponentTranslation("multiblocked.gui.text_field.number.2", new Object[]{maxValue}) : (maxValue == Long.MAX_VALUE ? new TextComponentTranslation("multiblocked.gui.text_field.number.1", new Object[]{minValue}) : new TextComponentTranslation("multiblocked.gui.text_field.number.0", new Object[]{minValue, maxValue})));
        return this.setWheelDur(1.0f);
    }

    public TextFieldWidget setNumbersOnly(int minValue, int maxValue) {
        this.setValidator(s -> {
            try {
                if (s == null || s.isEmpty()) {
                    return minValue + "";
                }
                int value = Integer.parseInt(s);
                if (minValue <= value && value <= maxValue) {
                    return s;
                }
                if (value < minValue) {
                    return minValue + "";
                }
                return maxValue + "";
            }
            catch (NumberFormatException numberFormatException) {
                return this.currentString;
            }
        });
        this.hover = minValue == Integer.MIN_VALUE && maxValue == Integer.MAX_VALUE ? new TextComponentTranslation("multiblocked.gui.text_field.number.3", new Object[0]) : (minValue == Integer.MIN_VALUE ? new TextComponentTranslation("multiblocked.gui.text_field.number.2", new Object[]{maxValue}) : (maxValue == Integer.MAX_VALUE ? new TextComponentTranslation("multiblocked.gui.text_field.number.1", new Object[]{minValue}) : new TextComponentTranslation("multiblocked.gui.text_field.number.0", new Object[]{minValue, maxValue})));
        return this.setWheelDur(1.0f);
    }

    public TextFieldWidget setNumbersOnly(float minValue, float maxValue) {
        this.setValidator(s -> {
            try {
                if (s == null || s.isEmpty()) {
                    return minValue + "";
                }
                float value = Float.parseFloat(s);
                if (minValue <= value && value <= maxValue) {
                    return s;
                }
                if (value < minValue) {
                    return minValue + "";
                }
                return maxValue + "";
            }
            catch (NumberFormatException numberFormatException) {
                return this.currentString;
            }
        });
        this.hover = minValue == Float.MIN_VALUE && maxValue == Float.MAX_VALUE ? new TextComponentTranslation("multiblocked.gui.text_field.number.3", new Object[0]) : (minValue == Float.MIN_VALUE ? new TextComponentTranslation("multiblocked.gui.text_field.number.2", new Object[]{Float.valueOf(maxValue)}) : (maxValue == Float.MAX_VALUE ? new TextComponentTranslation("multiblocked.gui.text_field.number.1", new Object[]{Float.valueOf(minValue)}) : new TextComponentTranslation("multiblocked.gui.text_field.number.0", new Object[]{Float.valueOf(minValue), Float.valueOf(maxValue)})));
        return this.setWheelDur(0.1f);
    }

    public TextFieldWidget setWheelDur(float wheelDur) {
        this.wheelDur = wheelDur;
        this.numberInstance = NumberFormat.getNumberInstance();
        this.numberInstance.setMaximumFractionDigits(4);
        return this;
    }

    public TextFieldWidget setWheelDur(int digits, float wheelDur) {
        this.wheelDur = wheelDur;
        this.numberInstance = NumberFormat.getNumberInstance();
        this.numberInstance.setMaximumFractionDigits(digits);
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInForeground(int mouseX, int mouseY, float partialTicks) {
        if (this.gui != null && this.isMouseOverElement(mouseX, mouseY)) {
            GlStateManager.func_179126_j();
            ArrayList<String> tips = new ArrayList<String>();
            if (this.tooltipText != null) {
                tips.addAll(Arrays.asList(I18n.func_135052_a((String)this.tooltipText, (Object[])new Object[0]).split("\n")));
            }
            if (this.hover != null) {
                tips.add(this.hover.func_150254_d());
            }
            if (this.wheelDur > 0.0f && this.numberInstance != null && this.isFocus()) {
                tips.add(I18n.func_135052_a((String)"multiblocked.gui.text_field.number.wheel", (Object[])new Object[]{this.numberInstance.format(this.wheelDur)}));
            }
            if (!tips.isEmpty()) {
                DrawerHelper.drawHoveringText(ItemStack.field_190927_a, tips, 300, mouseX, mouseY, this.gui.getScreenWidth(), this.gui.getScreenHeight());
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Widget mouseWheelMove(int mouseX, int mouseY, int wheelDelta) {
        if (this.wheelDur > 0.0f && this.numberInstance != null && this.isMouseOverElement(mouseX, mouseY) && this.isFocus()) {
            try {
                this.onTextChanged(this.numberInstance.format(Float.parseFloat(this.getCurrentString()) + (float)(wheelDelta > 0 ? 1 : -1) * this.wheelDur));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this;
        }
        return super.mouseWheelMove(mouseX, mouseY, wheelDelta);
    }

    private static GuiPageButtonList.GuiResponder createTextFieldResponder(final Consumer<String> onChanged) {
        return new GuiPageButtonList.GuiResponder(){

            public void func_175321_a(int id, boolean value) {
            }

            public void func_175320_a(int id, float value) {
            }

            public void func_175319_a(int id, @Nonnull String value) {
                onChanged.accept(value);
            }
        };
    }
}

