/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.gui.widget.Widget;
import com.cleanroommc.multiblocked.util.Position;
import com.cleanroommc.multiblocked.util.Size;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;

public class TextBoxWidget
extends Widget {
    public List<String> content;
    public int space = 1;
    public int fontSize = 9;
    public int fontColor = -16777216;
    public boolean isShadow = false;
    public boolean isCenter = false;
    private transient List<String> textLines;

    public TextBoxWidget(int x, int y, int width, List<String> content) {
        super(x, y, width, 0);
        this.content = content;
        this.calculate();
    }

    public TextBoxWidget setContent(List<String> content) {
        this.content = content;
        this.calculate();
        return this;
    }

    public TextBoxWidget setSpace(int space) {
        this.space = space;
        this.calculate();
        return this;
    }

    public TextBoxWidget setFontSize(int fontSize) {
        this.fontSize = fontSize;
        this.calculate();
        return this;
    }

    public TextBoxWidget setFontColor(int fontColor) {
        this.fontColor = fontColor;
        this.calculate();
        return this;
    }

    public TextBoxWidget setShadow(boolean shadow) {
        this.isShadow = shadow;
        this.calculate();
        return this;
    }

    public TextBoxWidget setCenter(boolean center) {
        this.isCenter = center;
        this.calculate();
        return this;
    }

    protected void calculate() {
        if (Multiblocked.isClient()) {
            this.textLines = new ArrayList<String>();
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            this.space = Math.max(this.space, 0);
            this.fontSize = Math.max(this.fontSize, 1);
            int wrapWidth = this.getSize().width * font.field_78288_b / this.fontSize;
            if (this.content != null) {
                for (String textLine : this.content) {
                    this.textLines.addAll(font.func_78271_c(textLine, wrapWidth));
                }
            }
            this.setSize(new Size(this.getSize().width, this.textLines.size() * (this.fontSize + this.space)));
        }
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks) {
        super.drawInBackground(mouseX, mouseY, partialTicks);
        if (!this.textLines.isEmpty()) {
            Position position = this.getPosition();
            Size size = this.getSize();
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            float scale = (float)this.fontSize * 1.0f / (float)font.field_78288_b;
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            GlStateManager.func_179109_b((float)((float)position.x / scale), (float)((float)position.y / scale), (float)0.0f);
            float x = 0.0f;
            float y = 0.0f;
            float ySpace = (float)font.field_78288_b + (float)this.space / scale;
            for (String textLine : this.textLines) {
                if (this.isCenter) {
                    x = ((float)size.width / scale - (float)font.func_78256_a(textLine)) / 2.0f;
                }
                font.func_175065_a(textLine, x, y, this.fontColor, this.isShadow);
                y += ySpace;
            }
            GlStateManager.func_179121_F();
        }
    }
}

