/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp;

import com.cleanroommc.multiblocked.api.gui.ingredient.IIngredientSlot;
import com.cleanroommc.multiblocked.api.gui.texture.IGuiTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ProgressTexture;
import com.cleanroommc.multiblocked.api.gui.util.DrawerHelper;
import com.cleanroommc.multiblocked.api.gui.util.TextFormattingUtil;
import com.cleanroommc.multiblocked.api.gui.widget.Widget;
import com.cleanroommc.multiblocked.util.Position;
import com.cleanroommc.multiblocked.util.Size;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class TankWidget
extends Widget
implements IIngredientSlot {
    public final IFluidTank fluidTank;
    protected boolean showTips;
    protected boolean allowClickFilling;
    protected boolean allowClickEmptying;
    protected boolean drawHoverTips;
    protected IGuiTexture background;
    protected IGuiTexture overlay;
    protected FluidStack lastFluidInTank;
    protected int lastTankCapacity;
    protected ProgressTexture.FillDirection fillDirection = ProgressTexture.FillDirection.ALWAYS_FULL;

    public TankWidget(IFluidTank fluidTank, int x, int y, boolean allowClickContainerFilling, boolean allowClickContainerEmptying) {
        this(fluidTank, x, y, 18, 18, allowClickContainerFilling, allowClickContainerEmptying);
    }

    public TankWidget(IFluidTank fluidTank, int x, int y, int width, int height, boolean allowClickContainerFilling, boolean allowClickContainerEmptying) {
        super(new Position(x, y), new Size(width, height));
        this.fluidTank = fluidTank;
        this.showTips = true;
        this.allowClickFilling = allowClickContainerFilling;
        this.allowClickEmptying = allowClickContainerEmptying;
        this.drawHoverTips = true;
    }

    public TankWidget setFillDirection(ProgressTexture.FillDirection fillDirection) {
        this.fillDirection = fillDirection;
        return this;
    }

    public TankWidget setDrawHoverTips(boolean drawHoverTips) {
        this.drawHoverTips = drawHoverTips;
        return this;
    }

    @Override
    public TankWidget setClientSideWidget() {
        super.setClientSideWidget();
        this.lastFluidInTank = this.fluidTank != null ? (this.fluidTank.getFluid() != null ? this.fluidTank.getFluid().copy() : null) : null;
        this.lastTankCapacity = this.fluidTank != null ? this.fluidTank.getCapacity() : 0;
        return this;
    }

    public TankWidget setShowTips(boolean showTips) {
        this.showTips = showTips;
        return this;
    }

    public TankWidget setBackground(IGuiTexture background) {
        this.background = background;
        return this;
    }

    public TankWidget setOverlay(IGuiTexture overlay) {
        this.overlay = overlay;
        return this;
    }

    public TankWidget setContainerClicking(boolean allowClickContainerFilling, boolean allowClickContainerEmptying) {
        this.allowClickFilling = allowClickContainerFilling;
        this.allowClickEmptying = allowClickContainerEmptying;
        return this;
    }

    @Override
    public Object getIngredientOverMouse(int mouseX, int mouseY) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            return this.lastFluidInTank;
        }
        return null;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks) {
        Position pos = this.getPosition();
        Size size = this.getSize();
        if (this.background != null) {
            this.background.draw(mouseX, mouseY, pos.x, pos.y, size.width, size.height);
        }
        if (this.lastFluidInTank != null) {
            GlStateManager.func_179084_k();
            if (this.lastFluidInTank.amount > 0) {
                double progress = (double)this.lastFluidInTank.amount * 1.0 / (double)Math.max(this.lastFluidInTank.amount, this.lastTankCapacity);
                float drawnU = (float)this.fillDirection.getDrawnU(progress);
                float drawnV = (float)this.fillDirection.getDrawnV(progress);
                float drawnWidth = (float)this.fillDirection.getDrawnWidth(progress);
                float drawnHeight = (float)this.fillDirection.getDrawnHeight(progress);
                int width = size.width - 2;
                int height = size.height - 2;
                int x = pos.x + 1;
                int y = pos.y + 1;
                DrawerHelper.drawFluidForGui(this.lastFluidInTank, this.lastFluidInTank.amount, (int)((float)x + drawnU * (float)width), (int)((float)y + drawnV * (float)height), (int)((float)width * drawnWidth), (int)((float)height * drawnHeight));
            }
            if (this.showTips) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
                String s = TextFormattingUtil.formatLongToCompactStringBuckets(this.lastFluidInTank.amount, 3) + "B";
                FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
                fontRenderer.func_175063_a(s, ((float)pos.x + (float)size.width / 3.0f) * 2.0f - (float)fontRenderer.func_78256_a(s) + 21.0f, ((float)pos.y + (float)size.height / 3.0f + 6.0f) * 2.0f, 0xFFFFFF);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (this.overlay != null) {
            this.overlay.draw(mouseX, mouseY, pos.x, pos.y, size.width, size.height);
        }
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY, float partialTicks) {
        if (this.drawHoverTips && this.isMouseOverElement(mouseX, mouseY)) {
            ArrayList<String> tooltips = new ArrayList<String>();
            if (this.lastFluidInTank != null) {
                Fluid fluid = this.lastFluidInTank.getFluid();
                tooltips.add(fluid.getLocalizedName(this.lastFluidInTank));
                tooltips.add(I18n.func_135052_a((String)"multiblocked.fluid.amount", (Object[])new Object[]{this.lastFluidInTank.amount, this.lastTankCapacity}));
                tooltips.add(I18n.func_135052_a((String)"multiblocked.fluid.temperature", (Object[])new Object[]{fluid.getTemperature(this.lastFluidInTank)}));
                tooltips.add(I18n.func_135052_a((String)(fluid.isGaseous(this.lastFluidInTank) ? "multiblocked.fluid.state_gas" : "multiblocked.fluid.state_liquid"), (Object[])new Object[0]));
            } else {
                tooltips.add(I18n.func_135052_a((String)"multiblocked.fluid.empty", (Object[])new Object[0]));
                tooltips.add(I18n.func_135052_a((String)"multiblocked.fluid.amount", (Object[])new Object[]{0, this.lastTankCapacity}));
            }
            if (this.gui != null) {
                DrawerHelper.drawHoveringText(ItemStack.field_190927_a, tooltips, 300, mouseX, mouseY, this.gui.getScreenWidth(), this.gui.getScreenHeight());
            }
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public void updateScreen() {
        if (this.isClientSideWidget) {
            FluidStack fluidStack = this.fluidTank.getFluid();
            if (this.fluidTank.getCapacity() != this.lastTankCapacity) {
                this.lastTankCapacity = this.fluidTank.getCapacity();
            }
            if (fluidStack == null && this.lastFluidInTank != null) {
                this.lastFluidInTank = null;
            } else if (fluidStack != null) {
                if (!fluidStack.isFluidEqual(this.lastFluidInTank)) {
                    this.lastFluidInTank = fluidStack.copy();
                } else if (fluidStack.amount != this.lastFluidInTank.amount) {
                    this.lastFluidInTank.amount = fluidStack.amount;
                }
            }
        }
    }

    @Override
    public void detectAndSendChanges() {
        FluidStack fluidStack = this.fluidTank.getFluid();
        if (this.fluidTank.getCapacity() != this.lastTankCapacity) {
            this.lastTankCapacity = this.fluidTank.getCapacity();
            this.writeUpdateInfo(0, buffer -> buffer.func_150787_b(this.lastTankCapacity));
        }
        if (fluidStack == null && this.lastFluidInTank != null) {
            this.lastFluidInTank = null;
            this.writeUpdateInfo(1, buffer -> {});
        } else if (fluidStack != null) {
            if (!fluidStack.isFluidEqual(this.lastFluidInTank)) {
                this.lastFluidInTank = fluidStack.copy();
                NBTTagCompound fluidStackTag = fluidStack.writeToNBT(new NBTTagCompound());
                this.writeUpdateInfo(2, buffer -> buffer.func_150786_a(fluidStackTag));
            } else if (fluidStack.amount != this.lastFluidInTank.amount) {
                this.lastFluidInTank.amount = fluidStack.amount;
                this.writeUpdateInfo(3, buffer -> buffer.func_150787_b(this.lastFluidInTank.amount));
            }
        }
    }

    @Override
    public void writeInitialData(PacketBuffer buffer) {
        this.lastTankCapacity = this.fluidTank.getCapacity();
        buffer.func_150787_b(this.lastTankCapacity);
        FluidStack fluidStack = this.fluidTank.getFluid();
        if (fluidStack == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            this.lastFluidInTank = fluidStack.copy();
            buffer.func_150786_a(fluidStack.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public void readInitialData(PacketBuffer buffer) {
        this.lastTankCapacity = buffer.func_150792_a();
        if (buffer.readBoolean()) {
            this.readUpdateInfo(2, buffer);
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        if (id == 0) {
            this.lastTankCapacity = buffer.func_150792_a();
        } else if (id == 1) {
            this.lastFluidInTank = null;
        } else if (id == 2) {
            NBTTagCompound fluidStackTag;
            try {
                fluidStackTag = buffer.func_150793_b();
            }
            catch (IOException ignored) {
                return;
            }
            this.lastFluidInTank = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidStackTag);
        } else if (id == 3 && this.lastFluidInTank != null) {
            this.lastFluidInTank.amount = buffer.func_150792_a();
        } else if (id == 4) {
            ItemStack currentStack = this.gui.entityPlayer.field_71071_by.func_70445_o();
            int newStackSize = buffer.func_150792_a();
            currentStack.func_190920_e(newStackSize);
            this.gui.entityPlayer.field_71071_by.func_70437_b(currentStack);
        }
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        boolean isShiftKeyDown;
        int clickResult;
        super.handleClientAction(id, buffer);
        if (id == 1 && (clickResult = this.tryClickContainer(isShiftKeyDown = buffer.readBoolean())) >= 0) {
            this.writeUpdateInfo(4, buf -> buf.func_150787_b(clickResult));
        }
    }

    private int tryClickContainer(boolean isShiftKeyDown) {
        int maxAttempts;
        EntityPlayer player = this.gui.entityPlayer;
        ItemStack currentStack = player.field_71071_by.func_70445_o();
        if (!currentStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            return -1;
        }
        int n = maxAttempts = isShiftKeyDown ? currentStack.func_190916_E() : 1;
        if (this.allowClickFilling && this.fluidTank.getFluidAmount() > 0) {
            ItemStack remainingStack;
            FluidActionResult result;
            boolean performedFill = false;
            FluidStack initialFluid = this.fluidTank.getFluid();
            for (int i = 0; i < maxAttempts && (result = FluidUtil.tryFillContainer((ItemStack)currentStack, (IFluidHandler)((IFluidHandler)this.fluidTank), (int)Integer.MAX_VALUE, null, (boolean)false)).isSuccess() && ((remainingStack = result.getResult()).func_190926_b() || player.field_71071_by.func_70441_a(remainingStack)); ++i) {
                FluidUtil.tryFillContainer((ItemStack)currentStack, (IFluidHandler)((IFluidHandler)this.fluidTank), (int)Integer.MAX_VALUE, null, (boolean)true);
                currentStack.func_190918_g(1);
                performedFill = true;
            }
            if (performedFill && initialFluid != null) {
                SoundEvent soundevent = initialFluid.getFluid().getFillSound(initialFluid);
                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.gui.entityPlayer.field_71071_by.func_70437_b(currentStack);
                return currentStack.func_190916_E();
            }
        }
        if (this.allowClickEmptying) {
            ItemStack remainingStack;
            FluidActionResult result;
            boolean performedEmptying = false;
            for (int i = 0; i < maxAttempts && (result = FluidUtil.tryEmptyContainer((ItemStack)currentStack, (IFluidHandler)((IFluidHandler)this.fluidTank), (int)Integer.MAX_VALUE, null, (boolean)false)).isSuccess() && ((remainingStack = result.getResult()).func_190926_b() || player.field_71071_by.func_70441_a(remainingStack)); ++i) {
                FluidUtil.tryEmptyContainer((ItemStack)currentStack, (IFluidHandler)((IFluidHandler)this.fluidTank), (int)Integer.MAX_VALUE, null, (boolean)true);
                currentStack.func_190918_g(1);
                performedEmptying = true;
            }
            FluidStack filledFluid = this.fluidTank.getFluid();
            if (performedEmptying && filledFluid != null) {
                SoundEvent soundevent = filledFluid.getFluid().getEmptySound(filledFluid);
                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.gui.entityPlayer.field_71071_by.func_70437_b(currentStack);
                return currentStack.func_190916_E();
            }
        }
        return -1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Widget mouseClicked(int mouseX, int mouseY, int button) {
        if ((this.allowClickEmptying || this.allowClickFilling) && this.isMouseOverElement(mouseX, mouseY)) {
            ItemStack currentStack = this.gui.entityPlayer.field_71071_by.func_70445_o();
            if (button == 0 && currentStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                boolean isShiftKeyDown = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
                this.writeClientAction(1, writer -> writer.writeBoolean(isShiftKeyDown));
                TankWidget.playButtonClickSound();
                return this;
            }
        }
        return null;
    }
}

