/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp;

import com.cleanroommc.multiblocked.api.gui.texture.ColorBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.IGuiTexture;
import com.cleanroommc.multiblocked.api.gui.util.ClickData;
import com.cleanroommc.multiblocked.api.gui.widget.Widget;
import com.cleanroommc.multiblocked.util.Position;
import com.cleanroommc.multiblocked.util.Size;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;

public class SwitchWidget
extends Widget {
    protected IGuiTexture[] baseTexture;
    protected IGuiTexture[] pressedTexture;
    protected IGuiTexture[] hoverTexture;
    protected boolean isPressed;
    protected BiConsumer<ClickData, Boolean> onPressCallback;
    protected Supplier<Boolean> supplier;

    public SwitchWidget(int xPosition, int yPosition, int width, int height, BiConsumer<ClickData, Boolean> onPressed) {
        super(xPosition, yPosition, width, height);
        this.onPressCallback = onPressed;
    }

    public void setOnPressCallback(BiConsumer<ClickData, Boolean> onPressCallback) {
        this.onPressCallback = onPressCallback;
    }

    public SwitchWidget setTexture(IGuiTexture baseTexture, IGuiTexture pressedTexture) {
        this.setBaseTexture(baseTexture);
        this.setPressedTexture(pressedTexture);
        return this;
    }

    public SwitchWidget setBaseTexture(IGuiTexture ... baseTexture) {
        this.baseTexture = baseTexture;
        return this;
    }

    public SwitchWidget setPressedTexture(IGuiTexture ... pressedTexture) {
        this.pressedTexture = pressedTexture;
        return this;
    }

    public SwitchWidget setHoverTexture(IGuiTexture ... hoverTexture) {
        this.hoverTexture = hoverTexture;
        return this;
    }

    public SwitchWidget setHoverBorderTexture(int border, int color) {
        this.hoverTexture = new IGuiTexture[]{new ColorBorderTexture(border, color)};
        return this;
    }

    @Override
    public void updateScreen() {
        if (this.baseTexture != null) {
            for (IGuiTexture texture : this.baseTexture) {
                texture.updateTick();
            }
        }
        if (this.pressedTexture != null) {
            for (IGuiTexture texture : this.pressedTexture) {
                texture.updateTick();
            }
        }
        if (this.hoverTexture != null) {
            for (IGuiTexture texture : this.hoverTexture) {
                texture.updateTick();
            }
        }
        if (this.isClientSideWidget && this.supplier != null) {
            this.setPressed(this.supplier.get());
        }
    }

    @Override
    public void writeInitialData(PacketBuffer buffer) {
        buffer.writeBoolean(this.isPressed);
    }

    @Override
    public void readInitialData(PacketBuffer buffer) {
        this.isPressed = buffer.readBoolean();
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (!this.isClientSideWidget && this.supplier != null) {
            this.setPressed(this.supplier.get());
        }
    }

    public boolean isPressed() {
        return this.isPressed;
    }

    public SwitchWidget setPressed(boolean isPressed) {
        if (this.isPressed == isPressed) {
            return this;
        }
        this.isPressed = isPressed;
        if (this.gui == null) {
            return this;
        }
        if (this.isRemote()) {
            this.writeClientAction(2, buffer -> buffer.writeBoolean(isPressed));
        } else {
            this.writeUpdateInfo(2, buffer -> buffer.writeBoolean(isPressed));
        }
        return this;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks) {
        Position position = this.getPosition();
        Size size = this.getSize();
        if (this.baseTexture != null && !this.isPressed) {
            for (IGuiTexture texture : this.baseTexture) {
                texture.draw(mouseX, mouseY, position.x, position.y, size.width, size.height);
            }
        } else if (this.pressedTexture != null && this.isPressed) {
            for (IGuiTexture texture : this.pressedTexture) {
                texture.draw(mouseX, mouseY, position.x, position.y, size.width, size.height);
            }
        }
        if (this.isMouseOverElement(mouseX, mouseY) && this.hoverTexture != null) {
            for (IGuiTexture texture : this.hoverTexture) {
                texture.draw(mouseX, mouseY, position.x, position.y, size.width, size.height);
            }
        }
    }

    @Override
    public Widget mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            ClickData clickData = new ClickData();
            this.isPressed = !this.isPressed;
            this.writeClientAction(1, buffer -> {
                clickData.writeToBuf((PacketBuffer)buffer);
                buffer.writeBoolean(this.isPressed);
            });
            if (this.onPressCallback != null) {
                this.onPressCallback.accept(clickData, this.isPressed);
            }
            SwitchWidget.playButtonClickSound();
            return this;
        }
        return null;
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        super.handleClientAction(id, buffer);
        if (id == 1) {
            if (this.onPressCallback != null) {
                this.isPressed = buffer.readBoolean();
                this.onPressCallback.accept(ClickData.readFromBuf(buffer), this.isPressed);
            }
        } else if (id == 2) {
            this.isPressed = buffer.readBoolean();
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        if (id == 2) {
            this.isPressed = buffer.readBoolean();
        } else {
            super.readUpdateInfo(id, buffer);
        }
    }

    public SwitchWidget setSupplier(Supplier<Boolean> supplier) {
        this.supplier = supplier;
        return this;
    }
}

