/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp;

import com.cleanroommc.multiblocked.api.block.BlockComponent;
import com.cleanroommc.multiblocked.api.gui.ingredient.IIngredientSlot;
import com.cleanroommc.multiblocked.api.gui.modular.ModularUIGuiContainer;
import com.cleanroommc.multiblocked.api.gui.texture.IGuiTexture;
import com.cleanroommc.multiblocked.api.gui.util.DrawerHelper;
import com.cleanroommc.multiblocked.api.gui.widget.Widget;
import com.cleanroommc.multiblocked.client.renderer.impl.CycleBlockStateRenderer;
import com.cleanroommc.multiblocked.util.Position;
import com.cleanroommc.multiblocked.util.Size;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;

public class SlotWidget
extends Widget
implements IIngredientSlot {
    protected final Slot slotReference;
    protected final boolean canTakeItems;
    protected final boolean canPutItems;
    public boolean isPlayerInventory;
    public boolean isPlayerHotBar;
    public boolean drawOverlay = true;
    public boolean drawHoverTips = true;
    protected IGuiTexture backgroundTexture;
    protected Runnable changeListener;
    protected BiConsumer<SlotWidget, List<String>> onAddedTooltips;

    public SlotWidget(IInventory inventory, int slotIndex, int xPosition, int yPosition, boolean canTakeItems, boolean canPutItems) {
        super(new Position(xPosition, yPosition), new Size(18, 18));
        this.canTakeItems = canTakeItems;
        this.canPutItems = canPutItems;
        this.slotReference = this.createSlot(inventory, slotIndex);
    }

    public SlotWidget(IItemHandler itemHandler, int slotIndex, int xPosition, int yPosition, boolean canTakeItems, boolean canPutItems) {
        super(new Position(xPosition, yPosition), new Size(18, 18));
        this.canTakeItems = canTakeItems;
        this.canPutItems = canPutItems;
        this.slotReference = this.createSlot(itemHandler, slotIndex);
    }

    protected Slot createSlot(IInventory inventory, int index) {
        return new WidgetSlot(inventory, index, 0, 0);
    }

    protected Slot createSlot(IItemHandler itemHandler, int index) {
        return new WidgetSlotItemHandler(itemHandler, index, 0, 0);
    }

    public SlotWidget setOnAddedTooltips(BiConsumer<SlotWidget, List<String>> onAddedTooltips) {
        this.onAddedTooltips = onAddedTooltips;
        return this;
    }

    public SlotWidget setDrawHoverTips(boolean drawHoverTips) {
        this.drawHoverTips = drawHoverTips;
        return this;
    }

    public SlotWidget setDrawOverlay(boolean drawOverlay) {
        this.drawOverlay = drawOverlay;
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInForeground(int mouseX, int mouseY, float partialTicks) {
        super.drawInForeground(mouseX, mouseY, partialTicks);
        if (this.drawHoverTips && this.isMouseOverElement(mouseX, mouseY) && this.isActive()) {
            ((ISlotWidget)this.slotReference).setHover(true);
            ItemStack stack = this.slotReference.func_75211_c();
            if (!stack.func_190926_b()) {
                GuiUtils.preItemToolTip((ItemStack)stack);
                DrawerHelper.drawHoveringText(stack, this.getToolTips(DrawerHelper.getItemToolTip(stack)), 300, mouseX, mouseY, this.gui.getScreenWidth(), this.gui.getScreenHeight());
                GuiUtils.postItemToolTip();
            }
        }
        ((ISlotWidget)this.slotReference).setHover(false);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInBackground(int mouseX, int mouseY, float partialTicks) {
        ModularUIGuiContainer modularUIGui;
        Position pos = this.getPosition();
        Size size = this.getSize();
        if (this.backgroundTexture != null) {
            this.backgroundTexture.draw(mouseX, mouseY, pos.x, pos.y, size.width, size.height);
        }
        ItemStack itemStack = this.getRealStack(this.slotReference.func_75211_c());
        ModularUIGuiContainer modularUIGuiContainer = modularUIGui = this.gui == null ? null : this.gui.getModularUIGui();
        if (itemStack.func_190926_b() && modularUIGui != null && modularUIGui.getDragSplitting() && modularUIGui.getDragSplittingSlots().contains(this.slotReference)) {
            int splitSize = modularUIGui.getDragSplittingSlots().size();
            itemStack = this.gui.entityPlayer.field_71071_by.func_70445_o();
            if (!itemStack.func_190926_b() && splitSize > 1 && Container.func_94527_a((Slot)this.slotReference, (ItemStack)itemStack, (boolean)true)) {
                itemStack = itemStack.func_77946_l();
                Container.func_94525_a(modularUIGui.getDragSplittingSlots(), (int)modularUIGui.field_146987_F, (ItemStack)itemStack, (int)(this.slotReference.func_75211_c().func_190926_b() ? 0 : this.slotReference.func_75211_c().func_190916_E()));
                int k = Math.min(itemStack.func_77976_d(), this.slotReference.func_178170_b(itemStack));
                if (itemStack.func_190916_E() > k) {
                    itemStack.func_190920_e(k);
                }
            }
        }
        if (!itemStack.func_190926_b()) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179126_j();
            GlStateManager.func_179101_C();
            GlStateManager.func_179140_f();
            RenderHelper.func_74518_a();
            RenderHelper.func_74519_b();
            RenderHelper.func_74520_c();
            GlStateManager.func_179094_E();
            RenderItem itemRender = Minecraft.func_71410_x().func_175599_af();
            itemRender.func_180450_b(itemStack, pos.x + 1, pos.y + 1);
            itemRender.func_180453_a(Minecraft.func_71410_x().field_71466_p, itemStack, pos.x + 1, pos.y + 1, null);
            GlStateManager.func_179141_d();
            GlStateManager.func_179121_F();
            RenderHelper.func_74518_a();
        }
        if (!this.drawOverlay) {
            return;
        }
        if (this.isActive()) {
            if (this.slotReference instanceof ISlotWidget && this.isMouseOverElement(mouseX, mouseY)) {
                GlStateManager.func_179097_i();
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                DrawerHelper.drawSolidRect(this.getPosition().x + 1, this.getPosition().y + 1, 16, 16, -2130706433);
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GlStateManager.func_179126_j();
                GlStateManager.func_179147_l();
            }
        } else {
            GlStateManager.func_179097_i();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            DrawerHelper.drawSolidRect(this.getPosition().x + 1, this.getPosition().y + 1, 16, 16, -1090519040);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179126_j();
            GlStateManager.func_179147_l();
        }
    }

    @Override
    public Widget mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY) && this.gui != null && (this.canPutItems || this.canTakeItems)) {
            ModularUIGuiContainer modularUIGui = this.gui.getModularUIGui();
            boolean last = modularUIGui.getDragSplitting();
            this.gui.getModularUIGui().superMouseClicked(mouseX, mouseY, button);
            if (last != modularUIGui.getDragSplitting()) {
                modularUIGui.field_146988_G = button;
                if (button == 0) {
                    modularUIGui.field_146987_F = 0;
                } else if (button == 1) {
                    modularUIGui.field_146987_F = 1;
                } else if (Minecraft.func_71410_x().field_71474_y.field_74322_I.isActiveAndMatches(button - 100)) {
                    modularUIGui.field_146987_F = 2;
                }
            }
            return this;
        }
        return null;
    }

    @Override
    public Widget mouseReleased(int mouseX, int mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY) && this.gui != null) {
            this.gui.getModularUIGui().superMouseReleased(mouseX, mouseY, button);
            return this;
        }
        return null;
    }

    @Override
    public Widget mouseDragged(int mouseX, int mouseY, int button, long timeDragged) {
        if (this.isMouseOverElement(mouseX, mouseY) && this.gui != null) {
            this.gui.getModularUIGui().superMouseClickMove(mouseX, mouseY, button, timeDragged);
            return this;
        }
        return null;
    }

    @Override
    protected void onPositionUpdate() {
        if (this.slotReference != null && this.gui != null) {
            Position position = this.getPosition();
            this.slotReference.field_75223_e = position.x + 1 - this.gui.getGuiLeft();
            this.slotReference.field_75221_f = position.y + 1 - this.gui.getGuiTop();
        }
    }

    public SlotWidget setChangeListener(Runnable changeListener) {
        this.changeListener = changeListener;
        return this;
    }

    public SlotWidget(IItemHandlerModifiable itemHandler, int slotIndex, int xPosition, int yPosition) {
        this((IItemHandler)itemHandler, slotIndex, xPosition, yPosition, true, true);
    }

    public SlotWidget(IInventory inventory, int slotIndex, int xPosition, int yPosition) {
        this(inventory, slotIndex, xPosition, yPosition, true, true);
    }

    public SlotWidget setBackgroundTexture(IGuiTexture backgroundTexture) {
        this.backgroundTexture = backgroundTexture;
        return this;
    }

    public boolean canPutStack(ItemStack stack) {
        return this.isEnabled() && this.canPutItems;
    }

    public boolean canTakeStack(EntityPlayer player) {
        return this.isEnabled() && this.canTakeItems;
    }

    public boolean isEnabled() {
        return this.isActive() && this.isVisible();
    }

    public boolean canMergeSlot(ItemStack stack) {
        return this.isEnabled();
    }

    public void onSlotChanged() {
        if (this.gui == null) {
            return;
        }
        this.gui.holder.markAsDirty();
    }

    public ItemStack slotClick(int dragType, ClickType clickTypeIn, EntityPlayer player) {
        return null;
    }

    public final Slot getHandle() {
        return this.slotReference;
    }

    public Widget setLocationInfo(boolean isPlayerInventory, boolean isPlayerHotBar) {
        this.isPlayerHotBar = isPlayerHotBar;
        this.isPlayerInventory = isPlayerInventory;
        return this;
    }

    public ItemStack onItemTake(EntityPlayer player, ItemStack stack, boolean simulate) {
        return stack;
    }

    private List<String> getToolTips(List<String> list) {
        if (this.onAddedTooltips != null) {
            this.onAddedTooltips.accept(this, list);
        }
        return list;
    }

    @Override
    public Object getIngredientOverMouse(int mouseX, int mouseY) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            return this.getRealStack(this.getHandle().func_75211_c());
        }
        return null;
    }

    public ItemStack getRealStack(ItemStack itemStack) {
        Block block;
        if (itemStack.func_77973_b() instanceof ItemBlock && (block = ((ItemBlock)itemStack.func_77973_b()).func_179223_d()) instanceof BlockComponent && ((BlockComponent)block).definition.getRenderer() instanceof CycleBlockStateRenderer) {
            CycleBlockStateRenderer renderer = (CycleBlockStateRenderer)((BlockComponent)block).definition.getRenderer();
            itemStack = renderer.getBlockInfo().getItemStackForm();
        }
        return itemStack;
    }

    protected class WidgetSlotItemHandler
    extends SlotItemHandler
    implements ISlotWidget {
        boolean isHover;

        public WidgetSlotItemHandler(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        @Override
        public void setHover(boolean isHover) {
            this.isHover = isHover;
        }

        @Override
        public boolean isHover() {
            return this.isHover;
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            return SlotWidget.this.canPutStack(stack) && super.func_75214_a(stack);
        }

        public boolean func_82869_a(EntityPlayer playerIn) {
            return SlotWidget.this.canTakeStack(playerIn) && super.func_82869_a(playerIn);
        }

        public void func_75215_d(@Nonnull ItemStack stack) {
            if (!SlotWidget.this.canPutStack(stack)) {
                return;
            }
            super.func_75215_d(stack);
            if (SlotWidget.this.changeListener != null) {
                SlotWidget.this.changeListener.run();
            }
        }

        @Nonnull
        public final ItemStack func_190901_a(@Nonnull EntityPlayer thePlayer, @Nonnull ItemStack stack) {
            return SlotWidget.this.onItemTake(thePlayer, super.func_190901_a(thePlayer, stack), false);
        }

        public void func_75218_e() {
            SlotWidget.this.onSlotChanged();
        }

        public boolean func_111238_b() {
            return SlotWidget.this.isEnabled();
        }
    }

    protected class WidgetSlot
    extends Slot
    implements ISlotWidget {
        boolean isHover;

        public WidgetSlot(IInventory inventory, int index, int xPosition, int yPosition) {
            super(inventory, index, xPosition, yPosition);
        }

        @Override
        public void setHover(boolean isHover) {
            this.isHover = isHover;
        }

        @Override
        public boolean isHover() {
            return this.isHover;
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            return SlotWidget.this.canPutStack(stack) && super.func_75214_a(stack);
        }

        public boolean func_82869_a(@Nonnull EntityPlayer playerIn) {
            return SlotWidget.this.canTakeStack(playerIn) && super.func_82869_a(playerIn);
        }

        public void func_75215_d(@Nonnull ItemStack stack) {
            if (!SlotWidget.this.canPutStack(stack)) {
                return;
            }
            super.func_75215_d(stack);
            if (SlotWidget.this.changeListener != null) {
                SlotWidget.this.changeListener.run();
            }
        }

        @Nonnull
        public final ItemStack func_190901_a(@Nonnull EntityPlayer thePlayer, @Nonnull ItemStack stack) {
            return SlotWidget.this.onItemTake(thePlayer, super.func_190901_a(thePlayer, stack), false);
        }

        public void func_75218_e() {
            SlotWidget.this.onSlotChanged();
        }

        public boolean func_111238_b() {
            return SlotWidget.this.isEnabled();
        }
    }

    public static interface ISlotWidget {
        public void setHover(boolean var1);

        public boolean isHover();
    }
}

