/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp;

import com.cleanroommc.multiblocked.api.gui.texture.ColorRectTexture;
import com.cleanroommc.multiblocked.api.gui.texture.IGuiTexture;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.widget.Widget;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ButtonWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableScrollableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ImageWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SelectableWidgetGroup;
import com.cleanroommc.multiblocked.util.Position;
import com.cleanroommc.multiblocked.util.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.network.PacketBuffer;

public class SelectorWidget
extends WidgetGroup {
    protected ButtonWidget button;
    protected List<String> candidates;
    protected List<SelectableWidgetGroup> selects;
    protected String currentString;
    protected boolean isShow;
    private Consumer<String> onChanged;
    public final TextTexture textTexture;
    public final DraggableScrollableWidgetGroup popUp;
    public int capacity = 5;

    public SelectorWidget(int x, int y, int width, int height, List<String> candidates, int fontColor) {
        super(new Position(x, y), new Size(width, height));
        this.button = new ButtonWidget(0, 0, width, height, d -> this.setShow(!this.isShow));
        this.candidates = candidates;
        this.selects = new ArrayList<SelectableWidgetGroup>();
        this.addWidget(this.button);
        this.textTexture = new TextTexture("", fontColor).setWidth(width).setType(TextTexture.TextType.ROLL);
        this.addWidget(new ImageWidget(0, 0, width, height, this.textTexture));
        this.popUp = new DraggableScrollableWidgetGroup(0, height, width, Math.min(this.capacity, candidates.size()) * 15);
        this.addWidget(this.popUp);
        this.popUp.setBackground(new ColorRectTexture(-1442840576));
        if (candidates.size() > this.capacity) {
            this.popUp.setYScrollBarWidth(4).setYBarStyle(null, new ColorRectTexture(-1));
        }
        this.popUp.setVisible(false);
        this.popUp.setActive(false);
        this.currentString = "";
        y = 0;
        width = candidates.size() > this.capacity ? width - 4 : width;
        for (String candidate : candidates) {
            SelectableWidgetGroup select = new SelectableWidgetGroup(0, y, width, 15);
            select.addWidget(new ImageWidget(0, 0, width, 15, new TextTexture(candidate, fontColor).setWidth(width).setType(TextTexture.TextType.ROLL)));
            select.setSelectedTexture(-1, -1);
            select.setOnSelected(s -> {
                this.setValue(candidate);
                if (this.onChanged != null) {
                    this.onChanged.accept(candidate);
                }
                this.setValue(candidate);
                this.writeClientAction(2, buffer -> buffer.func_180714_a(candidate));
                this.setShow(false);
            });
            this.popUp.addWidget(select);
            this.selects.add(select);
            y += 15;
        }
    }

    public SelectorWidget setIsUp(boolean isUp) {
        this.popUp.setSelfPosition(isUp ? new Position(0, -Math.min(this.candidates.size(), this.capacity) * 15) : new Position(0, this.getSize().height));
        return this;
    }

    public SelectorWidget setCapacity(int capacity) {
        this.capacity = capacity;
        this.popUp.setSize(new Size(this.getSize().width, Math.min(capacity, this.candidates.size()) * 15));
        if (this.candidates.size() > capacity) {
            this.popUp.setYScrollBarWidth(4).setYBarStyle(null, new ColorRectTexture(-1));
        } else {
            this.popUp.setYScrollBarWidth(0).setYBarStyle(null, null);
        }
        return this;
    }

    public void setShow(boolean isShow) {
        this.isShow = isShow;
        this.popUp.setVisible(isShow);
        this.popUp.setActive(isShow);
    }

    public SelectorWidget setValue(String value) {
        int index = this.candidates.indexOf(value);
        if (index >= 0 && !value.equals(this.currentString)) {
            this.currentString = value;
            this.textTexture.updateText(value);
            for (int i = 0; i < this.selects.size(); ++i) {
                this.selects.get((int)i).isSelected = index == i;
            }
        }
        return this;
    }

    public String getValue() {
        return this.currentString;
    }

    public SelectorWidget setOnChanged(Consumer<String> onChanged) {
        this.onChanged = onChanged;
        return this;
    }

    public SelectorWidget setButtonBackground(IGuiTexture ... guiTexture) {
        this.button.setButtonTexture(guiTexture);
        return this;
    }

    public SelectorWidget setBackground(IGuiTexture background) {
        this.popUp.setBackground(background);
        return this;
    }

    @Override
    public void setFocus(boolean focus) {
        super.setFocus(focus);
        if (!focus) {
            this.setShow(false);
        }
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY, float particleTicks) {
        super.drawInForeground(mouseX, mouseY, particleTicks);
        if (this.isShow) {
            GlStateManager.func_179097_i();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)200.0f);
            this.popUp.drawInBackground(mouseX, mouseY, particleTicks);
            this.popUp.drawInForeground(mouseX, mouseY, particleTicks);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-200.0f);
            GlStateManager.func_179126_j();
        }
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks) {
        for (Widget widget : this.widgets) {
            if (!widget.isVisible() || widget == this.popUp) continue;
            widget.drawInBackground(mouseX, mouseY, partialTicks);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public Widget mouseClicked(int mouseX, int mouseY, int button) {
        SelectorWidget widget = super.mouseClicked(mouseX, mouseY, button) == null ? null : this;
        return widget;
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        super.handleClientAction(id, buffer);
        if (id == 2) {
            this.setValue(buffer.func_150789_c(Short.MAX_VALUE));
            if (this.onChanged != null) {
                this.onChanged.accept(this.getValue());
            }
        }
    }
}

