/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp;

import com.cleanroommc.multiblocked.api.gui.texture.ColorBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.IGuiTexture;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableScrollableWidgetGroup;
import com.cleanroommc.multiblocked.util.Position;
import com.cleanroommc.multiblocked.util.Size;
import java.util.function.Consumer;

public class SelectableWidgetGroup
extends WidgetGroup
implements DraggableScrollableWidgetGroup.ISelected {
    protected boolean isSelected;
    protected IGuiTexture selectedTexture;
    protected Consumer<SelectableWidgetGroup> onSelected;
    protected Consumer<SelectableWidgetGroup> onUnSelected;

    public SelectableWidgetGroup(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public SelectableWidgetGroup(Position position) {
        super(position);
    }

    public SelectableWidgetGroup(Position position, Size size) {
        super(position, size);
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public SelectableWidgetGroup setOnSelected(Consumer<SelectableWidgetGroup> onSelected) {
        this.onSelected = onSelected;
        return this;
    }

    public SelectableWidgetGroup setOnUnSelected(Consumer<SelectableWidgetGroup> onUnSelected) {
        this.onUnSelected = onUnSelected;
        return this;
    }

    public SelectableWidgetGroup setSelectedTexture(IGuiTexture selectedTexture) {
        this.selectedTexture = selectedTexture;
        return this;
    }

    public SelectableWidgetGroup setSelectedTexture(int border, int color) {
        this.selectedTexture = new ColorBorderTexture(border, color);
        return this;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks) {
        super.drawInBackground(mouseX, mouseY, partialTicks);
        if (this.isSelected && this.selectedTexture != null) {
            this.selectedTexture.draw(mouseX, mouseY, this.getPosition().x, this.getPosition().y, this.getSize().width, this.getSize().height);
        }
    }

    @Override
    public boolean allowSelected(int mouseX, int mouseY, int button) {
        return this.isMouseOverElement(mouseX, mouseY);
    }

    @Override
    public void onSelected() {
        this.isSelected = true;
        if (this.onSelected != null) {
            this.onSelected.accept(this);
        }
    }

    @Override
    public void onUnSelected() {
        this.isSelected = false;
        if (this.onUnSelected != null) {
            this.onUnSelected.accept(this);
        }
    }
}

