/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp;

import com.cleanroommc.multiblocked.api.gui.texture.ColorRectTexture;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.widget.Widget;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ButtonWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableScrollableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextFieldWidget;
import com.cleanroommc.multiblocked.util.ISearch;
import com.cleanroommc.multiblocked.util.SearchEngine;
import com.cleanroommc.multiblocked.util.Size;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SearchComponentWidget<T>
extends WidgetGroup {
    public final SearchEngine<T> engine;
    public final IWidgetSearch<T> search;
    public final DraggableScrollableWidgetGroup popUp;
    public final TextFieldWidget textFieldWidget;
    private int capacity = 10;
    protected boolean isShow;

    public SearchComponentWidget(int x, int y, int width, int height, IWidgetSearch<T> search) {
        super(x, y, width, height);
        this.setClientSideWidget();
        this.popUp = new DraggableScrollableWidgetGroup(0, height, width, 0);
        this.addWidget(this.popUp);
        this.textFieldWidget = new TextFieldWidget(0, 0, width, height, null, null){

            @Override
            public void setFocus(boolean focus) {
                super.setFocus(focus);
                SearchComponentWidget.this.setShow(focus);
            }
        };
        this.addWidget(this.textFieldWidget);
        this.popUp.setBackground(new ColorRectTexture(-1979711488));
        this.popUp.setVisible(false);
        this.popUp.setActive(false);
        this.search = search;
        this.engine = new SearchEngine<Object>(search, r -> {
            int size = this.popUp.getAllWidgetSize();
            this.popUp.setSize(new Size(this.getSize().width, Math.min(size + 1, this.capacity) * 15));
            this.popUp.waitToAdded(new ButtonWidget(0, size * 15, width, 15, new TextTexture(search.resultDisplay(r)).setWidth(width).setType(TextTexture.TextType.ROLL), cd -> {
                search.selectResult(r);
                this.textFieldWidget.setCurrentString(search.resultDisplay(r));
            }).setHoverBorderTexture(-1, -1));
        });
        this.textFieldWidget.setTextResponder(s -> {
            this.popUp.clearAllWidgets();
            this.popUp.setSize(new Size(this.getSize().width, 0));
            this.engine.searchWord((String)s);
        });
    }

    public SearchComponentWidget<T> setCapacity(int capacity) {
        this.capacity = capacity;
        this.popUp.setSize(new Size(this.getSize().width, Math.min(this.popUp.getAllWidgetSize(), capacity) * 15));
        return this;
    }

    public SearchComponentWidget<T> setCurrentString(String currentString) {
        this.textFieldWidget.setCurrentString(currentString);
        return this;
    }

    public String getCurrentString() {
        return this.textFieldWidget.getCurrentString();
    }

    public void setShow(boolean isShow) {
        this.isShow = isShow;
        this.popUp.setVisible(isShow);
        this.popUp.setActive(isShow);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInBackground(int mouseX, int mouseY, float partialTicks) {
        for (Widget widget : this.widgets) {
            if (!widget.isVisible() || widget == this.popUp) continue;
            widget.drawInBackground(mouseX, mouseY, partialTicks);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInForeground(int mouseX, int mouseY, float partialTicks) {
        for (Widget widget : this.widgets) {
            if (!widget.isVisible()) continue;
            widget.drawInForeground(mouseX, mouseY, partialTicks);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (this.isShow) {
            GlStateManager.func_179097_i();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)200.0f);
            this.popUp.drawInBackground(mouseX, mouseY, partialTicks);
            this.popUp.drawInForeground(mouseX, mouseY, partialTicks);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-200.0f);
            GlStateManager.func_179126_j();
        }
    }

    public static interface IWidgetSearch<T>
    extends ISearch<T> {
        public String resultDisplay(T var1);

        public void selectResult(T var1);
    }
}

