/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.gui.widget.imp;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.gui.modular.ModularUI;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.util.DrawerHelper;
import com.cleanroommc.multiblocked.api.gui.widget.Widget;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.client.particle.ParticleManager;
import com.cleanroommc.multiblocked.client.renderer.scene.ISceneRenderHook;
import com.cleanroommc.multiblocked.client.renderer.scene.ImmediateWorldSceneRenderer;
import com.cleanroommc.multiblocked.client.renderer.scene.WorldSceneRenderer;
import com.cleanroommc.multiblocked.client.util.RenderUtils;
import com.cleanroommc.multiblocked.client.util.TrackedDummyWorld;
import com.cleanroommc.multiblocked.util.BlockPosFace;
import com.cleanroommc.multiblocked.util.Vector3;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.Blocks;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SceneWidget
extends WidgetGroup {
    @SideOnly(value=Side.CLIENT)
    protected WorldSceneRenderer renderer;
    @SideOnly(value=Side.CLIENT)
    protected TrackedDummyWorld dummyWorld;
    @SideOnly(value=Side.CLIENT)
    protected ParticleManager particleManager;
    protected boolean dragging;
    protected boolean renderFacing = true;
    protected boolean renderSelect = true;
    protected int lastMouseX;
    protected int lastMouseY;
    protected int currentMouseX;
    protected int currentMouseY;
    protected Vector3f center;
    protected float rotationYaw = 25.0f;
    protected float rotationPitch = -135.0f;
    protected float zoom = 5.0f;
    protected BlockPosFace clickPosFace;
    protected BlockPosFace hoverPosFace;
    protected BlockPosFace selectedPosFace;
    protected BiConsumer<BlockPos, EnumFacing> onSelected;
    protected Set<BlockPos> core;
    protected boolean useCache;

    public SceneWidget(int x, int y, int width, int height, World world) {
        super(x, y, width, height);
        if (Multiblocked.isClient()) {
            this.createScene(world);
        }
    }

    public SceneWidget useCacheBuffer() {
        this.useCache = true;
        if (Multiblocked.isClient() && this.renderer != null) {
            this.renderer.useCacheBuffer(true);
        }
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public ParticleManager getParticleManager() {
        return this.particleManager;
    }

    @Override
    public void setGui(ModularUI gui) {
        super.setGui(gui);
        if (gui != null) {
            gui.registerCloseListener(this::releaseCacheBuffer);
        }
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        if (this.particleManager != null) {
            this.particleManager.updateEffects();
        }
    }

    public void releaseCacheBuffer() {
        if (Multiblocked.isClient() && this.renderer != null) {
            this.renderer.deleteCacheBuffer();
        }
    }

    public void needCompileCache() {
        if (Multiblocked.isClient() && this.renderer != null) {
            this.renderer.needCompileCache();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final void createScene(World world) {
        if (world == null) {
            return;
        }
        this.core = new HashSet<BlockPos>();
        this.dummyWorld = new TrackedDummyWorld(world);
        this.dummyWorld.setRenderFilter(pos -> this.renderer.renderedBlocksMap.keySet().stream().anyMatch(c -> c.contains(pos)));
        if (this.renderer != null) {
            this.renderer.deleteCacheBuffer();
        }
        this.renderer = new ImmediateWorldSceneRenderer(this.dummyWorld);
        this.center = new Vector3f();
        this.renderer.setOnLookingAt(ray -> {});
        this.renderer.setAfterWorldRender(this::renderBlockOverLay);
        this.renderer.setCameraLookAt(this.center, this.zoom, Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
        this.renderer.useCacheBuffer(this.useCache);
        this.particleManager = new ParticleManager();
        this.renderer.setParticleManager(this.particleManager);
        this.clickPosFace = null;
        this.hoverPosFace = null;
        this.selectedPosFace = null;
    }

    @SideOnly(value=Side.CLIENT)
    public WorldSceneRenderer getRenderer() {
        return this.renderer;
    }

    @SideOnly(value=Side.CLIENT)
    public TrackedDummyWorld getDummyWorld() {
        return this.dummyWorld;
    }

    public SceneWidget setOnSelected(BiConsumer<BlockPos, EnumFacing> onSelected) {
        this.onSelected = onSelected;
        return this;
    }

    public SceneWidget setClearColor(int color) {
        if (Multiblocked.isClient()) {
            this.renderer.setClearColor(color);
        }
        return this;
    }

    public SceneWidget setRenderSelect(boolean renderSelect) {
        this.renderSelect = renderSelect;
        return this;
    }

    public SceneWidget setRenderFacing(boolean renderFacing) {
        this.renderFacing = renderFacing;
        return this;
    }

    public SceneWidget setRenderedCore(Collection<BlockPos> blocks, ISceneRenderHook renderHook) {
        if (Multiblocked.isClient()) {
            this.core.clear();
            this.core.addAll(blocks);
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int minZ = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            int maxZ = Integer.MIN_VALUE;
            for (BlockPos vPos : blocks) {
                minX = Math.min(minX, vPos.func_177958_n());
                minY = Math.min(minY, vPos.func_177956_o());
                minZ = Math.min(minZ, vPos.func_177952_p());
                maxX = Math.max(maxX, vPos.func_177958_n());
                maxY = Math.max(maxY, vPos.func_177956_o());
                maxZ = Math.max(maxZ, vPos.func_177952_p());
            }
            this.center = new Vector3f((float)(minX + maxX) / 2.0f + 0.5f, (float)(minY + maxY) / 2.0f + 0.5f, (float)(minZ + maxZ) / 2.0f + 0.5f);
            this.renderer.addRenderedBlocks(this.core, renderHook);
            this.zoom = (float)(3.5 * Math.sqrt(Math.max(Math.max(Math.max(maxX - minX + 1, maxY - minY + 1), maxZ - minZ + 1), 1)));
            this.renderer.setCameraLookAt(this.center, this.zoom, Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
            this.needCompileCache();
        }
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderBlockOverLay(WorldSceneRenderer renderer) {
        BlockPosFace tmp;
        RayTraceResult hit;
        this.hoverPosFace = null;
        if (this.isMouseOverElement(this.currentMouseX, this.currentMouseY) && (hit = renderer.getLastTraceResult()) != null) {
            if (this.core.contains(hit.func_178782_a())) {
                this.hoverPosFace = new BlockPosFace(hit.func_178782_a(), hit.field_178784_b);
            } else {
                Vector3 hitPos = new Vector3(hit.field_72307_f);
                World world = renderer.world;
                Vec3d eyePos = new Vec3d((double)renderer.getEyePos().x, (double)renderer.getEyePos().y, (double)renderer.getEyePos().z);
                hitPos.multiply(2.0);
                Vec3d endPos = new Vec3d(hitPos.x - eyePos.field_72450_a, hitPos.y - eyePos.field_72448_b, hitPos.z - eyePos.field_72449_c);
                double min = 3.4028234663852886E38;
                for (BlockPos pos : this.core) {
                    double dist;
                    IBlockState blockState = world.func_180495_p(pos);
                    if (blockState.func_177230_c() == Blocks.field_150350_a || (hit = blockState.func_185910_a(world, pos, eyePos, endPos)) == null || hit.field_72313_a == RayTraceResult.Type.MISS || !((dist = eyePos.func_72436_e(new Vec3d((Vec3i)hit.func_178782_a()))) < min)) continue;
                    min = dist;
                    this.hoverPosFace = new BlockPosFace(hit.func_178782_a(), hit.field_178784_b);
                }
            }
        }
        BlockPosFace blockPosFace = tmp = this.dragging ? this.clickPosFace : this.hoverPosFace;
        if (this.selectedPosFace != null || tmp != null) {
            RenderUtils.useLightMap(240.0f, 240.0f, () -> {
                GlStateManager.func_179097_i();
                if (this.selectedPosFace != null && this.renderFacing) {
                    this.drawFacingBorder(this.selectedPosFace, -16711936);
                }
                if (tmp != null && !tmp.equals(this.selectedPosFace) && this.renderFacing) {
                    this.drawFacingBorder(tmp, -1);
                }
                GlStateManager.func_179126_j();
            });
        }
        if (this.selectedPosFace == null) {
            return;
        }
        if (this.renderSelect) {
            RenderUtils.renderBlockOverLay(this.selectedPosFace.pos, 0.6f, 0.0f, 0.0f, 1.01f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawFacingBorder(BlockPosFace posFace, int color) {
        this.drawFacingBorder(posFace, color, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawFacingBorder(BlockPosFace posFace, int color, int inner) {
        GlStateManager.func_179094_E();
        RenderUtils.moveToFace(posFace.pos.func_177958_n(), posFace.pos.func_177956_o(), posFace.pos.func_177952_p(), posFace.facing);
        RenderUtils.rotateToFace(posFace.facing, null);
        GlStateManager.func_179152_a((float)0.0625f, (float)0.0625f, (float)0.0f);
        GlStateManager.func_179109_b((float)-8.0f, (float)-8.0f, (float)0.0f);
        DrawerHelper.drawBorder(1 + inner * 2, 1 + inner * 2, 14 - 4 * inner, 14 - 4 * inner, color, 1);
        GlStateManager.func_179121_F();
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        if (id == -1) {
            this.selectedPosFace = new BlockPosFace(buffer.func_179259_c(), (EnumFacing)buffer.func_179257_a(EnumFacing.class));
            if (this.onSelected != null) {
                this.onSelected.accept(this.selectedPosFace.pos, this.selectedPosFace.facing);
            }
        } else {
            super.handleClientAction(id, buffer);
        }
    }

    @Override
    public Widget mouseClicked(int mouseX, int mouseY, int button) {
        Widget widget = super.mouseClicked(mouseX, mouseY, button);
        if (widget != null) {
            return widget;
        }
        if (this.isMouseOverElement(mouseX, mouseY)) {
            this.dragging = true;
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            this.clickPosFace = this.hoverPosFace;
            return this;
        }
        this.dragging = false;
        return null;
    }

    @Override
    public Widget mouseWheelMove(int mouseX, int mouseY, int wheelDelta) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            this.zoom = (float)MathHelper.func_151237_a((double)((double)this.zoom + (wheelDelta < 0 ? 0.5 : -0.5)), (double)0.1, (double)999.0);
            if (this.renderer != null) {
                this.renderer.setCameraLookAt(this.center, this.zoom, Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
            }
        }
        return super.mouseWheelMove(mouseX, mouseY, wheelDelta);
    }

    @Override
    public Widget mouseDragged(int mouseX, int mouseY, int button, long timeDragged) {
        if (this.dragging) {
            this.rotationPitch += (float)(mouseX - this.lastMouseX + 360);
            this.rotationPitch %= 360.0f;
            this.rotationYaw = (float)MathHelper.func_151237_a((double)(this.rotationYaw + (float)(mouseY - this.lastMouseY)), (double)-89.9, (double)89.9);
            this.lastMouseY = mouseY;
            this.lastMouseX = mouseX;
            if (this.renderer != null) {
                this.renderer.setCameraLookAt(this.center, this.zoom, Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
            }
            return this;
        }
        return super.mouseDragged(mouseX, mouseY, button, timeDragged);
    }

    @Override
    public Widget mouseReleased(int mouseX, int mouseY, int button) {
        this.dragging = false;
        if (this.hoverPosFace != null && this.hoverPosFace.equals(this.clickPosFace)) {
            this.selectedPosFace = this.hoverPosFace;
            this.writeClientAction(-1, buffer -> {
                buffer.func_179255_a(this.selectedPosFace.pos);
                buffer.func_179249_a((Enum)this.selectedPosFace.facing);
            });
            if (this.onSelected != null) {
                this.onSelected.accept(this.selectedPosFace.pos, this.selectedPosFace.facing);
            }
            this.clickPosFace = null;
            return this;
        }
        this.clickPosFace = null;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks) {
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        int width = this.getSize().width;
        int height = this.getSize().height;
        if (this.renderer != null) {
            double progress;
            this.renderer.render(x, y, width, height, mouseX, mouseY);
            if (this.renderer.isCompiling() && (progress = this.renderer.getCompileProgress()) > 0.0) {
                new TextTexture("Renderer is compiling! " + String.format("%.1f", progress * 100.0) + "%%").setWidth(width).draw(mouseX, mouseY, x, y, width, height);
            }
        }
        super.drawInBackground(mouseX, mouseY, partialTicks);
        this.currentMouseX = mouseX;
        this.currentMouseY = mouseY;
    }

    public SceneWidget setCenter(Vector3f center) {
        this.center = center;
        if (this.renderer != null) {
            this.renderer.setCameraLookAt(this.center, this.zoom, Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
        }
        return this;
    }

    public SceneWidget setCameraYawAndPitch(float rotationYaw, float rotationPitch) {
        this.rotationYaw = rotationYaw;
        this.rotationPitch = rotationPitch;
        if (this.renderer != null) {
            this.renderer.setCameraLookAt(this.center, this.zoom, Math.toRadians(rotationPitch), Math.toRadians(rotationYaw));
        }
        return this;
    }
}

